<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Services\CommissionService;

class CommissionCalculationTest extends TestCase
{
    public function test_commission_calculated_correctly(): void
    {
        $service = new CommissionService();
        
        $result = $service->calculateCommission(100000, 15);
        
        $this->assertEquals(15, $result['commission_rate']);
        $this->assertEquals(15000, $result['commission_amount']);
        $this->assertEquals(85000, $result['vendor_amount']);
    }

    public function test_commission_uses_default_rate(): void
    {
        \App\Models\Setting::create([
            'key' => 'global_commission_percentage',
            'value' => '20',
            'type' => 'decimal',
        ]);

        $service = new CommissionService();
        
        $result = $service->calculateCommission(100000);
        
        $this->assertEquals(20, $result['commission_rate']);
        $this->assertEquals(20000, $result['commission_amount']);
        $this->assertEquals(80000, $result['vendor_amount']);
    }
}