<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use App\Models\Vendor;
use App\Models\Property;
use App\Models\Booking;
use App\Services\BookingService;
use Illuminate\Foundation\Testing\RefreshDatabase;

class MapVisibilityTest extends TestCase
{
    use RefreshDatabase;

    public function test_map_hidden_before_payment_verification(): void
    {
        $this->seed();
        
        $user = User::factory()->create();
        $vendorUser = User::factory()->create();
        $vendorUser->assignRole('vendor');
        $vendor = Vendor::factory()->create(['user_id' => $vendorUser->id]);
        $property = Property::factory()->create(['vendor_id' => $vendor->id]);

        $booking = Booking::factory()->create([
            'user_id' => $user->id,
            'property_id' => $property->id,
            'vendor_id' => $vendor->id,
            'payment_status' => 'paid',
            'admin_verified' => false,
            'map_visible' => false,
        ]);

        $bookingService = app(BookingService::class);
        $bookingService->verifyPayment($booking, $admin);

        $booking->refresh();

        $this->assertTrue($booking->admin_verified);
        $this->assertTrue($booking->map_visible);
        $this->assertTrue($booking->user_visible_vendor_info);
        $this->assertTrue($booking->vendor_visible_user_info);
    }
}