<?php $__env->startSection('title', 'Forgot Password'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-md mx-auto px-3 sm:px-4 py-6 sm:py-12">
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 md:p-8">
        <!-- Header -->
        <div class="text-center mb-4 sm:mb-6">
            <div class="bg-primary/10 w-14 h-14 sm:w-16 sm:h-16 rounded-full flex items-center justify-center mx-auto mb-3 sm:mb-4">
                <i class="fas fa-lock text-primary text-xl sm:text-2xl"></i>
            </div>
            <h1 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-2">Forgot Password?</h1>
            <p class="text-gray-600 text-sm sm:text-base">No worries! Enter your email and we'll send you reset instructions.</p>
        </div>

        <!-- Success Message -->
        <?php if(session('status')): ?>
            <div class="mb-4 sm:mb-6 bg-green-50 border-l-4 border-green-500 p-3 sm:p-4 rounded">
                <div class="flex items-start">
                    <i class="fas fa-check-circle text-green-500 mr-2 sm:mr-3 flex-shrink-0 mt-0.5"></i>
                    <p class="text-green-700 text-sm sm:text-base"><?php echo e(session('status')); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Form -->
        <form method="POST" action="<?php echo e(route('password.email')); ?>">
            <?php echo csrf_field(); ?>

            <div class="mb-4 sm:mb-6">
                <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                    <i class="fas fa-envelope text-primary mr-2"></i>Email Address
                </label>
                <input type="email" 
                    name="email" 
                    value="<?php echo e(old('email')); ?>" 
                    required 
                    autofocus
                    placeholder="Enter your email address"
                    class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-2 flex items-center">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?php echo e($message); ?>

                    </p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <button type="submit" 
                class="w-full bg-gradient-to-r from-primary to-primary-dark text-white py-2.5 sm:py-3 rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105 text-sm sm:text-base">
                <i class="fas fa-paper-plane mr-2"></i>Send Reset Link
            </button>
        </form>

        <!-- Back to Login -->
        <div class="mt-4 sm:mt-6 text-center">
            <a href="<?php echo e(route('login')); ?>" class="text-primary hover:text-primary-dark font-semibold inline-flex items-center text-sm sm:text-base">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Login
            </a>
        </div>

        <!-- Additional Help -->
        <div class="mt-6 sm:mt-8 pt-4 sm:pt-6 border-t border-gray-200">
            <p class="text-xs sm:text-sm text-gray-600 text-center">
                <i class="fas fa-info-circle text-primary mr-1"></i>
                Didn't receive the email? Check your spam folder or 
                <a href="<?php echo e(route('contact')); ?>" class="text-primary hover:underline">contact support</a>
            </p>
        </div>
    </div>

    <!-- Security Notice -->
    <div class="mt-4 sm:mt-6 bg-blue-50 border border-blue-200 rounded-lg p-3 sm:p-4">
        <div class="flex items-start">
            <i class="fas fa-shield-alt text-blue-600 text-lg sm:text-xl mr-2 sm:mr-3 mt-1 flex-shrink-0"></i>
            <div>
                <h3 class="font-semibold text-blue-900 mb-1 text-sm sm:text-base">Security Notice</h3>
                <p class="text-xs sm:text-sm text-blue-800">
                    For your security, password reset links expire after 60 minutes. 
                    Never share your reset link with anyone.
                </p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>