<?php $__env->startSection('title', 'Nearby Attractions - ' . $property->title); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto">
    <div class="mb-6">
        <a href="<?php echo e(route('bookings.show', $booking)); ?>" class="text-primary hover:underline">← Back to Booking</a>
    </div>

    <h1 class="text-3xl font-bold mb-6">Location & Nearby Attractions</h1>

    <!-- Map -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="font-bold text-xl mb-4">Property Location</h2>
        <div id="map" class="w-full h-96 rounded mb-4"></div>
        <p class="text-gray-600"><?php echo e($property->address); ?>, <?php echo e($property->city); ?>, <?php echo e($property->state); ?></p>
    </div>

    <!-- Nearby Attractions -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-6">Things to Do Nearby</h2>

        <?php if(count($attractions) > 0): ?>
            <div class="grid md:grid-cols-2 gap-6">
                <?php $__currentLoopData = $attractions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attraction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border rounded-lg overflow-hidden hover:shadow-lg transition">
                        <?php if(isset($attraction['photo_url']) && $attraction['photo_url']): ?>
                            <img src="<?php echo e($attraction['photo_url']); ?>" 
                                alt="<?php echo e($attraction['name']); ?>" 
                                class="w-full h-48 object-cover">
                        <?php endif; ?>
                        
                        <div class="p-4">
                            <h3 class="font-bold text-lg mb-2"><?php echo e($attraction['name']); ?></h3>
                            
                            <?php if(isset($attraction['rating']) && $attraction['rating']): ?>
                                <div class="flex items-center mb-2">
                                    <span class="text-yellow-500">★</span>
                                    <span class="ml-1 text-sm"><?php echo e(number_format($attraction['rating'], 1)); ?></span>
                                </div>
                            <?php endif; ?>

                            <?php if(isset($attraction['vicinity']) && $attraction['vicinity']): ?>
                                <p class="text-sm text-gray-600 mb-2"><?php echo e($attraction['vicinity']); ?></p>
                            <?php endif; ?>

                            <?php if(isset($attraction['description']) && $attraction['description']): ?>
                                <p class="text-sm text-gray-700 mb-3"><?php echo e(Str::limit($attraction['description'], 150)); ?></p>
                            <?php endif; ?>

                            <div class="flex flex-wrap gap-2">
                                <?php $__currentLoopData = array_slice($attraction['types'], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="px-2 py-1 bg-primary/10 text-blue-800 text-xs rounded">
                                        <?php echo e(str_replace('_', ' ', $type)); ?>

                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <p class="text-gray-600 text-center py-8">No nearby attractions found at this time.</p>
        <?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('services.google.maps_api_key')); ?>"></script>
<script>
    function initMap() {
        const location = { 
            lat: <?php echo e($property->location_lat); ?>, 
            lng: <?php echo e($property->location_lng); ?> 
        };
        
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: 15,
            center: location,
            styles: [
                {
                    featureType: "poi",
                    elementType: "labels",
                    stylers: [{ visibility: "on" }]
                }
            ]
        });
        
        // Property marker
        new google.maps.Marker({
            position: location,
            map: map,
            title: "<?php echo e($property->title); ?>",
            icon: {
                url: "http://maps.google.com/mapfiles/ms/icons/red-dot.png"
            }
        });

        // Attractions markers
        <?php $__currentLoopData = $attractions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attraction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            new google.maps.Marker({
                position: { 
                    lat: <?php echo e($attraction['geometry']['location']['lat'] ?? $property->location_lat); ?>, 
                    lng: <?php echo e($attraction['geometry']['location']['lng'] ?? $property->location_lng); ?> 
                },
                map: map,
                title: "<?php echo e($attraction['name']); ?>",
                label: "<?php echo e($index + 1); ?>",
                icon: {
                    url: "http://maps.google.com/mapfiles/ms/icons/blue-dot.png"
                }
            });
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    }
    
    initMap();
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/properties/nearby-attractions.blade.php ENDPATH**/ ?>