<div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 border-t-4
    <?php echo e($plan->name === 'Gold' ? 'border-yellow-500' : ($plan->name === 'Silver' ? 'border-gray-400' : 'border-orange-500')); ?>">
    <!-- Plan Header -->
    <div class="p-4 sm:p-6 text-center
        <?php echo e($plan->name === 'Gold' ? 'bg-gradient-to-br from-yellow-50 to-yellow-100' : ($plan->name === 'Silver' ? 'bg-gradient-to-br from-gray-50 to-gray-100' : 'bg-gradient-to-br from-orange-50 to-orange-100')); ?>">
        <div class="inline-block p-3 sm:p-4 rounded-full mb-3 sm:mb-4
            <?php echo e($plan->name === 'Gold' ? 'bg-yellow-500' : ($plan->name === 'Silver' ? 'bg-gray-400' : 'bg-orange-500')); ?>">
            <i class="fas <?php echo e($plan->name === 'Gold' ? 'fa-crown' : ($plan->name === 'Silver' ? 'fa-medal' : 'fa-award')); ?> text-white text-2xl sm:text-3xl"></i>
        </div>
        <h3 class="font-bold text-2xl sm:text-3xl mb-2 
            <?php echo e($plan->name === 'Gold' ? 'text-yellow-700' : ($plan->name === 'Silver' ? 'text-gray-700' : 'text-orange-700')); ?>"><?php echo e($plan->name); ?></h3>
        <p class="text-3xl sm:text-4xl font-bold text-primary mb-2">₦<?php echo e(number_format($plan->price)); ?></p>
        <p class="text-xs sm:text-sm font-semibold
            <?php echo e($plan->name === 'Gold' ? 'text-yellow-700' : ($plan->name === 'Silver' ? 'text-gray-700' : 'text-orange-700')); ?>">
            <i class="fas fa-clock mr-1"></i><?php echo e($plan->duration_days); ?> days
        </p>
        <?php if($plan->placement_type !== 'featured'): ?>
            <p class="text-xs mt-2 px-3 py-1 inline-block rounded-full
                <?php echo e($plan->placement_type === 'weekend_deals' ? 'bg-orange-200 text-orange-800' : 'bg-purple-200 text-purple-800'); ?>">
                <i class="fas <?php echo e($plan->placement_type === 'weekend_deals' ? 'fa-calendar-week' : 'fa-gem'); ?> mr-1"></i>
                <?php echo e(ucfirst(str_replace('_', ' ', $plan->placement_type))); ?>

            </p>
        <?php endif; ?>
    </div>

    <!-- Plan Body -->
    <div class="p-4 sm:p-6">
        <p class="text-xs sm:text-sm text-gray-600 mb-4 sm:mb-6 text-center"><?php echo e($plan->description); ?></p>
        
        <button onclick="document.getElementById('purchase-<?php echo e($plan->id); ?>').classList.toggle('hidden')"
            class="w-full bg-gradient-to-r from-primary to-primary-dark text-white py-2 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
            <i class="fas fa-shopping-cart mr-2"></i>Purchase Plan
        </button>

        <form id="purchase-<?php echo e($plan->id); ?>" 
            method="POST" 
            action="<?php echo e(route('vendor.ads.store')); ?>" 
            class="hidden mt-3 sm:mt-4 bg-gray-50 rounded-lg p-3 sm:p-4 border-2 border-primary/20">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="ad_plan_id" value="<?php echo e($plan->id); ?>">
            <input type="hidden" name="placement_type" value="<?php echo e($plan->placement_type); ?>">
            <label class="block text-xs sm:text-sm font-bold text-gray-700 mb-2">
                <i class="fas fa-home text-primary mr-2"></i>Select Property
            </label>
            <select name="property_id" required class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 mb-3 text-sm sm:text-base focus:border-primary focus:outline-none">
                <option value="">Choose a property...</option>
                <?php $__currentLoopData = auth()->user()->vendor->properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($property->id); ?>"><?php echo e($property->title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="w-full bg-gradient-to-r from-green-500 to-green-600 text-white py-2 sm:py-3 rounded-lg hover:shadow-xl transition font-bold text-sm sm:text-base">
                <i class="fas fa-credit-card mr-2"></i>Proceed to Payment
            </button>
        </form>
    </div>
</div><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/ads/partials/plan-card.blade.php ENDPATH**/ ?>