<?php $__env->startSection('title', $property->title); ?>
<?php $__env->startSection('description', substr($property->description, 0, 160)); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 py-6">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="<?php echo e(route('properties.index')); ?>" class="text-primary hover:text-primary-dark font-semibold">
            <i class="fas fa-arrow-left mr-2"></i> Back to Properties
        </a>
    </div>

    <!-- Hero Section with Photos -->
    <div class="mb-6">
        <?php if($property->photos && count($property->photos) > 0): ?>
            <div class="grid grid-cols-4 gap-2 rounded-xl overflow-hidden">
                <!-- Main large photo -->
                <div class="col-span-4 md:col-span-2 md:row-span-2">
                    <img src="<?php echo e(asset('storage/' . $property->photos[0])); ?>" 
                        alt="<?php echo e($property->title); ?>"
                        class="w-full h-full object-cover cursor-pointer hover:opacity-90 transition"
                        onclick="openGallery(0)">
                </div>
                <!-- Smaller photos -->
                <?php $__currentLoopData = array_slice($property->photos, 1, 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-span-2 md:col-span-1">
                        <img src="<?php echo e(asset('storage/' . $photo)); ?>" 
                            alt="<?php echo e($property->title); ?>"
                            class="w-full h-48 object-cover cursor-pointer hover:opacity-90 transition"
                            onclick="openGallery(<?php echo e($index + 1); ?>)">
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <?php if(count($property->photos) > 5): ?>
                    <button onclick="openGallery(0)" 
                        class="absolute bottom-4 right-4 bg-white px-4 py-2 rounded-lg shadow-lg hover:bg-gray-100 font-semibold">
                        <i class="fas fa-images mr-2"></i> Show all <?php echo e(count($property->photos)); ?> photos
                    </button>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>

    <div class="grid lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Title & Location -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex-1">
                        <?php if($property->isFeatured()): ?>
                            <span class="inline-block bg-gradient-to-r from-yellow-400 to-orange-500 text-white px-3 py-1 rounded-full text-xs font-bold mb-2">
                                <i class="fas fa-star mr-1"></i> FEATURED
                            </span>
                        <?php endif; ?>
                        <h1 class="text-3xl font-bold text-secondary mb-2"><?php echo e($property->title); ?></h1>
                        <p class="text-gray-600 flex items-center">
                            <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                            <?php if(auth()->guard()->check()): ?>
                                <?php
                                    $userBooking = $property->bookings()
                                        ->where('user_id', auth()->id())
                                        ->where('payment_status', 'paid')
                                        ->where('admin_verified', true)
                                        ->first();
                                ?>
                                <?php if($userBooking && $userBooking->map_visible): ?>
                                    <?php echo e($property->address); ?>, <?php echo e($property->city); ?>, <?php echo e($property->state); ?>

                                <?php else: ?>
                                    <?php echo e($property->city); ?>, <?php echo e($property->state); ?>

                                    <span class="text-sm text-gray-500 ml-2">(Full address after booking)</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php echo e($property->city); ?>, <?php echo e($property->state); ?>

                                <span class="text-sm text-gray-500 ml-2">(Full address after booking)</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    
                    <!-- Favorite Button -->
                    <?php if(auth()->guard()->check()): ?>
                        <button onclick="toggleFavorite(<?php echo e($property->id); ?>, this)" 
                            class="ml-4 w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center hover:scale-110 transition">
                            <i class="fas fa-heart text-xl <?php echo e(auth()->user()->hasFavorited($property->id) ? 'text-red-500' : 'text-gray-400'); ?>"></i>
                        </button>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" 
                            class="ml-4 w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center hover:scale-110 transition">
                            <i class="fas fa-heart text-xl text-gray-400"></i>
                        </a>
                    <?php endif; ?>
                </div>

                <!-- Badges -->
                <div class="flex flex-wrap gap-2">
                    <?php if($property->quality_standard): ?>
                        <span class="bg-blue-100 text-blue-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-certificate mr-1"></i> Quality Standard
                        </span>
                    <?php endif; ?>
                    <?php if($property->verified): ?>
                        <span class="bg-green-100 text-green-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-check-circle mr-1"></i> Verified
                        </span>
                    <?php endif; ?>
                    <?php if($property->quality_assured): ?>
                        <span class="bg-purple-100 text-purple-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-shield-alt mr-1"></i> Quality Assured
                        </span>
                    <?php endif; ?>
                    <?php if($property->allow_parties): ?>
                        <span class="bg-primary/10 text-primary px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-glass-cheers mr-1"></i> Party Friendly
                        </span>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Property Details Grid -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-info-circle text-primary mr-3"></i> Property Details
                </h2>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-home text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Type</p>
                        <p class="font-bold text-secondary"><?php echo e($property->house_type); ?></p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bed text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Bedrooms</p>
                        <p class="font-bold text-secondary"><?php echo e($property->bedrooms); ?></p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bed text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Beds</p>
                        <p class="font-bold text-secondary"><?php echo e($property->beds); ?></p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bath text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Bathrooms</p>
                        <p class="font-bold text-secondary"><?php echo e($property->bathrooms); ?></p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-users text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Max Guests</p>
                        <p class="font-bold text-secondary"><?php echo e($property->max_guests); ?></p>
                    </div>
                    <div class="bg-green-50 rounded-lg p-4 text-center">
                        <i class="fas fa-money-bill-wave text-green-600 text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Per Night</p>
                        <p class="font-bold text-green-600">₦<?php echo e(number_format($property->price_per_night)); ?></p>
                    </div>
                </div>
            </div>

            <!-- Property Video Section (NEW) -->
                <?php if($property->video_url): ?>
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-900 mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-video text-primary mr-2 sm:mr-3"></i>
                        Property Video Tour
                    </h2>
                    <div class="relative rounded-lg overflow-hidden bg-black shadow-lg" style="padding-top: 56.25%;">
                        <video controls class="absolute top-0 left-0 w-full h-full" controlsList="nodownload">
                            <source src="<?php echo e(Storage::url($property->video_url)); ?>" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                    <p class="text-xs sm:text-sm text-gray-600 mt-3 flex items-center">
                        <i class="fas fa-info-circle text-blue-500 mr-2"></i>
                        Watch a video tour of this property
                    </p>
                </div>
                <?php endif; ?>

            <!-- Description -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-align-left text-primary mr-3"></i> About This Place
                </h2>
                <p class="text-gray-700 whitespace-pre-line leading-relaxed"><?php echo e($property->description); ?></p>
                
                <?php if($property->highlighted_features): ?>
                    <div class="mt-6">
                        <h3 class="font-bold text-lg mb-3">Highlighted Features</h3>
                        <div class="grid md:grid-cols-2 gap-3">
                            <?php $__currentLoopData = $property->highlighted_features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="flex items-start bg-green-50 rounded-lg p-3">
                                    <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                    <span class="text-gray-700"><?php echo e($feature); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Amenities -->
            <?php if($property->amenities): ?>
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                        <i class="fas fa-star text-primary mr-3"></i> Amenities
                    </h2>
                    <div class="grid md:grid-cols-2 gap-6">
                        <?php $__currentLoopData = $property->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div>
                                <h3 class="font-semibold mb-3 flex items-center text-lg">
                                    <?php if($category === 'Essentials'): ?>
                                        <i class="fas fa-home text-primary mr-2"></i>
                                    <?php elseif($category === 'Kitchen & Dining'): ?>
                                        <i class="fas fa-utensils text-green-600 mr-2"></i>
                                    <?php elseif($category === 'Outdoor & Facilities'): ?>
                                        <i class="fas fa-tree text-primary mr-2"></i>
                                    <?php elseif($category === 'Safety & Other'): ?>
                                        <i class="fas fa-shield-alt text-red-600 mr-2"></i>
                                    <?php else: ?>
                                        <i class="fas fa-star text-yellow-600 mr-2"></i>
                                    <?php endif; ?>
                                    <?php echo e($category); ?>

                                </h3>
                                <ul class="space-y-2">
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-gray-700 flex items-center">
                                            <?php
                                                $itemLower = strtolower($item);
                                                $iconClass = 'fas fa-check text-green-600';
                                                
                                                // Map specific amenities to icons
                                                if (str_contains($itemLower, 'wifi') || str_contains($itemLower, 'internet')) {
                                                    $iconClass = 'fas fa-wifi text-blue-600';
                                                } elseif (str_contains($itemLower, 'tv') || str_contains($itemLower, 'television')) {
                                                    $iconClass = 'fas fa-tv text-purple-600';
                                                } elseif (str_contains($itemLower, 'air conditioning') || str_contains($itemLower, 'ac')) {
                                                    $iconClass = 'fas fa-snowflake text-blue-400';
                                                } elseif (str_contains($itemLower, 'heating')) {
                                                    $iconClass = 'fas fa-fire text-orange-600';
                                                } elseif (str_contains($itemLower, 'kitchen')) {
                                                    $iconClass = 'fas fa-utensils text-green-600';
                                                } elseif (str_contains($itemLower, 'refrigerator') || str_contains($itemLower, 'fridge')) {
                                                    $iconClass = 'fas fa-temperature-low text-blue-500';
                                                } elseif (str_contains($itemLower, 'microwave')) {
                                                    $iconClass = 'fas fa-microwave text-gray-600';
                                                } elseif (str_contains($itemLower, 'coffee') || str_contains($itemLower, 'tea')) {
                                                    $iconClass = 'fas fa-mug-hot text-brown-600';
                                                } elseif (str_contains($itemLower, 'dishwasher')) {
                                                    $iconClass = 'fas fa-sink text-blue-600';
                                                } elseif (str_contains($itemLower, 'washing machine') || str_contains($itemLower, 'washer')) {
                                                    $iconClass = 'fas fa-tshirt text-indigo-600';
                                                } elseif (str_contains($itemLower, 'dryer')) {
                                                    $iconClass = 'fas fa-wind text-cyan-600';
                                                } elseif (str_contains($itemLower, 'iron')) {
                                                    $iconClass = 'fas fa-iron text-gray-700';
                                                } elseif (str_contains($itemLower, 'pool') || str_contains($itemLower, 'swimming')) {
                                                    $iconClass = 'fas fa-swimming-pool text-blue-500';
                                                } elseif (str_contains($itemLower, 'gym') || str_contains($itemLower, 'fitness')) {
                                                    $iconClass = 'fas fa-dumbbell text-red-600';
                                                } elseif (str_contains($itemLower, 'parking')) {
                                                    $iconClass = 'fas fa-parking text-blue-700';
                                                } elseif (str_contains($itemLower, 'elevator') || str_contains($itemLower, 'lift')) {
                                                    $iconClass = 'fas fa-elevator text-gray-600';
                                                } elseif (str_contains($itemLower, 'balcony') || str_contains($itemLower, 'terrace')) {
                                                    $iconClass = 'fas fa-building text-green-600';
                                                } elseif (str_contains($itemLower, 'garden') || str_contains($itemLower, 'yard')) {
                                                    $iconClass = 'fas fa-tree text-green-700';
                                                } elseif (str_contains($itemLower, 'bbq') || str_contains($itemLower, 'grill')) {
                                                    $iconClass = 'fas fa-fire-burner text-orange-600';
                                                } elseif (str_contains($itemLower, 'security') || str_contains($itemLower, 'alarm')) {
                                                    $iconClass = 'fas fa-shield-halved text-red-600';
                                                } elseif (str_contains($itemLower, 'smoke detector')) {
                                                    $iconClass = 'fas fa-bell text-red-500';
                                                } elseif (str_contains($itemLower, 'fire extinguisher')) {
                                                    $iconClass = 'fas fa-fire-extinguisher text-red-600';
                                                } elseif (str_contains($itemLower, 'first aid')) {
                                                    $iconClass = 'fas fa-kit-medical text-red-500';
                                                } elseif (str_contains($itemLower, 'lock') || str_contains($itemLower, 'safe')) {
                                                    $iconClass = 'fas fa-lock text-gray-700';
                                                } elseif (str_contains($itemLower, 'pet')) {
                                                    $iconClass = 'fas fa-paw text-brown-600';
                                                } elseif (str_contains($itemLower, 'wheelchair') || str_contains($itemLower, 'accessible')) {
                                                    $iconClass = 'fas fa-wheelchair text-blue-600';
                                                } elseif (str_contains($itemLower, 'crib') || str_contains($itemLower, 'baby')) {
                                                    $iconClass = 'fas fa-baby text-pink-500';
                                                } elseif (str_contains($itemLower, 'beach')) {
                                                    $iconClass = 'fas fa-umbrella-beach text-yellow-500';
                                                } elseif (str_contains($itemLower, 'generator')) {
                                                    $iconClass = 'fas fa-bolt text-yellow-600';
                                                } elseif (str_contains($itemLower, 'water') || str_contains($itemLower, 'borehole')) {
                                                    $iconClass = 'fas fa-droplet text-blue-500';
                                                } elseif (str_contains($itemLower, 'ps5') || str_contains($itemLower, 'playstation')) {
                                                    $iconClass = 'fab fa-playstation text-blue-600';
                                                } elseif (str_contains($itemLower, 'snooker') || str_contains($itemLower, 'pool') || str_contains($itemLower, 'billiards')) {
                                                    $iconClass = 'fas fa-bowling-ball text-green-600';
                                                }
                                            ?>
                                            <i class="<?php echo e($iconClass); ?> mr-2"></i>
                                            <?php echo e($item); ?>

                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- House Rules -->
            <?php if($property->house_rules): ?>
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                        <i class="fas fa-list-check text-primary mr-3"></i> House Rules
                    </h2>
                    <ul class="space-y-3">
                        <?php $__currentLoopData = $property->house_rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="flex items-start">
                                <i class="fas fa-circle text-primary text-xs mt-2 mr-3"></i>
                                <span class="text-gray-700"><?php echo e($rule); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <!-- Reviews -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-star text-primary mr-3"></i> Reviews
                    <?php if($averageRating): ?>
                        <span class="ml-2 text-yellow-500">★ <?php echo e(number_format($averageRating, 1)); ?></span>
                        <span class="ml-2 text-sm text-gray-600">(<?php echo e($property->reviews()->visible()->count()); ?> reviews)</span>
                    <?php endif; ?>
                </h2>

                <?php $__empty_1 = true; $__currentLoopData = $property->reviews()->visible()->latest()->take(5)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="border-b pb-4 mb-4 last:border-b-0">
                        <div class="flex items-start mb-2">
                            <?php if($review->user->profile_photo): ?>
                                <img src="<?php echo e(asset('storage/' . $review->user->profile_photo)); ?>" 
                                    alt="<?php echo e($review->user->name); ?>"
                                    class="w-12 h-12 rounded-full object-cover">
                            <?php else: ?>
                                <div class="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-white font-bold text-lg">
                                    <?php echo e(substr($review->user->name, 0, 1)); ?>

                                </div>
                            <?php endif; ?>
                            <div class="ml-3 flex-1">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <p class="font-semibold"><?php echo e($review->user->name); ?></p>
                                        <p class="text-sm text-gray-600"><?php echo e($review->created_at->format('F Y')); ?></p>
                                    </div>
                                    <div class="text-yellow-500 text-lg">
                                        <?php echo e(str_repeat('★', $review->rating)); ?><?php echo e(str_repeat('☆', 5 - $review->rating)); ?>

                                    </div>
                                </div>
                                <p class="text-gray-700 mt-2"><?php echo e($review->comment); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-8">
                        <i class="fas fa-comments text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-600">No reviews yet. Be the first to review!</p>
                    </div>
                <?php endif; ?>

                <?php if($property->reviews()->visible()->count() > 5): ?>
                    <div class="text-center mt-4">
                        <button class="text-primary hover:text-primary-dark font-semibold">
                            View all <?php echo e($property->reviews()->visible()->count()); ?> reviews
                        </button>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Location & Map (Unlocked after booking) -->
            <?php if(auth()->guard()->check()): ?>
                <?php
                    $userBooking = $property->bookings()
                        ->where('user_id', auth()->id())
                        ->where('payment_status', 'paid')
                        ->where('admin_verified', true)
                        ->first();
                ?>

                <?php if($userBooking && $userBooking->map_visible): ?>
                    <div class="bg-white rounded-xl shadow-md p-6">
                        <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <i class="fas fa-map-marker-alt text-primary mr-3"></i> Location
                        </h2>
                        
                        <?php if($property->location_lat && $property->location_lng): ?>
                            <div id="map" class="w-full h-80 bg-gray-200 rounded-lg mb-4"></div>
                            <p class="text-sm text-gray-700 mb-4 flex items-center">
                                <i class="fas fa-location-dot text-primary mr-2"></i>
                                <strong>Address:</strong> <span class="ml-2"><?php echo e($property->address); ?>, <?php echo e($property->city); ?>, <?php echo e($property->state); ?></span>
                            </p>
                            
                            <a href="<?php echo e(route('properties.nearby-attractions', $property)); ?>" 
                                class="inline-flex items-center text-primary hover:text-primary-dark font-semibold">
                                <i class="fas fa-map mr-2"></i> View Nearby Attractions & Full Map
                            </a>

                            <?php $__env->startPush('scripts'); ?>
                            <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('services.google.maps_api_key')); ?>"></script>
                            <script>
                                function initMap() {
                                    const location = { lat: <?php echo e($property->location_lat); ?>, lng: <?php echo e($property->location_lng); ?> };
                                    const map = new google.maps.Map(document.getElementById('map'), {
                                        zoom: 15,
                                        center: location,
                                        styles: [
                                            {
                                                featureType: "poi",
                                                elementType: "labels",
                                                stylers: [{ visibility: "on" }]
                                            }
                                        ]
                                    });
                                    new google.maps.Marker({ 
                                        position: location, 
                                        map: map,
                                        title: "<?php echo e($property->title); ?>"
                                    });
                                }
                                initMap();
                            </script>
                            <?php $__env->stopPush(); ?>
                        <?php else: ?>
                            <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                                <p class="text-yellow-800 font-semibold mb-2">
                                    <i class="fas fa-map-marker-alt mr-2"></i>
                                    <strong>Address:</strong> <?php echo e($property->address); ?>, <?php echo e($property->city); ?>, <?php echo e($property->state); ?>

                                </p>
                                <p class="text-sm text-gray-600">
                                    Map coordinates not available for this property.
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Booking Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-lg p-6 sticky top-4">
                <div class="text-center mb-6">
                    <div class="text-4xl font-bold text-primary mb-2">
                        ₦<?php echo e(number_format($property->price_per_night)); ?>

                    </div>
                    <p class="text-gray-600">per night</p>
                </div>

                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('bookings.create', $property)); ?>" 
                        class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                        <i class="fas fa-calendar-check mr-2"></i> Book Now
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" 
                        class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                        <i class="fas fa-sign-in-alt mr-2"></i> Login to Book
                    </a>
                <?php endif; ?>

                <div class="mt-6 space-y-3">
                    <div class="flex justify-between items-center py-3 border-b">
                        <span class="text-gray-600">Caution Fee</span>
                        <span class="font-bold text-yellow-600">₦<?php echo e(number_format($property->caution_fee)); ?></span>
                    </div>
                    <p class="text-xs text-gray-500">
                        <i class="fas fa-info-circle mr-1"></i>
                        Caution fee is fully refundable after stay
                    </p>
                </div>

                <?php if(!$property->allow_parties): ?>
                    <div class="mt-4 bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                        <p class="text-sm text-yellow-800 font-semibold">
                            <i class="fas fa-ban mr-2"></i>
                            No parties or events allowed
                        </p>
                    </div>
                <?php endif; ?>

                <!-- Contact Host -->
                <div class="mt-6 pt-6 border-t">
                    <h3 class="font-bold text-secondary mb-3">Hosted by</h3>
                    <div class="flex items-center">
                        <?php if($property->vendor->user->profile_photo): ?>
                            <img src="<?php echo e(asset('storage/' . $property->vendor->user->profile_photo)); ?>" 
                                alt="<?php echo e($property->vendor->company_name); ?>"
                                class="w-12 h-12 rounded-full object-cover">
                        <?php else: ?>
                            <div class="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-white font-bold text-lg">
                                <?php echo e(substr($property->vendor->company_name, 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <div class="ml-3">
                            <p class="font-semibold"><?php echo e($property->vendor->company_name); ?></p>
                            <p class="text-sm text-gray-600">Property Host</p>
                        </div>
                    </div>
                </div>

                <!-- Share -->
                <div class="mt-6 pt-6 border-t">
                    <button onclick="shareProperty()" class="w-full border-2 border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 font-semibold transition">
                        <i class="fas fa-share-alt mr-2"></i> Share Property
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleFavorite(propertyId, button) {
    fetch(`/favorites/toggle/${propertyId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const icon = button.querySelector('i');
            if (data.favorited) {
                icon.classList.remove('text-gray-400');
                icon.classList.add('text-red-500');
            } else {
                icon.classList.remove('text-red-500');
                icon.classList.add('text-gray-400');
            }
        }
    })
    .catch(error => console.error('Error:', error));
}

function openGallery(index) {
    // Implement photo gallery modal here
    console.log('Open gallery at index:', index);
}

function shareProperty() {
    const propertyTitle = "<?php echo e($property->title); ?>";
    const propertyUrl = "<?php echo e(url()->current()); ?>";
    const propertyDescription = "<?php echo e(substr($property->description, 0, 100)); ?>...";
    
    // Check if Web Share API is supported
    if (navigator.share) {
        navigator.share({
            title: propertyTitle,
            text: propertyDescription,
            url: propertyUrl
        })
        .then(() => console.log('Shared successfully'))
        .catch((error) => console.log('Error sharing:', error));
    } else {
        // Fallback: Copy to clipboard
        const shareText = `${propertyTitle}\n${propertyDescription}\n${propertyUrl}`;
        
        if (navigator.clipboard) {
            navigator.clipboard.writeText(propertyUrl)
                .then(() => {
                    alert('Property link copied to clipboard! Share it with your friends.');
                })
                .catch(() => {
                    showShareModal(propertyUrl);
                });
        } else {
            showShareModal(propertyUrl);
        }
    }
}

function showShareModal(url) {
    // Create a temporary modal for sharing
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50';
    modal.innerHTML = `
        <div class="bg-white rounded-xl p-6 max-w-md mx-4">
            <h3 class="text-xl font-bold text-secondary mb-4">Share Property</h3>
            <p class="text-gray-600 mb-4">Share this property on:</p>
            <div class="space-y-3">
                <a href="https://wa.me/?text=${encodeURIComponent(url)}" target="_blank" 
                   class="block w-full bg-green-500 text-white py-3 rounded-lg hover:bg-green-600 text-center font-semibold">
                    <i class="fab fa-whatsapp mr-2"></i> WhatsApp
                </a>
                <a href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}" target="_blank"
                   class="block w-full bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 text-center font-semibold">
                    <i class="fab fa-facebook mr-2"></i> Facebook
                </a>
                <a href="https://twitter.com/intent/tweet?url=${encodeURIComponent(url)}&text=<?php echo e(urlencode($property->title)); ?>" target="_blank"
                   class="block w-full bg-sky-500 text-white py-3 rounded-lg hover:bg-sky-600 text-center font-semibold">
                    <i class="fab fa-twitter mr-2"></i> Twitter
                </a>
                <button onclick="copyToClipboard('${url}')" 
                   class="block w-full bg-gray-600 text-white py-3 rounded-lg hover:bg-gray-700 text-center font-semibold">
                    <i class="fas fa-copy mr-2"></i> Copy Link
                </button>
            </div>
            <button onclick="this.closest('.fixed').remove()" 
                class="mt-4 w-full border-2 border-gray-300 text-gray-700 py-2 rounded-lg hover:bg-gray-50 font-semibold">
                Close
            </button>
        </div>
    `;
    document.body.appendChild(modal);
    
    // Close on background click
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.remove();
        }
    });
}

function copyToClipboard(text) {
    const textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();
    
    try {
        document.execCommand('copy');
        alert('Link copied to clipboard!');
    } catch (err) {
        alert('Failed to copy link');
    }
    
    document.body.removeChild(textarea);
}

// Track property view for guest activity
document.addEventListener('DOMContentLoaded', function() {
    fetch('/guest/track-property/<?php echo e($property->id); ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).catch(error => console.error('Error tracking property view:', error));
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/properties/show.blade.php ENDPATH**/ ?>