<?php $__env->startSection('title', 'Booking Details #' . $booking->id); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <a href="<?php echo e(route('admin.bookings.index')); ?>" class="text-primary hover:text-primary-dark font-semibold">
        <i class="fas fa-arrow-left mr-2"></i> Back to Bookings
    </a>
</div>

<!-- Header Card -->
<div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6 mb-6">
    <div class="flex justify-between items-start">
        <div>
            <h1 class="text-3xl font-bold mb-2">Booking #<?php echo e($booking->id); ?></h1>
            <p class="text-primary-light"><i class="fas fa-hashtag mr-2"></i>Reference: <?php echo e($booking->payment_reference); ?></p>
        </div>
        <div class="text-right">
            <span class="px-4 py-2 rounded-full font-semibold text-sm
                <?php if($booking->booking_status === 'confirmed'): ?> bg-green-500 text-white
                <?php elseif($booking->booking_status === 'pending'): ?> bg-yellow-400 text-gray-900
                <?php elseif($booking->booking_status === 'completed'): ?> bg-blue-500 text-white
                <?php else: ?> bg-gray-500 text-white
                <?php endif; ?>">
                <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst($booking->booking_status)); ?>

            </span>
        </div>
    </div>
</div>

<div class="grid md:grid-cols-3 gap-6 mb-6">
    <!-- Main Content -->
    <div class="md:col-span-2 space-y-6">
        <!-- Guest & Vendor Info -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-users text-primary mr-3"></i> People Involved
            </h2>
            <div class="grid md:grid-cols-2 gap-6">
                <div class="bg-blue-50 rounded-lg p-4">
                    <h3 class="font-bold text-primary mb-3 flex items-center">
                        <i class="fas fa-user-circle mr-2"></i> Guest Information
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p><strong>Name:</strong> <?php echo e($booking->user->name); ?></p>
                        <p><strong>Email:</strong> <?php echo e($booking->user->email); ?></p>
                        <p><strong>Phone:</strong> <?php echo e($booking->user->phone); ?></p>
                    </div>
                </div>

                <div class="bg-green-50 rounded-lg p-4">
                    <h3 class="font-bold text-green-700 mb-3 flex items-center">
                        <i class="fas fa-store mr-2"></i> Vendor Information
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p><strong>Company:</strong> <?php echo e($booking->vendor->company_name); ?></p>
                        <p><strong>Contact:</strong> <?php echo e($booking->vendor->user->name); ?></p>
                        <p><strong>Phone:</strong> <?php echo e($booking->vendor->user->phone); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Property & Stay Details -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-home text-primary mr-3"></i> Property & Stay Details
            </h2>
            <div class="space-y-3">
                <div class="flex items-start">
                    <i class="fas fa-building text-primary mt-1 mr-3"></i>
                    <div>
                        <p class="font-semibold"><?php echo e($booking->property->title); ?></p>
                        <p class="text-sm text-gray-600"><?php echo e($booking->property->address); ?>, <?php echo e($booking->property->city); ?></p>
                    </div>
                </div>
                
                <div class="grid md:grid-cols-2 gap-4 mt-4">
                    <div class="bg-primary/5 rounded-lg p-3">
                        <p class="text-xs text-gray-600">Check-in</p>
                        <p class="font-semibold text-primary"><i class="fas fa-calendar-check mr-2"></i><?php echo e($booking->start_date->format('M d, Y')); ?></p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-3">
                        <p class="text-xs text-gray-600">Check-out</p>
                        <p class="font-semibold text-primary"><i class="fas fa-calendar-times mr-2"></i><?php echo e($booking->end_date->format('M d, Y')); ?></p>
                    </div>
                </div>

                <div class="grid grid-cols-3 gap-3 mt-4">
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-2xl font-bold text-primary"><?php echo e($booking->nights_count); ?></p>
                        <p class="text-xs text-gray-600">Nights</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-2xl font-bold text-primary"><?php echo e($booking->guest_count); ?></p>
                        <p class="text-xs text-gray-600">Guests</p>
                    </div>
                    <div class="text-center bg-light-bg rounded-lg p-3">
                        <p class="text-sm font-bold text-primary"><?php echo e(ucfirst($booking->trip_type)); ?></p>
                        <p class="text-xs text-gray-600">Trip Type</p>
                    </div>
                </div>
                
                <p class="text-sm text-gray-600 mt-2">
                    <i class="fas fa-users mr-2"></i><?php echo e($booking->adults_count); ?> adults, <?php echo e($booking->children_count); ?> children
                </p>

                <!-- Check-In/Out Status -->
                <?php if($booking->checked_in_at || $booking->checked_out_at || $booking->booking_status === 'checked_in'): ?>
                    <div class="mt-4 pt-4 border-t">
                        <h3 class="font-semibold text-gray-800 mb-3">
                            <i class="fas fa-clipboard-check text-primary mr-2"></i>Check-In/Out Status
                        </h3>
                        <div class="grid md:grid-cols-2 gap-3">
                            <?php if($booking->checked_in_at || $booking->booking_status === 'checked_in'): ?>
                                <div class="bg-green-50 border-l-4 border-green-500 p-3 rounded">
                                    <p class="font-semibold text-green-800 text-sm mb-1">
                                        <i class="fas fa-check-circle mr-1"></i>Checked In
                                    </p>
                                    <p class="text-xs text-green-700">
                                        <?php echo e($booking->checked_in_at ? $booking->checked_in_at->format('M d, Y h:i A') : 'Status: Confirmed'); ?>

                                    </p>
                                </div>
                            <?php else: ?>
                                <div class="bg-gray-50 border-l-4 border-gray-300 p-3 rounded">
                                    <p class="font-semibold text-gray-600 text-sm">
                                        <i class="fas fa-clock mr-1"></i>Not Checked In
                                    </p>
                                </div>
                            <?php endif; ?>

                            <?php if($booking->checked_out_at): ?>
                                <div class="bg-blue-50 border-l-4 border-blue-500 p-3 rounded">
                                    <p class="font-semibold text-blue-800 text-sm mb-1">
                                        <i class="fas fa-check-circle mr-1"></i>Checked Out
                                    </p>
                                    <p class="text-xs text-blue-700">
                                        <?php echo e($booking->checked_out_at->format('M d, Y h:i A')); ?>

                                    </p>
                                </div>
                            <?php else: ?>
                                <div class="bg-gray-50 border-l-4 border-gray-300 p-3 rounded">
                                    <p class="font-semibold text-gray-600 text-sm">
                                        <i class="fas fa-clock mr-1"></i>Not Checked Out
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Payment Details -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-wallet text-primary mr-3"></i> Payment Details
            </h2>
            <div class="space-y-2">
                <div class="flex justify-between">
                    <span>Subtotal (Room charges)</span>
                    <span>₦<?php echo e(number_format($booking->subtotal)); ?></span>
                </div>
                <div class="flex justify-between text-gray-600">
                    <span>Caution Fee (Refundable deposit)</span>
                    <span>₦<?php echo e(number_format($booking->caution_fee_amount)); ?></span>
                </div>
                <?php if($booking->discount_amount > 0): ?>
                    <div class="flex justify-between text-green-600 bg-green-50 -mx-4 px-4 py-2 rounded">
                        <span class="flex items-center">
                            <i class="fas fa-tag mr-2"></i>
                            Discount Applied <span class="text-xs ml-1 font-mono">(<?php echo e($booking->discount_code); ?>)</span>
                        </span>
                        <span class="font-semibold">-₦<?php echo e(number_format($booking->discount_amount)); ?></span>
                    </div>
                <?php endif; ?>
                <div class="flex justify-between font-bold text-lg border-t pt-2">
                    <span>Total Paid by Customer</span>
                    <span>₦<?php echo e(number_format($booking->total_amount)); ?></span>
                </div>
                
                <div class="border-t pt-3 mt-3">
                    <p class="text-xs text-gray-600 mb-2">Commission breakdown (calculated on subtotal only):</p>
                    <div class="flex justify-between text-sm bg-primary/5 p-2 rounded">
                        <span>Platform Commission (<?php echo e($booking->commission_rate); ?>% of ₦<?php echo e(number_format($booking->subtotal)); ?>)</span>
                        <span class="font-semibold">₦<?php echo e(number_format($booking->commission_amount)); ?></span>
                    </div>
                    <div class="flex justify-between text-sm bg-green-50 p-2 rounded mt-1">
                        <span>Vendor Payout (Subtotal - Commission)</span>
                        <span class="font-semibold">₦<?php echo e(number_format($booking->vendor_payout_amount)); ?></span>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">
                        <i class="fas fa-info-circle"></i> Caution fee (₦<?php echo e(number_format($booking->caution_fee_amount)); ?>) is excluded from commission and will be refunded to vendor or customer based on property condition.
                    </p>
                </div>
            </div>

            <div class="mt-6 p-4 bg-gradient-to-r from-light-bg to-white rounded-lg border-l-4 border-primary">
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600">Payment Status</p>
                        <p class="font-bold text-lg <?php echo e($booking->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600'); ?>">
                            <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst($booking->payment_status)); ?>

                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Payment Method</p>
                        <p class="font-bold text-lg text-secondary"><?php echo e($booking->payment_method ? ucfirst($booking->payment_method) : 'N/A'); ?></p>
                    </div>
                </div>
                <?php if($booking->paid_at): ?>
                    <div class="mt-3 pt-3 border-t">
                        <p class="text-sm text-gray-600">Paid At: <span class="font-semibold text-secondary"><?php echo e($booking->paid_at->format('M d, Y H:i')); ?></span></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Admin Actions -->
        <?php if($booking->payment_status === 'paid' && !$booking->admin_verified): ?>
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4 mb-4">
                    <p class="text-yellow-800 font-bold mb-2 flex items-center">
                        <i class="fas fa-exclamation-triangle mr-2"></i> Verification Required
                    </p>
                    <p class="text-sm text-yellow-700">This booking payment requires admin verification before details are unlocked.</p>
                </div>

                <form method="POST" action="<?php echo e(route('admin.bookings.verify', $booking)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" 
                        class="w-full bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                        <i class="fas fa-check-circle mr-2"></i> Verify Payment
                    </button>
                </form>
            </div>
        <?php endif; ?>

        <?php if($booking->admin_verified): ?>
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="text-green-800 font-bold flex items-center mb-2">
                        <i class="fas fa-check-circle mr-2"></i> Verified
                    </p>
                    <div class="text-sm text-green-700">
                        <?php if($booking->verifiedBy): ?>
                            <p>By: <span class="font-semibold"><?php echo e($booking->verifiedBy->name); ?></span></p>
                        <?php endif; ?>
                        <?php if($booking->verified_at): ?>
                            <p>On: <?php echo e($booking->verified_at->format('M d, Y H:i')); ?></p>
                        <?php elseif($booking->admin_verified_at): ?>
                            <p>On: <?php echo e($booking->admin_verified_at->format('M d, Y H:i')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Booking Timeline -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="font-bold text-lg text-gray-800 mb-4">
                <i class="fas fa-clock text-primary mr-2"></i>Booking Timeline
            </h3>
            
            <div class="space-y-4">
                <!-- Booking Created -->
                <div class="flex items-start">
                    <div class="bg-green-100 rounded-full p-2 mr-3">
                        <i class="fas fa-plus text-green-600"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-sm">Booking Created</p>
                        <p class="text-xs text-gray-600"><?php echo e($booking->created_at->format('M d, Y h:i A')); ?></p>
                    </div>
                </div>
                
                <!-- Vendor Approval -->
                <?php if($booking->requires_vendor_approval && $booking->vendor_approved_at): ?>
                    <div class="flex items-start">
                        <div class="bg-teal-100 rounded-full p-2 mr-3">
                            <i class="fas fa-thumbs-up text-teal-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Vendor Approved</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->vendor_approved_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Payment Received -->
                <?php if($booking->paid_at): ?>
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-money-bill text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Payment Received</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->paid_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Admin Verified -->
                <?php if($booking->admin_verified && ($booking->verified_at || $booking->admin_verified_at)): ?>
                    <div class="flex items-start">
                        <div class="bg-blue-100 rounded-full p-2 mr-3">
                            <i class="fas fa-check-circle text-blue-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Admin Verified</p>
                            <p class="text-xs text-gray-600">
                                <?php echo e(($booking->verified_at ?? $booking->admin_verified_at)->format('M d, Y h:i A')); ?>

                            </p>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Check-In -->
                <?php if($booking->checked_in_at): ?>
                    <div class="flex items-start">
                        <div class="bg-purple-100 rounded-full p-2 mr-3">
                            <i class="fas fa-door-open text-purple-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Guest Checked In</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->checked_in_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Check-Out -->
                <?php if($booking->checked_out_at): ?>
                    <div class="flex items-start">
                        <div class="bg-gray-100 rounded-full p-2 mr-3">
                            <i class="fas fa-door-closed text-gray-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Guest Checked Out</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->checked_out_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Completed -->
                <?php if($booking->booking_status === 'completed'): ?>
                    <div class="flex items-start">
                        <div class="bg-green-100 rounded-full p-2 mr-3">
                            <i class="fas fa-flag-checkered text-green-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Completed</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->updated_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Cancelled -->
                <?php if($booking->booking_status === 'cancelled' && $booking->cancelled_at): ?>
                    <div class="flex items-start">
                        <div class="bg-red-100 rounded-full p-2 mr-3">
                            <i class="fas fa-times-circle text-red-600"></i>
                        </div>
                        <div>
                            <p class="font-semibold text-sm">Booking Cancelled</p>
                            <p class="text-xs text-gray-600"><?php echo e($booking->cancelled_at->format('M d, Y h:i A')); ?></p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Caution Fee Management (Full Width) -->
<div class="mt-6">

    <?php if($booking->booking_status === 'completed' && $booking->checked_out_at): ?>
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-shield-alt text-primary mr-3"></i> Caution Fee Management
            </h2>
            
            <!-- Current Status -->
            <div class="mb-6 p-4 bg-light-bg rounded-lg">
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Caution Fee Amount</p>
                        <p class="font-bold text-2xl text-gray-800">₦<?php echo e(number_format($booking->caution_fee_amount ?? 0)); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600 mb-1">Current Status</p>
                        <p class="font-bold text-xl
                            <?php if($booking->caution_refund_status === 'refunded'): ?> text-green-600
                            <?php elseif($booking->caution_refund_status === 'deducted' || $booking->caution_refund_status === 'partially_deducted'): ?> text-orange-600
                            <?php elseif($booking->caution_refund_status === 'pending_vendor'): ?> text-yellow-600
                            <?php else: ?> text-gray-600
                            <?php endif; ?>">
                            <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst(str_replace('_', ' ', $booking->caution_refund_status ?? 'pending'))); ?>

                        </p>
                    </div>
                </div>
            </div>

            <!-- Caution Fee Dispute Resolution -->
            <?php if($booking->caution_refund_status === 'pending_vendor' && $booking->caution_deduction_amount): ?>
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-exclamation-triangle text-red-600 mr-2"></i>Caution Fee Dispute
                    </h3>

                    <div class="bg-red-50 border-l-4 border-red-500 p-4 mb-6">
                        <p class="font-semibold text-red-800 mb-2">Vendor has reported damage</p>
                        <p class="text-sm text-red-700">
                            The vendor is requesting to deduct ₦<?php echo e(number_format($booking->caution_deduction_amount)); ?> 
                            from the caution fee of ₦<?php echo e(number_format($booking->caution_fee_amount ?? $booking->caution_fee ?? 0)); ?>.
                        </p>
                    </div>

                    <div class="mb-6">
                        <h4 class="font-bold text-gray-800 mb-2">Damage Report:</h4>
                        <p class="text-gray-700 bg-gray-50 p-4 rounded-lg"><?php echo e($booking->caution_deduction_reason); ?></p>
                    </div>

                    <?php if($booking->caution_deduction_photos): ?>
                        <div class="mb-6">
                            <h4 class="font-bold text-gray-800 mb-2">Damage Photos:</h4>
                            <div class="grid grid-cols-3 gap-4">
                                <?php $__currentLoopData = json_decode($booking->caution_deduction_photos); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <img src="<?php echo e(asset('storage/' . $photo)); ?>" 
                                        alt="Damage photo" 
                                        class="w-full h-32 object-cover rounded-lg cursor-pointer hover:opacity-75"
                                        onclick="window.open('<?php echo e(asset('storage/' . $photo)); ?>', '_blank')">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('admin.bookings.resolve-caution', $booking)); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Admin Decision
                            </label>
                            <select name="decision" id="cautionDecision" required class="w-full border-gray-300 rounded-lg">
                                <option value="">Select decision...</option>
                                <option value="approve_deduction">Approve Deduction - Release to Vendor</option>
                                <option value="partial_deduction">Approve Partial Deduction</option>
                                <option value="reject_deduction">Reject Deduction - Refund to Customer</option>
                            </select>
                        </div>

                        <div id="partialAmountField" class="mb-4 hidden">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Approved Deduction Amount (₦)
                            </label>
                            <input type="number" name="approved_amount" 
                                min="0" max="<?php echo e($booking->caution_fee_amount ?? $booking->caution_fee ?? 0); ?>"
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Enter approved amount">
                        </div>

                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Admin Notes
                            </label>
                            <textarea name="admin_notes" rows="3" required
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Explain your decision..."></textarea>
                        </div>

                        <button type="submit" 
                            class="w-full bg-primary text-white py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                            <i class="fas fa-gavel mr-2"></i>Submit Decision
                        </button>
                    </form>

                    <script>
                        document.getElementById('cautionDecision').addEventListener('change', function() {
                            const partialAmount = document.getElementById('partialAmountField');
                            if (this.value === 'partial_deduction') {
                                partialAmount.classList.remove('hidden');
                                partialAmount.querySelector('input').required = true;
                            } else {
                                partialAmount.classList.add('hidden');
                                partialAmount.querySelector('input').required = false;
                            }
                        });
                    </script>
                </div>
            <?php elseif(!$booking->caution_refund_status || $booking->caution_refund_status === 'pending'): ?>
                <div class="p-4 bg-blue-50 border-l-4 border-blue-500 rounded">
                    <p class="text-blue-800">
                        <i class="fas fa-info-circle mr-2"></i>
                        Waiting for vendor to decide on caution fee refund. Vendor can either refund in full or report damages.
                    </p>
                </div>
            <?php endif; ?>

            <!-- User Refund Payout Request -->
            <?php if($booking->refund_payout_status === 'requested' && $booking->caution_refund_amount > 0): ?>
                <div class="mt-6 bg-white rounded-xl shadow-lg p-6">
                    <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-hand-holding-usd text-green-600 mr-2"></i>User Refund Payout Request
                    </h3>

                    <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 mb-6">
                        <p class="font-semibold text-yellow-800 mb-2">Action Required - User Requesting Refund</p>
                        <p class="text-sm text-yellow-700">
                            The user has requested payout of their caution fee refund of ₦<?php echo e(number_format($booking->caution_refund_amount)); ?>.
                        </p>
                        <p class="text-xs text-yellow-600 mt-2">
                            Requested on: <?php echo e($booking->refund_requested_at->format('M d, Y h:i A')); ?>

                        </p>
                    </div>

                    <!-- User Bank Details -->
                    <div class="mb-6 bg-gray-50 rounded-lg p-4">
                        <h4 class="font-bold text-gray-800 mb-3">User Bank Details:</h4>
                        <?php if($booking->user->bank_name && $booking->user->account_number): ?>
                            <div class="grid md:grid-cols-3 gap-4">
                                <div>
                                    <p class="text-xs text-gray-600">Bank Name</p>
                                    <p class="font-semibold"><?php echo e($booking->user->bank_name); ?></p>
                                </div>
                                <div>
                                    <p class="text-xs text-gray-600">Account Number</p>
                                    <p class="font-semibold"><?php echo e($booking->user->account_number); ?></p>
                                </div>
                                <div>
                                    <p class="text-xs text-gray-600">Account Name</p>
                                    <p class="font-semibold"><?php echo e($booking->user->account_name ?? 'N/A'); ?></p>
                                </div>
                            </div>
                        <?php else: ?>
                            <p class="text-red-600 text-sm">
                                <i class="fas fa-exclamation-triangle mr-2"></i>User has not provided bank details. Please contact user.
                            </p>
                        <?php endif; ?>
                    </div>

                    <!-- Process Refund Form -->
                    <form method="POST" action="<?php echo e(route('admin.bookings.process-refund', $booking)); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Payment Method
                            </label>
                            <select name="payment_method" required class="w-full border-gray-300 rounded-lg">
                                <option value="">Select payment method...</option>
                                <option value="bank_transfer">Bank Transfer</option>
                                <option value="cash">Cash</option>
                                <option value="cheque">Cheque</option>
                                <option value="mobile_money">Mobile Money</option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                Payment Reference/Notes
                            </label>
                            <textarea name="payment_details" rows="3" required
                                class="w-full border-gray-300 rounded-lg"
                                placeholder="Enter transaction reference or payment notes..."></textarea>
                        </div>

                        <button type="submit" 
                            class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                            <i class="fas fa-check-circle mr-2"></i>Mark as Paid (₦<?php echo e(number_format($booking->caution_refund_amount)); ?>)
                        </button>
                    </form>
                </div>
            <?php elseif($booking->refund_payout_status === 'processing'): ?>
                <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                    <p class="text-yellow-800">
                        <i class="fas fa-spinner fa-spin mr-2"></i>
                        Refund is being processed. Mark as paid when complete.
                    </p>
                </div>
            <?php elseif($booking->refund_payout_status === 'paid'): ?>
                <div class="mt-6 bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                    <p class="font-semibold text-green-800 mb-2">
                        <i class="fas fa-check-circle mr-2"></i>Refund Paid
                    </p>
                    <div class="grid md:grid-cols-2 gap-4 mt-3 text-sm">
                        <div>
                            <p class="text-gray-600">Amount Paid</p>
                            <p class="font-bold">₦<?php echo e(number_format($booking->caution_refund_amount)); ?></p>
                        </div>
                        <div>
                            <p class="text-gray-600">Payment Date</p>
                            <p class="font-bold"><?php echo e($booking->refund_paid_at->format('M d, Y h:i A')); ?></p>
                        </div>
                        <?php if($booking->refund_payment_method): ?>
                            <div>
                                <p class="text-gray-600">Payment Method</p>
                                <p class="font-bold"><?php echo e(ucfirst(str_replace('_', ' ', $booking->refund_payment_method))); ?></p>
                            </div>
                        <?php endif; ?>
                        <?php if($booking->refund_payment_details): ?>
                            <div class="md:col-span-2">
                                <p class="text-gray-600">Payment Details</p>
                                <p class="font-bold"><?php echo e($booking->refund_payment_details); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Caution Refund Logs -->
            <?php if($booking->cautionRefundLogs->count() > 0): ?>
                <div class="mt-6">
                    <h3 class="font-semibold text-lg mb-4 flex items-center">
                        <i class="fas fa-history text-primary mr-2"></i> Refund History
                    </h3>
                    <div class="space-y-3">
                        <?php $__currentLoopData = $booking->cautionRefundLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-light-bg border-l-4 border-primary p-4 rounded-lg">
                                <p class="font-semibold text-secondary"><?php echo e($log->actor->name); ?> <span class="text-sm text-gray-600">(<?php echo e($log->actor_role); ?>)</span></p>
                                <p class="text-sm text-gray-700 mt-1"><?php echo e($log->action); ?></p>
                                <p class="text-sm text-primary font-semibold mt-1"><?php echo e($log->previous_status); ?> → <?php echo e($log->new_status); ?></p>
                                <?php if($log->reason): ?>
                                    <p class="text-sm text-gray-600 mt-2 italic">"<?php echo e($log->reason); ?>"</p>
                                <?php endif; ?>
                                <p class="text-xs text-gray-500 mt-2"><i class="fas fa-clock mr-1"></i><?php echo e($log->created_at->format('M d, Y H:i')); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<!-- Activity Log -->
<?php if($booking->activities && $booking->activities->count() > 0): ?>
    <div class="mt-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-history text-primary mr-3"></i> Activity Log
            </h2>
            
            <div class="space-y-3">
                <?php $__currentLoopData = $booking->activities->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border-l-4 p-4 rounded
                        <?php if($activity->action === 'user_checkin'): ?> border-green-500 bg-green-50
                        <?php elseif($activity->action === 'user_checkout'): ?> border-blue-500 bg-blue-50
                        <?php elseif($activity->action === 'payment_verified'): ?> border-purple-500 bg-purple-50
                        <?php elseif($activity->action === 'booking_approved'): ?> border-teal-500 bg-teal-50
                        <?php else: ?> border-gray-500 bg-gray-50
                        <?php endif; ?>">
                        
                        <div class="flex items-start justify-between">
                            <div class="flex-1">
                                <div class="flex items-center gap-2 mb-2">
                                    <?php if($activity->action === 'user_checkin'): ?>
                                        <i class="fas fa-door-open text-green-600 text-lg"></i>
                                        <h3 class="font-semibold text-green-800">User Check-In</h3>
                                    <?php elseif($activity->action === 'user_checkout'): ?>
                                        <i class="fas fa-door-closed text-blue-600 text-lg"></i>
                                        <h3 class="font-semibold text-blue-800">User Check-Out</h3>
                                    <?php elseif($activity->action === 'payment_verified'): ?>
                                        <i class="fas fa-check-circle text-purple-600 text-lg"></i>
                                        <h3 class="font-semibold text-purple-800">Payment Verified</h3>
                                    <?php elseif($activity->action === 'booking_approved'): ?>
                                        <i class="fas fa-thumbs-up text-teal-600 text-lg"></i>
                                        <h3 class="font-semibold text-teal-800">Booking Approved</h3>
                                    <?php else: ?>
                                        <i class="fas fa-info-circle text-gray-600 text-lg"></i>
                                        <h3 class="font-semibold text-gray-800"><?php echo e(ucfirst(str_replace('_', ' ', $activity->action))); ?></h3>
                                    <?php endif; ?>
                                </div>
                                
                                <p class="text-sm text-gray-700 mb-2"><?php echo e($activity->description); ?></p>
                                
                                <?php if($activity->data): ?>
                                    <div class="text-xs text-gray-600 space-y-1 mt-2">
                                        <?php $data = is_string($activity->data) ? json_decode($activity->data, true) : $activity->data; ?>
                                        <?php if(isset($data['user_name'])): ?>
                                            <p><i class="fas fa-user mr-1"></i><strong>User:</strong> <?php echo e($data['user_name']); ?></p>
                                        <?php endif; ?>
                                        <?php if(isset($data['property'])): ?>
                                            <p><i class="fas fa-home mr-1"></i><strong>Property:</strong> <?php echo e($data['property']); ?></p>
                                        <?php endif; ?>
                                        <?php if(isset($data['checked_in_at'])): ?>
                                            <p><i class="fas fa-clock mr-1"></i><strong>Checked In:</strong> <?php echo e(\Carbon\Carbon::parse($data['checked_in_at'])->format('M d, Y h:i A')); ?></p>
                                        <?php endif; ?>
                                        <?php if(isset($data['checked_out_at'])): ?>
                                            <p><i class="fas fa-clock mr-1"></i><strong>Checked Out:</strong> <?php echo e(\Carbon\Carbon::parse($data['checked_out_at'])->format('M d, Y h:i A')); ?></p>
                                        <?php endif; ?>
                                        <?php if(isset($data['stay_duration'])): ?>
                                            <p><i class="fas fa-calendar mr-1"></i><strong>Duration:</strong> <?php echo e($data['stay_duration']); ?></p>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="text-right ml-4">
                                <p class="text-xs text-gray-500">
                                    <i class="fas fa-calendar-alt mr-1"></i><?php echo e($activity->created_at->format('M d, Y')); ?>

                                </p>
                                <p class="text-xs text-gray-500">
                                    <i class="fas fa-clock mr-1"></i><?php echo e($activity->created_at->format('h:i A')); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/bookings/show.blade.php ENDPATH**/ ?>