<?php $__env->startSection('title', 'Bank Transfer Payment'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-6xl mx-auto px-3 sm:px-4 py-4 sm:py-8">
    <!-- Header with Back Button -->
    <div class="mb-4 sm:mb-6">
        <a href="<?php echo e(route('vendor.ads.index')); ?>" class="text-primary hover:underline mb-2 inline-block text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i>Back to My Ads
        </a>
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                <i class="fas fa-university mr-2 sm:mr-3"></i>Complete Bank Transfer
            </h1>
            <p class="text-primary-light text-sm sm:text-base">Follow the instructions below to complete your payment</p>
        </div>
    </div>

    <div class="grid lg:grid-cols-3 gap-4 sm:gap-8">
        <!-- Bank Transfer Instructions -->
        <div class="lg:col-span-2 space-y-4 sm:space-y-6">
            <!-- Step 1: Bank Details -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-primary rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base">1</span>
                        Transfer to This Account
                    </h2>
                </div>

                <div class="p-4 sm:p-6">
                    <div class="grid md:grid-cols-2 gap-3 sm:gap-6 mb-4 sm:mb-6">
                        <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-primary">
                            <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">Bank Name</p>
                            <p class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($bankTransferMethod->settings['bank_name'] ?? 'N/A'); ?></p>
                        </div>

                        <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-l-4 border-primary">
                            <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">Account Name</p>
                            <p class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($bankTransferMethod->settings['account_name'] ?? 'N/A'); ?></p>
                        </div>
                    </div>

                    <div class="bg-gradient-to-r from-blue-50 to-primary/5 rounded-lg sm:rounded-xl p-4 sm:p-6 border-2 border-primary/20 mb-4 sm:mb-6">
                        <p class="text-xs text-gray-500 uppercase tracking-wide mb-2">Account Number</p>
                        <div class="flex flex-col sm:flex-row items-start sm:items-center sm:justify-between gap-3">
                            <p class="font-mono font-bold text-xl sm:text-2xl md:text-3xl text-primary tracking-wider break-all" id="account-number">
                                <?php echo e($bankTransferMethod->settings['account_number'] ?? 'N/A'); ?>

                            </p>
                            <button type="button" 
                                onclick="copyAccountNumber('<?php echo e($bankTransferMethod->settings['account_number'] ?? ''); ?>')"
                                class="bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark transition transform hover:scale-105 shadow-md text-sm sm:text-base whitespace-nowrap w-full sm:w-auto">
                                <i class="fas fa-copy mr-2"></i> Copy
                            </button>
                        </div>
                    </div>

                    <div class="bg-green-50 rounded-lg sm:rounded-xl p-4 sm:p-6 border-2 border-green-200">
                        <p class="text-sm text-gray-600 mb-2 flex items-center">
                            <i class="fas fa-money-bill-wave text-green-600 mr-2"></i>
                            Amount to Transfer
                        </p>
                        <?php if($vendorAd->discount_amount > 0): ?>
                            <div class="flex items-baseline gap-2 sm:gap-3 flex-wrap">
                                <p class="text-base sm:text-lg text-gray-400 line-through">₦<?php echo e(number_format($vendorAd->adPlan->price)); ?></p>
                                <p class="font-bold text-2xl sm:text-3xl md:text-4xl text-green-600">₦<?php echo e(number_format($vendorAd->final_amount ?? $vendorAd->adPlan->price)); ?></p>
                            </div>
                            <div class="mt-2 inline-flex items-center bg-green-100 text-green-700 px-2 sm:px-3 py-1 rounded-full text-xs sm:text-sm">
                                <i class="fas fa-tag mr-1 sm:mr-2"></i>
                                <span class="font-semibold"><?php echo e($vendorAd->promo_code); ?></span>
                                <span class="ml-1 sm:ml-2">- You saved ₦<?php echo e(number_format($vendorAd->discount_amount)); ?>!</span>
                            </div>
                        <?php else: ?>
                            <p class="font-bold text-2xl sm:text-3xl md:text-4xl text-green-600">₦<?php echo e(number_format($vendorAd->adPlan->price)); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Step 2: Important Instructions -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-yellow-500 to-orange-500 text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-yellow-600 rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base">2</span>
                        Important Instructions
                    </h2>
                </div>
                <div class="p-4 sm:p-6">
                    <div class="space-y-3 sm:space-y-4">
                        <div class="flex items-start">
                            <div class="bg-yellow-100 rounded-full p-2 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-check text-yellow-600 text-sm"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-800 text-sm sm:text-base">Transfer Exact Amount</p>
                                <p class="text-xs sm:text-sm text-gray-600">Transfer exactly <strong class="text-green-600">₦<?php echo e(number_format($vendorAd->final_amount ?? $vendorAd->adPlan->price)); ?></strong> to avoid delays</p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-yellow-100 rounded-full p-2 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-hashtag text-yellow-600 text-sm"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-800 text-sm sm:text-base">Use Payment Reference</p>
                                <p class="text-xs sm:text-sm text-gray-600 break-all">Reference: <strong class="font-mono bg-gray-100 px-2 py-1 rounded"><?php echo e($vendorAd->payment_reference); ?></strong></p>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-yellow-100 rounded-full p-2 mr-3 sm:mr-4 flex-shrink-0">
                                <i class="fas fa-clock text-yellow-600 text-sm"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-800 text-sm sm:text-base">Verification Time</p>
                                <p class="text-xs sm:text-sm text-gray-600">Payment will be verified within 24 hours</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 3: Upload Proof -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden">
                <div class="bg-gradient-to-r from-green-500 to-teal-500 text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h2 class="text-lg sm:text-xl font-bold flex items-center">
                        <span class="bg-white text-green-600 rounded-full w-7 h-7 sm:w-8 sm:h-8 flex items-center justify-center mr-2 sm:mr-3 font-bold text-sm sm:text-base">3</span>
                        Upload Payment Proof
                    </h2>
                </div>
                <div class="p-4 sm:p-6">
                    <form method="POST" action="<?php echo e(route('vendor.ads.upload-proof', $vendorAd)); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-gray-700 font-semibold mb-2 sm:mb-3 flex items-center text-sm sm:text-base">
                                <i class="fas fa-camera text-primary mr-2"></i>
                                Payment Receipt/Screenshot *
                            </label>
                            <div class="border-2 border-dashed border-gray-300 rounded-lg sm:rounded-xl p-4 sm:p-8 text-center hover:border-primary transition">
                                <i class="fas fa-cloud-upload-alt text-3xl sm:text-4xl text-gray-400 mb-2 sm:mb-3"></i>
                                <input type="file" name="payment_proof" accept="image/*" required
                                    class="w-full text-sm" id="file-input">
                                <p class="text-xs sm:text-sm text-gray-600 mt-2">
                                    Click to upload or drag and drop<br>
                                    <span class="text-xs text-gray-500">PNG, JPG up to 5MB</span>
                                </p>
                            </div>
                            <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mt-2 flex items-center">
                                    <i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?>

                                </p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <button type="submit" 
                            class="w-full bg-gradient-to-r from-green-600 to-teal-600 text-white py-3 sm:py-4 rounded-lg sm:rounded-xl hover:shadow-xl font-bold text-base sm:text-lg transition transform hover:scale-105">
                            <i class="fas fa-upload mr-2"></i> Submit Payment Proof
                        </button>
                    </form>
                </div>
            </div>

            <!-- Security Notice -->
            <div class="bg-gradient-to-r from-blue-50 to-primary/5 rounded-lg sm:rounded-xl p-3 sm:p-4 border border-primary/20">
                <div class="flex items-center">
                    <i class="fas fa-shield-alt text-primary text-xl sm:text-2xl mr-2 sm:mr-3 flex-shrink-0"></i>
                    <div>
                        <p class="font-semibold text-gray-800 text-sm sm:text-base">Secure Payment</p>
                        <p class="text-xs sm:text-sm text-gray-600">Your payment information is secure and will be verified by our team</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ad Summary Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden lg:sticky lg:top-4">
                <!-- Header -->
                <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-4 sm:px-6 py-3 sm:py-4">
                    <h3 class="font-bold text-base sm:text-lg flex items-center">
                        <i class="fas fa-receipt mr-2"></i>
                        Order Summary
                    </h3>
                </div>

                <!-- Property Image -->
                <div class="relative">
                    <img src="<?php echo e(isset($vendorAd->property->photos[0]) ? asset('storage/' . $vendorAd->property->photos[0]) : '/images/placeholder.jpg'); ?>" 
                        alt="<?php echo e($vendorAd->property->title); ?>" 
                        class="w-full h-40 sm:h-48 object-cover">
                    <div class="absolute top-0 left-0 right-0 bottom-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                </div>
                
                <!-- Property Details -->
                <div class="p-4 sm:p-6">
                    <h4 class="font-bold text-base sm:text-lg text-gray-800 mb-1"><?php echo e($vendorAd->property->title); ?></h4>
                    <p class="text-xs sm:text-sm text-gray-600 mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                        <?php echo e($vendorAd->property->city); ?>, <?php echo e($vendorAd->property->state); ?>

                    </p>

                    <!-- Ad Plan Details -->
                    <div class="bg-gray-50 rounded-lg p-3 sm:p-4 mb-3 sm:mb-4 space-y-2 sm:space-y-3">
                        <div class="flex justify-between items-center">
                            <span class="text-xs sm:text-sm text-gray-600 flex items-center">
                                <i class="fas fa-bullhorn text-primary mr-2"></i>Ad Plan
                            </span>
                            <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($vendorAd->adPlan->name); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-xs sm:text-sm text-gray-600 flex items-center">
                                <i class="fas fa-calendar text-primary mr-2"></i>Duration
                            </span>
                            <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($vendorAd->adPlan->duration_days); ?> days</span>
                        </div>
                    </div>

                    <!-- Pricing -->
                    <div class="border-t border-gray-200 pt-3 sm:pt-4">
                        <?php if($vendorAd->discount_amount > 0): ?>
                            <div class="space-y-2 mb-3">
                                <div class="flex justify-between text-xs sm:text-sm">
                                    <span class="text-gray-600">Original Price:</span>
                                    <span class="text-gray-400 line-through">₦<?php echo e(number_format($vendorAd->adPlan->price)); ?></span>
                                </div>
                                <div class="flex justify-between text-xs sm:text-sm bg-green-50 -mx-2 px-2 py-2 rounded">
                                    <span class="text-green-700 flex items-center">
                                        <i class="fas fa-tag mr-1"></i>
                                        Discount (<?php echo e($vendorAd->promo_code); ?>)
                                    </span>
                                    <span class="font-semibold text-green-700">-₦<?php echo e(number_format($vendorAd->discount_amount)); ?></span>
                                </div>
                            </div>
                            <div class="border-t border-gray-200 pt-3">
                                <div class="flex justify-between items-center">
                                    <span class="font-bold text-base sm:text-lg text-gray-800">Total Amount:</span>
                                    <span class="font-bold text-xl sm:text-2xl text-primary">₦<?php echo e(number_format($vendorAd->final_amount)); ?></span>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="flex justify-between items-center">
                                <span class="font-bold text-base sm:text-lg text-gray-800">Total Amount:</span>
                                <span class="font-bold text-xl sm:text-2xl text-primary">₦<?php echo e(number_format($vendorAd->adPlan->price)); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Reference -->
                    <div class="mt-3 sm:mt-4 bg-primary/5 rounded-lg p-3">
                        <p class="text-xs text-gray-500 uppercase tracking-wide mb-1">Payment Reference</p>
                        <p class="font-mono font-semibold text-xs sm:text-sm text-primary break-all"><?php echo e($vendorAd->payment_reference); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyAccountNumber(accountNumber) {
    const tempInput = document.createElement('input');
    tempInput.value = accountNumber;
    document.body.appendChild(tempInput);
    tempInput.select();
    
    try {
        document.execCommand('copy');
        
        const button = event.target.closest('button');
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check mr-1"></i> Copied!';
        button.classList.remove('bg-primary', 'hover:bg-primary-dark');
        button.classList.add('bg-green-600');
        
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('bg-green-600');
            button.classList.add('bg-primary', 'hover:bg-primary-dark');
        }, 2000);
    } catch (err) {
        alert('Failed to copy. Please copy manually: ' + accountNumber);
    }
    
    document.body.removeChild(tempInput);
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/ads/bank-transfer.blade.php ENDPATH**/ ?>