<?php $__env->startSection('title', 'Add New Property'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <h1 class="text-3xl font-bold mb-6">Add New Property</h1>

    <!-- Progress Steps -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div class="flex-1 text-center">
                <div class="step-indicator active" id="indicator-1">
                    <div class="w-12 h-12 mx-auto bg-primary text-white rounded-full flex items-center justify-center font-bold text-lg">1</div>
                    <p class="text-sm mt-2 font-semibold text-primary">Basic Info</p>
                </div>
            </div>
            <div class="flex-1 border-t-2 border-gray-300" id="line-1"></div>
            <div class="flex-1 text-center">
                <div class="step-indicator" id="indicator-2">
                    <div class="w-12 h-12 mx-auto bg-gray-300 text-gray-600 rounded-full flex items-center justify-center font-bold text-lg">2</div>
                    <p class="text-sm mt-2 text-gray-600">Amenities</p>
                </div>
            </div>
            <div class="flex-1 border-t-2 border-gray-300" id="line-2"></div>
            <div class="flex-1 text-center">
                <div class="step-indicator" id="indicator-3">
                    <div class="w-12 h-12 mx-auto bg-gray-300 text-gray-600 rounded-full flex items-center justify-center font-bold text-lg">3</div>
                    <p class="text-sm mt-2 text-gray-600">Photos & Finish</p>
                </div>
            </div>
        </div>
    </div>

    <form method="POST" action="<?php echo e(route('vendor.properties.store')); ?>" enctype="multipart/form-data" id="property-form" onsubmit="return validateAllSteps()">
        <?php echo csrf_field(); ?>

        <!-- Step 1: Basic Information -->
        <div class="step-content bg-white rounded-lg shadow-md p-8" id="step-1">
            <h2 class="font-bold text-2xl mb-6">Basic Information</h2>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Property Title *</label>
                <input type="text" name="title" value="<?php echo e(old('title')); ?>" required
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                    placeholder="e.g., Luxury 3-Bedroom Apartment in Victoria Island">
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Description *</label>
                <textarea name="description" rows="5" required
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                    placeholder="Describe your property..."><?php echo e(old('description')); ?></textarea>
            </div>

            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">House Type *</label>
                    <select name="house_type" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                        <option value="">Select Type</option>
                        <option value="Apartment">Apartment</option>
                        <option value="Villa">Villa</option>
                        <option value="Bungalow">Bungalow</option>
                        <option value="Duplex">Duplex</option>
                        <option value="Studio">Studio</option>
                        <option value="Penthouse">Penthouse</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Price per Night (₦) *</label>
                    <input type="number" name="price_per_night" value="<?php echo e(old('price_per_night')); ?>" 
                        min="0" step="1000" required
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                        placeholder="50000">
                </div>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Caution Fee (₦) *</label>
                <input type="number" name="caution_fee" value="<?php echo e(old('caution_fee', 0)); ?>" 
                    min="0" step="1000" required
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                    placeholder="20000">
                <p class="text-sm text-gray-600 mt-1">Refundable security deposit</p>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Full Address *</label>
                <input type="text" name="address" id="address-autocomplete" value="<?php echo e(old('address')); ?>" required
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                    placeholder="Start typing address... (e.g., 15 Admiralty Way, Lekki Phase 1)">
                <!-- Hidden fields for coordinates -->
                <input type="hidden" name="location_lat" id="location_lat" value="<?php echo e(old('location_lat')); ?>">
                <input type="hidden" name="location_lng" id="location_lng" value="<?php echo e(old('location_lng')); ?>">
                <p class="text-sm text-gray-600 mt-1">
                    <i class="fas fa-map-marker-alt mr-1"></i>
                    Start typing and select from suggestions for accurate location
                </p>
            </div>

            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">City *</label>
                    <input type="text" name="city" value="<?php echo e(old('city')); ?>" required
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                        placeholder="e.g., Lagos">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">State *</label>
                    <select name="state" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                        <option value="">Select State</option>
                        <option value="Lagos">Lagos</option>
                        <option value="Abuja">Abuja (FCT)</option>
                        <option value="Rivers">Rivers</option>
                        <option value="Oyo">Oyo</option>
                        <option value="Kano">Kano</option>
                        <option value="Kaduna">Kaduna</option>
                        <option value="Ogun">Ogun</option>
                        <option value="Enugu">Enugu</option>
                        <option value="Delta">Delta</option>
                        <option value="Edo">Edo</option>
                        <option value="Anambra">Anambra</option>
                    </select>
                </div>
            </div>

            <div class="grid md:grid-cols-4 gap-4 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Bedrooms *</label>
                    <input type="number" name="bedrooms" value="<?php echo e(old('bedrooms', 1)); ?>" 
                        min="0" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Beds *</label>
                    <input type="number" name="beds" value="<?php echo e(old('beds', 1)); ?>" 
                        min="1" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Bathrooms *</label>
                    <input type="number" name="bathrooms" value="<?php echo e(old('bathrooms', 1)); ?>" 
                        min="1" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Max Guests *</label>
                    <input type="number" name="max_guests" value="<?php echo e(old('max_guests', 2)); ?>" 
                        min="1" required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>
            </div>

            <div class="grid md:grid-cols-3 gap-4 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Check-in From *</label>
                    <input type="time" name="check_in_from" value="<?php echo e(old('check_in_from', '14:00')); ?>" 
                        required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Check-in Until *</label>
                    <input type="time" name="check_in_until" value="<?php echo e(old('check_in_until', '22:00')); ?>" 
                        required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2 font-semibold">Check-out Time *</label>
                    <input type="time" name="check_out_time" value="<?php echo e(old('check_out_time', '11:00')); ?>" 
                        required class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                </div>
            </div>

            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="allow_parties" value="1" class="mr-3 w-5 h-5">
                    <span class="font-semibold">Allow parties and events</span>
                </label>
            </div>

            <div class="flex justify-end">
                <button type="button" onclick="goToStep(2)" class="bg-primary text-white px-8 py-3 rounded-lg hover:bg-primary-dark font-semibold text-lg">
                    Next: Select Amenities <i class="fas fa-arrow-right ml-2"></i>
                </button>
            </div>
        </div>

        <!-- Step 2: Amenities -->
        <div class="step-content bg-white rounded-lg shadow-md p-8 hidden" id="step-2">
            <h2 class="font-bold text-2xl mb-4">Select Amenities</h2>
            <p class="text-gray-600 mb-6">Choose all amenities available at your property</p>

            <div class="space-y-6">
                <!-- Essentials -->
                <div class="border-2 border-blue-100 rounded-lg p-4">
                    <h3 class="font-semibold text-lg mb-3 flex items-center text-primary">
                        <i class="fas fa-home mr-2"></i> Essentials
                    </h3>
                    <div class="grid md:grid-cols-3 gap-3">
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="WiFi" class="mr-3 w-5 h-5">
                            <span>WiFi</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="Air Conditioning" class="mr-3 w-5 h-5">
                            <span>Air Conditioning</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="TV" class="mr-3 w-5 h-5">
                            <span>TV</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="Hot Water" class="mr-3 w-5 h-5">
                            <span>Hot Water</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="Heating" class="mr-3 w-5 h-5">
                            <span>Heating</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-blue-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Essentials][]" value="Towels & Bedding" class="mr-3 w-5 h-5">
                            <span>Towels & Bedding</span>
                        </label>
                    </div>
                </div>

                <!-- Kitchen -->
                <div class="border-2 border-green-100 rounded-lg p-4">
                    <h3 class="font-semibold text-lg mb-3 flex items-center text-green-600">
                        <i class="fas fa-utensils mr-2"></i> Kitchen & Dining
                    </h3>
                    <div class="grid md:grid-cols-3 gap-3">
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Full Kitchen" class="mr-3 w-5 h-5">
                            <span>Full Kitchen</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Refrigerator" class="mr-3 w-5 h-5">
                            <span>Refrigerator</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Microwave" class="mr-3 w-5 h-5">
                            <span>Microwave</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Stove" class="mr-3 w-5 h-5">
                            <span>Stove</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Dishwasher" class="mr-3 w-5 h-5">
                            <span>Dishwasher</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-green-50 hover:border-green-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Kitchen][]" value="Coffee Maker" class="mr-3 w-5 h-5">
                            <span>Coffee Maker</span>
                        </label>
                    </div>
                </div>

                <!-- Outdoor & Facilities -->
                <div class="border-2 border-purple-100 rounded-lg p-4">
                    <h3 class="font-semibold text-lg mb-3 flex items-center text-primary">
                        <i class="fas fa-tree mr-2"></i> Outdoor & Facilities
                    </h3>
                    <div class="grid md:grid-cols-3 gap-3">
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="Swimming Pool" class="mr-3 w-5 h-5">
                            <span>Swimming Pool</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="Gym" class="mr-3 w-5 h-5">
                            <span>Gym</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="Free Parking" class="mr-3 w-5 h-5">
                            <span>Free Parking</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="Balcony" class="mr-3 w-5 h-5">
                            <span>Balcony</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="Garden" class="mr-3 w-5 h-5">
                            <span>Garden</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-primary/5 hover:border-purple-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Outdoor][]" value="BBQ Grill" class="mr-3 w-5 h-5">
                            <span>BBQ Grill</span>
                        </label>
                    </div>
                </div>

                <!-- Safety & Other -->
                <div class="border-2 border-red-100 rounded-lg p-4">
                    <h3 class="font-semibold text-lg mb-3 flex items-center text-red-600">
                        <i class="fas fa-shield-alt mr-2"></i> Safety & Other
                    </h3>
                    <div class="grid md:grid-cols-3 gap-3">
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="Smoke Detector" class="mr-3 w-5 h-5">
                            <span>Smoke Detector</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="Fire Extinguisher" class="mr-3 w-5 h-5">
                            <span>Fire Extinguisher</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="Security Guard" class="mr-3 w-5 h-5">
                            <span>Security Guard</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="CCTV" class="mr-3 w-5 h-5">
                            <span>CCTV</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="Washing Machine" class="mr-3 w-5 h-5">
                            <span>Washing Machine</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-red-50 hover:border-red-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Safety][]" value="Generator" class="mr-3 w-5 h-5">
                            <span>Generator</span>
                        </label>
                    </div>
                </div>

                <!-- Entertainment -->
                <div class="border-2 border-yellow-100 rounded-lg p-4">
                    <h3 class="font-semibold text-lg mb-3 flex items-center text-yellow-600">
                        <i class="fas fa-gamepad mr-2"></i> Entertainment
                    </h3>
                    <div class="grid md:grid-cols-3 gap-3">
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-yellow-50 hover:border-yellow-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Entertainment][]" value="PS5" class="mr-3 w-5 h-5">
                            <span>PS5</span>
                        </label>
                        <label class="flex items-center p-3 border-2 rounded-lg hover:bg-yellow-50 hover:border-yellow-300 cursor-pointer transition">
                            <input type="checkbox" name="amenities[Entertainment][]" value="Snooker" class="mr-3 w-5 h-5">
                            <span>Snooker</span>
                        </label>
                    </div>
                </div>
            </div>

            <div class="flex justify-between mt-8">
                <button type="button" onclick="goToStep(1)" class="bg-gray-300 text-gray-700 px-8 py-3 rounded-lg hover:bg-gray-400 font-semibold text-lg">
                    <i class="fas fa-arrow-left mr-2"></i> Previous
                </button>
                <button type="button" onclick="goToStep(3)" class="bg-primary text-white px-8 py-3 rounded-lg hover:bg-primary-dark font-semibold text-lg">
                    Next: Upload Photos <i class="fas fa-arrow-right ml-2"></i>
                </button>
            </div>
        </div>

        <!-- Step 3: Photos & Finish -->
        <div class="step-content bg-white rounded-lg shadow-md p-8 hidden" id="step-3">
            <h2 class="font-bold text-2xl mb-6">Photos & Final Details</h2>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Property Photos *</label>
                <input type="file" name="photos[]" multiple accept="image/*" required
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none">
                <p class="text-sm text-gray-600 mt-1">Upload at least 3 high-quality photos (Max 10 photos, 5MB each)</p>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Highlighted Features (Optional)</label>
                <p class="text-sm text-gray-600 mb-2">Add special features that make your property stand out</p>
                <div id="features-list" class="space-y-2">
                    <input type="text" name="highlighted_features[]" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                        placeholder="e.g., Ocean view, Newly renovated">
                </div>
                <button type="button" onclick="addField('features')" class="mt-2 text-primary hover:text-primary-dark font-semibold">
                    <i class="fas fa-plus-circle mr-1"></i> Add Another Feature
                </button>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">House Rules (Optional)</label>
                <p class="text-sm text-gray-600 mb-2">Set clear expectations for your guests</p>
                <div id="rules-list" class="space-y-2">
                    <input type="text" name="house_rules[]" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none"
                        placeholder="e.g., No smoking indoors">
                </div>
                <button type="button" onclick="addField('rules')" class="mt-2 text-primary hover:text-primary-dark font-semibold">
                    <i class="fas fa-plus-circle mr-1"></i> Add Another Rule
                </button>
            </div>

            <div class="bg-primary/5 border-2 border-blue-200 rounded-lg p-6 mb-6">
                <h3 class="font-semibold text-lg mb-2 flex items-center text-blue-800">
                    <i class="fas fa-info-circle mr-2"></i> Before You Submit
                </h3>
                <ul class="text-sm text-blue-900 space-y-1">
                    <li>• Make sure all information is accurate</li>
                    <li>• Photos should be clear and well-lit</li>
                    <li>• Your property will be reviewed before going live</li>
                    <li>• You can edit details after submission</li>
                </ul>
            </div>

            <div class="flex justify-between">
                <button type="button" onclick="goToStep(2)" class="bg-gray-300 text-gray-700 px-8 py-3 rounded-lg hover:bg-gray-400 font-semibold text-lg">
                    <i class="fas fa-arrow-left mr-2"></i> Previous
                </button>
                <button type="submit" class="bg-green-600 text-white px-8 py-3 rounded-lg hover:bg-green-700 font-semibold text-lg">
                    <i class="fas fa-check-circle mr-2"></i> Submit Property
                </button>
            </div>
        </div>
    </form>
</div>

<script>
function validateStep(stepNumber) {
    const currentStep = document.getElementById('step-' + stepNumber);
    const requiredFields = currentStep.querySelectorAll('[required]');
    let isValid = true;
    let firstInvalidField = null;
    
    requiredFields.forEach(field => {
        // Remove previous error styling
        field.classList.remove('border-red-500');
        
        // Check if field is empty
        if (!field.value || field.value.trim() === '') {
            field.classList.add('border-red-500');
            isValid = false;
            if (!firstInvalidField) {
                firstInvalidField = field;
            }
        }
    });
    
    if (!isValid && firstInvalidField) {
        firstInvalidField.focus();
        firstInvalidField.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }
    
    return isValid;
}

function goToStep(step) {
    // Get current step number
    const currentStepElement = document.querySelector('.step-content:not(.hidden)');
    const currentStepNumber = currentStepElement ? parseInt(currentStepElement.id.split('-')[1]) : 1;
    
    // If moving forward, validate current step
    if (step > currentStepNumber) {
        if (!validateStep(currentStepNumber)) {
            return; // Don't proceed if validation fails
        }
    }
    
    // Hide all steps
    document.querySelectorAll('.step-content').forEach(el => el.classList.add('hidden'));
    
    // Show target step
    document.getElementById('step-' + step).classList.remove('hidden');
    
    // Update indicators
    for (let i = 1; i <= 3; i++) {
        const indicator = document.getElementById('indicator-' + i);
        const circle = indicator.querySelector('div');
        const text = indicator.querySelector('p');
        const line = document.getElementById('line-' + i);
        
        if (i < step) {
            // Completed steps
            circle.className = 'w-12 h-12 mx-auto bg-green-600 text-white rounded-full flex items-center justify-center font-bold text-lg';
            text.className = 'text-sm mt-2 font-semibold text-green-600';
            if (line) line.className = 'flex-1 border-t-2 border-green-600';
        } else if (i === step) {
            // Current step
            circle.className = 'w-12 h-12 mx-auto bg-primary text-white rounded-full flex items-center justify-center font-bold text-lg';
            text.className = 'text-sm mt-2 font-semibold text-primary';
            if (line) line.className = 'flex-1 border-t-2 border-gray-300';
        } else {
            // Future steps
            circle.className = 'w-12 h-12 mx-auto bg-gray-300 text-gray-600 rounded-full flex items-center justify-center font-bold text-lg';
            text.className = 'text-sm mt-2 text-gray-600';
            if (line) line.className = 'flex-1 border-t-2 border-gray-300';
        }
    }
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function validateAllSteps() {
    // Validate all steps before submission
    for (let i = 1; i <= 3; i++) {
        if (!validateStep(i)) {
            // Show the step with errors
            goToStep(i);
            return false;
        }
    }
    return true;
}

function addField(type) {
    const container = document.getElementById(type + '-list');
    const input = document.createElement('input');
    input.type = 'text';
    input.name = (type === 'features' ? 'highlighted_features' : 'house_rules') + '[]';
    input.className = 'w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none';
    input.placeholder = type === 'features' ? 'e.g., City view' : 'e.g., Check-out by 11 AM';
    container.appendChild(input);
}

// Add event listeners to remove error styling when user types
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('property-form');
    if (form) {
        form.addEventListener('input', function(e) {
            if (e.target.hasAttribute('required') && e.target.value.trim() !== '') {
                e.target.classList.remove('border-red-500');
                e.target.classList.add('border-green-500');
                setTimeout(() => {
                    e.target.classList.remove('border-green-500');
                }, 1000);
            }
        });
    }
});

// Google Places Autocomplete
let autocomplete;

function initAutocomplete() {
    const addressInput = document.getElementById('address-autocomplete');
    
    if (!addressInput) return;
    
    // Initialize autocomplete with Nigeria bias
    autocomplete = new google.maps.places.Autocomplete(addressInput, {
        types: ['address'],
        componentRestrictions: { country: 'ng' }, // Restrict to Nigeria
        fields: ['address_components', 'formatted_address', 'geometry']
    });
    
    // Listen for place selection
    autocomplete.addListener('place_changed', function() {
        const place = autocomplete.getPlace();
        
        if (!place.address_components) {
            console.log('No address components found');
            return;
        }
        
        // Extract address components
        let city = '';
        let state = '';
        
        place.address_components.forEach(component => {
            const types = component.types;
            
            if (types.includes('locality') || types.includes('administrative_area_level_2')) {
                city = component.long_name;
            }
            
            if (types.includes('administrative_area_level_1')) {
                state = component.long_name;
            }
        });
        
        // Auto-fill city and state fields
        const cityInput = document.querySelector('input[name="city"]');
        const stateSelect = document.querySelector('select[name="state"]');
        
        if (city && cityInput) {
            cityInput.value = city;
            cityInput.classList.remove('border-red-500');
        }
        
        if (state && stateSelect) {
            // Try to match the state with select options
            const stateOptions = stateSelect.querySelectorAll('option');
            stateOptions.forEach(option => {
                if (option.value.toLowerCase().includes(state.toLowerCase()) || 
                    state.toLowerCase().includes(option.value.toLowerCase())) {
                    stateSelect.value = option.value;
                    stateSelect.classList.remove('border-red-500');
                }
            });
        }
        
        // Store coordinates if available
        if (place.geometry && place.geometry.location) {
            const latInput = document.getElementById('location_lat');
            const lngInput = document.getElementById('location_lng');
            
            if (latInput) latInput.value = place.geometry.location.lat();
            if (lngInput) lngInput.value = place.geometry.location.lng();
        }
        
        // Show success message
        showAddressSuccess();
    });
}

function showAddressSuccess() {
    const addressInput = document.getElementById('address-autocomplete');
    const originalBorder = addressInput.className;
    
    // Temporarily show success styling
    addressInput.className = addressInput.className.replace('focus:border-primary', 'border-green-500');
    
    // Create success message
    const successMsg = document.createElement('div');
    successMsg.className = 'text-green-600 text-sm mt-1 flex items-center';
    successMsg.innerHTML = '<i class="fas fa-check-circle mr-1"></i> Address details auto-filled!';
    
    // Insert after address input
    addressInput.parentNode.appendChild(successMsg);
    
    // Remove after 3 seconds
    setTimeout(() => {
        addressInput.className = originalBorder;
        if (successMsg.parentNode) {
            successMsg.parentNode.removeChild(successMsg);
        }
    }, 3000);
}

// Load Google Maps API with Places library
function loadGoogleMapsAPI() {
    if (typeof google !== 'undefined' && google.maps && google.maps.places) {
        initAutocomplete();
        return;
    }
    
    const script = document.createElement('script');
    script.src = `https://maps.googleapis.com/maps/api/js?key=<?php echo e(config('services.google.maps_api_key')); ?>&libraries=places&callback=initAutocomplete`;
    script.async = true;
    script.defer = true;
    document.head.appendChild(script);
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', loadGoogleMapsAPI);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/properties/create.blade.php ENDPATH**/ ?>