<?php $__env->startSection('title', $car->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-4 sm:py-8">
    <div class="container mx-auto px-3 sm:px-4">
        <!-- Back Button -->
        <div class="mb-4 sm:mb-6">
            <a href="<?php echo e(route('cars.index')); ?>" class="inline-flex items-center text-primary hover:text-green-700 font-semibold text-sm sm:text-base">
                <i class="fas fa-arrow-left mr-2"></i>Back to Cars
            </a>
        </div>

        <div class="grid lg:grid-cols-3 gap-4 sm:gap-6 lg:gap-8">
            <!-- Main Content -->
            <div class="lg:col-span-2">
                <!-- Photo Gallery -->
                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden mb-4 sm:mb-6">
                    <?php if($car->photos && count($car->photos) > 0): ?>
                        <div class="relative">
                            <img id="main-photo" src="<?php echo e(asset('storage/' . $car->photos[0])); ?>" 
                                alt="<?php echo e($car->full_name); ?>"
                                class="w-full h-56 sm:h-72 md:h-96 object-cover">
                            
                            <!-- Category Badge -->
                            <div class="absolute top-2 sm:top-4 left-2 sm:left-4 bg-white/90 backdrop-blur-sm px-2 sm:px-4 py-1 sm:py-2 rounded-full text-xs sm:text-sm">
                                <i class="fas <?php echo e($car->category->icon); ?> text-primary mr-1 sm:mr-2"></i>
                                <span class="font-semibold"><?php echo e($car->category->name); ?></span>
                            </div>

                            <!-- Rating Badge -->
                            <?php if($car->average_rating > 0): ?>
                                <div class="absolute top-2 sm:top-4 right-2 sm:right-4 bg-yellow-500 text-white px-2 sm:px-4 py-1 sm:py-2 rounded-full font-bold text-xs sm:text-sm">
                                    <i class="fas fa-star mr-1"></i><?php echo e(number_format($car->average_rating, 1)); ?>

                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Thumbnail Gallery -->
                        <?php if(count($car->photos) > 1): ?>
                            <div class="p-2 sm:p-4 grid grid-cols-4 sm:grid-cols-5 gap-1 sm:gap-2">
                                <?php $__currentLoopData = $car->photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <img src="<?php echo e(asset('storage/' . $photo)); ?>" 
                                        alt="Photo <?php echo e($index + 1); ?>"
                                        class="w-full h-16 sm:h-20 object-cover rounded-lg cursor-pointer hover:opacity-75 transition <?php echo e($index === 0 ? 'ring-2 ring-green-600' : ''); ?>"
                                        onclick="changeMainPhoto('<?php echo e(asset('storage/' . $photo)); ?>', this)">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="w-full h-56 sm:h-72 md:h-96 bg-gray-200 flex items-center justify-center">
                            <i class="fas fa-car text-gray-400 text-6xl sm:text-8xl"></i>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Car Details -->
                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-800 mb-2"><?php echo e($car->full_name); ?></h1>
                    <p class="text-base sm:text-lg text-gray-600 mb-4">
                        <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                        <?php echo e($car->city); ?>, <?php echo e($car->state); ?>

                    </p>

                    <!-- Key Specs -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-2 sm:gap-4 mb-4 sm:mb-6 pb-4 sm:pb-6 border-b">
                        <div class="text-center p-3 sm:p-4 bg-gray-50 rounded-lg">
                            <i class="fas fa-users text-primary text-xl sm:text-2xl mb-2"></i>
                            <p class="text-xs sm:text-sm text-gray-600">Seats</p>
                            <p class="font-bold text-gray-800 text-sm sm:text-base"><?php echo e($car->seats); ?></p>
                        </div>
                        <div class="text-center p-3 sm:p-4 bg-gray-50 rounded-lg">
                            <i class="fas fa-cog text-primary text-xl sm:text-2xl mb-2"></i>
                            <p class="text-xs sm:text-sm text-gray-600">Transmission</p>
                            <p class="font-bold text-gray-800 text-sm sm:text-base"><?php echo e(ucfirst($car->transmission)); ?></p>
                        </div>
                        <div class="text-center p-3 sm:p-4 bg-gray-50 rounded-lg">
                            <i class="fas fa-gas-pump text-primary text-xl sm:text-2xl mb-2"></i>
                            <p class="text-xs sm:text-sm text-gray-600">Fuel</p>
                            <p class="font-bold text-gray-800 text-sm sm:text-base"><?php echo e(ucfirst($car->fuel_type)); ?></p>
                        </div>
                        <div class="text-center p-3 sm:p-4 bg-gray-50 rounded-lg">
                            <i class="fas fa-suitcase text-primary text-xl sm:text-2xl mb-2"></i>
                            <p class="text-xs sm:text-sm text-gray-600">Luggage</p>
                            <p class="font-bold text-gray-800 text-sm sm:text-base"><?php echo e($car->luggage_capacity); ?></p>
                        </div>
                    </div>

                    <!-- Description -->
                    <?php if($car->description): ?>
                        <div class="mb-4 sm:mb-6">
                            <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 sm:mb-3">
                                <i class="fas fa-align-left text-primary mr-2"></i>Description
                            </h2>
                            <p class="text-gray-700 leading-relaxed text-sm sm:text-base"><?php echo e($car->description); ?></p>
                        </div>
                    <?php endif; ?>

                    <!-- Features -->
                    <?php if($car->features && count($car->features) > 0): ?>
                        <div class="mb-4 sm:mb-6">
                            <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 sm:mb-3">
                                <i class="fas fa-star text-primary mr-2"></i>Features
                            </h2>
                            <div class="grid sm:grid-cols-2 md:grid-cols-3 gap-2 sm:gap-3">
                                <?php if($car->air_conditioning): ?>
                                    <div class="flex items-center p-2 sm:p-3 bg-primary/5 rounded-lg">
                                        <i class="fas fa-snowflake text-primary mr-2 flex-shrink-0"></i>
                                        <span class="text-xs sm:text-sm text-gray-700">Air Conditioning</span>
                                    </div>
                                <?php endif; ?>
                                <?php $__currentLoopData = $car->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center p-2 sm:p-3 bg-primary/5 rounded-lg">
                                        <i class="fas fa-check-circle text-primary mr-2 flex-shrink-0"></i>
                                        <span class="text-xs sm:text-sm text-gray-700"><?php echo e($feature); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Specifications -->
                    <div class="mb-4 sm:mb-6">
                        <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 sm:mb-3">
                            <i class="fas fa-info-circle text-primary mr-2"></i>Specifications
                        </h2>
                        <div class="grid sm:grid-cols-2 gap-2 sm:gap-4">
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Brand</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->brand); ?></span>
                            </div>
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Model</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->model); ?></span>
                            </div>
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Year</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->year); ?></span>
                            </div>
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Color</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->color); ?></span>
                            </div>
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Doors</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->doors); ?></span>
                            </div>
                            <div class="flex justify-between p-2 sm:p-3 bg-gray-50 rounded-lg">
                                <span class="text-gray-600 text-xs sm:text-sm">Plate Number</span>
                                <span class="font-semibold text-gray-800 text-xs sm:text-sm"><?php echo e($car->plate_number); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Rental Terms -->
                    <?php if($car->rental_terms): ?>
                        <div class="mb-4 sm:mb-6">
                            <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 sm:mb-3">
                                <i class="fas fa-file-contract text-primary mr-2"></i>Rental Terms
                            </h2>
                            <div class="bg-blue-50 border-l-4 border-blue-500 p-3 sm:p-4 rounded">
                                <p class="text-gray-700 text-xs sm:text-sm whitespace-pre-line"><?php echo e($car->rental_terms); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Cancellation Policy -->
                    <?php if($car->cancellation_policy): ?>
                        <div>
                            <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2 sm:mb-3">
                                <i class="fas fa-ban text-primary mr-2"></i>Cancellation Policy
                            </h2>
                            <div class="bg-yellow-50 border-l-4 border-yellow-500 p-3 sm:p-4 rounded">
                                <p class="text-gray-700 text-xs sm:text-sm whitespace-pre-line"><?php echo e($car->cancellation_policy); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Reviews Section - Moved inside main content for mobile -->
                <div class="lg:hidden mb-4 sm:mb-6">
                    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
                        <h2 class="text-xl sm:text-2xl font-bold text-gray-800">
                            <i class="fas fa-star text-yellow-500 mr-2"></i>Reviews & Ratings
                        </h2>
                        <?php if($car->average_rating > 0): ?>
                            <div class="flex items-center gap-2">
                                <div class="text-2xl sm:text-3xl font-bold text-gray-800"><?php echo e(number_format($car->average_rating, 1)); ?></div>
                                <div>
                                    <div class="flex text-yellow-400">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star text-sm <?php echo e($i <= round($car->average_rating) ? '' : 'text-gray-300'); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <p class="text-xs sm:text-sm text-gray-600"><?php echo e($car->reviews_count); ?> <?php echo e(Str::plural('review', $car->reviews_count)); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if($car->approvedReviews->count() > 0): ?>
                        <div class="space-y-3 sm:space-y-4">
                            <?php $__currentLoopData = $car->approvedReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                                    <div class="flex justify-between items-start mb-2 sm:mb-3">
                                        <div>
                                            <h4 class="font-bold text-gray-800 text-sm sm:text-base"><?php echo e($review->user->name); ?></h4>
                                            <p class="text-xs sm:text-sm text-gray-500"><?php echo e($review->created_at->format('M d, Y')); ?></p>
                                        </div>
                                        <div class="flex text-yellow-400">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <i class="fas fa-star text-xs sm:text-sm <?php echo e($i <= $review->overall_rating ? '' : 'text-gray-300'); ?>"></i>
                                            <?php endfor; ?>
                                        </div>
                                    </div>
                                    <p class="text-gray-700 text-sm"><?php echo e($review->comment); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-8 sm:p-12 text-center">
                            <i class="fas fa-star text-gray-300 text-4xl sm:text-5xl mb-3 sm:mb-4"></i>
                            <p class="text-gray-600 text-base sm:text-lg">No reviews yet</p>
                            <p class="text-gray-500 text-xs sm:text-sm">Be the first to review this car!</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Booking Sidebar -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 lg:sticky lg:top-4">
                    <!-- Price -->
                    <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b">
                        <p class="text-2xl sm:text-3xl font-bold text-primary">₦<?php echo e(number_format($car->price_per_day)); ?></p>
                        <p class="text-gray-600 text-sm sm:text-base">per day</p>
                        
                        <?php if($car->price_per_week): ?>
                            <p class="text-xs sm:text-sm text-gray-600 mt-2">
                                <i class="fas fa-calendar-week mr-1"></i>
                                Weekly: ₦<?php echo e(number_format($car->price_per_week)); ?>

                            </p>
                        <?php endif; ?>
                        
                        <?php if($car->price_per_month): ?>
                            <p class="text-xs sm:text-sm text-gray-600">
                                <i class="fas fa-calendar-alt mr-1"></i>
                                Monthly: ₦<?php echo e(number_format($car->price_per_month)); ?>

                            </p>
                        <?php endif; ?>
                    </div>

                    <!-- Rental Requirements -->
                    <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b">
                        <h3 class="font-bold text-gray-800 mb-2 sm:mb-3 text-sm sm:text-base">
                            <i class="fas fa-user-check text-primary mr-2"></i>Requirements
                        </h3>
                        <div class="space-y-2 text-xs sm:text-sm">
                            <p class="flex items-center text-gray-700">
                                <i class="fas fa-birthday-cake text-primary mr-2 w-4 sm:w-5 flex-shrink-0"></i>
                                Min. age: <?php echo e($car->minimum_driver_age); ?> years
                            </p>
                            <p class="flex items-center text-gray-700">
                                <i class="fas fa-id-card text-primary mr-2 w-4 sm:w-5 flex-shrink-0"></i>
                                License: <?php echo e($car->minimum_license_years); ?>+ years
                            </p>
                            <p class="flex items-center text-gray-700">
                                <i class="fas fa-calendar text-primary mr-2 w-4 sm:w-5 flex-shrink-0"></i>
                                Min. rental: <?php echo e($car->minimum_rental_days); ?> <?php echo e(Str::plural('day', $car->minimum_rental_days)); ?>

                            </p>
                            <?php if($car->security_deposit > 0): ?>
                                <p class="flex items-center text-gray-700">
                                    <i class="fas fa-shield-alt text-primary mr-2 w-4 sm:w-5 flex-shrink-0"></i>
                                    Deposit: ₦<?php echo e(number_format($car->security_deposit)); ?>

                                </p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Pickup Location -->
                    <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b">
                        <h3 class="font-bold text-gray-800 mb-2 text-sm sm:text-base">
                            <i class="fas fa-location-arrow text-primary mr-2"></i>Pickup Location
                        </h3>
                        <p class="text-xs sm:text-sm text-gray-700"><?php echo e($car->pickup_location); ?></p>
                    </div>

                    <!-- Vendor Info -->
                    <div class="mb-4 sm:mb-6 pb-4 sm:pb-6 border-b">
                        <h3 class="font-bold text-gray-800 mb-2 text-sm sm:text-base">
                            <i class="fas fa-store text-primary mr-2"></i>Vendor
                        </h3>
                        <p class="text-xs sm:text-sm text-gray-700"><?php echo e($car->vendor->company_name); ?></p>
                    </div>

                    <!-- Book Button -->
                    <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('cars.booking', $car)); ?>" 
                            class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center px-4 sm:px-6 py-3 sm:py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                            <i class="fas fa-calendar-check mr-2"></i>Book Now
                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" 
                            class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center px-4 sm:px-6 py-3 sm:py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                            <i class="fas fa-sign-in-alt mr-2"></i>Login to Book
                        </a>
                    <?php endif; ?>

                    <p class="text-xs text-gray-500 text-center mt-2 sm:mt-3">
                        <i class="fas fa-info-circle mr-1"></i>
                        Free cancellation available
                    </p>
                </div>
            </div>
        </div>

        <!-- Reviews Section - Desktop only -->
        <div class="hidden lg:block mt-8 lg:mt-12">
            <div class="flex justify-between items-center mb-6">
                <h2 class="text-2xl font-bold text-gray-800">
                    <i class="fas fa-star text-yellow-500 mr-2"></i>Reviews & Ratings
                </h2>
                <?php if($car->average_rating > 0): ?>
                    <div class="text-right">
                        <div class="flex items-center gap-2">
                            <div class="text-3xl font-bold text-gray-800"><?php echo e(number_format($car->average_rating, 1)); ?></div>
                            <div>
                                <div class="flex text-yellow-400">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas fa-star <?php echo e($i <= round($car->average_rating) ? '' : 'text-gray-300'); ?>"></i>
                                    <?php endfor; ?>
                                </div>
                                <p class="text-sm text-gray-600"><?php echo e($car->reviews_count); ?> <?php echo e(Str::plural('review', $car->reviews_count)); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php if($car->approvedReviews->count() > 0): ?>
                <div class="space-y-4">
                    <?php $__currentLoopData = $car->approvedReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="bg-white rounded-xl shadow-lg p-6">
                            <div class="flex justify-between items-start mb-3">
                                <div>
                                    <h4 class="font-bold text-gray-800"><?php echo e($review->user->name); ?></h4>
                                    <p class="text-sm text-gray-500"><?php echo e($review->created_at->format('M d, Y')); ?></p>
                                </div>
                                <div class="flex text-yellow-400">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas fa-star <?php echo e($i <= $review->overall_rating ? '' : 'text-gray-300'); ?>"></i>
                                    <?php endfor; ?>
                                </div>
                            </div>
                            <p class="text-gray-700"><?php echo e($review->comment); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="bg-white rounded-xl shadow-lg p-12 text-center">
                    <i class="fas fa-star text-gray-300 text-5xl mb-4"></i>
                    <p class="text-gray-600 text-lg">No reviews yet</p>
                    <p class="text-gray-500 text-sm">Be the first to review this car!</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Similar Cars -->
        <?php if($similarCars->count() > 0): ?>
            <div class="mt-8 sm:mt-12">
                <h2 class="text-xl sm:text-2xl font-bold text-gray-800 mb-4 sm:mb-6">
                    <i class="fas fa-car text-primary mr-2"></i>Similar Cars
                </h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3 sm:gap-6">
                    <?php $__currentLoopData = $similarCars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $similarCar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('cars.show', $similarCar)); ?>" 
                            class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition transform hover:-translate-y-1">
                            <div class="h-32 sm:h-40 bg-gray-200">
                                <?php if($similarCar->main_photo): ?>
                                    <img src="<?php echo e(asset('storage/' . $similarCar->main_photo)); ?>" 
                                        alt="<?php echo e($similarCar->full_name); ?>"
                                        class="w-full h-full object-cover">
                                <?php endif; ?>
                            </div>
                            <div class="p-3 sm:p-4">
                                <h3 class="font-bold text-gray-800 mb-1 sm:mb-2 text-sm sm:text-base line-clamp-2"><?php echo e($similarCar->full_name); ?></h3>
                                <p class="text-lg sm:text-2xl font-bold text-primary">₦<?php echo e(number_format($similarCar->price_per_day)); ?></p>
                                <p class="text-xs text-gray-500">per day</p>
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function changeMainPhoto(photoUrl, thumbnail) {
    document.getElementById('main-photo').src = photoUrl;
    
    // Update active thumbnail
    document.querySelectorAll('.grid img').forEach(img => {
        img.classList.remove('ring-2', 'ring-green-600');
    });
    thumbnail.classList.add('ring-2', 'ring-green-600');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/cars/show.blade.php ENDPATH**/ ?>