<?php $__env->startSection('title', 'Become a Vendor'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow-md p-8">
        <h1 class="text-2xl font-bold mb-6 text-center">Become a Vendor on ShortStayNG</h1>
        <p class="text-gray-600 mb-6 text-center">List your properties and start earning today!</p>

        <?php if(isset($vendorRegistrationEnabled) && !$vendorRegistrationEnabled): ?>
            <div class="bg-red-50 border-2 border-red-200 rounded-lg p-6 text-center">
                <i class="fas fa-exclamation-circle text-red-500 text-4xl mb-3"></i>
                <h2 class="text-xl font-bold text-red-800 mb-2">Vendor Registration Disabled</h2>
                <p class="text-red-700 mb-4">Vendor registration is currently disabled by the administrator.</p>
                <?php if(isset($userRegistrationEnabled) && $userRegistrationEnabled): ?>
                    <p class="text-gray-700 mb-4">However, user registration is still available.</p>
                    <a href="<?php echo e(route('register')); ?>" class="inline-block bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark font-semibold">
                        Register as User
                    </a>
                <?php endif; ?>
                <div class="mt-4">
                    <a href="<?php echo e(route('login')); ?>" class="text-primary hover:underline">
                        Back to Login
                    </a>
                </div>
            </div>
        <?php else: ?>
        <form method="POST" action="<?php echo e(route('register')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="register_as_vendor" value="1">

            <div class="grid md:grid-cols-2 gap-4">
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Full Name *</label>
                    <input type="text" name="name" value="<?php echo e(old('name')); ?>" required
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Email *</label>
                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" required
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">
                        Phone Number (Preferably WhatsApp) *
                        <i class="fab fa-whatsapp text-green-600 ml-1"></i>
                    </label>
                    <input type="tel" name="phone" value="<?php echo e(old('phone')); ?>" 
                        placeholder="+234... (WhatsApp preferred)" required
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <p class="text-xs text-gray-500 mt-1">
                        <i class="fas fa-info-circle mr-1"></i>
                        We'll use this number for important notifications via WhatsApp
                    </p>
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Company Name *</label>
                    <input type="text" name="company_name" value="<?php echo e(old('company_name')); ?>" required
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Password *</label>
                    <div class="relative">
                        <input type="password" id="password" name="password" required
                            class="w-full border rounded px-4 py-2 pr-10 <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <button type="button" onclick="togglePassword('password', 'toggleIcon1')" 
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700">
                            <i id="toggleIcon1" class="fas fa-eye"></i>
                        </button>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Confirm Password *</label>
                    <div class="relative">
                        <input type="password" id="password_confirmation" name="password_confirmation" required
                            class="w-full border rounded px-4 py-2 pr-10">
                        <button type="button" onclick="togglePassword('password_confirmation', 'toggleIcon2')" 
                            class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700">
                            <i id="toggleIcon2" class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Company Description (Optional)</label>
                <textarea name="company_description" rows="3"
                    class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['company_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('company_description')); ?></textarea>
                <?php $__errorArgs = ['company_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Service Type Selection -->
            <div class="mb-6">
                <label class="block text-gray-700 mb-3 font-semibold">
                    <i class="fas fa-briefcase mr-2 text-primary"></i>What services will you offer? *
                </label>
                <p class="text-sm text-gray-600 mb-4">Select all that apply. You can add more services later.</p>
                
                <div class="grid md:grid-cols-2 gap-4">
                    <!-- Property Shortlet -->
                    <label class="relative cursor-pointer">
                        <input type="checkbox" name="service_types[]" value="property" 
                            <?php echo e(in_array('property', old('service_types', [])) ? 'checked' : ''); ?>

                            class="peer sr-only">
                        <div class="border-2 rounded-xl p-6 transition-all peer-checked:border-primary peer-checked:bg-blue-50 hover:shadow-md">
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center peer-checked:bg-primary peer-checked:text-white">
                                        <i class="fas fa-home text-2xl text-primary peer-checked:text-white"></i>
                                    </div>
                                </div>
                                <div class="ml-4 flex-1">
                                    <h3 class="font-bold text-lg mb-1">Property Shortlet</h3>
                                    <p class="text-sm text-gray-600">List apartments, houses, and vacation rentals</p>
                                </div>
                                <div class="ml-2">
                                    <i class="fas fa-check-circle text-2xl text-primary opacity-0 peer-checked:opacity-100 transition-opacity"></i>
                                </div>
                            </div>
                        </div>
                    </label>

                    <!-- Car Rental -->
                    <?php
                        $carRentalEnabled = \App\Models\Setting::where('key', 'car_rental_enabled')->value('value') == '1';
                    ?>
                    
                    <?php if($carRentalEnabled): ?>
                    <label class="relative cursor-pointer">
                        <input type="checkbox" name="service_types[]" value="car_rental" 
                            <?php echo e(in_array('car_rental', old('service_types', [])) ? 'checked' : ''); ?>

                            class="peer sr-only">
                        <div class="border-2 rounded-xl p-6 transition-all peer-checked:border-green-600 peer-checked:bg-green-50 hover:shadow-md">
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center peer-checked:bg-green-600">
                                        <i class="fas fa-car text-2xl text-green-600 peer-checked:text-white"></i>
                                    </div>
                                </div>
                                <div class="ml-4 flex-1">
                                    <h3 class="font-bold text-lg mb-1">Car Rental</h3>
                                    <p class="text-sm text-gray-600">Rent out vehicles to travelers</p>
                                </div>
                                <div class="ml-2">
                                    <i class="fas fa-check-circle text-2xl text-green-600 opacity-0 peer-checked:opacity-100 transition-opacity"></i>
                                </div>
                            </div>
                        </div>
                    </label>
                    <?php else: ?>
                    <div class="border-2 border-gray-200 rounded-xl p-6 bg-gray-50 opacity-60">
                        <div class="flex items-start">
                            <div class="flex-shrink-0">
                                <div class="w-12 h-12 bg-gray-200 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-car text-2xl text-gray-400"></i>
                                </div>
                            </div>
                            <div class="ml-4 flex-1">
                                <h3 class="font-bold text-lg mb-1 text-gray-500">Car Rental</h3>
                                <p class="text-sm text-gray-500">Coming soon! This feature is not yet available.</p>
                            </div>
                            <div class="ml-2">
                                <i class="fas fa-lock text-xl text-gray-400"></i>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                
                <?php $__errorArgs = ['service_types'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                
                <p class="text-xs text-gray-500 mt-3">
                    <i class="fas fa-info-circle mr-1"></i>
                    You must select at least one service type. Additional KYC verification will be required for each service.
                </p>
            </div>

            <div class="mb-4">
                <label class="flex items-start">
                    <input type="checkbox" name="terms" required class="mr-2 mt-1">
                    <span class="text-sm">I agree to the 
                        <a href="<?php echo e(route('terms')); ?>" class="text-primary hover:underline" target="_blank">
                            Terms & Conditions
                        </a> and understand the commission structure
                    </span>
                </label>
            </div>

            <!-- CAPTCHA -->
            <div class="mb-6">
                <label class="block text-gray-700 mb-2 font-semibold">Security Verification</label>
                <div class="bg-gray-50 border-2 border-gray-200 rounded-lg p-4">
                    <div class="flex items-center gap-4 mb-3">
                        <img id="captcha-image" src="" alt="CAPTCHA" class="border-2 border-gray-300 rounded">
                        <button type="button" onclick="refreshCaptcha()" 
                            class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark transition">
                            <i class="fas fa-sync-alt"></i> Refresh
                        </button>
                    </div>
                    <input type="text" name="captcha" required placeholder="Enter the code above"
                        class="w-full border rounded px-4 py-2 <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                    <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <button type="submit" 
                class="w-full bg-primary text-white py-3 rounded hover:bg-primary-dark font-semibold">
                Register as Vendor
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-gray-600">Already have an account?</p>
            <a href="<?php echo e(route('login')); ?>" class="text-primary hover:underline">
                Login here
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function togglePassword(inputId, iconId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById(iconId);
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}

// CAPTCHA Functions
function refreshCaptcha() {
    fetch('<?php echo e(route('captcha.generate')); ?>')
        .then(response => response.json())
        .then(data => {
            document.getElementById('captcha-image').src = data.image;
        })
        .catch(error => console.error('Error loading CAPTCHA:', error));
}

// Load CAPTCHA on page load
document.addEventListener('DOMContentLoaded', function() {
    refreshCaptcha();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/auth/vendor-register.blade.php ENDPATH**/ ?>