<?php $__env->startSection('title', 'Complete Ad Payment'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-3 sm:px-4 py-4 sm:py-8">
    <h1 class="text-2xl sm:text-3xl font-bold mb-4 sm:mb-6">Complete Payment</h1>

    <div class="grid md:grid-cols-3 gap-4 sm:gap-8">
        <!-- Payment Method Selection -->
        <div class="md:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
                <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4">Select Payment Method</h2>

                <?php if(count($availablePaymentMethods) === 0): ?>
                    <div class="bg-yellow-100 border border-yellow-400 text-yellow-800 px-3 sm:px-4 py-2 sm:py-3 rounded text-sm sm:text-base">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        No payment methods are currently available. Please contact support.
                    </div>
                <?php else: ?>
                    <form method="POST" action="<?php echo e(route('vendor.ads.process-payment', $vendorAd)); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="space-y-3 sm:space-y-4 mb-4 sm:mb-6">
                            <?php $__currentLoopData = $availablePaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <label class="block">
                                    <input type="radio" name="payment_method" value="<?php echo e($method['id']); ?>" required
                                        class="mr-2 sm:mr-3" <?php echo e($loop->first ? 'checked' : ''); ?>>
                                    <div class="inline-block border-2 rounded-lg p-3 sm:p-4 cursor-pointer hover:border-primary hover:bg-primary/5 transition w-full"
                                        onclick="this.previousElementSibling.checked = true;">
                                        <div class="flex items-center justify-between gap-3">
                                            <div class="flex-1 min-w-0">
                                                <h3 class="font-bold text-base sm:text-lg"><?php echo e($method['name']); ?></h3>
                                                <p class="text-xs sm:text-sm text-gray-600"><?php echo e($method['description']); ?></p>
                                            </div>
                                            <?php if($method['id'] === 'paystack'): ?>
                                                <div class="text-primary flex-shrink-0">
                                                    <i class="fas fa-credit-card text-2xl sm:text-3xl"></i>
                                                </div>
                                            <?php elseif($method['id'] === 'flutterwave'): ?>
                                                <div class="text-orange-600 flex-shrink-0">
                                                    <i class="fas fa-wallet text-2xl sm:text-3xl"></i>
                                                </div>
                                            <?php elseif($method['id'] === 'bank_transfer'): ?>
                                                <div class="text-green-600 flex-shrink-0">
                                                    <i class="fas fa-university text-2xl sm:text-3xl"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mb-3 sm:mb-4"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        <?php $__errorArgs = ['payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="bg-red-100 border border-red-400 text-red-800 px-3 sm:px-4 py-2 sm:py-3 rounded mb-3 sm:mb-4 text-sm sm:text-base">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        <!-- Promo Code -->
                        <div class="mb-4 sm:mb-6">
                            <label class="block text-sm font-semibold text-gray-700 mb-2">
                                <i class="fas fa-ticket-alt text-primary mr-2"></i>Promo Code (Optional)
                            </label>
                            <div class="flex flex-col sm:flex-row gap-2">
                                <input type="text" name="promo_code" id="promo_code" 
                                    class="flex-1 border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 focus:border-primary focus:outline-none transition uppercase text-sm sm:text-base"
                                    placeholder="Enter promo code" style="text-transform: uppercase;">
                                <button type="button" onclick="validatePromoCode()" 
                                    class="px-4 sm:px-6 py-2 sm:py-3 bg-primary text-white rounded-lg hover:bg-primary-dark transition font-semibold text-sm sm:text-base whitespace-nowrap">
                                    Apply
                                </button>
                            </div>
                            <div id="promo-message" class="mt-2 text-xs sm:text-sm"></div>
                            <div id="promo-details" class="mt-2 hidden">
                                <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-2 sm:p-3">
                                    <p class="text-green-800 font-semibold text-xs sm:text-sm">
                                        <i class="fas fa-check-circle mr-2"></i>
                                        <span id="promo-text"></span>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <button type="submit" 
                            class="w-full bg-primary text-white py-3 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-base sm:text-lg">
                            <i class="fas fa-lock mr-2"></i> Proceed to Payment
                        </button>
                    </form>
                <?php endif; ?>
            </div>

            <!-- Security Notice -->
            <div class="bg-light-bg rounded-lg p-3 sm:p-4 text-xs sm:text-sm text-gray-600">
                <i class="fas fa-shield-alt text-green-600 mr-2"></i>
                Your payment is secured with industry-standard encryption
            </div>
        </div>

        <!-- Ad Summary -->
        <div>
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:sticky md:top-4">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4">Advertisement Summary</h3>
                
                <div class="mb-3 sm:mb-4">
                    <img src="<?php echo e(isset($vendorAd->property->photos[0]) ? asset('storage/' . $vendorAd->property->photos[0]) : '/images/placeholder.jpg'); ?>" 
                        alt="<?php echo e($vendorAd->property->title); ?>" 
                        class="w-full h-32 object-cover rounded">
                </div>
                
                <h4 class="font-semibold text-sm sm:text-base mb-1 sm:mb-2"><?php echo e($vendorAd->property->title); ?></h4>
                <p class="text-xs sm:text-sm text-gray-600 mb-3 sm:mb-4"><?php echo e($vendorAd->property->city); ?>, <?php echo e($vendorAd->property->state); ?></p>

                <div class="border-t pt-3 sm:pt-4 space-y-2 text-xs sm:text-sm">
                    <div class="flex justify-between">
                        <span>Ad Plan:</span>
                        <span class="font-semibold"><?php echo e($vendorAd->adPlan->name); ?></span>
                    </div>
                    <div class="flex justify-between">
                        <span>Duration:</span>
                        <span class="font-semibold"><?php echo e($vendorAd->adPlan->duration_days); ?> days</span>
                    </div>
                    <div class="flex justify-between">
                        <span>Impressions:</span>
                        <span class="font-semibold"><?php echo e(number_format($vendorAd->adPlan->impressions_limit ?? 0)); ?></span>
                    </div>
                </div>

                <div class="border-t mt-3 sm:mt-4 pt-3 sm:pt-4">
                    <div id="discount-section" class="hidden mb-3 pb-3 border-b">
                        <div class="flex justify-between text-xs sm:text-sm text-green-600">
                            <span>Discount:</span>
                            <span class="font-semibold">-₦<span id="discount-value">0</span></span>
                        </div>
                    </div>
                    <div class="flex justify-between font-bold text-base sm:text-lg">
                        <span>Total:</span>
                        <span class="text-primary" id="total-amount">₦<?php echo e(number_format($vendorAd->adPlan->price)); ?></span>
                    </div>
                </div>

                <p class="text-xs text-gray-500 mt-3 sm:mt-4 break-all">
                    <i class="fas fa-info-circle mr-1"></i>
                    Reference: <?php echo e($vendorAd->payment_reference); ?>

                </p>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
const originalAmount = <?php echo e($vendorAd->adPlan->price); ?>;
let appliedDiscount = 0;

function validatePromoCode() {
    const code = document.getElementById('promo_code').value.trim();
    const messageEl = document.getElementById('promo-message');
    const detailsEl = document.getElementById('promo-details');
    
    if (!code) {
        messageEl.innerHTML = '<p class="text-red-600"><i class="fas fa-exclamation-circle mr-1"></i>Please enter a promo code</p>';
        detailsEl.classList.add('hidden');
        return;
    }
    
    messageEl.innerHTML = '<p class="text-gray-600"><i class="fas fa-spinner fa-spin mr-1"></i>Validating code...</p>';
    
    fetch('/api/v1/promo-codes/validate', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        credentials: 'same-origin',
        body: JSON.stringify({
            code: code,
            amount: originalAmount
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    })
    .then(data => {
        if (data.valid) {
            messageEl.innerHTML = `<p class="text-green-600"><i class="fas fa-check-circle mr-1"></i>${data.message}</p>`;
            detailsEl.classList.remove('hidden');
            document.getElementById('promo-text').textContent = 
                `You save ₦${data.discount_amount.toLocaleString()}! New total: ₦${data.final_amount.toLocaleString()}`;
            
            // Update sidebar
            appliedDiscount = data.discount_amount;
            updateTotal();
        } else {
            messageEl.innerHTML = `<p class="text-red-600"><i class="fas fa-times-circle mr-1"></i>${data.message}</p>`;
            detailsEl.classList.add('hidden');
            appliedDiscount = 0;
            updateTotal();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        messageEl.innerHTML = `<p class="text-red-600"><i class="fas fa-exclamation-circle mr-1"></i>Error: ${error.message}. Please try again.</p>`;
        detailsEl.classList.add('hidden');
        appliedDiscount = 0;
        updateTotal();
    });
}

function updateTotal() {
    const discountSection = document.getElementById('discount-section');
    const discountValue = document.getElementById('discount-value');
    const totalAmount = document.getElementById('total-amount');
    
    if (appliedDiscount > 0) {
        discountSection.classList.remove('hidden');
        discountValue.textContent = appliedDiscount.toLocaleString();
        const newTotal = originalAmount - appliedDiscount;
        totalAmount.textContent = '₦' + newTotal.toLocaleString();
    } else {
        discountSection.classList.add('hidden');
        totalAmount.textContent = '₦' + originalAmount.toLocaleString();
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/ads/payment.blade.php ENDPATH**/ ?>