<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h1 class="text-3xl font-bold mb-6">Dashboard Overview</h1>

    <!-- Stats Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Users</p>
                <i class="fas fa-users text-primary text-2xl"></i>
            </div>
            <p class="text-3xl font-bold"><?php echo e(number_format($stats['total_users'])); ?></p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Active Vendors</p>
                <i class="fas fa-store text-green-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold"><?php echo e(number_format($stats['active_vendors'])); ?></p>
            <p class="text-sm text-gray-500">of <?php echo e($stats['total_vendors']); ?> total</p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Revenue</p>
                <i class="fas fa-money-bill-wave text-primary text-2xl"></i>
            </div>
            <p class="text-3xl font-bold">₦<?php echo e(number_format($stats['total_revenue'])); ?></p>
        </div>

        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex items-center justify-between mb-2">
                <p class="text-gray-600">Total Commission Earned</p>
                <i class="fas fa-chart-line text-yellow-500 text-2xl"></i>
            </div>
            <p class="text-3xl font-bold mb-3">₦<?php echo e(number_format($stats['total_commission'])); ?></p>
            
            <!-- Commission Breakdown -->
            <div class="grid grid-cols-2 gap-3 mt-4 pt-4 border-t">
                <div class="bg-blue-50 rounded-lg p-3">
                    <p class="text-xs text-blue-600 mb-1">Property Commission</p>
                    <p class="text-lg font-bold text-blue-700">₦<?php echo e(number_format($stats['property_commission'])); ?></p>
                </div>
                <div class="bg-green-50 rounded-lg p-3">
                    <p class="text-xs text-green-600 mb-1">Car Rental Commission</p>
                    <p class="text-lg font-bold text-green-700">₦<?php echo e(number_format($stats['car_commission'])); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Action Items -->
    <div class="grid md:grid-cols-2 gap-6 mb-8">
        <!-- Pending Payment Verifications -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="font-bold text-xl">Pending Payment Verifications</h2>
                <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">
                    <?php echo e($pendingVerifications->count()); ?>

                </span>
            </div>

            <?php $__empty_1 = true; $__currentLoopData = $pendingVerifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="border-b last:border-b-0 py-3">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-semibold"><?php echo e($booking->property->title); ?></p>
                            <p class="text-sm text-gray-600"><?php echo e($booking->user->name); ?></p>
                            <p class="text-sm text-gray-500">₦<?php echo e(number_format($booking->total_amount)); ?></p>
                        </div>
                        <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" 
                            class="text-primary hover:underline text-sm">Verify</a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-gray-600 text-center py-4">No pending verifications</p>
            <?php endif; ?>
        </div>

        <!-- Pending Ad Approvals -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="font-bold text-xl">Pending Ad Approvals</h2>
                <span class="bg-primary/10 text-purple-800 px-3 py-1 rounded-full text-sm font-semibold">
                    <?php echo e($stats['pending_ad_approvals']); ?>

                </span>
            </div>

            <div class="text-center py-4">
                <a href="<?php echo e(route('admin.ads.index')); ?>" 
                    class="text-primary hover:underline">View Ad Approvals →</a>
            </div>
        </div>
    </div>

    <!-- Recent Bookings -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-4">Recent Bookings</h2>
        
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-light-bg">
                    <tr>
                        <th class="px-4 py-2 text-left">ID</th>
                        <th class="px-4 py-2 text-left">Guest</th>
                        <th class="px-4 py-2 text-left">Property</th>
                        <th class="px-4 py-2 text-left">Dates</th>
                        <th class="px-4 py-2 text-left">Amount</th>
                        <th class="px-4 py-2 text-left">Status</th>
                        <th class="px-4 py-2 text-left">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recentBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-b">
                            <td class="px-4 py-3">#<?php echo e($booking->id); ?></td>
                            <td class="px-4 py-3"><?php echo e($booking->user->name); ?></td>
                            <td class="px-4 py-3"><?php echo e(Str::limit($booking->property->title, 30)); ?></td>
                            <td class="px-4 py-3"><?php echo e($booking->start_date->format('M d')); ?> - <?php echo e($booking->end_date->format('M d')); ?></td>
                            <td class="px-4 py-3">₦<?php echo e(number_format($booking->total_amount)); ?></td>
                            <td class="px-4 py-3">
                                <span class="px-2 py-1 rounded-full text-xs
                                    <?php if($booking->booking_status === 'confirmed'): ?> bg-green-100 text-green-800
                                    <?php elseif($booking->booking_status === 'pending'): ?> bg-yellow-100 text-yellow-800
                                    <?php else: ?> bg-gray-100 text-secondary
                                    <?php endif; ?>">
                                    <?php echo e(ucfirst($booking->booking_status)); ?>

                                </span>
                            </td>
                            <td class="px-4 py-3">
                                <a href="<?php echo e(route('admin.bookings.show', $booking)); ?>" 
                                    class="text-primary hover:underline">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-8 text-gray-600">No bookings yet</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>