<?php $__env->startSection('title', 'All Users'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-3xl font-bold text-secondary">All Users</h1>
    <p class="text-gray-600">Manage all platform users, customers, and vendors</p>
</div>

<!-- Statistics Cards -->
<div class="grid md:grid-cols-4 gap-6 mb-8">
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Users</p>
                <p class="text-3xl font-bold text-primary"><?php echo e(number_format($stats['total_users'])); ?></p>
            </div>
            <div class="bg-primary/10 p-3 rounded-full">
                <i class="fas fa-users text-primary text-2xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Customers</p>
                <p class="text-3xl font-bold text-blue-600"><?php echo e(number_format($stats['total_customers'])); ?></p>
            </div>
            <div class="bg-blue-100 p-3 rounded-full">
                <i class="fas fa-user text-blue-600 text-2xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Vendors</p>
                <p class="text-3xl font-bold text-green-600"><?php echo e(number_format($stats['total_vendors'])); ?></p>
            </div>
            <div class="bg-green-100 p-3 rounded-full">
                <i class="fas fa-store text-green-600 text-2xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Verified Users</p>
                <p class="text-3xl font-bold text-purple-600"><?php echo e(number_format($stats['verified_users'])); ?></p>
            </div>
            <div class="bg-purple-100 p-3 rounded-full">
                <i class="fas fa-check-circle text-purple-600 text-2xl"></i>
            </div>
        </div>
    </div>
</div>

<!-- Revenue Statistics -->
<div class="grid md:grid-cols-3 gap-6 mb-8">
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg shadow-lg p-6">
        <p class="text-sm opacity-90">Total Bookings</p>
        <p class="text-4xl font-bold"><?php echo e(number_format($stats['total_bookings'])); ?></p>
    </div>

    <div class="bg-gradient-to-r from-green-600 to-green-700 text-white rounded-lg shadow-lg p-6">
        <p class="text-sm opacity-90">Total Booking Amount</p>
        <p class="text-4xl font-bold">₦<?php echo e(number_format($stats['total_booking_amount'])); ?></p>
    </div>

    <div class="bg-gradient-to-r from-orange-600 to-orange-700 text-white rounded-lg shadow-lg p-6">
        <p class="text-sm opacity-90">Platform Revenue</p>
        <p class="text-4xl font-bold">₦<?php echo e(number_format($stats['total_revenue'])); ?></p>
    </div>
</div>

<!-- Filters -->
<div class="bg-white rounded-lg shadow-md p-6 mb-6">
    <form method="GET" class="grid md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">Search</label>
            <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                placeholder="Name, email, or phone" 
                class="w-full border-2 border-gray-200 rounded-lg px-4 py-2 focus:border-primary focus:outline-none">
        </div>

        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">Role</label>
            <select name="role" class="w-full border-2 border-gray-200 rounded-lg px-4 py-2 focus:border-primary focus:outline-none">
                <option value="">All Roles</option>
                <option value="customer" <?php echo e(request('role') == 'customer' ? 'selected' : ''); ?>>Customers</option>
                <option value="vendor" <?php echo e(request('role') == 'vendor' ? 'selected' : ''); ?>>Vendors</option>
                <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>>Admins</option>
            </select>
        </div>

        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">Status</label>
            <select name="status" class="w-full border-2 border-gray-200 rounded-lg px-4 py-2 focus:border-primary focus:outline-none">
                <option value="">All Status</option>
                <option value="verified" <?php echo e(request('status') == 'verified' ? 'selected' : ''); ?>>Verified</option>
                <option value="unverified" <?php echo e(request('status') == 'unverified' ? 'selected' : ''); ?>>Unverified</option>
            </select>
        </div>

        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">&nbsp;</label>
            <button type="submit" class="w-full bg-primary text-white rounded-lg px-4 py-2 hover:bg-primary-dark font-semibold">
                <i class="fas fa-search mr-2"></i> Filter
            </button>
        </div>
    </form>
</div>

<!-- Users Table -->
<div class="bg-white rounded-lg shadow-md overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-50 border-b">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">User</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Role</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Bookings</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Joined</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <?php if($user->profile_photo): ?>
                                <img src="<?php echo e(asset('storage/' . $user->profile_photo)); ?>" 
                                    alt="<?php echo e($user->name); ?>"
                                    class="w-10 h-10 rounded-full object-cover border-2 border-primary mr-3"
                                    onerror="this.onerror=null; this.outerHTML='<div class=\'w-10 h-10 bg-primary rounded-full flex items-center justify-center text-white font-bold mr-3\'><?php echo e(substr($user->name, 0, 1)); ?></div>'">
                            <?php else: ?>
                                <div class="w-10 h-10 bg-primary rounded-full flex items-center justify-center text-white font-bold mr-3">
                                    <?php echo e(substr($user->name, 0, 1)); ?>

                                </div>
                            <?php endif; ?>
                            <div>
                                <p class="font-semibold text-gray-900"><?php echo e($user->name); ?></p>
                                <p class="text-sm text-gray-600"><?php echo e($user->email); ?></p>
                                <?php if($user->phone): ?>
                                    <p class="text-xs text-gray-500"><?php echo e($user->phone); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <?php if($user->hasRole('vendor')): ?>
                            <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                <i class="fas fa-store mr-1"></i> Vendor
                            </span>
                        <?php elseif($user->hasAnyRole(['owner', 'manager', 'moderator'])): ?>
                            <span class="px-3 py-1 bg-red-100 text-red-800 rounded-full text-xs font-semibold">
                                <i class="fas fa-shield-alt mr-1"></i> Admin
                            </span>
                        <?php else: ?>
                            <span class="px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold">
                                <i class="fas fa-user mr-1"></i> Customer
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4">
                        <?php if($user->email_verified_at): ?>
                            <span class="px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                <i class="fas fa-check-circle mr-1"></i> Verified
                            </span>
                        <?php else: ?>
                            <span class="px-3 py-1 bg-yellow-100 text-yellow-800 rounded-full text-xs font-semibold">
                                <i class="fas fa-clock mr-1"></i> Unverified
                            </span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4">
                        <span class="font-semibold"><?php echo e($user->bookings->count()); ?></span> bookings
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600">
                        <?php echo e($user->created_at->format('M d, Y')); ?>

                    </td>
                    <td class="px-6 py-4">
                        <a href="<?php echo e(route('admin.all-users.show', $user)); ?>" 
                            class="text-primary hover:text-primary-dark font-semibold">
                            <i class="fas fa-eye mr-1"></i> View
                        </a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-8 text-center text-gray-500">
                        No users found
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Pagination -->
<div class="mt-6">
    <?php echo e($users->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/all-users/index.blade.php ENDPATH**/ ?>