<?php $__env->startSection('title', 'Vendor Details - ' . $vendor->company_name); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <a href="<?php echo e(route('admin.vendors.index')); ?>" class="text-primary hover:text-primary-dark font-semibold">
        <i class="fas fa-arrow-left mr-2"></i> Back to Vendors
    </a>
</div>

<!-- Header Card -->
<div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6 mb-6">
    <div class="flex justify-between items-start">
        <div>
            <h1 class="text-3xl font-bold mb-2"><?php echo e($vendor->company_name); ?></h1>
            <p class="text-primary-light"><i class="fas fa-hashtag mr-2"></i>Vendor ID: <?php echo e($vendor->id); ?></p>
        </div>
        <div class="flex gap-3">
            <?php if(!$vendor->verified): ?>
                <form method="POST" action="<?php echo e(route('admin.vendors.verify', $vendor)); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="bg-green-500 text-white px-6 py-2 rounded-lg hover:bg-green-600 font-semibold transition">
                        <i class="fas fa-check-circle mr-2"></i> Verify Vendor
                    </button>
                </form>
            <?php else: ?>
                <span class="px-6 py-2 bg-green-500 text-white rounded-lg font-semibold">
                    <i class="fas fa-check-circle mr-2"></i> Verified
                </span>
            <?php endif; ?>

            <button onclick="document.getElementById('suspend-form').classList.toggle('hidden')"
                class="bg-red-500 text-white px-6 py-2 rounded-lg hover:bg-red-600 font-semibold transition">
                <i class="fas fa-ban mr-2"></i> Suspend
            </button>
        </div>
    </div>
</div>

<!-- Suspend Form -->
<div id="suspend-form" class="hidden mb-6">
    <form method="POST" action="<?php echo e(route('admin.vendors.suspend', $vendor)); ?>" class="bg-white rounded-xl shadow-md p-6">
        <?php echo csrf_field(); ?>
        <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4 mb-4">
            <p class="text-red-800 font-bold mb-2"><i class="fas fa-exclamation-triangle mr-2"></i>Suspend Vendor</p>
            <p class="text-sm text-red-700">This action will suspend the vendor's account.</p>
        </div>
        <label class="block text-sm font-semibold text-gray-700 mb-2">Reason for Suspension</label>
        <textarea name="reason" rows="3" placeholder="Please provide a reason for suspension..." 
            class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 mb-4 focus:border-primary focus:outline-none" required></textarea>
        <button type="submit" class="bg-red-600 text-white px-6 py-3 rounded-lg hover:bg-red-700 font-semibold transition">
            <i class="fas fa-ban mr-2"></i> Confirm Suspension
        </button>
    </form>
</div>

<div class="grid md:grid-cols-3 gap-6 mb-6">
    <!-- Main Content -->
    <div class="md:col-span-2 space-y-6">

        <!-- Contact & Bank Info -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-address-card text-primary mr-3"></i> Vendor Information
            </h2>
            <div class="grid md:grid-cols-2 gap-6">
                <div class="bg-blue-50 rounded-lg p-4">
                    <h3 class="font-bold text-primary mb-3 flex items-center">
                        <i class="fas fa-user-circle mr-2"></i> Contact Person
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p class="flex items-center">
                            <i class="fas fa-user text-primary mr-3 w-5"></i>
                            <span class="font-semibold"><?php echo e($vendor->user->name); ?></span>
                        </p>
                        <p class="flex items-center">
                            <i class="fas fa-envelope text-primary mr-3 w-5"></i>
                            <span><?php echo e($vendor->user->email); ?></span>
                        </p>
                        <p class="flex items-center">
                            <i class="fas fa-phone text-primary mr-3 w-5"></i>
                            <span><?php echo e($vendor->user->phone); ?></span>
                        </p>
                    </div>
                </div>

                <div class="bg-green-50 rounded-lg p-4">
                    <h3 class="font-bold text-green-700 mb-3 flex items-center">
                        <i class="fas fa-university mr-2"></i> Bank Details
                    </h3>
                    <div class="space-y-2 text-sm">
                        <p><strong>Bank:</strong> <?php echo e($vendor->bank_name ?? 'Not provided'); ?></p>
                        <p><strong>Account:</strong> <?php echo e($vendor->account_number ?? 'Not provided'); ?></p>
                        <p><strong>Name:</strong> <?php echo e($vendor->account_name ?? 'Not provided'); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Stats -->
        <div class="grid md:grid-cols-2 gap-4">
            <div class="bg-gradient-to-r from-yellow-500 to-yellow-600 text-white rounded-xl shadow-md p-6">
                <p class="text-sm opacity-90">Pending Balance</p>
                <p class="text-3xl font-bold">₦<?php echo e(number_format($vendor->pending_balance)); ?></p>
            </div>
            <div class="bg-gradient-to-r from-green-500 to-green-600 text-white rounded-xl shadow-md p-6">
                <p class="text-sm opacity-90">Payout Balance</p>
                <p class="text-3xl font-bold">₦<?php echo e(number_format($vendor->payout_balance)); ?></p>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Financial Summary -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-chart-line text-primary mr-2"></i> Financial Summary
            </h3>
            <div class="space-y-4">
                <div class="bg-primary/5 rounded-lg p-4">
                    <p class="text-xs text-gray-600 mb-1">Commission Rate</p>
                    <p class="text-2xl font-bold text-primary"><?php echo e($vendor->commission_rate_at_signup); ?>%</p>
                </div>
                <div class="bg-green-50 rounded-lg p-4">
                    <p class="text-xs text-gray-600 mb-1">Total Earned</p>
                    <p class="text-2xl font-bold text-green-600">₦<?php echo e(number_format($vendor->total_earned)); ?></p>
                </div>
            </div>
        </div>

        <!-- Security Actions -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h3 class="font-bold text-secondary mb-4 flex items-center">
                <i class="fas fa-shield-alt text-primary mr-2"></i> Security Actions
            </h3>
            <div class="space-y-3">
                <?php if($vendor->transaction_pin): ?>
                    <div class="bg-green-50 border-l-4 border-green-400 p-3 rounded mb-3">
                        <p class="text-xs text-green-800">
                            <i class="fas fa-check-circle mr-1"></i>
                            PIN set on <?php echo e($vendor->pin_set_at->format('M d, Y')); ?>

                        </p>
                    </div>
                <?php else: ?>
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-3 rounded mb-3">
                        <p class="text-xs text-yellow-800">
                            <i class="fas fa-exclamation-triangle mr-1"></i>
                            No transaction PIN set
                        </p>
                    </div>
                <?php endif; ?>

                <form method="POST" action="<?php echo e(route('admin.vendors.reset-pin', $vendor)); ?>" 
                    onsubmit="return confirm('Are you sure you want to reset this vendor\'s transaction PIN? They will need to set a new one.');">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full bg-primary text-white px-4 py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                        <i class="fas fa-redo mr-2"></i> Reset Transaction PIN
                    </button>
                </form>
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>
                    Vendor will need to set a new PIN after reset
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Properties -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6 mt-6">
    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
        <i class="fas fa-home text-primary mr-3"></i> Properties (<?php echo e($vendor->properties->count()); ?>)
    </h2>
        
    <?php $__empty_1 = true; $__currentLoopData = $vendor->properties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $property): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="border-b last:border-b-0 py-4 flex justify-between items-center hover:bg-gray-50 transition">
            <div>
                <p class="font-semibold text-secondary"><?php echo e($property->title); ?></p>
                <p class="text-sm text-gray-600">
                    <i class="fas fa-map-marker-alt text-primary mr-1"></i><?php echo e($property->city); ?> • 
                    <i class="fas fa-money-bill-wave text-green-600 mr-1"></i>₦<?php echo e(number_format($property->price_per_night)); ?>/night
                </p>
            </div>
            <span class="px-3 py-1 rounded-full text-xs font-semibold
                <?php echo e($property->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-secondary'); ?>">
                <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst($property->status)); ?>

            </span>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-8">
            <i class="fas fa-home text-gray-300 text-4xl mb-3"></i>
            <p class="text-gray-600">No properties yet</p>
        </div>
    <?php endif; ?>
</div>

<!-- Recent Bookings -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
        <i class="fas fa-calendar-check text-primary mr-3"></i> Recent Bookings
    </h2>
        
    <?php $__empty_1 = true; $__currentLoopData = $vendor->bookings->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="border-b last:border-b-0 py-4 hover:bg-gray-50 transition">
            <div class="flex justify-between items-start">
                <div>
                    <p class="font-semibold text-secondary"><?php echo e($booking->property->title); ?></p>
                    <p class="text-sm text-gray-600"><i class="fas fa-user text-primary mr-1"></i><?php echo e($booking->user->name); ?></p>
                    <p class="text-xs text-gray-500"><i class="fas fa-calendar text-primary mr-1"></i><?php echo e($booking->start_date->format('M d')); ?> - <?php echo e($booking->end_date->format('M d, Y')); ?></p>
                </div>
                <div class="text-right">
                    <p class="font-bold text-green-600 text-lg">₦<?php echo e(number_format($booking->total_amount)); ?></p>
                    <span class="text-xs px-3 py-1 rounded-full font-semibold
                        <?php echo e($booking->booking_status === 'confirmed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>">
                        <?php echo e(ucfirst($booking->booking_status)); ?>

                    </span>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-8">
            <i class="fas fa-calendar-times text-gray-300 text-4xl mb-3"></i>
            <p class="text-gray-600">No bookings yet</p>
        </div>
    <?php endif; ?>
</div>

<!-- Recent Payouts -->
<div class="bg-white rounded-xl shadow-md p-6">
    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
        <i class="fas fa-money-check-alt text-primary mr-3"></i> Recent Payouts
    </h2>
        
    <?php $__empty_1 = true; $__currentLoopData = $vendor->payouts->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="border-b last:border-b-0 py-4 flex justify-between items-center hover:bg-gray-50 transition">
            <div>
                <p class="font-bold text-green-600 text-lg">₦<?php echo e(number_format($payout->amount)); ?></p>
                <p class="text-xs text-gray-500"><i class="fas fa-calendar text-primary mr-1"></i><?php echo e($payout->created_at->format('M d, Y')); ?></p>
            </div>
            <span class="px-3 py-1 rounded-full text-xs font-semibold
                <?php if($payout->status === 'completed'): ?> bg-green-100 text-green-800
                <?php elseif($payout->status === 'pending'): ?> bg-yellow-100 text-yellow-800
                <?php else: ?> bg-gray-100 text-secondary
                <?php endif; ?>">
                <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst($payout->status)); ?>

            </span>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-8">
            <i class="fas fa-wallet text-gray-300 text-4xl mb-3"></i>
            <p class="text-gray-600">No payouts yet</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/vendors/show.blade.php ENDPATH**/ ?>