<?php $__env->startSection('title', 'Payment - ' . $booking->car->full_name); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-4 sm:py-8">
    <div class="container mx-auto px-3 sm:px-4 max-w-6xl">
        <!-- Header -->
        <div class="mb-4 sm:mb-8">
            <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                    <i class="fas fa-credit-card mr-2 sm:mr-3"></i>Complete Payment
                </h1>
                <p class="text-green-100 text-sm sm:text-base"><?php echo e($booking->car->full_name); ?></p>
            </div>
        </div>

        <div class="grid lg:grid-cols-3 gap-4 sm:gap-6 lg:gap-8">
            <!-- Payment Method Selection -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-4 sm:mb-6 flex items-center">
                        <i class="fas fa-wallet text-green-600 mr-2 sm:mr-3"></i>Select Payment Method
                    </h2>

                    <?php
                        $paymentMethods = \App\Models\PaymentMethod::active()->get();
                        $availablePaymentMethods = $paymentMethods->map(function($method) {
                            return [
                                'id' => $method->slug,
                                'name' => $method->name,
                                'description' => $method->description,
                                'settings' => $method->settings,
                            ];
                        })->toArray();
                    ?>

                    <?php if(count($availablePaymentMethods) === 0): ?>
                        <div class="bg-yellow-100 border border-yellow-400 text-yellow-800 px-3 sm:px-4 py-2 sm:py-3 rounded-lg text-sm sm:text-base">
                            <i class="fas fa-exclamation-triangle mr-2"></i>
                            No payment methods are currently available. Please contact support.
                        </div>
                    <?php else: ?>
                        <form method="POST" action="<?php echo e(route('cars.booking.process-payment', $booking)); ?>">
                            <?php echo csrf_field(); ?>

                            <div class="space-y-3 sm:space-y-4 mb-4 sm:mb-6">
                                <?php $__currentLoopData = $availablePaymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <label class="block cursor-pointer">
                                        <input type="radio" name="payment_method" value="<?php echo e($method['id']); ?>" required
                                            class="hidden peer" <?php echo e($loop->first ? 'checked' : ''); ?>>
                                        <div class="border-2 border-gray-300 rounded-lg p-3 sm:p-4 peer-checked:border-green-600 peer-checked:bg-green-50 hover:border-green-400 transition">
                                            <div class="flex items-center justify-between gap-3">
                                                <div class="flex-1 min-w-0">
                                                    <h3 class="font-bold text-base sm:text-lg text-gray-800"><?php echo e($method['name']); ?></h3>
                                                    <p class="text-xs sm:text-sm text-gray-600"><?php echo e($method['description']); ?></p>
                                                </div>
                                                <?php if($method['id'] === 'paystack'): ?>
                                                    <div class="text-green-600 flex-shrink-0">
                                                        <i class="fas fa-credit-card text-2xl sm:text-3xl"></i>
                                                    </div>
                                                <?php elseif($method['id'] === 'flutterwave'): ?>
                                                    <div class="text-orange-600 flex-shrink-0">
                                                        <i class="fas fa-wallet text-2xl sm:text-3xl"></i>
                                                    </div>
                                                <?php elseif($method['id'] === 'bank_transfer'): ?>
                                                    <div class="text-blue-600 flex-shrink-0">
                                                        <i class="fas fa-university text-2xl sm:text-3xl"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </label>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs sm:text-sm mb-3 sm:mb-4"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <?php $__errorArgs = ['payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="bg-red-100 border border-red-400 text-red-800 px-3 sm:px-4 py-2 sm:py-3 rounded-lg mb-3 sm:mb-4 text-sm sm:text-base">
                                    <i class="fas fa-exclamation-circle mr-2"></i><?php echo e($message); ?>

                                </div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <button type="submit" 
                                class="w-full bg-gradient-to-r from-green-600 to-teal-600 text-white py-3 sm:py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-base sm:text-lg">
                                <i class="fas fa-lock mr-2"></i> Proceed to Payment
                            </button>
                        </form>
                    <?php endif; ?>
                </div>

                <!-- Security Notice -->
                <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 text-xs sm:text-sm">
                    <div class="flex items-start">
                        <i class="fas fa-shield-alt text-blue-600 text-lg sm:text-xl mr-2 sm:mr-3 mt-1 flex-shrink-0"></i>
                        <div>
                            <p class="font-semibold text-blue-800 mb-1">Secure Payment</p>
                            <p class="text-blue-700">Your payment is secured with industry-standard encryption. We never store your card details.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Booking Summary -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 lg:sticky lg:top-4">
                    <h3 class="font-bold text-base sm:text-lg text-gray-800 mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-file-invoice text-green-600 mr-2"></i>Booking Summary
                    </h3>
                    
                    <?php if($booking->car->main_photo): ?>
                        <img src="<?php echo e(asset('storage/' . $booking->car->main_photo)); ?>" 
                            alt="<?php echo e($booking->car->full_name); ?>" 
                            class="w-full h-32 sm:h-40 object-cover rounded-lg mb-3 sm:mb-4">
                    <?php endif; ?>
                    
                    <h4 class="font-bold text-gray-800 mb-1 text-sm sm:text-base"><?php echo e($booking->car->full_name); ?></h4>
                    <p class="text-xs sm:text-sm text-gray-600 mb-2"><?php echo e($booking->car->category->name); ?></p>
                    <p class="text-xs sm:text-sm text-gray-600 mb-3 sm:mb-4">
                        <i class="fas fa-map-marker-alt text-green-600 mr-1"></i>
                        <?php echo e($booking->car->city); ?>, <?php echo e($booking->car->state); ?>

                    </p>

                    <div class="border-t pt-3 sm:pt-4 space-y-2 sm:space-y-3 text-xs sm:text-sm mb-3 sm:mb-4">
                        <div class="flex justify-between">
                            <span class="text-gray-600">
                                <i class="fas fa-calendar-check text-green-600 mr-1"></i>Pickup:
                            </span>
                            <span class="font-semibold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('M d, Y')); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">
                                <i class="fas fa-clock text-green-600 mr-1"></i>Time:
                            </span>
                            <span class="font-semibold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->pickup_time, 'UTC')->format('h:i A')); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">
                                <i class="fas fa-calendar-times text-red-600 mr-1"></i>Return:
                            </span>
                            <span class="font-semibold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('M d, Y')); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">
                                <i class="fas fa-clock text-red-600 mr-1"></i>Time:
                            </span>
                            <span class="font-semibold text-gray-800"><?php echo e(\Carbon\Carbon::parse($booking->return_time, 'UTC')->format('h:i A')); ?></span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-600">
                                <i class="fas fa-calendar-day text-blue-600 mr-1"></i>Total Days:
                            </span>
                            <span class="font-semibold text-gray-800"><?php echo e($booking->total_days); ?> <?php echo e(Str::plural('day', $booking->total_days)); ?></span>
                        </div>
                    </div>

                    <div class="border-t pt-3 sm:pt-4">
                        <div class="space-y-2 mb-3">
                            <div class="flex justify-between text-xs sm:text-sm">
                                <span class="text-gray-600">Rental Cost:</span>
                                <span class="text-gray-800">₦<?php echo e(number_format($booking->rental_cost)); ?></span>
                            </div>
                            <?php if($booking->insurance_cost > 0): ?>
                                <div class="flex justify-between text-xs sm:text-sm">
                                    <span class="text-gray-600">Insurance:</span>
                                    <span class="text-gray-800">₦<?php echo e(number_format($booking->insurance_cost)); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if($booking->security_deposit > 0): ?>
                                <div class="flex justify-between text-xs sm:text-sm">
                                    <span class="text-gray-600">Security Deposit <span class="text-xs">(Refundable)</span>:</span>
                                    <span class="text-gray-800">₦<?php echo e(number_format($booking->security_deposit)); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="flex justify-between font-bold text-base sm:text-lg border-t pt-3">
                            <span class="text-gray-800">Total Amount:</span>
                            <span class="text-green-600">₦<?php echo e(number_format($booking->total_amount)); ?></span>
                        </div>
                    </div>

                    <div class="mt-3 sm:mt-4 p-2 sm:p-3 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                        <p class="text-xs text-yellow-800">
                            <i class="fas fa-info-circle mr-1"></i>
                            <strong>Note:</strong> Security deposit will be refunded after vehicle inspection upon return.
                        </p>
                    </div>

                    <div class="mt-3 sm:mt-4 pt-3 sm:pt-4 border-t">
                        <p class="text-xs text-gray-500 break-all">
                            <i class="fas fa-hashtag mr-1"></i>
                            Reference: <span class="font-mono font-semibold"><?php echo e($booking->payment_reference ?? 'N/A'); ?></span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/cars/payment.blade.php ENDPATH**/ ?>