<?php $__env->startSection('title', 'Manage Bookings'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                        <i class="fas fa-calendar-alt mr-2 sm:mr-3"></i>Manage Bookings
                    </h1>
                    <p class="text-xs sm:text-sm opacity-90">View and manage all your bookings</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-4 sm:px-6 py-2 sm:py-3">
                    <p class="text-xs opacity-90">Total Bookings</p>
                    <p class="text-2xl sm:text-3xl font-bold">
                        <?php echo e(($offersProperties ? auth()->user()->vendor->bookings()->count() : 0) + ($offersCarRentals ? auth()->user()->vendor->carBookings()->count() : 0)); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-3 sm:gap-4 md:gap-6 mb-6 sm:mb-8">
        <div class="bg-gradient-to-br from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-3 sm:p-4 md:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-calendar-check text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-chart-line text-xl sm:text-2xl md:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs opacity-90 mb-1">Total</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                <?php echo e(($offersProperties ? auth()->user()->vendor->bookings()->count() : 0) + ($offersCarRentals ? auth()->user()->vendor->carBookings()->count() : 0)); ?>

            </p>
        </div>

        <div class="bg-gradient-to-br from-yellow-500 to-yellow-600 text-white rounded-lg sm:rounded-xl shadow-lg p-3 sm:p-4 md:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-clock text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-hourglass-half text-xl sm:text-2xl md:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs opacity-90 mb-1">Pending</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                <?php echo e(($offersProperties ? auth()->user()->vendor->bookings()->where('booking_status', 'pending')->count() : 0) + ($offersCarRentals ? auth()->user()->vendor->carBookings()->where('status', 'pending')->count() : 0)); ?>

            </p>
        </div>

        <div class="bg-gradient-to-br from-green-500 to-green-600 text-white rounded-lg sm:rounded-xl shadow-lg p-3 sm:p-4 md:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-check-circle text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-thumbs-up text-xl sm:text-2xl md:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs opacity-90 mb-1">Confirmed</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                <?php echo e(($offersProperties ? auth()->user()->vendor->bookings()->where('booking_status', 'confirmed')->count() : 0) + ($offersCarRentals ? auth()->user()->vendor->carBookings()->where('status', 'confirmed')->count() : 0)); ?>

            </p>
        </div>

        <div class="bg-gradient-to-br from-blue-500 to-blue-600 text-white rounded-lg sm:rounded-xl shadow-lg p-3 sm:p-4 md:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-flag-checkered text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-trophy text-xl sm:text-2xl md:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs opacity-90 mb-1">Completed</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">
                <?php echo e(($offersProperties ? auth()->user()->vendor->bookings()->where('booking_status', 'completed')->count() : 0) + ($offersCarRentals ? auth()->user()->vendor->carBookings()->where('status', 'completed')->count() : 0)); ?>

            </p>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-6 sm:mb-8">
        <div class="flex items-center gap-2 sm:gap-3 mb-3 sm:mb-4">
            <i class="fas fa-filter text-primary text-lg sm:text-xl"></i>
            <h3 class="font-bold text-base sm:text-lg text-gray-800">Filter Bookings:</h3>
        </div>
        <div class="flex flex-wrap gap-2 sm:gap-3">
            <a href="<?php echo e(route('vendor.bookings.index')); ?>" 
                class="px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg font-semibold text-xs sm:text-sm transition transform hover:scale-105 <?php echo e(!request('status') ? 'bg-primary text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?>">
                <i class="fas fa-list mr-1 sm:mr-2"></i> All
            </a>
            <a href="?status=pending" 
                class="px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg font-semibold text-xs sm:text-sm transition transform hover:scale-105 <?php echo e(request('status') === 'pending' ? 'bg-yellow-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?>">
                <i class="fas fa-clock mr-1 sm:mr-2"></i> Pending
            </a>
            <a href="?status=confirmed" 
                class="px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg font-semibold text-xs sm:text-sm transition transform hover:scale-105 <?php echo e(request('status') === 'confirmed' ? 'bg-green-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?>">
                <i class="fas fa-check-circle mr-1 sm:mr-2"></i> Confirmed
            </a>
            <a href="?status=completed" 
                class="px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg font-semibold text-xs sm:text-sm transition transform hover:scale-105 <?php echo e(request('status') === 'completed' ? 'bg-blue-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?>">
                <i class="fas fa-flag-checkered mr-1 sm:mr-2"></i> Completed
            </a>
            <a href="?status=cancelled" 
                class="px-3 sm:px-4 md:px-6 py-2 sm:py-2.5 md:py-3 rounded-lg font-semibold text-xs sm:text-sm transition transform hover:scale-105 <?php echo e(request('status') === 'cancelled' ? 'bg-red-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'); ?>">
                <i class="fas fa-times-circle mr-1 sm:mr-2"></i> Cancelled
            </a>
        </div>
    </div>

    <!-- Tabs -->
    <?php if($offersProperties && $offersCarRentals): ?>
        <div class="mb-4 sm:mb-6">
            <nav class="flex space-x-2 sm:space-x-4 border-b-2 overflow-x-auto">
                <button onclick="showTab('properties')" id="tab-properties" class="tab-button px-4 sm:px-6 py-2 sm:py-3 text-sm sm:text-base font-bold border-b-4 border-primary text-primary whitespace-nowrap">
                    <i class="fas fa-home mr-1 sm:mr-2"></i>Properties (<?php echo e($bookings->total()); ?>)
                </button>
                <button onclick="showTab('cars')" id="tab-cars" class="tab-button px-4 sm:px-6 py-2 sm:py-3 text-sm sm:text-base font-bold border-b-4 border-transparent text-gray-600 hover:text-primary whitespace-nowrap">
                    <i class="fas fa-car mr-1 sm:mr-2"></i>Cars (<?php echo e($carBookings->total()); ?>)
                </button>
            </nav>
        </div>
    <?php endif; ?>

    <!-- Property Bookings List -->
    <?php if($offersProperties): ?>
    <div id="content-properties" class="tab-content space-y-4 sm:space-y-6 <?php echo e($offersCarRentals && !$offersProperties ? 'hidden' : ''); ?>">
        <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300">
                <!-- Card Header -->
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 p-4 sm:p-6 border-b-2 border-primary/20">
                    <div class="flex flex-col sm:flex-row justify-between items-start gap-3 sm:gap-4">
                        <div class="flex-1 w-full">
                            <div class="flex items-start gap-2 sm:gap-3 mb-2 sm:mb-3">
                                <div class="bg-primary/10 p-2 sm:p-3 rounded-lg flex-shrink-0">
                                    <i class="fas fa-home text-primary text-lg sm:text-xl md:text-2xl"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h3 class="text-base sm:text-lg md:text-2xl font-bold text-gray-800 truncate"><?php echo e($booking->property->title); ?></h3>
                                    <p class="text-xs sm:text-sm text-gray-600">Booking #<?php echo e($booking->id); ?></p>
                                </div>
                            </div>
                            <?php if($booking->vendor_visible_user_info): ?>
                                <div class="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4 text-xs sm:text-sm ml-0 sm:ml-11 md:ml-14">
                                    <div class="flex items-center text-gray-700">
                                        <i class="fas fa-user-circle text-primary mr-2"></i>
                                        <span class="font-semibold truncate"><?php echo e($booking->user->name); ?></span>
                                    </div>
                                    <div class="flex items-center text-gray-600 truncate">
                                        <i class="fas fa-envelope text-primary mr-2"></i>
                                        <span class="truncate"><?php echo e($booking->user->email); ?></span>
                                    </div>
                                    <div class="flex items-center text-gray-600">
                                        <i class="fas fa-phone text-primary mr-2"></i>
                                        <?php echo e($booking->user->phone); ?>

                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="flex items-center text-xs sm:text-sm ml-0 sm:ml-11 md:ml-14">
                                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-2 rounded w-full">
                                        <i class="fas fa-lock text-yellow-600 mr-2"></i>
                                        <span class="text-yellow-700 font-semibold">Guest details locked - Payment pending</span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="flex flex-row sm:flex-col gap-2 items-start sm:items-end w-full sm:w-auto">
                            <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-bold shadow-md
                                <?php if($booking->vendor_approval_status === 'approved'): ?> bg-green-500 text-white
                                <?php elseif($booking->vendor_approval_status === 'pending'): ?> bg-yellow-500 text-white
                                <?php else: ?> bg-red-500 text-white
                                <?php endif; ?>">
                                <i class="fas fa-circle text-xs mr-1"></i> <?php echo e(ucfirst($booking->vendor_approval_status)); ?>

                            </span>
                            <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-bold shadow-md
                                <?php if($booking->booking_status === 'confirmed'): ?> bg-blue-500 text-white
                                <?php elseif($booking->booking_status === 'completed'): ?> bg-green-500 text-white
                                <?php elseif($booking->booking_status === 'cancelled'): ?> bg-red-500 text-white
                                <?php else: ?> bg-gray-500 text-white
                                <?php endif; ?>">
                                <?php echo e(ucfirst($booking->booking_status)); ?>

                            </span>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="p-4 sm:p-6">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-2 sm:gap-3 md:gap-4 mb-4 sm:mb-6">
                        <div class="bg-blue-50 border-2 border-blue-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-blue-600 font-semibold mb-1 sm:mb-2">Check-in</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-calendar-check text-blue-600 mr-1 sm:mr-2"></i>
                                <span class="truncate"><?php echo e($booking->start_date->format('M d, Y')); ?></span>
                            </p>
                        </div>
                        <div class="bg-red-50 border-2 border-red-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-red-600 font-semibold mb-1 sm:mb-2">Check-out</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-calendar-times text-red-600 mr-1 sm:mr-2"></i>
                                <span class="truncate"><?php echo e($booking->end_date->format('M d, Y')); ?></span>
                            </p>
                        </div>
                        <div class="bg-purple-50 border-2 border-purple-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-purple-600 font-semibold mb-1 sm:mb-2">Guests</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-users text-purple-600 mr-1 sm:mr-2"></i>
                                <?php echo e($booking->guest_count); ?> • <?php echo e(ucfirst($booking->trip_type)); ?>

                            </p>
                        </div>
                        <div class="bg-green-50 border-2 border-green-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-green-600 font-semibold mb-1 sm:mb-2">Total</p>
                            <p class="font-bold text-green-600 text-base sm:text-lg md:text-xl flex items-center">
                                <i class="fas fa-money-bill-wave mr-1 sm:mr-2"></i>
                                <span class="truncate">₦<?php echo e(number_format($booking->total_amount)); ?></span>
                            </p>
                        </div>
                    </div>

                    <?php if($booking->requires_vendor_approval && $booking->vendor_approval_status === 'pending'): ?>
                        <div class="bg-yellow-50 border-l-4 border-yellow-500 rounded-lg p-3 sm:p-4 md:p-5 mb-4 sm:mb-6">
                            <div class="flex items-start">
                                <i class="fas fa-exclamation-triangle text-yellow-500 text-lg sm:text-xl md:text-2xl mr-2 sm:mr-3 mt-1 flex-shrink-0"></i>
                                <div class="flex-1">
                                    <p class="text-yellow-800 font-bold text-sm sm:text-base md:text-lg mb-2">Action Required</p>
                                    <p class="text-xs sm:text-sm text-yellow-700 mb-3 sm:mb-4">This booking requires your approval before payment can proceed.</p>
                                    
                                    <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                                        <form method="POST" action="<?php echo e(route('vendor.bookings.approve', $booking)); ?>" class="flex-1">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="w-full bg-gradient-to-r from-green-500 to-green-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-xs sm:text-sm">
                                                <i class="fas fa-check-circle mr-2"></i> Approve
                                            </button>
                                        </form>

                                        <button onclick="document.getElementById('reject-form-<?php echo e($booking->id); ?>').classList.toggle('hidden')"
                                            class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-xs sm:text-sm">
                                            <i class="fas fa-times-circle mr-2"></i> Reject
                                        </button>
                                    </div>

                                    <form id="reject-form-<?php echo e($booking->id); ?>" 
                                        method="POST" 
                                        action="<?php echo e(route('vendor.bookings.reject', $booking)); ?>" 
                                        class="hidden mt-3 sm:mt-4 bg-white rounded-lg p-3 sm:p-4 border-2 border-red-200">
                                        <?php echo csrf_field(); ?>
                                        <label class="block text-xs sm:text-sm font-bold text-gray-700 mb-2">
                                            <i class="fas fa-comment-alt text-red-600 mr-2"></i>Reason for Rejection
                                        </label>
                                        <textarea name="reason" rows="3" placeholder="Please provide a reason for rejection..." 
                                            class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 mb-3 text-sm focus:border-red-500 focus:outline-none" required></textarea>
                                        <button type="submit" class="w-full sm:w-auto bg-gradient-to-r from-red-500 to-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:shadow-xl transition font-bold text-xs sm:text-sm">
                                            <i class="fas fa-ban mr-2"></i> Confirm Rejection
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="border-t-2 border-gray-200 pt-3 sm:pt-4">
                        <a href="<?php echo e(route('vendor.bookings.show', $booking)); ?>" 
                            class="inline-flex items-center bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-xs sm:text-sm transition transform hover:scale-105">
                            <i class="fas fa-eye mr-2"></i> View Details
                            <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg sm:rounded-xl shadow-lg p-8 sm:p-12 md:p-16 text-center border-2 border-dashed border-gray-300">
                <div class="bg-gray-200 rounded-full w-16 h-16 sm:w-20 sm:h-20 md:w-24 md:h-24 flex items-center justify-center mx-auto mb-4 sm:mb-6">
                    <i class="fas fa-calendar-times text-3xl sm:text-4xl md:text-5xl text-gray-400"></i>
                </div>
                <h3 class="text-lg sm:text-xl md:text-2xl font-bold text-gray-700 mb-2">No Property Bookings Found</h3>
                <p class="text-sm sm:text-base text-gray-600"><?php echo e(request('status') ? 'No property bookings match the selected filter.' : 'You don\'t have any property bookings yet.'); ?></p>
            </div>
        <?php endif; ?>

        <div class="mt-4 sm:mt-6">
            <?php echo e($bookings->links()); ?>

        </div>
    </div>
    <?php endif; ?>

    <!-- Car Bookings List -->
    <?php if($offersCarRentals): ?>
    <div id="content-cars" class="tab-content space-y-4 sm:space-y-6 <?php echo e($offersProperties ? 'hidden' : ''); ?>">
        <?php $__empty_1 = true; $__currentLoopData = $carBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300">
                <!-- Card Header -->
                <div class="bg-gradient-to-r from-green-50 to-teal-50 p-4 sm:p-6 border-b-2 border-green-200">
                    <div class="flex flex-col sm:flex-row justify-between items-start gap-3 sm:gap-4">
                        <div class="flex-1 w-full">
                            <div class="flex items-start gap-2 sm:gap-3 mb-2 sm:mb-3">
                                <div class="bg-green-100 p-2 sm:p-3 rounded-lg flex-shrink-0">
                                    <i class="fas fa-car text-green-600 text-lg sm:text-xl md:text-2xl"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h3 class="text-base sm:text-lg md:text-2xl font-bold text-gray-800 truncate"><?php echo e($booking->car->full_name); ?></h3>
                                    <p class="text-xs sm:text-sm text-gray-600 truncate">Booking #<?php echo e($booking->id); ?> • <?php echo e($booking->car->category->name); ?></p>
                                </div>
                            </div>
                            <div class="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4 text-xs sm:text-sm ml-0 sm:ml-11 md:ml-14">
                                <div class="flex items-center text-gray-700">
                                    <i class="fas fa-user-circle text-green-600 mr-2"></i>
                                    <span class="font-semibold truncate"><?php echo e($booking->driver_name); ?></span>
                                </div>
                                <div class="flex items-center text-gray-600 truncate">
                                    <i class="fas fa-envelope text-green-600 mr-2"></i>
                                    <span class="truncate"><?php echo e($booking->driver_email); ?></span>
                                </div>
                                <div class="flex items-center text-gray-600">
                                    <i class="fas fa-phone text-green-600 mr-2"></i>
                                    <?php echo e($booking->driver_phone); ?>

                                </div>
                            </div>
                        </div>
                        <div class="flex flex-row sm:flex-col gap-2 items-start sm:items-end w-full sm:w-auto">
                            <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-bold shadow-md
                                <?php if($booking->status === 'confirmed'): ?> bg-green-500 text-white
                                <?php elseif($booking->status === 'pending'): ?> bg-yellow-500 text-white
                                <?php elseif($booking->status === 'active'): ?> bg-blue-500 text-white
                                <?php elseif($booking->status === 'completed'): ?> bg-gray-500 text-white
                                <?php else: ?> bg-red-500 text-white
                                <?php endif; ?>">
                                <?php echo e(ucfirst($booking->status)); ?>

                            </span>
                            <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-bold shadow-md
                                <?php if($booking->payment_status === 'paid'): ?> bg-green-500 text-white
                                <?php elseif($booking->payment_status === 'pending_verification'): ?> bg-yellow-500 text-white
                                <?php else: ?> bg-gray-500 text-white
                                <?php endif; ?>">
                                <?php echo e(ucfirst(str_replace('_', ' ', $booking->payment_status))); ?>

                            </span>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="p-4 sm:p-6">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-2 sm:gap-3 md:gap-4 mb-4 sm:mb-6">
                        <div class="bg-green-50 border-2 border-green-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-green-600 font-semibold mb-1 sm:mb-2">Pickup</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-calendar-check text-green-600 mr-1 sm:mr-2"></i>
                                <span class="truncate"><?php echo e(\Carbon\Carbon::parse($booking->pickup_date)->format('M d, Y')); ?></span>
                            </p>
                        </div>
                        <div class="bg-red-50 border-2 border-red-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-red-600 font-semibold mb-1 sm:mb-2">Return</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-calendar-times text-red-600 mr-1 sm:mr-2"></i>
                                <span class="truncate"><?php echo e(\Carbon\Carbon::parse($booking->return_date)->format('M d, Y')); ?></span>
                            </p>
                        </div>
                        <div class="bg-blue-50 border-2 border-blue-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-blue-600 font-semibold mb-1 sm:mb-2">Days</p>
                            <p class="font-bold text-gray-800 flex items-center text-xs sm:text-sm">
                                <i class="fas fa-calendar-
                                day text-blue-600 mr-1 sm:mr-2"></i>
                                <?php echo e($booking->total_days); ?> <?php echo e(Str::plural('day', $booking->total_days)); ?>

                            </p>
                        </div>
                        <div class="bg-green-50 border-2 border-green-200 rounded-lg sm:rounded-xl p-2 sm:p-3 md:p-4">
                            <p class="text-xs text-green-600 font-semibold mb-1 sm:mb-2">Total</p>
                            <p class="font-bold text-green-600 text-base sm:text-lg md:text-xl flex items-center">
                                <i class="fas fa-money-bill-wave mr-1 sm:mr-2"></i>
                                <span class="truncate">₦<?php echo e(number_format($booking->total_amount)); ?></span>
                            </p>
                        </div>
                    </div>

                    <div class="border-t-2 border-gray-200 pt-3 sm:pt-4">
                        <a href="<?php echo e(route('vendor.car-bookings.show', $booking)); ?>" 
                            class="inline-flex items-center bg-green-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-green-700 font-semibold text-xs sm:text-sm transition transform hover:scale-105">
                            <i class="fas fa-eye mr-2"></i> View Details
                            <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg sm:rounded-xl shadow-lg p-8 sm:p-12 md:p-16 text-center border-2 border-dashed border-gray-300">
                <div class="bg-gray-200 rounded-full w-16 h-16 sm:w-20 sm:h-20 md:w-24 md:h-24 flex items-center justify-center mx-auto mb-4 sm:mb-6">
                    <i class="fas fa-car text-3xl sm:text-4xl md:text-5xl text-gray-400"></i>
                </div>
                <h3 class="text-lg sm:text-xl md:text-2xl font-bold text-gray-700 mb-2">No Car Bookings Found</h3>
                <p class="text-sm sm:text-base text-gray-600"><?php echo e(request('status') ? 'No car bookings match the selected filter.' : 'You don\'t have any car bookings yet.'); ?></p>
            </div>
        <?php endif; ?>

        <div class="mt-4 sm:mt-6">
            <?php echo e($carBookings->links()); ?>

        </div>
    </div>
    <?php endif; ?>
</div>

<script>
function showTab(tab) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });
    
    // Remove active state from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('border-primary', 'text-primary');
        button.classList.add('border-transparent', 'text-gray-600');
    });
    
    // Show selected tab content
    document.getElementById('content-' + tab).classList.remove('hidden');
    
    // Add active state to selected tab
    const activeTab = document.getElementById('tab-' + tab);
    activeTab.classList.remove('border-transparent', 'text-gray-600');
    activeTab.classList.add('border-primary', 'text-primary');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/bookings/index.blade.php ENDPATH**/ ?>