<?php $__env->startSection('title', 'Manage FAQs'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-3xl font-bold text-secondary">
                    <i class="fas fa-question-circle mr-2"></i>Manage FAQs
                </h1>
                <p class="text-gray-600 mt-1">Create and manage frequently asked questions</p>
            </div>
            <a href="<?php echo e(route('admin.faqs.create')); ?>" 
               class="bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition shadow-md">
                <i class="fas fa-plus mr-2"></i>Add New FAQ
            </a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded">
            <p class="font-bold">Success!</p>
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <!-- FAQs Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Question
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Category
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Order
                    </th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Status
                    </th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                        Actions
                    </th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900">
                                <?php echo e(Str::limit($faq->question, 80)); ?>

                            </div>
                            <div class="text-sm text-gray-500 mt-1">
                                <?php echo e(Str::limit($faq->answer, 100)); ?>

                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full 
                                <?php if($faq->category === 'general'): ?> bg-gray-100 text-gray-800
                                <?php elseif($faq->category === 'booking'): ?> bg-blue-100 text-blue-800
                                <?php elseif($faq->category === 'payment'): ?> bg-green-100 text-green-800
                                <?php elseif($faq->category === 'car_rental'): ?> bg-purple-100 text-purple-800
                                <?php else: ?> bg-yellow-100 text-yellow-800
                                <?php endif; ?>">
                                <?php echo e(\App\Models\Faq::categories()[$faq->category] ?? $faq->category); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <?php echo e($faq->display_order); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <form action="<?php echo e(route('admin.faqs.toggle', $faq)); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PATCH'); ?>
                                <button type="submit" 
                                    class="px-3 py-1 text-xs font-semibold rounded-full transition
                                    <?php echo e($faq->is_active 
                                        ? 'bg-green-100 text-green-800 hover:bg-green-200' 
                                        : 'bg-red-100 text-red-800 hover:bg-red-200'); ?>">
                                    <?php echo e($faq->is_active ? 'Active' : 'Inactive'); ?>

                                </button>
                            </form>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <a href="<?php echo e(route('admin.faqs.edit', $faq)); ?>" 
                               class="text-primary hover:text-primary-dark mr-3">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="<?php echo e(route('admin.faqs.destroy', $faq)); ?>" 
                                  method="POST" 
                                  class="inline"
                                  onsubmit="return confirm('Are you sure you want to delete this FAQ?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900">
                                    <i class="fas fa-trash"></i> Delete
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-500">
                            <i class="fas fa-question-circle text-4xl mb-3 text-gray-300"></i>
                            <p class="text-lg">No FAQs found</p>
                            <a href="<?php echo e(route('admin.faqs.create')); ?>" 
                               class="text-primary hover:underline mt-2 inline-block">
                                Create your first FAQ
                            </a>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <?php if($faqs->hasPages()): ?>
        <div class="mt-6">
            <?php echo e($faqs->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/faqs/index.blade.php ENDPATH**/ ?>