<?php $__env->startSection('title', 'Edit Property - ' . $property->title); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <div class="mb-4 sm:mb-6">
        <a href="<?php echo e(route('vendor.properties.show', $property)); ?>" class="text-primary hover:text-primary-dark font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i> Back to Property Details
        </a>
    </div>

    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
            <i class="fas fa-edit mr-2 sm:mr-3"></i>Edit Property
        </h1>
        <p class="text-sm sm:text-base opacity-90"><?php echo e($property->title); ?></p>
    </div>

    <form method="POST" action="<?php echo e(route('vendor.properties.update', $property)); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Basic Information -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-info-circle text-primary mr-2 sm:mr-3"></i> Basic Information
            </h2>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Property Title *</label>
                <input type="text" name="title" value="<?php echo e(old('title', $property->title)); ?>" required
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Description *</label>
                <textarea name="description" rows="4" required
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition"><?php echo e(old('description', $property->description)); ?></textarea>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-money-bill-wave text-green-600 mr-2"></i>Price per Night (₦) *
                    </label>
                    <input type="number" name="price_per_night" 
                        value="<?php echo e(old('price_per_night', $property->price_per_night)); ?>" 
                        min="0" step="0.01" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    <?php $__errorArgs = ['price_per_night'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-shield-alt text-yellow-600 mr-2"></i>Caution Fee (₦) *
                    </label>
                    <input type="number" name="caution_fee" 
                        value="<?php echo e(old('caution_fee', $property->caution_fee)); ?>" 
                        min="0" step="0.01" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    <?php $__errorArgs = ['caution_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-toggle-on text-primary mr-2"></i>Status
                </label>
                <select name="status" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    <option value="active" <?php echo e($property->status === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="inactive" <?php echo e($property->status === 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        <!-- Unavailable Dates -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                <i class="fas fa-calendar-times text-primary mr-2 sm:mr-3"></i> Availability Management
            </h2>
            <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                <p class="text-xs sm:text-sm text-blue-800">
                    <i class="fas fa-info-circle mr-2"></i>
                    Mark dates when this property is unavailable for booking
                </p>
            </div>
            
            <div id="unavailable-dates" class="space-y-2 sm:space-y-3 mb-3 sm:mb-4">
                <?php if($property->unavailable_dates): ?>
                    <?php $__currentLoopData = $property->unavailable_dates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                            <input type="date" name="unavailable_dates[]" value="<?php echo e($date); ?>" 
                                class="flex-1 border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                            <button type="button" onclick="this.parentElement.remove()" 
                                class="bg-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base transition">
                                <i class="fas fa-trash mr-2"></i> Remove
                            </button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>

            <button type="button" onclick="addUnavailableDate()" 
                class="w-full sm:w-auto bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base transition">
                <i class="fas fa-plus mr-2"></i> Add Unavailable Date
            </button>
        </div>

        <!-- Action Buttons -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                <button type="submit" 
                    class="flex-1 bg-primary text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-primary-dark font-bold text-base sm:text-lg transition">
                    <i class="fas fa-save mr-2"></i> Update Property
                </button>
                <a href="<?php echo e(route('vendor.properties.show', $property)); ?>" 
                    class="flex-1 bg-gray-300 text-gray-700 px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-gray-400 font-bold text-base sm:text-lg text-center transition">
                    <i class="fas fa-times mr-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function addUnavailableDate() {
    const container = document.getElementById('unavailable-dates');
    const div = document.createElement('div');
    div.className = 'flex flex-col sm:flex-row gap-2 sm:gap-3';
    div.innerHTML = `
        <input type="date" name="unavailable_dates[]" class="flex-1 border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
        <button type="button" onclick="this.parentElement.remove()" 
            class="bg-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base transition">
            <i class="fas fa-trash mr-2"></i> Remove
        </button>
    `;
    container.appendChild(div);
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/properties/edit.blade.php ENDPATH**/ ?>