<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-secondary mb-2">All Transactions</h1>
        <p class="text-gray-600">View all platform transactions</p>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.transactions.index')); ?>" class="grid md:grid-cols-2 gap-4">
            <select name="type" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" <?php echo e($type === 'all' ? 'selected' : ''); ?>>All Types</option>
                <option value="bookings" <?php echo e($type === 'bookings' ? 'selected' : ''); ?>>Bookings Only</option>
                <option value="refunds" <?php echo e($type === 'refunds' ? 'selected' : ''); ?>>Refunds Only</option>
            </select>
            
            <select name="service" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" <?php echo e($service === 'all' ? 'selected' : ''); ?>>All Services</option>
                <option value="property" <?php echo e($service === 'property' ? 'selected' : ''); ?>>Property Only</option>
                <option value="car" <?php echo e($service === 'car' ? 'selected' : ''); ?>>Car Only</option>
            </select>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Transactions</p>
                    <p class="text-2xl font-bold text-secondary"><?php echo e($transactions->count()); ?></p>
                </div>
                <div class="bg-blue-100 rounded-full p-3">
                    <i class="fas fa-receipt text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Bookings</p>
                    <p class="text-2xl font-bold text-secondary"><?php echo e($transactions->where('type', 'booking')->count()); ?></p>
                </div>
                <div class="bg-purple-100 rounded-full p-3">
                    <i class="fas fa-shopping-cart text-purple-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Refunds</p>
                    <p class="text-2xl font-bold text-secondary"><?php echo e($transactions->where('type', 'refund')->count()); ?></p>
                </div>
                <div class="bg-green-100 rounded-full p-3">
                    <i class="fas fa-money-bill-wave text-green-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Amount</p>
                    <p class="text-2xl font-bold text-secondary">₦<?php echo e(number_format($transactions->sum('amount'))); ?></p>
                </div>
                <div class="bg-yellow-100 rounded-full p-3">
                    <i class="fas fa-coins text-yellow-600 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-2">
                                    <?php if($transaction['type'] === 'booking'): ?>
                                        <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded text-xs font-semibold">
                                            <i class="fas fa-shopping-cart mr-1"></i>Booking
                                        </span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded text-xs font-semibold">
                                            <i class="fas fa-money-bill-wave mr-1"></i>Refund
                                        </span>
                                    <?php endif; ?>
                                    
                                    <?php if($transaction['service'] === 'property'): ?>
                                        <span class="px-2 py-1 bg-purple-100 text-purple-800 rounded text-xs">Property</span>
                                    <?php else: ?>
                                        <span class="px-2 py-1 bg-orange-100 text-orange-800 rounded text-xs">Car</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($transaction['user']); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-gray-900"><?php echo e($transaction['description']); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500">#<?php echo e($transaction['reference']); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold 
                                    <?php if($transaction['type'] === 'booking'): ?> text-red-600
                                    <?php else: ?> text-green-600
                                    <?php endif; ?>">
                                    <?php if($transaction['type'] === 'booking'): ?>-<?php else: ?>+<?php endif; ?>₦<?php echo e(number_format($transaction['amount'])); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500">
                                    <?php echo e($transaction['date'] ? $transaction['date']->format('M d, Y') : 'N/A'); ?>

                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 
                                    <?php if($transaction['status'] === 'paid'): ?> bg-green-100 text-green-800
                                    <?php elseif($transaction['status'] === 'requested'): ?> bg-blue-100 text-blue-800
                                    <?php elseif($transaction['status'] === 'processing'): ?> bg-yellow-100 text-yellow-800
                                    <?php else: ?> bg-gray-100 text-gray-800
                                    <?php endif; ?> rounded text-xs font-semibold">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $transaction['status']))); ?>

                                </span>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <i class="fas fa-receipt text-4xl text-gray-300 mb-2"></i>
                                <p class="text-gray-500">No transactions found</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/transactions/index.blade.php ENDPATH**/ ?>