<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Form Submission</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px 10px 0 0;
            text-align: center;
        }
        .content {
            background: #f9f9f9;
            padding: 30px;
            border: 1px solid #ddd;
            border-top: none;
        }
        .info-row {
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #ddd;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .label {
            font-weight: bold;
            color: #667eea;
            display: block;
            margin-bottom: 5px;
        }
        .value {
            color: #333;
            display: block;
        }
        .message-box {
            background: white;
            padding: 20px;
            border-radius: 5px;
            border-left: 4px solid #667eea;
            margin-top: 10px;
        }
        .footer {
            background: #333;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 0 0 10px 10px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1 style="margin: 0;">📧 New Contact Form Submission</h1>
        <p style="margin: 10px 0 0 0; opacity: 0.9;">Someone has sent you a message</p>
    </div>

    <div class="content">
        <div class="info-row">
            <span class="label">👤 Name:</span>
            <span class="value"><?php echo e($name); ?></span>
        </div>

        <div class="info-row">
            <span class="label">📧 Email:</span>
            <span class="value">
                <a href="mailto:<?php echo e($email); ?>" style="color: #667eea; text-decoration: none;"><?php echo e($email); ?></a>
            </span>
        </div>

        <?php if(!empty($phone)): ?>
        <div class="info-row">
            <span class="label">📱 Phone:</span>
            <span class="value">
                <a href="tel:<?php echo e($phone); ?>" style="color: #667eea; text-decoration: none;"><?php echo e($phone); ?></a>
            </span>
        </div>
        <?php endif; ?>

        <div class="info-row">
            <span class="label">📋 Subject:</span>
            <span class="value"><?php echo e($subject); ?></span>
        </div>

        <div class="info-row">
            <span class="label">💬 Message:</span>
            <div class="message-box">
                <?php echo nl2br(e($message)); ?>

            </div>
        </div>

        <div style="margin-top: 30px; padding: 15px; background: #e8f4f8; border-radius: 5px; text-align: center;">
            <p style="margin: 0; color: #555;">
                <strong>💡 Quick Actions:</strong><br>
                <a href="mailto:<?php echo e($email); ?>" style="color: #667eea; text-decoration: none; margin: 0 10px;">Reply via Email</a>
                <?php if(!empty($phone)): ?>
                | <a href="tel:<?php echo e($phone); ?>" style="color: #667eea; text-decoration: none; margin: 0 10px;">Call</a>
                <?php endif; ?>
            </p>
        </div>
    </div>

    <div class="footer">
        <p style="margin: 0;">This message was sent via the contact form on <?php echo e(config('app.name')); ?></p>
        <p style="margin: 5px 0 0 0; opacity: 0.7;"><?php echo e(now()->format('F d, Y \a\t h:i A')); ?></p>
    </div>
</body>
</html><?php /**PATH /Users/mac/ShortStayNG/resources/views/emails/contact.blade.php ENDPATH**/ ?>