<?php $__env->startSection('title', 'Payouts'); ?>

<?php $__env->startSection('content'); ?>
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3 sm:gap-4">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                        <i class="fas fa-wallet mr-2 sm:mr-3"></i>Payouts & Earnings
                    </h1>
                    <p class="text-xs sm:text-sm opacity-90">Manage your earnings and request withdrawals</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-4 sm:px-6 py-2 sm:py-3">
                    <p class="text-xs opacity-90">Available Balance</p>
                    <p class="text-2xl sm:text-3xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->pending_balance)); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Balance Overview -->
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-3 sm:gap-4 md:gap-6 mb-6 sm:mb-8">
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-hourglass-half text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-arrow-up text-2xl sm:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs sm:text-sm opacity-90 mb-1">Pending Balance</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->pending_balance)); ?></p>
            <p class="text-xs opacity-75 mt-1 sm:mt-2">Available for withdrawal</p>
        </div>

        <div class="bg-gradient-to-br from-green-500 to-green-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 transform hover:scale-105 transition">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-money-bill-wave text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-chart-line text-2xl sm:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs sm:text-sm opacity-90 mb-1">Payout Balance</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->payout_balance)); ?></p>
            <p class="text-xs opacity-75 mt-1 sm:mt-2">In processing</p>
        </div>

        <div class="bg-gradient-to-br from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 transform hover:scale-105 transition sm:col-span-2 md:col-span-1">
            <div class="flex items-center justify-between mb-2 sm:mb-3">
                <div class="bg-white/20 p-2 sm:p-3 rounded-lg">
                    <i class="fas fa-trophy text-lg sm:text-xl md:text-2xl"></i>
                </div>
                <i class="fas fa-coins text-2xl sm:text-3xl opacity-20"></i>
            </div>
            <p class="text-xs sm:text-sm opacity-90 mb-1">Total Earned</p>
            <p class="text-2xl sm:text-3xl md:text-4xl font-bold">₦<?php echo e(number_format(auth()->user()->vendor->total_earned)); ?></p>
            <p class="text-xs opacity-75 mt-1 sm:mt-2">All-time earnings</p>
        </div>
    </div>

    <!-- Request Payout -->
    <?php if(auth()->user()->vendor->pending_balance > 0): ?>
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-6 sm:mb-8">
            <div class="flex items-center mb-4 sm:mb-6">
                <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                    <i class="fas fa-hand-holding-usd text-primary text-xl sm:text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Request Payout</h2>
                    <p class="text-xs sm:text-sm text-gray-600">Withdraw your available balance</p>
                </div>
            </div>
            
            <?php if(!auth()->user()->vendor->transaction_pin): ?>
                <div class="bg-red-50 border-2 border-red-200 rounded-lg p-3 sm:p-4 mb-3 sm:mb-4">
                    <p class="text-red-800 font-semibold mb-2 text-sm sm:text-base">
                        <i class="fas fa-shield-alt mr-2"></i>
                        Transaction PIN Required
                    </p>
                    <p class="text-red-700 text-xs sm:text-sm mb-2 sm:mb-3">
                        Please set your transaction PIN in your profile before requesting payout for security purposes.
                    </p>
                    <a href="<?php echo e(route('vendor.profile')); ?>" class="inline-block bg-red-600 text-white px-3 sm:px-4 py-2 rounded hover:bg-red-700 font-semibold text-xs sm:text-sm">
                        Set Transaction PIN →
                    </a>
                </div>
            <?php elseif(!auth()->user()->vendor->bank_name || !auth()->user()->vendor->account_number): ?>
                <div class="bg-yellow-50 border border-yellow-200 rounded p-3 sm:p-4 mb-3 sm:mb-4">
                    <p class="text-yellow-800 text-xs sm:text-sm">
                        <i class="fas fa-exclamation-triangle mr-2"></i>
                        Please update your bank details in your profile before requesting payout.
                    </p>
                    <a href="<?php echo e(route('vendor.profile')); ?>" class="text-primary hover:underline mt-2 inline-block text-xs sm:text-sm">
                        Update Bank Details →
                    </a>
                </div>
            <?php else: ?>
                <form method="POST" action="<?php echo e(route('vendor.payouts.request')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 mb-2 text-sm sm:text-base font-semibold">Amount to Withdraw *</label>
                        <input type="number" name="amount" 
                            max="<?php echo e(auth()->user()->vendor->pending_balance); ?>" 
                            min="1000" 
                            step="0.01"
                            value="<?php echo e(old('amount')); ?>"
                            class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            required>
                        <p class="text-xs sm:text-sm text-gray-600 mt-1">
                            Available: ₦<?php echo e(number_format(auth()->user()->vendor->pending_balance)); ?> | Minimum: ₦1,000
                        </p>
                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4">
                        <label class="block text-gray-700 font-semibold mb-2 text-sm sm:text-base">
                            <i class="fas fa-shield-alt text-primary mr-2"></i>Transaction PIN *
                        </label>
                        <input type="password" name="transaction_pin" 
                            maxlength="4" 
                            pattern="\d{4}"
                            placeholder="Enter your 4-digit PIN"
                            class="w-full border-2 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition <?php $__errorArgs = ['transaction_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            required>
                        <p class="text-xs text-gray-600 mt-1">
                            <i class="fas fa-info-circle mr-1"></i>Enter your 4-digit transaction PIN to authorize this payout
                        </p>
                        <?php $__errorArgs = ['transaction_pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php $__errorArgs = ['bank_details'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs sm:text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3 sm:mb-4 bg-gray-50 border-2 border-gray-200 p-3 sm:p-4 rounded-lg">
                        <p class="text-xs sm:text-sm text-gray-700 mb-2 font-semibold">
                            <i class="fas fa-university mr-2"></i>Payout Destination:
                        </p>
                        <p class="text-xs sm:text-sm font-semibold"><?php echo e(auth()->user()->vendor->bank_name); ?></p>
                        <p class="text-xs sm:text-sm"><?php echo e(auth()->user()->vendor->account_number); ?></p>
                        <p class="text-xs sm:text-sm"><?php echo e(auth()->user()->vendor->account_name); ?></p>
                    </div>

                    <button type="submit" class="w-full sm:w-auto bg-gradient-to-r from-primary to-primary-dark text-white px-6 sm:px-8 py-2 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base">
                        <i class="fas fa-paper-plane mr-2"></i> Request Payout
                    </button>
                </form>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="bg-gradient-to-br from-blue-50 to-primary/5 border-2 border-dashed border-primary/30 rounded-lg sm:rounded-xl p-6 sm:p-8 mb-6 sm:mb-8 text-center">
            <div class="bg-primary/10 rounded-full w-16 h-16 sm:w-20 sm:h-20 flex items-center justify-center mx-auto mb-3 sm:mb-4">
                <i class="fas fa-wallet text-primary text-3xl sm:text-4xl"></i>
            </div>
            <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-2">No Balance Available</h3>
            <p class="text-gray-600 text-sm sm:text-base">
                Complete more bookings to earn and request payouts!
            </p>
        </div>
    <?php endif; ?>

    <!-- Payout History -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
        <div class="flex items-center mb-4 sm:mb-6">
            <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                <i class="fas fa-history text-primary text-xl sm:text-2xl"></i>
            </div>
            <div>
                <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Payout History</h2>
                <p class="text-xs sm:text-sm text-gray-600">Track your withdrawal requests</p>
            </div>
        </div>
        
        <div class="space-y-3 sm:space-y-4">
            <?php $__empty_1 = true; $__currentLoopData = $payouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 md:p-5 hover:shadow-md transition border-l-4 
                    <?php echo e($payout->status === 'pending' ? 'border-yellow-500' : 
                       ($payout->status === 'completed' ? 'border-green-500' : 'border-red-500')); ?>">
                    <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
                        <div class="flex-1 w-full">
                            <div class="flex items-center gap-2 sm:gap-3 mb-2">
                                <div class="bg-white p-2 rounded-lg flex-shrink-0">
                                    <i class="fas fa-money-bill-wave text-primary text-lg sm:text-xl"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <p class="text-xl sm:text-2xl font-bold text-gray-800">₦<?php echo e(number_format($payout->amount)); ?></p>
                                    <p class="text-xs text-gray-600"><?php echo e($payout->created_at->format('M d, Y H:i')); ?></p>
                                </div>
                            </div>
                            <div class="space-y-1 ml-0 sm:ml-10 md:ml-12">
                                <p class="text-xs sm:text-sm text-gray-600 break-all">
                                    <i class="fas fa-hashtag text-primary mr-1 sm:mr-2"></i>
                                    <strong>Reference:</strong> <?php echo e($payout->reference); ?>

                                </p>
                                <?php if($payout->status === 'completed' && $payout->processed_at): ?>
                                    <p class="text-xs sm:text-sm text-green-700">
                                        <i class="fas fa-check-circle mr-1 sm:mr-2"></i>
                                        <strong>Processed:</strong> <?php echo e($payout->processed_at->format('M d, Y')); ?>

                                    </p>
                                <?php endif; ?>
                                <?php if($payout->status === 'rejected' && $payout->rejection_reason): ?>
                                    <div class="bg-red-50 border-l-4 border-red-500 p-2 sm:p-3 rounded mt-2">
                                        <p class="text-xs sm:text-sm text-red-800">
                                            <i class="fas fa-exclamation-circle mr-1 sm:mr-2"></i>
                                            <strong>Rejection Reason:</strong> <?php echo e($payout->rejection_reason); ?>

                                        </p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="w-full sm:w-auto sm:text-right">
                            <span class="inline-block px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-bold shadow-md
                                <?php echo e($payout->status === 'pending' ? 'bg-yellow-500 text-white' : 
                                   ($payout->status === 'completed' ? 'bg-green-500 text-white' : 'bg-red-500 text-white')); ?>">
                                <i class="fas <?php echo e($payout->status === 'pending' ? 'fa-clock' : ($payout->status === 'completed' ? 'fa-check-circle' : 'fa-times-circle')); ?> mr-1"></i>
                                <?php echo e(ucfirst($payout->status)); ?>

                            </span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg sm:rounded-xl p-8 sm:p-12 text-center border-2 border-dashed border-gray-300">
                    <div class="bg-gray-200 rounded-full w-16 h-16 sm:w-20 sm:h-20 flex items-center justify-center mx-auto mb-3 sm:mb-4">
                        <i class="fas fa-inbox text-gray-400 text-3xl sm:text-4xl"></i>
                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-700 mb-2">No Payout Requests Yet</h3>
                    <p class="text-gray-600 text-sm sm:text-base">Your payout history will appear here</p>
                </div>
            <?php endif; ?>
        </div>

        <?php if($payouts->hasPages()): ?>
            <div class="mt-4 sm:mt-6">
                <?php echo e($payouts->links()); ?>

            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/vendor/payouts/index.blade.php ENDPATH**/ ?>