<?php $__env->startSection('title', 'Advertisement Approvals'); ?>

<?php $__env->startSection('content'); ?>
<div>
    <h1 class="text-3xl font-bold mb-6">Advertisement Approvals</h1>

    <!-- Pending Payment Verification (Bank Transfer) -->
    <?php if(isset($pendingPaymentAds) && $pendingPaymentAds->count() > 0): ?>
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="font-bold text-xl">Pending Payment Verification</h2>
            <span class="bg-orange-100 text-orange-800 px-3 py-1 rounded-full text-sm font-semibold">
                <?php echo e($pendingPaymentAds->count()); ?>

            </span>
        </div>

        <?php $__currentLoopData = $pendingPaymentAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold"><?php echo e($ad->property->title); ?></h3>
                        <p class="text-sm text-gray-600">Vendor: <?php echo e($ad->vendor->company_name); ?></p>
                        <p class="text-sm text-gray-600">Plan: <?php echo e($ad->adPlan->name); ?> (<?php echo e($ad->adPlan->duration_days); ?> days)</p>
                        <p class="text-sm text-gray-600">Amount: ₦<?php echo e(number_format($ad->adPlan->price)); ?></p>
                        <p class="text-sm text-gray-600">Payment Method: <?php echo e(ucfirst(str_replace('_', ' ', $ad->payment_method))); ?></p>
                        <?php if($ad->payment_proof): ?>
                            <div class="mt-2">
                                <a href="<?php echo e(asset('storage/' . $ad->payment_proof)); ?>" target="_blank" 
                                    class="text-primary hover:underline text-sm">
                                    <i class="fas fa-image mr-1"></i> View Payment Proof
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="flex gap-2">
                        <form method="POST" action="<?php echo e(route('admin.ads.verify-payment', $ad)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                <i class="fas fa-check mr-1"></i> Verify Payment
                            </button>
                        </form>

                        <form method="POST" action="<?php echo e(route('admin.ads.reject-payment', $ad)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm"
                                onclick="return confirm('Reject this payment proof?')">
                                <i class="fas fa-times mr-1"></i> Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <?php endif; ?>

    <!-- Pending Approvals -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex justify-between items-center mb-4">
            <h2 class="font-bold text-xl">Pending Approvals</h2>
            <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">
                <?php echo e($pendingAds->count()); ?>

            </span>
        </div>

        <?php $__empty_1 = true; $__currentLoopData = $pendingAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold"><?php echo e($ad->property->title); ?></h3>
                        <p class="text-sm text-gray-600">Vendor: <?php echo e($ad->vendor->company_name); ?></p>
                        <p class="text-sm text-gray-600">Plan: <?php echo e($ad->adPlan->name); ?> (<?php echo e($ad->adPlan->duration_days); ?> days)</p>
                        <div class="text-sm text-gray-600">
                            <?php if($ad->discount_amount > 0): ?>
                                <span class="line-through text-gray-400">₦<?php echo e(number_format($ad->adPlan->price)); ?></span>
                                <span class="text-green-600 font-semibold ml-2">₦<?php echo e(number_format($ad->final_amount)); ?></span>
                                <span class="ml-2 bg-green-100 text-green-700 px-2 py-0.5 rounded text-xs">
                                    <i class="fas fa-tag"></i> <?php echo e($ad->promo_code); ?>

                                </span>
                            <?php else: ?>
                                Price: ₦<?php echo e(number_format($ad->adPlan->price)); ?>

                            <?php endif; ?>
                        </div>
                        <?php if($ad->paid_at): ?>
                            <p class="text-xs text-green-600 mt-1">✓ Paid on <?php echo e($ad->paid_at->format('M d, Y H:i')); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="flex gap-2">
                        <form method="POST" action="<?php echo e(route('admin.ads.approve', $ad)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="bg-green-600 text-white px-4 py-2 rounded hover:bg-green-700 text-sm">
                                Approve
                            </button>
                        </form>

                        <form method="POST" action="<?php echo e(route('admin.ads.deactivate', $ad)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="bg-red-600 text-white px-4 py-2 rounded hover:bg-red-700 text-sm">
                                Reject
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-gray-600 text-center py-8">No pending ad approvals</p>
        <?php endif; ?>
    </div>

    <!-- Active Ads -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="font-bold text-xl mb-4">Active Advertisements</h2>

        <?php $__empty_1 = true; $__currentLoopData = $activeAds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-b last:border-b-0 py-4">
                <div class="flex justify-between items-start">
                    <div class="flex-1">
                        <h3 class="font-bold"><?php echo e($ad->property->title); ?></h3>
                        <p class="text-sm text-gray-600">Vendor: <?php echo e($ad->vendor->company_name); ?></p>
                        <p class="text-sm text-gray-600">Plan: <?php echo e($ad->adPlan->name); ?></p>
                        <p class="text-sm text-gray-600">
                            Active: <?php echo e($ad->start_date->format('M d')); ?> - <?php echo e($ad->end_date->format('M d, Y')); ?>

                        </p>
                        <p class="text-xs text-gray-500 mt-1">
                            <?php echo e($ad->end_date->diffInDays(now())); ?> days remaining
                        </p>
                    </div>

                    <div class="flex gap-2">
                        <button onclick="document.getElementById('extend-form-<?php echo e($ad->id); ?>').classList.toggle('hidden')"
                            class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark text-sm">
                            Extend
                        </button>

                        <form method="POST" action="<?php echo e(route('admin.ads.deactivate', $ad)); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700 text-sm">
                                Deactivate
                            </button>
                        </form>
                    </div>
                </div>

                <form id="extend-form-<?php echo e($ad->id); ?>" 
                    method="POST" 
                    action="<?php echo e(route('admin.ads.extend', $ad)); ?>" 
                    class="hidden mt-3 flex gap-2">
                    <?php echo csrf_field(); ?>
                    <input type="number" name="days" min="1" max="90" placeholder="Days" 
                        class="border rounded px-4 py-2 w-32">
                    <button type="submit" class="bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                        Extend
                    </button>
                </form>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p class="text-gray-600 text-center py-8">No active advertisements</p>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/mac/ShortStayNG/resources/views/admin/ads/index.blade.php ENDPATH**/ ?>