<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WebhookController;

Route::post('/webhooks/paystack', [WebhookController::class, 'paystack'])->name('webhooks.paystack');
Route::post('/webhooks/flutterwave', [WebhookController::class, 'flutterwave'])->name('webhooks.flutterwave');

// API endpoints (add authentication as needed)
Route::prefix('v1')->group(function () {
    // Public API routes
    Route::get('/properties', [\App\Http\Controllers\Api\PropertyController::class, 'index']);
    Route::get('/properties/{property}', [\App\Http\Controllers\Api\PropertyController::class, 'show']);
    
    // Authenticated API routes
    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/bookings', [\App\Http\Controllers\Api\BookingController::class, 'index']);
        Route::post('/bookings', [\App\Http\Controllers\Api\BookingController::class, 'store']);
    });
});

// Public property availability endpoint (no version prefix for backward compatibility)
Route::get('/properties/{property}/booked-dates', [\App\Http\Controllers\Api\PropertyController::class, 'bookedDates']);