@extends('layouts.vendor')

@section('title', 'Property Details - ' . $property->title)

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('vendor.properties.index') }}" class="text-primary hover:text-primary-dark font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i> Back to Properties
        </a>
    </div>

    <!-- Header Card -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
            <div class="flex-1">
                <div class="flex flex-wrap items-center gap-2 mb-2">
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold">{{ $property->title }}</h1>
                    @if($property->is_hotel)
                        <span class="bg-white/20 px-2 sm:px-3 py-1 rounded-full text-xs font-semibold">
                            <i class="fas fa-hotel mr-1"></i> Hotel
                        </span>
                    @endif
                    @if($property->video_url)
                        <span class="bg-purple-500/80 px-2 sm:px-3 py-1 rounded-full text-xs font-semibold">
                            <i class="fas fa-video mr-1"></i> Has Video
                        </span>
                    @endif
                </div>
                <p class="text-sm sm:text-base opacity-90">
                    <i class="fas fa-map-marker-alt mr-2"></i>{{ $property->address }}, {{ $property->city }}
                </p>
            </div>
            <span class="px-3 sm:px-4 py-1.5 sm:py-2 rounded-full text-xs sm:text-sm font-semibold
                {{ $property->status === 'active' ? 'bg-green-500 text-white' : 'bg-gray-500 text-white' }}">
                <i class="fas fa-circle text-xs mr-1"></i> {{ ucfirst($property->status) }}
            </span>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 sm:gap-6 mb-4 sm:mb-6">
        <!-- Main Content -->
        <div class="md:col-span-2 space-y-4 sm:space-y-6">

            <!-- Video Section (if exists) -->
            @if($property->video_url)
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-video text-primary mr-2 sm:mr-3"></i> Property Video
                    </h2>
                    <div class="relative" style="padding-top: 56.25%;">
                        <video controls class="absolute top-0 left-0 w-full h-full rounded-lg">
                            <source src="{{ Storage::url($property->video_url) }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                </div>
            @endif

            <!-- Photos -->
            @if($property->photos && count($property->photos) > 0)
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-images text-primary mr-2 sm:mr-3"></i> Property Photos
                    </h2>
                    <div class="grid grid-cols-2 sm:grid-cols-3 gap-2 sm:gap-3">
                        @foreach(array_slice($property->photos, 0, 6) as $photo)
                            <img src="{{ Storage::url($photo) }}" alt="{{ $property->title }}" 
                                class="w-full h-32 sm:h-40 object-cover rounded-lg hover:scale-105 transition cursor-pointer">
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Hotel Room Types Section -->
            @if($property->is_hotel)
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <div class="flex justify-between items-center mb-3 sm:mb-4">
                        <h2 class="text-lg sm:text-xl font-bold text-secondary flex items-center">
                            <i class="fas fa-door-open text-primary mr-2 sm:mr-3"></i> Room Types
                        </h2>
                        <a href="{{ route('vendor.properties.rooms.create', $property) }}" 
                            class="bg-primary text-white px-3 sm:px-4 py-1.5 sm:py-2 rounded-lg hover:bg-primary-dark text-xs sm:text-sm font-semibold">
                            <i class="fas fa-plus mr-1"></i> Add Room
                        </a>
                    </div>

                    @if($property->rooms->count() > 0)
                        <div class="space-y-3 sm:space-y-4">
                            @foreach($property->rooms as $room)
                                <div class="bg-gray-50 rounded-lg p-3 sm:p-4 border-2 border-gray-200 hover:border-primary transition">
                                    <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
                                        <div class="flex-1">
                                            <h3 class="font-bold text-base sm:text-lg text-gray-800 mb-1">
                                                {{ $room->room_type }}
                                                <span class="text-xs px-2 py-1 rounded-full ml-2
                                                    {{ $room->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                                    {{ ucfirst($room->status) }}
                                                </span>
                                            </h3>
                                            @if($room->description)
                                                <p class="text-xs sm:text-sm text-gray-600 mb-2">{{ Str::limit($room->description, 100) }}</p>
                                            @endif
                                            <div class="grid grid-cols-2 sm:grid-cols-4 gap-2 text-xs sm:text-sm">
                                                <div>
                                                    <span class="text-gray-600">Price:</span>
                                                    <span class="font-bold text-primary">₦{{ number_format($room->price_per_night) }}</span>
                                                </div>
                                                <div>
                                                    <span class="text-gray-600">Units:</span>
                                                    <span class="font-bold">{{ $room->total_units }}</span>
                                                </div>
                                                <div>
                                                    <span class="text-gray-600">Guests:</span>
                                                    <span class="font-bold">{{ $room->max_guests }}</span>
                                                </div>
                                                <div>
                                                    <span class="text-gray-600">Size:</span>
                                                    <span class="font-bold">{{ $room->room_size_sqm ?? 'N/A' }} m²</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="flex sm:flex-col gap-2 w-full sm:w-auto">
                                            <a href="{{ route('vendor.properties.rooms.edit', [$property, $room]) }}" 
                                                class="flex-1 sm:flex-none bg-blue-600 text-white px-3 py-1.5 rounded hover:bg-blue-700 text-xs sm:text-sm text-center">
                                                <i class="fas fa-edit mr-1"></i> Edit
                                            </a>
                                            <form action="{{ route('vendor.properties.rooms.destroy', [$property, $room]) }}" 
                                                  method="POST" onsubmit="return confirm('Delete this room type?')" 
                                                  class="flex-1 sm:flex-none">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" 
                                                    class="w-full bg-red-600 text-white px-3 py-1.5 rounded hover:bg-red-700 text-xs sm:text-sm">
                                                    <i class="fas fa-trash mr-1"></i> Delete
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-6 sm:py-8 bg-gray-50 rounded-lg">
                            <i class="fas fa-door-open text-4xl sm:text-5xl text-gray-300 mb-3"></i>
                            <p class="text-gray-600 text-sm sm:text-base mb-3">No room types added yet</p>
                            <a href="{{ route('vendor.properties.rooms.create', $property) }}" 
                                class="inline-block bg-primary text-white px-4 sm:px-6 py-2 rounded-lg hover:bg-primary-dark text-sm sm:text-base">
                                <i class="fas fa-plus mr-2"></i> Add First Room Type
                            </a>
                        </div>
                    @endif
                </div>
            @else
                <!-- Property Details (Non-Hotel) -->
                <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                    <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-info-circle text-primary mr-2 sm:mr-3"></i> Property Details
                    </h2>
                    <div class="grid grid-cols-2 sm:grid-cols-3 gap-2 sm:gap-4">
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-home text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Type</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->house_type }}</p>
                        </div>
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-bed text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Bedrooms</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->bedrooms }}</p>
                        </div>
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-bed text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Beds</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->beds }}</p>
                        </div>
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-bath text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Bathrooms</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->bathrooms }}</p>
                        </div>
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-users text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Max Guests</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->max_guests }}</p>
                        </div>
                        <div class="bg-primary/5 rounded-lg p-3 sm:p-4 text-center">
                            <i class="fas fa-boxes text-primary text-xl sm:text-2xl mb-1 sm:mb-2"></i>
                            <p class="text-xs text-gray-600">Units</p>
                            <p class="font-bold text-secondary text-sm sm:text-base">{{ $property->total_units }}</p>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Description -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                    <i class="fas fa-align-left text-primary mr-2 sm:mr-3"></i> Description
                </h2>
                <p class="text-gray-700 whitespace-pre-line leading-relaxed text-sm sm:text-base">{{ $property->description }}</p>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-4 sm:space-y-6">
            <!-- Pricing -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h3 class="font-bold text-secondary mb-3 sm:mb-4 flex items-center text-base sm:text-lg">
                    <i class="fas fa-money-bill-wave text-primary mr-2"></i> Pricing
                </h3>
                <div class="space-y-3 sm:space-y-4">
                    @if($property->is_hotel)
                        <div class="bg-green-50 rounded-lg p-3 sm:p-4">
                            <p class="text-xs text-gray-600 mb-1">Starting Price</p>
                            <p class="text-xl sm:text-2xl font-bold text-green-600">
                                ₦{{ number_format($property->rooms->min('price_per_night') ?? 0) }}
                            </p>
                        </div>
                        <div class="bg-blue-50 rounded-lg p-3 sm:p-4">
                            <p class="text-xs text-gray-600 mb-1">Price Range</p>
                            <p class="text-base sm:text-lg font-bold text-blue-600">
                                ₦{{ number_format($property->rooms->min('price_per_night') ?? 0) }} - 
                                ₦{{ number_format($property->rooms->max('price_per_night') ?? 0) }}
                            </p>
                        </div>
                    @else
                        <div class="bg-green-50 rounded-lg p-3 sm:p-4">
                            <p class="text-xs text-gray-600 mb-1">Price per Night</p>
                            <p class="text-xl sm:text-2xl font-bold text-green-600">₦{{ number_format($property->price_per_night) }}</p>
                        </div>
                    @endif
                    <div class="bg-yellow-50 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Caution Fee</p>
                        <p class="text-xl sm:text-2xl font-bold text-yellow-600">₦{{ number_format($property->caution_fee) }}</p>
                    </div>
                </div>
            </div>

            <!-- Booking Statistics -->
            <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
                <h3 class="font-bold text-secondary mb-3 sm:mb-4 flex items-center text-base sm:text-lg">
                    <i class="fas fa-chart-bar text-primary mr-2"></i> Statistics
                </h3>
                <div class="space-y-3 sm:space-y-4">
                    <div class="bg-blue-50 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Total Bookings</p>
                        <p class="text-xl sm:text-2xl font-bold text-blue-600">{{ $property->bookings->count() }}</p>
                    </div>
                    <div class="bg-green-50 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Confirmed</p>
                        <p class="text-xl sm:text-2xl font-bold text-green-600">{{ $property->bookings->where('booking_status', 'confirmed')->count() }}</p>
                    </div>
                    <div class="bg-yellow-50 rounded-lg p-3 sm:p-4">
                        <p class="text-xs text-gray-600 mb-1">Average Rating</p>
                        <p class="text-xl sm:text-2xl font-bold text-yellow-600">
                            {{ $property->averageRating() ? number_format($property->averageRating(), 1) . ' ★' : 'No reviews' }}
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Featured Badge -->
    @if($property->isFeatured())
        <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
            <p class="text-yellow-800 font-semibold flex items-center text-xs sm:text-sm md:text-base">
                <i class="fas fa-star text-yellow-500 mr-2"></i>
                This property is featured until {{ $property->featured_until->format('M d, Y') }}
            </p>
        </div>
    @endif

    <!-- Action Buttons -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
        <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
            <i class="fas fa-cog text-primary mr-2 sm:mr-3"></i> Actions
        </h2>
        <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
            <a href="{{ route('vendor.properties.edit', $property) }}" 
                class="flex-1 bg-primary text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-center text-sm sm:text-base transition">
                <i class="fas fa-edit mr-2"></i> Edit Property
            </a>
            <a href="{{ route('properties.show', $property) }}" target="_blank"
                class="flex-1 bg-gray-600 text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-gray-700 font-semibold text-center text-sm sm:text-base transition">
                <i class="fas fa-external-link-alt mr-2"></i> View Public Page
            </a>
            <button onclick="confirmDelete()" 
                class="flex-1 bg-red-600 text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base transition">
                <i class="fas fa-trash mr-2"></i> Delete Property
            </button>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div id="delete-modal" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
        <div class="bg-white rounded-lg p-6 sm:p-8 max-w-md w-full">
            <h2 class="text-xl sm:text-2xl font-bold mb-3 sm:mb-4 text-red-600">
                <i class="fas fa-exclamation-triangle mr-2"></i> Delete Property
            </h2>
            
            <p class="text-gray-700 mb-3 sm:mb-4 text-sm sm:text-base">
                Are you sure you want to delete <strong>{{ $property->title }}</strong>?
            </p>
            
            <div class="bg-yellow-50 border border-yellow-200 rounded p-3 mb-3 sm:mb-4">
                <p class="text-xs sm:text-sm text-yellow-800">
                    <i class="fas fa-info-circle mr-1"></i>
                    <strong>Warning:</strong> This action cannot be undone. All property data and photos will be permanently deleted.
                </p>
            </div>

            @php
                $activeBookings = $property->bookings()
                    ->whereIn('booking_status', ['confirmed', 'pending'])
                    ->where('payment_status', 'paid')
                    ->where('end_date', '>=', now())
                    ->count();
            @endphp

            @if($activeBookings > 0)
                <div class="bg-red-50 border border-red-200 rounded p-3 mb-3 sm:mb-4">
                    <p class="text-xs sm:text-sm text-red-800">
                        <i class="fas fa-ban mr-1"></i>
                        <strong>Cannot Delete:</strong> This property has {{ $activeBookings }} active booking(s). Please wait until all bookings are completed.
                    </p>
                </div>
                
                <div class="flex gap-2 sm:gap-3">
                    <button type="button" 
                        onclick="closeDeleteModal()"
                        class="flex-1 bg-gray-200 text-gray-700 px-3 sm:px-4 py-2.5 sm:py-3 rounded-lg hover:bg-gray-300 font-semibold text-sm sm:text-base">
                        Close
                    </button>
                </div>
            @else
                <form method="POST" action="{{ route('vendor.properties.destroy', $property) }}">
                    @csrf
                    @method('DELETE')
                    
                    <div class="flex gap-2 sm:gap-3">
                        <button type="button" 
                            onclick="closeDeleteModal()"
                            class="flex-1 bg-gray-200 text-gray-700 px-3 sm:px-4 py-2.5 sm:py-3 rounded-lg hover:bg-gray-300 font-semibold text-sm sm:text-base">
                            Cancel
                        </button>
                        <button type="submit" 
                            class="flex-1 bg-red-600 text-white px-3 sm:px-4 py-2.5 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base">
                            <i class="fas fa-trash mr-1"></i> Yes, Delete
                        </button>
                    </div>
                </form>
            @endif
        </div>
    </div>
</div>

<script>
function confirmDelete() {
    document.getElementById('delete-modal').classList.remove('hidden');
}

function closeDeleteModal() {
    document.getElementById('delete-modal').classList.add('hidden');
}

// Close modal on escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeDeleteModal();
    }
});

// Close modal when clicking outside
document.getElementById('delete-modal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeDeleteModal();
    }
});
</script>

@endsection