@extends('layouts.vendor')

@section('title', 'My Properties')

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3 sm:gap-4">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                        <i class="fas fa-building mr-2 sm:mr-3"></i>My Properties
                    </h1>
                    <p class="text-xs sm:text-sm opacity-90">Manage your property listings</p>
                </div>
                <a href="{{ route('vendor.properties.create') }}" 
                    class="w-full sm:w-auto bg-white text-primary px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base text-center">
                    <i class="fas fa-plus mr-2"></i> Add Property
                </a>
            </div>
        </div>
    </div>

    <!-- Properties Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
        @forelse($properties as $property)
            <div class="bg-white rounded-lg sm:rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2">
                <!-- Property Image -->
                <div class="relative">
                    <img src="{{ isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg' }}" 
                        alt="{{ $property->title }}" 
                        class="w-full h-48 sm:h-56 object-cover">
                    
                    <!-- Status Badge -->
                    <div class="absolute top-2 sm:top-4 right-2 sm:right-4">
                        <span class="px-2 sm:px-3 py-1 rounded-full text-xs font-bold shadow-lg
                            {{ $property->status === 'active' ? 'bg-green-500 text-white' : 'bg-gray-500 text-white' }}">
                            <i class="fas fa-circle text-xs mr-1"></i>{{ ucfirst($property->status) }}
                        </span>
                    </div>

                    <!-- Featured Badge -->
                    @if($property->isFeatured())
                        <div class="absolute top-2 sm:top-4 left-2 sm:left-4">
                            <span class="bg-gradient-to-r from-yellow-400 to-orange-500 text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold shadow-lg">
                                <i class="fas fa-star mr-1"></i>Featured
                            </span>
                        </div>
                    @endif

                    <!-- Hotel Badge -->
                    @if($property->is_hotel)
                        <div class="absolute bottom-2 left-2 sm:left-4">
                            <span class="bg-blue-600 text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold shadow-lg">
                                <i class="fas fa-hotel mr-1"></i>Hotel
                            </span>
                        </div>
                    @endif

                    <!-- Video Badge -->
                    @if($property->video_url)
                        <div class="absolute bottom-2 right-2 sm:right-4">
                            <span class="bg-purple-600 text-white px-2 sm:px-3 py-1 rounded-full text-xs font-bold shadow-lg">
                                <i class="fas fa-video mr-1"></i>Video
                            </span>
                        </div>
                    @endif
                </div>
                
                <!-- Property Details -->
                <div class="p-4 sm:p-5">
                    <h3 class="font-bold text-base sm:text-lg md:text-xl text-gray-800 mb-2 line-clamp-1">{{ $property->title }}</h3>
                    <p class="text-gray-600 text-xs sm:text-sm mb-3 sm:mb-4 flex items-center">
                        <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                        {{ $property->city }}, {{ $property->state }}
                    </p>

                    @if($property->isFeatured())
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg px-2 sm:px-3 py-1.5 sm:py-2 mb-3 sm:mb-4">
                            <p class="text-yellow-800 text-xs font-semibold">
                                <i class="fas fa-clock mr-1"></i>Featured until {{ $property->featured_until->format('M d, Y') }}
                            </p>
                        </div>
                    @endif

                    <!-- Property Stats -->
                    @if($property->is_hotel)
                        <!-- Hotel Stats -->
                        <div class="grid grid-cols-2 gap-2 sm:gap-3 mb-3 sm:mb-4">
                            <div class="bg-gray-50 rounded-lg p-2 sm:p-3 text-center">
                                <i class="fas fa-door-open text-primary text-base sm:text-lg mb-1"></i>
                                <p class="text-xs text-gray-600">{{ $property->rooms->count() }} Room Types</p>
                            </div>
                            <div class="bg-gray-50 rounded-lg p-2 sm:p-3 text-center">
                                <i class="fas fa-boxes text-primary text-base sm:text-lg mb-1"></i>
                                <p class="text-xs text-gray-600">{{ $property->rooms->sum('total_units') }} Total Units</p>
                            </div>
                        </div>
                    @else
                        <!-- Regular Property Stats -->
                        <div class="grid grid-cols-3 gap-2 sm:gap-3 mb-3 sm:mb-4">
                            <div class="bg-gray-50 rounded-lg p-2 sm:p-3 text-center">
                                <i class="fas fa-bed text-primary text-base sm:text-lg mb-1"></i>
                                <p class="text-xs text-gray-600">{{ $property->bedrooms }} Beds</p>
                            </div>
                            <div class="bg-gray-50 rounded-lg p-2 sm:p-3 text-center">
                                <i class="fas fa-bath text-primary text-base sm:text-lg mb-1"></i>
                                <p class="text-xs text-gray-600">{{ $property->bathrooms }} Baths</p>
                            </div>
                            <div class="bg-gray-50 rounded-lg p-2 sm:p-3 text-center">
                                <i class="fas fa-users text-primary text-base sm:text-lg mb-1"></i>
                                <p class="text-xs text-gray-600">{{ $property->max_guests }} Guests</p>
                            </div>
                        </div>
                    @endif

                    <!-- Price and Bookings -->
                    <div class="flex justify-between items-center mb-3 sm:mb-4 pb-3 sm:pb-4 border-b">
                        <div>
                            <p class="text-xs text-gray-500">
                                @if($property->is_hotel)
                                    Starting from
                                @else
                                    Price per night
                                @endif
                            </p>
                            <p class="text-lg sm:text-xl font-bold text-primary">
                                @if($property->is_hotel && $property->rooms->count() > 0)
                                    ₦{{ number_format($property->rooms->min('price_per_night')) }}
                                @else
                                    ₦{{ number_format($property->price_per_night) }}
                                @endif
                            </p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs text-gray-500">Total Bookings</p>
                            <p class="text-lg sm:text-xl font-bold text-green-600">{{ $property->bookings_count ?? 0 }}</p>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="flex flex-col sm:flex-row gap-2">
                        <a href="{{ route('vendor.properties.edit', $property) }}" 
                            class="flex-1 bg-primary text-white text-center py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark transition font-semibold text-sm">
                            <i class="fas fa-edit mr-1"></i> Edit
                        </a>
                        <a href="{{ route('vendor.properties.show', $property) }}" 
                            class="flex-1 bg-gray-600 text-white text-center py-2.5 sm:py-3 rounded-lg hover:bg-gray-700 transition font-semibold text-sm">
                            <i class="fas fa-eye mr-1"></i> View
                        </a>
                    </div>
                </div>
            </div>
        @empty
            <!-- Empty State -->
            <div class="col-span-full">
                <div class="bg-gradient-to-br from-blue-50 to-primary/5 rounded-lg sm:rounded-xl shadow-lg p-6 sm:p-8 md:p-12 text-center border-2 border-dashed border-primary/20">
                    <div class="bg-primary/10 rounded-full w-16 h-16 sm:w-20 sm:h-20 md:w-24 md:h-24 flex items-center justify-center mx-auto mb-4 sm:mb-6">
                        <i class="fas fa-home text-3xl sm:text-4xl md:text-5xl text-primary"></i>
                    </div>
                    <h2 class="text-xl sm:text-2xl font-bold text-gray-800 mb-2 sm:mb-3">No Properties Yet</h2>
                    <p class="text-sm sm:text-base text-gray-600 mb-4 sm:mb-6 max-w-md mx-auto">
                        Start your journey by listing your first property on ShortStayNG and reach thousands of potential guests.
                    </p>
                    <a href="{{ route('vendor.properties.create') }}" 
                        class="inline-block bg-gradient-to-r from-primary to-primary-dark text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg sm:rounded-xl hover:shadow-xl transition transform hover:scale-105 font-bold text-sm sm:text-base md:text-lg">
                        <i class="fas fa-plus mr-2"></i> Add Your First Property
                    </a>
                </div>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    <div class="mt-6 sm:mt-8">
        {{ $properties->links() }}
    </div>
</div>
@endsection