@extends('layouts.vendor')

@section('title', 'Edit Property - ' . $property->title)

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <div class="mb-4 sm:mb-6">
        <a href="{{ route('vendor.properties.show', $property) }}" class="text-primary hover:text-primary-dark font-semibold text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i> Back to Property Details
        </a>
    </div>

    <!-- Header -->
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
            <i class="fas fa-edit mr-2 sm:mr-3"></i>Edit Property
        </h1>
        <p class="text-sm sm:text-base opacity-90">{{ $property->title }}</p>
        @if($property->is_hotel)
            <div class="mt-2">
                <span class="bg-white/20 px-3 py-1 rounded-full text-xs font-semibold">
                    <i class="fas fa-hotel mr-1"></i> Hotel Property
                </span>
            </div>
        @endif
    </div>

    <form method="POST" action="{{ route('vendor.properties.update', $property) }}" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <!-- Basic Information -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-info-circle text-primary mr-2 sm:mr-3"></i> Basic Information
            </h2>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Property Title *</label>
                <input type="text" name="title" value="{{ old('title', $property->title) }}" required
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                @error('title')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4 sm:mb-6">
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Description *</label>
                <textarea name="description" rows="4" required
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">{{ old('description', $property->description) }}</textarea>
                @error('description')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6 mb-4 sm:mb-6">
                @if(!$property->is_hotel)
                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-money-bill-wave text-green-600 mr-2"></i>Price per Night (₦) *
                    </label>
                    <input type="number" name="price_per_night" 
                        value="{{ old('price_per_night', $property->price_per_night) }}" 
                        min="0" step="0.01" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('price_per_night')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
                @endif

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-shield-alt text-yellow-600 mr-2"></i>Caution Fee (₦) *
                    </label>
                    <input type="number" name="caution_fee" 
                        value="{{ old('caution_fee', $property->caution_fee) }}" 
                        min="0" step="0.01" required
                        class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                    @error('caution_fee')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                        <i class="fas fa-toggle-on text-primary mr-2"></i>Status *
                    </label>
                    <select name="status" class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                        <option value="active" {{ $property->status === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ $property->status === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                    @error('status')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Hotel Room Types Management -->
        @if($property->is_hotel)
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <div class="flex justify-between items-center mb-4 sm:mb-6">
                <h2 class="text-lg sm:text-xl font-bold text-secondary flex items-center">
                    <i class="fas fa-door-open text-primary mr-2 sm:mr-3"></i> Room Types Management
                </h2>
                <a href="{{ route('vendor.properties.rooms.create', $property) }}" 
                    class="bg-primary text-white px-3 sm:px-4 py-2 rounded-lg hover:bg-primary-dark font-semibold text-xs sm:text-sm transition">
                    <i class="fas fa-plus mr-1"></i> Add Room Type
                </a>
            </div>

            <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 mb-4">
                <p class="text-xs sm:text-sm text-blue-800">
                    <i class="fas fa-info-circle mr-2"></i>
                    Manage your hotel room types below. Each room type can have different pricing and availability.
                </p>
            </div>

            @if($property->rooms->count() > 0)
                <div class="space-y-3 sm:space-y-4">
                    @foreach($property->rooms as $room)
                        <div class="bg-gray-50 border-2 border-gray-200 rounded-lg p-3 sm:p-4">
                            <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
                                <div class="flex-1">
                                    <h3 class="font-bold text-base sm:text-lg text-gray-800 mb-1">
                                        {{ $room->room_type }}
                                        <span class="text-xs px-2 py-1 rounded-full ml-2
                                            {{ $room->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                            {{ ucfirst($room->status) }}
                                        </span>
                                    </h3>
                                    @if($room->description)
                                        <p class="text-xs sm:text-sm text-gray-600 mb-2">{{ Str::limit($room->description, 100) }}</p>
                                    @endif
                                    <div class="grid grid-cols-2 sm:grid-cols-4 gap-2 text-xs sm:text-sm">
                                        <div>
                                            <span class="text-gray-600">Price:</span>
                                            <span class="font-bold text-primary">₦{{ number_format($room->price_per_night) }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-600">Units:</span>
                                            <span class="font-bold">{{ $room->total_units }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-600">Max Guests:</span>
                                            <span class="font-bold">{{ $room->max_guests }}</span>
                                        </div>
                                        <div>
                                            <span class="text-gray-600">Size:</span>
                                            <span class="font-bold">{{ $room->room_size_sqm ?? 'N/A' }} m²</span>
                                        </div>
                                    </div>
                                    @if($room->amenities && count($room->amenities) > 0)
                                        <div class="mt-2 flex flex-wrap gap-1">
                                            @foreach(array_slice($room->amenities, 0, 5) as $amenity)
                                                <span class="bg-white px-2 py-1 rounded text-xs text-gray-700">
                                                    {{ $amenity }}
                                                </span>
                                            @endforeach
                                            @if(count($room->amenities) > 5)
                                                <span class="bg-white px-2 py-1 rounded text-xs text-gray-700">
                                                    +{{ count($room->amenities) - 5 }} more
                                                </span>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                                <div class="flex sm:flex-col gap-2 w-full sm:w-auto">
                                    <a href="{{ route('vendor.properties.rooms.edit', [$property, $room]) }}" 
                                        class="flex-1 sm:flex-none bg-blue-600 text-white px-3 py-2 rounded-lg hover:bg-blue-700 font-semibold text-xs sm:text-sm text-center transition">
                                        <i class="fas fa-edit mr-1"></i> Edit
                                    </a>
                                    <form action="{{ route('vendor.properties.rooms.destroy', [$property, $room]) }}" 
                                          method="POST" onsubmit="return confirm('Delete this room type?')" 
                                          class="flex-1 sm:flex-none">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="w-full bg-red-600 text-white px-3 py-2 rounded-lg hover:bg-red-700 font-semibold text-xs sm:text-sm transition">
                                            <i class="fas fa-trash mr-1"></i> Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-6 sm:py-8 bg-gray-50 rounded-lg border-2 border-dashed border-gray-300">
                    <i class="fas fa-door-open text-4xl sm:text-5xl text-gray-300 mb-3"></i>
                    <p class="text-gray-600 text-sm sm:text-base mb-3">No room types added yet</p>
                    <a href="{{ route('vendor.properties.rooms.create', $property) }}" 
                        class="inline-block bg-primary text-white px-4 sm:px-6 py-2 rounded-lg hover:bg-primary-dark text-sm sm:text-base transition">
                        <i class="fas fa-plus mr-2"></i> Add Your First Room Type
                    </a>
                </div>
            @endif
        </div>
        @endif

        <!-- Current Photos -->
        @if($property->photos && count($property->photos) > 0)
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-images text-primary mr-2 sm:mr-3"></i> Current Photos
            </h2>
            <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3 sm:gap-4">
                @foreach($property->photos as $photo)
                <div class="relative group">
                    <img src="{{ Storage::url($photo) }}" 
                        alt="{{ $property->title }}" 
                        class="w-full h-32 sm:h-40 object-cover rounded-lg">
                    <label class="absolute top-2 right-2 bg-red-600 text-white rounded px-2 py-1 text-xs cursor-pointer hover:bg-red-700 transition opacity-0 group-hover:opacity-100">
                        <input type="checkbox" name="delete_photos[]" value="{{ $photo }}" class="mr-1">
                        Delete
                    </label>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        <!-- Add New Photos -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-camera text-primary mr-2 sm:mr-3"></i> Add New Photos
            </h2>
            <div class="mb-3">
                <input type="file" name="photos[]" multiple accept="image/*" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition"
                    onchange="previewNewImages(this)">
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>
                    You can select multiple images at once (Max 5MB each)
                </p>
            </div>
            <div id="newPhotoPreview" class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-3 sm:gap-4"></div>
        </div>

        <!-- Video Section -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-4 sm:mb-6 flex items-center">
                <i class="fas fa-video text-primary mr-2 sm:mr-3"></i> Property Video
            </h2>

            <!-- Current Video -->
            @if($property->video_url)
                <div class="mb-4 sm:mb-6">
                    <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">Current Video</label>
                    <div class="relative rounded-lg overflow-hidden bg-black" style="padding-top: 56.25%;">
                        <video controls class="absolute top-0 left-0 w-full h-full">
                            <source src="{{ Storage::url($property->video_url) }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                    <label class="flex items-center space-x-2 mt-3 cursor-pointer">
                        <input type="checkbox" name="delete_video" value="1" class="w-4 h-4 text-red-600 rounded">
                        <span class="text-sm text-red-600 font-semibold">
                            <i class="fas fa-trash mr-1"></i> Delete this video
                        </span>
                    </label>
                </div>
            @endif

            <!-- Upload New Video -->
            <div>
                <label class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                    {{ $property->video_url ? 'Replace Video' : 'Upload Video' }} (Optional)
                </label>
                <input type="file" name="video" accept="video/mp4,video/mov,video/avi,video/wmv" 
                    class="w-full border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition"
                    onchange="previewVideo(this)">
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>
                    Accepted formats: MP4, MOV, AVI, WMV. Max size: 50MB
                </p>
                @error('video')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            <div id="videoPreview" class="mt-4"></div>
        </div>

        <!-- Unavailable Dates -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
            <h2 class="text-lg sm:text-xl font-bold text-secondary mb-3 sm:mb-4 flex items-center">
                <i class="fas fa-calendar-times text-primary mr-2 sm:mr-3"></i> Availability Management
            </h2>
            <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 mb-4 sm:mb-6">
                <p class="text-xs sm:text-sm text-blue-800">
                    <i class="fas fa-info-circle mr-2"></i>
                    Mark dates when this property is unavailable for booking
                </p>
            </div>
            
            <div id="unavailable-dates" class="space-y-2 sm:space-y-3 mb-3 sm:mb-4">
                @if($property->unavailable_dates)
                    @foreach($property->unavailable_dates as $date)
                        <div class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                            <input type="date" name="unavailable_dates[]" value="{{ $date }}" 
                                class="flex-1 border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
                            <button type="button" onclick="this.parentElement.remove()" 
                                class="bg-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base transition">
                                <i class="fas fa-trash mr-2"></i> Remove
                            </button>
                        </div>
                    @endforeach
                @endif
            </div>

            <button type="button" onclick="addUnavailableDate()" 
                class="w-full sm:w-auto bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base transition">
                <i class="fas fa-plus mr-2"></i> Add Unavailable Date
            </button>
        </div>

        <!-- Action Buttons -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-md p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                <button type="submit" 
                    class="flex-1 bg-primary text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-primary-dark font-bold text-base sm:text-lg transition">
                    <i class="fas fa-save mr-2"></i> Update Property
                </button>
                <a href="{{ route('vendor.properties.show', $property) }}" 
                    class="flex-1 bg-gray-300 text-gray-700 px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-gray-400 font-bold text-base sm:text-lg text-center transition">
                    <i class="fas fa-times mr-2"></i> Cancel
                </a>
            </div>
        </div>
    </form>
</div>

@push('scripts')
<script>
function addUnavailableDate() {
    const container = document.getElementById('unavailable-dates');
    const div = document.createElement('div');
    div.className = 'flex flex-col sm:flex-row gap-2 sm:gap-3';
    div.innerHTML = `
        <input type="date" name="unavailable_dates[]" class="flex-1 border-2 border-gray-300 rounded-lg px-3 sm:px-4 py-2 sm:py-3 text-sm sm:text-base focus:border-primary focus:outline-none transition">
        <button type="button" onclick="this.parentElement.remove()" 
            class="bg-red-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-red-700 font-semibold text-sm sm:text-base transition">
            <i class="fas fa-trash mr-2"></i> Remove
        </button>
    `;
    container.appendChild(div);
}

function previewNewImages(input) {
    const container = document.getElementById('newPhotoPreview');
    container.innerHTML = '';
    
    if (input.files) {
        Array.from(input.files).forEach((file) => {
            const reader = new FileReader();
            reader.onload = function(e) {
                const div = document.createElement('div');
                div.className = 'relative';
                div.innerHTML = `
                    <img src="${e.target.result}" class="w-full h-32 sm:h-40 object-cover rounded-lg">
                    <div class="absolute top-2 right-2 bg-green-600 text-white rounded px-2 py-1 text-xs">
                        New
                    </div>
                `;
                container.appendChild(div);
            };
            reader.readAsDataURL(file);
        });
    }
}

function previewVideo(input) {
    const container = document.getElementById('videoPreview');
    container.innerHTML = '';
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const videoUrl = URL.createObjectURL(file);
        
        container.innerHTML = `
            <div class="relative rounded-lg overflow-hidden bg-black" style="padding-top: 56.25%;">
                <video controls class="absolute top-0 left-0 w-full h-full">
                    <source src="${videoUrl}" type="${file.type}">
                    Your browser does not support the video tag.
                </video>
            </div>
            <p class="text-xs sm:text-sm text-gray-600 mt-2">
                <i class="fas fa-file-video mr-1"></i>
                <strong>New video:</strong> ${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)
            </p>
        `;
    }
}
</script>
@endpush
@endsection