@extends('layouts.vendor')

@section('title', 'Add New Property')

@section('content')
<div class="max-w-4xl">
    <h1 class="text-3xl font-bold mb-6">Add New Property</h1>

    <form method="POST" action="{{ route('vendor.properties.store') }}" enctype="multipart/form-data">
        @csrf

        <!-- Basic Information -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h2 class="font-bold text-xl mb-4">Basic Information</h2>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Property Title *</label>
                <input type="text" name="title" value="{{ old('title') }}" required
                    class="w-full border rounded px-4 py-2 @error('title') border-red-500 @enderror">
                @error('title')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Description *</label>
                <textarea name="description" rows="5" required
                    class="w-full border rounded px-4 py-2 @error('description') border-red-500 @enderror">{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700 mb-2">House Type *</label>
                    <select name="house_type" required class="w-full border rounded px-4 py-2">
                        <option value="">Select Type</option>
                        <option value="Apartment" {{ old('house_type') === 'Apartment' ? 'selected' : '' }}>Apartment</option>
                        <option value="Villa" {{ old('house_type') === 'Villa' ? 'selected' : '' }}>Villa</option>
                        <option value="Bungalow" {{ old('house_type') === 'Bungalow' ? 'selected' : '' }}>Bungalow</option>
                        <option value="Duplex" {{ old('house_type') === 'Duplex' ? 'selected' : '' }}>Duplex</option>
                        <option value="Studio" {{ old('house_type') === 'Studio' ? 'selected' : '' }}>Studio</option>
                    </select>
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Price per Night (₦) *</label>
                    <input type="number" name="price_per_night" value="{{ old('price_per_night') }}" 
                        min="0" step="0.01" required
                        class="w-full border rounded px-4 py-2">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Caution Fee (₦) *</label>
                <input type="number" name="caution_fee" value="{{ old('caution_fee', 0) }}" 
                    min="0" step="0.01" required
                    class="w-full border rounded px-4 py-2">
                <p class="text-sm text-gray-600 mt-1">Refundable security deposit</p>
            </div>
        </div>

        <!-- Location -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h2 class="font-bold text-xl mb-4">Location</h2>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Address *</label>
                <input type="text" name="address" value="{{ old('address') }}" required
                    class="w-full border rounded px-4 py-2">
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700 mb-2">City *</label>
                    <input type="text" name="city" value="{{ old('city') }}" required
                        class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">State *</label>
                    <select name="state" required class="w-full border rounded px-4 py-2 @error('state') border-red-500 @enderror">
                        <option value="">Select State</option>
                        <option value="Abia" {{ old('state') === 'Abia' ? 'selected' : '' }}>Abia</option>
                        <option value="Adamawa" {{ old('state') === 'Adamawa' ? 'selected' : '' }}>Adamawa</option>
                        <option value="Akwa Ibom" {{ old('state') === 'Akwa Ibom' ? 'selected' : '' }}>Akwa Ibom</option>
                        <option value="Anambra" {{ old('state') === 'Anambra' ? 'selected' : '' }}>Anambra</option>
                        <option value="Bauchi" {{ old('state') === 'Bauchi' ? 'selected' : '' }}>Bauchi</option>
                        <option value="Bayelsa" {{ old('state') === 'Bayelsa' ? 'selected' : '' }}>Bayelsa</option>
                        <option value="Benue" {{ old('state') === 'Benue' ? 'selected' : '' }}>Benue</option>
                        <option value="Borno" {{ old('state') === 'Borno' ? 'selected' : '' }}>Borno</option>
                        <option value="Cross River" {{ old('state') === 'Cross River' ? 'selected' : '' }}>Cross River</option>
                        <option value="Delta" {{ old('state') === 'Delta' ? 'selected' : '' }}>Delta</option>
                        <option value="Ebonyi" {{ old('state') === 'Ebonyi' ? 'selected' : '' }}>Ebonyi</option>
                        <option value="Edo" {{ old('state') === 'Edo' ? 'selected' : '' }}>Edo</option>
                        <option value="Ekiti" {{ old('state') === 'Ekiti' ? 'selected' : '' }}>Ekiti</option>
                        <option value="Enugu" {{ old('state') === 'Enugu' ? 'selected' : '' }}>Enugu</option>
                        <option value="FCT" {{ old('state') === 'FCT' ? 'selected' : '' }}>FCT (Abuja)</option>
                        <option value="Gombe" {{ old('state') === 'Gombe' ? 'selected' : '' }}>Gombe</option>
                        <option value="Imo" {{ old('state') === 'Imo' ? 'selected' : '' }}>Imo</option>
                        <option value="Jigawa" {{ old('state') === 'Jigawa' ? 'selected' : '' }}>Jigawa</option>
                        <option value="Kaduna" {{ old('state') === 'Kaduna' ? 'selected' : '' }}>Kaduna</option>
                        <option value="Kano" {{ old('state') === 'Kano' ? 'selected' : '' }}>Kano</option>
                        <option value="Katsina" {{ old('state') === 'Katsina' ? 'selected' : '' }}>Katsina</option>
                        <option value="Kebbi" {{ old('state') === 'Kebbi' ? 'selected' : '' }}>Kebbi</option>
                        <option value="Kogi" {{ old('state') === 'Kogi' ? 'selected' : '' }}>Kogi</option>
                        <option value="Kwara" {{ old('state') === 'Kwara' ? 'selected' : '' }}>Kwara</option>
                        <option value="Lagos" {{ old('state') === 'Lagos' ? 'selected' : '' }}>Lagos</option>
                        <option value="Nasarawa" {{ old('state') === 'Nasarawa' ? 'selected' : '' }}>Nasarawa</option>
                        <option value="Niger" {{ old('state') === 'Niger' ? 'selected' : '' }}>Niger</option>
                        <option value="Ogun" {{ old('state') === 'Ogun' ? 'selected' : '' }}>Ogun</option>
                        <option value="Ondo" {{ old('state') === 'Ondo' ? 'selected' : '' }}>Ondo</option>
                        <option value="Osun" {{ old('state') === 'Osun' ? 'selected' : '' }}>Osun</option>
                        <option value="Oyo" {{ old('state') === 'Oyo' ? 'selected' : '' }}>Oyo</option>
                        <option value="Plateau" {{ old('state') === 'Plateau' ? 'selected' : '' }}>Plateau</option>
                        <option value="Rivers" {{ old('state') === 'Rivers' ? 'selected' : '' }}>Rivers</option>
                        <option value="Sokoto" {{ old('state') === 'Sokoto' ? 'selected' : '' }}>Sokoto</option>
                        <option value="Taraba" {{ old('state') === 'Taraba' ? 'selected' : '' }}>Taraba</option>
                        <option value="Yobe" {{ old('state') === 'Yobe' ? 'selected' : '' }}>Yobe</option>
                        <option value="Zamfara" {{ old('state') === 'Zamfara' ? 'selected' : '' }}>Zamfara</option>
                    </select>
                    @error('state')
                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Property Details -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h2 class="font-bold text-xl mb-4">Property Details</h2>

            <div class="grid md:grid-cols-4 gap-4 mb-4">
                <div>
                    <label class="block text-gray-700 mb-2">Bedrooms *</label>
                    <input type="number" name="bedrooms" value="{{ old('bedrooms', 1) }}" 
                        min="0" required class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Beds *</label>
                    <input type="number" name="beds" value="{{ old('beds', 1) }}" 
                        min="0" required class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Bathrooms *</label>
                    <input type="number" name="bathrooms" value="{{ old('bathrooms', 1) }}" 
                        min="0" required class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Max Guests *</label>
                    <input type="number" name="max_guests" value="{{ old('max_guests', 2) }}" 
                        min="1" required class="w-full border rounded px-4 py-2">
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Total Units Available *</label>
                <input type="number" name="total_units" value="{{ old('total_units', 1) }}" 
                    min="1" required class="w-full border rounded px-4 py-2">
                <p class="text-sm text-gray-600 mt-1">
                    <i class="fas fa-info-circle mr-1"></i>
                    How many identical units of this property do you have? (e.g., 5 identical apartments)
                </p>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 mb-2">Max Allowed Guests (for auto-approval) *</label>
                <input type="number" name="max_allowed_guests" value="{{ old('max_allowed_guests', 2) }}" 
                    min="1" required class="w-full border rounded px-4 py-2">
                <p class="text-sm text-gray-600 mt-1">Bookings exceeding this will require your approval</p>
            </div>

            <div class="mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="allow_parties" value="1" 
                        {{ old('allow_parties') ? 'checked' : '' }} class="mr-2">
                    <span>Allow parties/events</span>
                </label>
            </div>
        </div>

        <!-- Photos -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h2 class="font-bold text-xl mb-4">Photos</h2>
            <input type="file" name="photos[]" multiple accept="image/*" 
                class="w-full border rounded px-4 py-2">
            <p class="text-sm text-gray-600 mt-1">Upload multiple photos (max 5MB each)</p>
        </div>

        <!-- Check-in/out Times -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h2 class="font-bold text-xl mb-4">Check-in / Check-out</h2>

            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-gray-700 mb-2">Check-in From</label>
                    <input type="time" name="check_in_from" value="{{ old('check_in_from', '14:00') }}" 
                        class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Check-in Until</label>
                    <input type="time" name="check_in_until" value="{{ old('check_in_until', '22:00') }}" 
                        class="w-full border rounded px-4 py-2">
                </div>

                <div>
                    <label class="block text-gray-700 mb-2">Check-out Time</label>
                    <input type="time" name="check_out_time" value="{{ old('check_out_time', '11:00') }}" 
                        class="w-full border rounded px-4 py-2">
                </div>
            </div>
        </div>

        <div class="flex gap-4">
            <button type="submit" 
                class="bg-primary text-white px-6 py-3 rounded hover:bg-primary-dark font-semibold">
                Create Property
            </button>
            <a href="{{ route('vendor.properties.index') }}" 
                class="bg-gray-300 text-gray-700 px-6 py-3 rounded hover:bg-gray-400">
                Cancel
            </a>
        </div>
    </form>
</div>
@endsection
