@extends('layouts.vendor')

@section('title', 'My Cars')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-car mr-3"></i>My Cars
                    </h1>
                    <p class="text-primary-light">Manage your vehicle listings</p>
                </div>
                <div class="flex items-center space-x-4">
                    @if($vendor->isCarRentalKycApproved())
                        <a href="{{ route('vendor.cars.create') }}" 
                            class="bg-white text-primary px-6 py-3 rounded-lg hover:bg-primary/5 font-semibold shadow-lg transition transform hover:scale-105">
                            <i class="fas fa-plus mr-2"></i>Add New Car
                        </a>
                    @else
                        <div class="bg-yellow-500 text-white px-6 py-3 rounded-lg">
                            <i class="fas fa-exclamation-triangle mr-2"></i>KYC Pending
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- KYC Status Alert -->
    @if(!$vendor->isCarRentalKycApproved())
        <div class="bg-yellow-50 border-2 border-yellow-200 rounded-xl p-6 mb-6">
            <div class="flex items-start">
                <div class="bg-yellow-500 text-white rounded-full p-3 mr-4">
                    <i class="fas fa-exclamation-triangle text-2xl"></i>
                </div>
                <div class="flex-1">
                    <h3 class="text-xl font-bold text-yellow-800 mb-2">Car Rental KYC Verification Required</h3>
                    <p class="text-yellow-700 mb-4">
                        You need to complete your car rental KYC verification before you can add vehicles.
                    </p>
                    <a href="{{ route('vendor.kyc.show') }}" 
                        class="inline-block bg-yellow-600 text-white px-6 py-3 rounded-lg hover:bg-yellow-700 font-semibold">
                        <i class="fas fa-id-card mr-2"></i>Complete KYC Verification
                    </a>
                </div>
            </div>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-primary">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Total Cars</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $cars->total() }}</p>
                </div>
                <div class="bg-primary/10 p-4 rounded-lg">
                    <i class="fas fa-car text-primary text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-green-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Approved</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $cars->where('status', 'approved')->count() }}</p>
                </div>
                <div class="bg-green-100 p-4 rounded-lg">
                    <i class="fas fa-check-circle text-green-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-yellow-500">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Pending</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $cars->where('status', 'pending')->count() }}</p>
                </div>
                <div class="bg-yellow-100 p-4 rounded-lg">
                    <i class="fas fa-clock text-yellow-600 text-2xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6 border-l-4 border-primary">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-600 text-sm font-semibold">Available</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $cars->where('is_available', true)->count() }}</p>
                </div>
                <div class="bg-primary/10 p-4 rounded-lg">
                    <i class="fas fa-check text-primary text-2xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Cars List -->
    @if($cars->count() > 0)
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gradient-to-r from-green-600 to-teal-600 text-white">
                        <tr>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Vehicle</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Category</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Location</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Price/Day</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Status</th>
                            <th class="px-6 py-4 text-left text-sm font-semibold">Availability</th>
                            <th class="px-6 py-4 text-center text-sm font-semibold">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @foreach($cars as $car)
                        <tr class="hover:bg-gray-50 transition">
                            <td class="px-6 py-4">
                                <div class="flex items-center">
                                    @if($car->main_photo)
                                        <img src="{{ asset('storage/' . $car->main_photo) }}" 
                                            class="w-16 h-16 rounded-lg object-cover mr-4" 
                                            alt="{{ $car->full_name }}">
                                    @else
                                        <div class="w-16 h-16 bg-gray-200 rounded-lg flex items-center justify-center mr-4">
                                            <i class="fas fa-car text-gray-400 text-2xl"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <p class="font-bold text-gray-800">{{ $car->full_name }}</p>
                                        <p class="text-sm text-gray-600">{{ $car->plate_number }}</p>
                                        <p class="text-xs text-gray-500">
                                            <i class="fas fa-cog mr-1"></i>{{ ucfirst($car->transmission) }} • 
                                            <i class="fas fa-gas-pump mr-1"></i>{{ ucfirst($car->fuel_type) }}
                                        </p>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-gray-100 text-gray-800">
                                    <i class="fas {{ $car->category->icon }} mr-2"></i>
                                    {{ $car->category->name }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-sm text-gray-800">{{ $car->city }}</p>
                                <p class="text-xs text-gray-600">{{ $car->state }}</p>
                            </td>
                            <td class="px-6 py-4">
                                <p class="text-lg font-bold text-green-600">₦{{ number_format($car->price_per_day) }}</p>
                                @if($car->price_per_week)
                                    <p class="text-xs text-gray-600">Week: ₦{{ number_format($car->price_per_week) }}</p>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if($car->status === 'approved')
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-green-100 text-green-800">
                                        <i class="fas fa-check-circle mr-2"></i>Approved
                                    </span>
                                @elseif($car->status === 'pending')
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-yellow-100 text-yellow-800">
                                        <i class="fas fa-clock mr-2"></i>Pending
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-800">
                                        <i class="fas fa-times-circle mr-2"></i>Rejected
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if($car->is_available)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-teal-100 text-teal-800">
                                        <i class="fas fa-check mr-2"></i>Available
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-gray-100 text-gray-800">
                                        <i class="fas fa-ban mr-2"></i>Unavailable
                                    </span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center justify-center space-x-2">
                                    <a href="{{ route('vendor.cars.edit', $car) }}" 
                                        class="bg-blue-500 text-white px-3 py-2 rounded-lg hover:bg-blue-600 transition text-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('vendor.cars.destroy', $car) }}" method="POST" 
                                        onsubmit="return confirm('Are you sure you want to delete this car?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" 
                                            class="bg-red-500 text-white px-3 py-2 rounded-lg hover:bg-red-600 transition text-sm">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="px-6 py-4 bg-gray-50">
                {{ $cars->links() }}
            </div>
        </div>
    @else
        <div class="bg-white rounded-xl shadow-lg p-12 text-center">
            <div class="bg-gray-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-6">
                <i class="fas fa-car text-gray-400 text-4xl"></i>
            </div>
            <h3 class="text-2xl font-bold text-gray-800 mb-3">No Cars Yet</h3>
            <p class="text-gray-600 mb-6">Start adding vehicles to your car rental inventory</p>
            @if($vendor->isCarRentalKycApproved())
                <a href="{{ route('vendor.cars.create') }}" 
                    class="inline-block bg-gradient-to-r from-green-600 to-teal-600 text-white px-8 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold">
                    <i class="fas fa-plus mr-2"></i>Add Your First Car
                </a>
            @endif
        </div>
    @endif
</div>
@endsection
