<!-- Photos Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-images mr-3"></i>Photos
        </h2>
    </div>
    <div class="p-6">
        @if(isset($car) && $car->photos)
            <!-- Existing Photos -->
            <div class="mb-6">
                <label class="block text-sm font-semibold text-gray-700 mb-3">Current Photos</label>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-4" id="existing-photos">
                    @foreach($car->photos as $index => $photo)
                        <div class="relative group" data-photo-index="{{ $index }}">
                            <img src="{{ asset('storage/' . $photo) }}" 
                                class="w-full h-32 object-cover rounded-lg border-2 border-gray-200">
                            <button type="button" 
                                onclick="deletePhoto({{ $car->id }}, {{ $index }})"
                                class="absolute top-2 right-2 bg-red-500 text-white p-2 rounded-full opacity-0 group-hover:opacity-100 transition hover:bg-red-600">
                                <i class="fas fa-trash text-sm"></i>
                            </button>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Upload New Photos -->
        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">
                <i class="fas fa-upload text-primary mr-2"></i>
                @if(isset($car))
                    Add More Photos (Max 10 total)
                @else
                    Upload Photos * (1-10 images)
                @endif
            </label>
            <input type="file" name="photos[]" accept="image/*" multiple 
                {{ isset($car) ? '' : 'required' }}
                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('photos') border-red-500 @enderror"
                onchange="previewPhotos(this)">
            <p class="text-xs text-gray-500 mt-2">
                <i class="fas fa-info-circle mr-1"></i>
                JPG, JPEG, or PNG. Max 5MB per image. Upload up to 10 images.
            </p>
            @error('photos')
                <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
            @enderror
            @error('photos.*')
                <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
            @enderror
        </div>

        <!-- Photo Preview -->
        <div id="photo-preview" class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-4 hidden"></div>
    </div>
</div>

<script>
function previewPhotos(input) {
    const preview = document.getElementById('photo-preview');
    preview.innerHTML = '';
    
    if (input.files && input.files.length > 0) {
        preview.classList.remove('hidden');
        
        Array.from(input.files).forEach((file, index) => {
            const reader = new FileReader();
            reader.onload = function(e) {
                const div = document.createElement('div');
                div.className = 'relative';
                div.innerHTML = `
                    <img src="${e.target.result}" class="w-full h-32 object-cover rounded-lg border-2 border-primary/20">
                    <div class="absolute top-2 left-2 bg-primary text-white px-2 py-1 rounded text-xs">
                        ${index + 1}
                    </div>
                `;
                preview.appendChild(div);
            };
            reader.readAsDataURL(file);
        });
    } else {
        preview.classList.add('hidden');
    }
}

function deletePhoto(carId, photoIndex) {
    if (!confirm('Are you sure you want to delete this photo?')) {
        return;
    }
    
    fetch(`/vendor/cars/${carId}/photos/${photoIndex}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json',
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.querySelector(`[data-photo-index="${photoIndex}"]`).remove();
            
            // Show success message
            const alert = document.createElement('div');
            alert.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50';
            alert.innerHTML = '<i class="fas fa-check-circle mr-2"></i>Photo deleted successfully';
            document.body.appendChild(alert);
            
            setTimeout(() => alert.remove(), 3000);
        }
    })
    .catch(error => {
        alert('Error deleting photo. Please try again.');
    });
}
</script>
