<!-- Location Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-map-marker-alt mr-3"></i>Location
        </h2>
    </div>
    <div class="p-6">
        <div class="grid md:grid-cols-2 gap-6">
            <!-- State -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-map text-primary mr-2"></i>State *
                </label>
                <select name="state" id="state" required
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('state') border-red-500 @enderror">
                    <option value="">Select State</option>
                    <option value="Lagos" {{ old('state', $car->state ?? '') === 'Lagos' ? 'selected' : '' }}>Lagos</option>
                    <option value="Abuja" {{ old('state', $car->state ?? '') === 'Abuja' ? 'selected' : '' }}>Abuja (FCT)</option>
                    <option value="Rivers" {{ old('state', $car->state ?? '') === 'Rivers' ? 'selected' : '' }}>Rivers</option>
                    <option value="Oyo" {{ old('state', $car->state ?? '') === 'Oyo' ? 'selected' : '' }}>Oyo</option>
                    <option value="Kano" {{ old('state', $car->state ?? '') === 'Kano' ? 'selected' : '' }}>Kano</option>
                    <option value="Kaduna" {{ old('state', $car->state ?? '') === 'Kaduna' ? 'selected' : '' }}>Kaduna</option>
                    <option value="Ogun" {{ old('state', $car->state ?? '') === 'Ogun' ? 'selected' : '' }}>Ogun</option>
                    <option value="Enugu" {{ old('state', $car->state ?? '') === 'Enugu' ? 'selected' : '' }}>Enugu</option>
                    <option value="Delta" {{ old('state', $car->state ?? '') === 'Delta' ? 'selected' : '' }}>Delta</option>
                    <option value="Edo" {{ old('state', $car->state ?? '') === 'Edo' ? 'selected' : '' }}>Edo</option>
                    <option value="Anambra" {{ old('state', $car->state ?? '') === 'Anambra' ? 'selected' : '' }}>Anambra</option>
                    <option value="Akwa Ibom" {{ old('state', $car->state ?? '') === 'Akwa Ibom' ? 'selected' : '' }}>Akwa Ibom</option>
                    <option value="Cross River" {{ old('state', $car->state ?? '') === 'Cross River' ? 'selected' : '' }}>Cross River</option>
                    <option value="Imo" {{ old('state', $car->state ?? '') === 'Imo' ? 'selected' : '' }}>Imo</option>
                    <option value="Abia" {{ old('state', $car->state ?? '') === 'Abia' ? 'selected' : '' }}>Abia</option>
                    <option value="Ondo" {{ old('state', $car->state ?? '') === 'Ondo' ? 'selected' : '' }}>Ondo</option>
                    <option value="Osun" {{ old('state', $car->state ?? '') === 'Osun' ? 'selected' : '' }}>Osun</option>
                    <option value="Ekiti" {{ old('state', $car->state ?? '') === 'Ekiti' ? 'selected' : '' }}>Ekiti</option>
                    <option value="Kwara" {{ old('state', $car->state ?? '') === 'Kwara' ? 'selected' : '' }}>Kwara</option>
                    <option value="Plateau" {{ old('state', $car->state ?? '') === 'Plateau' ? 'selected' : '' }}>Plateau</option>
                    <option value="Benue" {{ old('state', $car->state ?? '') === 'Benue' ? 'selected' : '' }}>Benue</option>
                    <option value="Niger" {{ old('state', $car->state ?? '') === 'Niger' ? 'selected' : '' }}>Niger</option>
                    <option value="Kogi" {{ old('state', $car->state ?? '') === 'Kogi' ? 'selected' : '' }}>Kogi</option>
                    <option value="Bauchi" {{ old('state', $car->state ?? '') === 'Bauchi' ? 'selected' : '' }}>Bauchi</option>
                    <option value="Borno" {{ old('state', $car->state ?? '') === 'Borno' ? 'selected' : '' }}>Borno</option>
                    <option value="Adamawa" {{ old('state', $car->state ?? '') === 'Adamawa' ? 'selected' : '' }}>Adamawa</option>
                    <option value="Gombe" {{ old('state', $car->state ?? '') === 'Gombe' ? 'selected' : '' }}>Gombe</option>
                    <option value="Taraba" {{ old('state', $car->state ?? '') === 'Taraba' ? 'selected' : '' }}>Taraba</option>
                    <option value="Yobe" {{ old('state', $car->state ?? '') === 'Yobe' ? 'selected' : '' }}>Yobe</option>
                    <option value="Jigawa" {{ old('state', $car->state ?? '') === 'Jigawa' ? 'selected' : '' }}>Jigawa</option>
                    <option value="Katsina" {{ old('state', $car->state ?? '') === 'Katsina' ? 'selected' : '' }}>Katsina</option>
                    <option value="Sokoto" {{ old('state', $car->state ?? '') === 'Sokoto' ? 'selected' : '' }}>Sokoto</option>
                    <option value="Kebbi" {{ old('state', $car->state ?? '') === 'Kebbi' ? 'selected' : '' }}>Kebbi</option>
                    <option value="Zamfara" {{ old('state', $car->state ?? '') === 'Zamfara' ? 'selected' : '' }}>Zamfara</option>
                    <option value="Bayelsa" {{ old('state', $car->state ?? '') === 'Bayelsa' ? 'selected' : '' }}>Bayelsa</option>
                    <option value="Ebonyi" {{ old('state', $car->state ?? '') === 'Ebonyi' ? 'selected' : '' }}>Ebonyi</option>
                    <option value="Nasarawa" {{ old('state', $car->state ?? '') === 'Nasarawa' ? 'selected' : '' }}>Nasarawa</option>
                </select>
                @error('state')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- City -->
            <div>
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-city text-primary mr-2"></i>City *
                </label>
                <input type="text" name="city" id="city" value="{{ old('city', $car->city ?? '') }}" required
                    placeholder="Start typing city name..."
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('city') border-red-500 @enderror">
                <p class="text-xs text-gray-500 mt-1">
                    <i class="fas fa-info-circle mr-1"></i>Type to search cities in Nigeria
                </p>
                @error('city')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>

            <!-- Pickup Location -->
            <div class="md:col-span-2">
                <label class="block text-sm font-semibold text-gray-700 mb-2">
                    <i class="fas fa-location-arrow text-primary mr-2"></i>Pickup Location *
                </label>
                <textarea name="pickup_location" id="pickup_location" rows="3" required
                    placeholder="Enter detailed pickup address"
                    class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('pickup_location') border-red-500 @enderror">{{ old('pickup_location', $car->pickup_location ?? '') }}</textarea>
                <p class="text-xs text-gray-500 mt-1">
                    <i class="fas fa-info-circle mr-1"></i>Type to search for exact address with Google Maps
                </p>
                @error('pickup_location')
                    <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>
</div>

<script>
let cityAutocomplete, pickupAutocomplete;

function initAutocomplete() {
    // City autocomplete - restricted to cities in Nigeria
    const cityInput = document.getElementById('city');
    if (cityInput) {
        cityAutocomplete = new google.maps.places.Autocomplete(cityInput, {
            types: ['(cities)'],
            componentRestrictions: { country: 'ng' }
        });

        cityAutocomplete.addListener('place_changed', function() {
            const place = cityAutocomplete.getPlace();
            if (place.address_components) {
                // Extract city and state from the place
                for (let component of place.address_components) {
                    if (component.types.includes('locality')) {
                        cityInput.value = component.long_name;
                    }
                    if (component.types.includes('administrative_area_level_1')) {
                        const stateSelect = document.getElementById('state');
                        const stateName = component.long_name;
                        // Try to match and select the state
                        for (let option of stateSelect.options) {
                            if (option.value === stateName || option.text.includes(stateName)) {
                                stateSelect.value = option.value;
                                break;
                            }
                        }
                    }
                }
            }
        });
    }

    // Pickup location autocomplete - full address in Nigeria
    const pickupInput = document.getElementById('pickup_location');
    if (pickupInput) {
        pickupAutocomplete = new google.maps.places.Autocomplete(pickupInput, {
            types: ['address'],
            componentRestrictions: { country: 'ng' }
        });

        pickupAutocomplete.addListener('place_changed', function() {
            const place = pickupAutocomplete.getPlace();
            if (place.formatted_address) {
                pickupInput.value = place.formatted_address;
            }
        });
    }
}

// Initialize when Google Maps API is loaded
if (typeof google !== 'undefined' && google.maps && google.maps.places) {
    initAutocomplete();
} else {
    // Wait for Google Maps to load
    window.addEventListener('load', function() {
        if (typeof google !== 'undefined' && google.maps && google.maps.places) {
            initAutocomplete();
        }
    });
}
</script>
