<!-- Description & Policies Section -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-primary to-primary-dark text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-file-alt mr-3"></i>Description & Policies
        </h2>
    </div>
    <div class="p-6">
        <!-- Description -->
        <div class="mb-6">
            <label class="block text-sm font-semibold text-gray-700 mb-2">
                <i class="fas fa-align-left text-primary mr-2"></i>Car Description
            </label>
            <textarea name="description" rows="5"
                placeholder="Describe your car, its condition, special features, etc."
                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('description') border-red-500 @enderror">{{ old('description', $car->description ?? '') }}</textarea>
            @error('description')
                <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
            @enderror
        </div>

        <!-- Cancellation Policy -->
        <div class="mb-6">
            <label class="block text-sm font-semibold text-gray-700 mb-2">
                <i class="fas fa-ban text-primary mr-2"></i>Cancellation Policy
            </label>
            <textarea name="cancellation_policy" rows="4"
                placeholder="e.g., Free cancellation up to 24 hours before pickup. 50% refund for cancellations within 24 hours."
                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('cancellation_policy') border-red-500 @enderror">{{ old('cancellation_policy', $car->cancellation_policy ?? '') }}</textarea>
            @error('cancellation_policy')
                <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
            @enderror
        </div>

        <!-- Rental Terms -->
        <div>
            <label class="block text-sm font-semibold text-gray-700 mb-2">
                <i class="fas fa-file-contract text-primary mr-2"></i>Rental Terms & Conditions
            </label>
            <textarea name="rental_terms" rows="4"
                placeholder="e.g., No smoking, No pets, Driver must present valid license, etc."
                class="w-full border-2 border-gray-300 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition @error('rental_terms') border-red-500 @enderror">{{ old('rental_terms', $car->rental_terms ?? '') }}</textarea>
            @error('rental_terms')
                <p class="text-red-500 text-sm mt-1"><i class="fas fa-exclamation-circle mr-1"></i>{{ $message }}</p>
            @enderror
        </div>
    </div>
</div>

@if(isset($car))
<!-- Availability Toggle (Edit Only) -->
<div class="bg-white rounded-xl shadow-lg overflow-hidden mb-6">
    <div class="bg-gradient-to-r from-gray-600 to-gray-700 text-white px-6 py-4">
        <h2 class="text-xl font-bold flex items-center">
            <i class="fas fa-toggle-on mr-3"></i>Availability
        </h2>
    </div>
    <div class="p-6">
        <label class="flex items-center cursor-pointer p-4 bg-gray-50 rounded-lg hover:bg-gray-100 transition">
            <input type="checkbox" name="is_available" value="1" 
                {{ old('is_available', $car->is_available ?? true) ? 'checked' : '' }}
                class="w-6 h-6 text-green-600 border-gray-300 rounded focus:ring-green-500">
            <span class="ml-4">
                <span class="block text-sm font-semibold text-gray-800">
                    <i class="fas fa-check-circle text-green-600 mr-2"></i>Car is Available for Rent
                </span>
                <span class="block text-xs text-gray-600 mt-1">
                    Uncheck this to temporarily disable bookings for this car
                </span>
            </span>
        </label>
    </div>
</div>
@endif
