@extends('layouts.vendor')

@section('title', 'Advertisements')

@section('content')
<div class="px-3 sm:px-4 py-4 sm:py-6 md:py-8">
    <!-- Header -->
    <div class="mb-6 sm:mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-3 sm:gap-4">
                <div>
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                        <i class="fas fa-bullhorn mr-2 sm:mr-3"></i>Property Advertisements
                    </h1>
                    <p class="text-xs sm:text-sm opacity-90">Boost your property visibility with featured listings</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-4 sm:px-6 py-2 sm:py-3">
                    <p class="text-xs opacity-90">Active Ads</p>
                    <p class="text-2xl sm:text-3xl font-bold">{{ auth()->user()->vendor->ads()->where('active', true)->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    @if(!$hasActivePlans)
        <!-- Coming Soon Message -->
        <div class="bg-gradient-to-br from-blue-50 to-purple-50 rounded-lg sm:rounded-xl shadow-lg p-8 sm:p-12 md:p-16 mb-6 sm:mb-8 text-center border-2 border-dashed border-primary/30">
            <div class="bg-primary/10 rounded-full w-20 h-20 sm:w-24 sm:h-24 md:w-32 md:h-32 flex items-center justify-center mx-auto mb-4 sm:mb-6">
                <i class="fas fa-rocket text-4xl sm:text-5xl md:text-6xl text-primary"></i>
            </div>
            <h2 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-800 mb-3 sm:mb-4">Coming Soon!</h2>
            <p class="text-base sm:text-lg md:text-xl text-gray-600 mb-3 sm:mb-4">
                We're preparing exciting advertisement plans to help boost your property visibility.
            </p>
            <p class="text-sm sm:text-base text-gray-500 mb-6 sm:mb-8">
                Stay tuned! Our advertisement features will be available soon.
            </p>
            <a href="{{ route('vendor.dashboard') }}" 
                class="inline-flex items-center bg-primary text-white px-6 sm:px-8 py-3 sm:py-4 rounded-lg hover:bg-primary-dark font-bold text-sm sm:text-base transition transform hover:scale-105 shadow-lg">
                <i class="fas fa-arrow-left mr-2"></i> Back to Dashboard
            </a>
        </div>
    @else
        <!-- Placement Type Tabs -->
        <div class="mb-6 sm:mb-8">
            <div class="flex flex-wrap gap-2 sm:gap-3 mb-4 sm:mb-6">
                <button onclick="switchPlacementType('featured')" 
                    class="placement-tab flex-1 sm:flex-none px-4 sm:px-6 py-2 sm:py-3 rounded-lg font-bold text-sm sm:text-base transition active"
                    data-type="featured">
                    <i class="fas fa-star mr-2"></i>Featured Listings
                </button>
                <button onclick="switchPlacementType('weekend_deals')" 
                    class="placement-tab flex-1 sm:flex-none px-4 sm:px-6 py-2 sm:py-3 rounded-lg font-bold text-sm sm:text-base transition"
                    data-type="weekend_deals">
                    <i class="fas fa-calendar-week mr-2"></i>Weekend Deals
                </button>
                <button onclick="switchPlacementType('top_unique')" 
                    class="placement-tab flex-1 sm:flex-none px-4 sm:px-6 py-2 sm:py-3 rounded-lg font-bold text-sm sm:text-base transition"
                    data-type="top_unique">
                    <i class="fas fa-gem mr-2"></i>Top Unique Properties
                </button>
            </div>

            <!-- Featured Plans -->
            <div id="featured-plans" class="placement-section">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                        <i class="fas fa-star text-primary text-lg sm:text-xl md:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Featured Listing Plans</h2>
                        <p class="text-xs sm:text-sm text-gray-600">Stand out with premium placement on our homepage</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 sm:gap-6">
                    @foreach($activePlans->where('placement_type', 'featured') as $plan)
                        @include('vendor.ads.partials.plan-card', ['plan' => $plan])
                    @endforeach
                    @if($activePlans->where('placement_type', 'featured')->isEmpty())
                        <div class="col-span-full text-center py-8 text-gray-500">
                            <i class="fas fa-info-circle text-4xl mb-3"></i>
                            <p>No featured listing plans available at the moment.</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Weekend Deals Plans -->
            <div id="weekend_deals-plans" class="placement-section hidden">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-orange-100 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                        <i class="fas fa-calendar-week text-orange-600 text-lg sm:text-xl md:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Weekend Deals Plans</h2>
                        <p class="text-xs sm:text-sm text-gray-600">Special weekend promotions section</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 sm:gap-6">
                    @foreach($activePlans->where('placement_type', 'weekend_deals') as $plan)
                        @include('vendor.ads.partials.plan-card', ['plan' => $plan])
                    @endforeach
                    @if($activePlans->where('placement_type', 'weekend_deals')->isEmpty())
                        <div class="col-span-full text-center py-8 text-gray-500">
                            <i class="fas fa-info-circle text-4xl mb-3"></i>
                            <p>No weekend deals plans available at the moment.</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Top Unique Properties Plans -->
            <div id="top_unique-plans" class="placement-section hidden">
                <div class="flex items-center mb-4 sm:mb-6">
                    <div class="bg-purple-100 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                        <i class="fas fa-gem text-purple-600 text-lg sm:text-xl md:text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Top Unique Properties Plans</h2>
                        <p class="text-xs sm:text-sm text-gray-600">Showcase your unique property in our curated collection</p>
                    </div>
                </div>

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 sm:gap-6">
                    @foreach($activePlans->where('placement_type', 'top_unique') as $plan)
                        @include('vendor.ads.partials.plan-card', ['plan' => $plan])
                    @endforeach
                    @if($activePlans->where('placement_type', 'top_unique')->isEmpty())
                        <div class="col-span-full text-center py-8 text-gray-500">
                            <i class="fas fa-info-circle text-4xl mb-3"></i>
                            <p>No top unique properties plans available at the moment.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endif

    <!-- Active Ads -->
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
        <div class="flex items-center mb-4 sm:mb-6">
            <div class="bg-green-100 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4">
                <i class="fas fa-bullseye text-green-600 text-lg sm:text-xl md:text-2xl"></i>
            </div>
            <div>
                <h2 class="font-bold text-lg sm:text-xl md:text-2xl text-gray-800">Your Active Ads</h2>
                <p class="text-xs sm:text-sm text-gray-600">Currently running advertisements</p>
            </div>
        </div>
        
        <div class="space-y-3 sm:space-y-4">
            @forelse(auth()->user()->vendor->ads()->where('active', true)->get() as $ad)
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 rounded-lg p-3 sm:p-4 md:p-5 hover:shadow-md transition border-l-4 
                    {{ $ad->placement_type === 'featured' ? 'border-green-500' : ($ad->placement_type === 'weekend_deals' ? 'border-orange-500' : 'border-purple-500') }}">
                    <div class="flex flex-col sm:flex-row justify-between items-start gap-3">
                        <div class="flex-1 w-full">
                            <div class="flex items-center gap-2 sm:gap-3 mb-2">
                                <div class="bg-white p-2 rounded-lg flex-shrink-0">
                                    <i class="fas fa-home text-primary text-lg sm:text-xl"></i>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h3 class="font-bold text-base sm:text-lg md:text-xl text-gray-800 truncate">{{ $ad->property->title }}</h3>
                                    <div class="flex flex-wrap gap-2 text-xs sm:text-sm text-gray-600">
                                        <span>
                                            <i class="fas fa-tag text-primary mr-1"></i>
                                            <strong>Plan:</strong> {{ $ad->adPlan->name }}
                                        </span>
                                        <span class="px-2 py-0.5 rounded-full text-xs font-semibold
                                            {{ $ad->placement_type === 'featured' ? 'bg-green-100 text-green-700' : ($ad->placement_type === 'weekend_deals' ? 'bg-orange-100 text-orange-700' : 'bg-purple-100 text-purple-700') }}">
                                            <i class="fas {{ $ad->placement_type === 'featured' ? 'fa-star' : ($ad->placement_type === 'weekend_deals' ? 'fa-calendar-week' : 'fa-gem') }} mr-1"></i>
                                            {{ ucfirst(str_replace('_', ' ', $ad->placement_type)) }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="ml-0 sm:ml-10 md:ml-12">
                                <p class="text-xs sm:text-sm text-gray-600">
                                    <i class="fas fa-calendar-check text-green-600 mr-2"></i>
                                    <strong>Active until:</strong> {{ $ad->end_date->format('M d, Y') }}
                                </p>
                            </div>
                        </div>
                        <span class="px-3 sm:px-4 py-1.5 sm:py-2 bg-green-500 text-white rounded-full text-xs sm:text-sm font-bold shadow-md">
                            <i class="fas fa-check-circle mr-1"></i>Active
                        </span>
                    </div>
                </div>
            @empty
                <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-lg sm:rounded-xl p-8 sm:p-12 text-center border-2 border-dashed border-gray-300">
                    <div class="bg-gray-200 rounded-full w-16 h-16 sm:w-20 sm:h-20 flex items-center justify-center mx-auto mb-3 sm:mb-4">
                        <i class="fas fa-ad text-gray-400 text-3xl sm:text-4xl"></i>
                    </div>
                    <h3 class="text-lg sm:text-xl font-bold text-gray-700 mb-2">No Active Advertisements</h3>
                    <p class="text-gray-600 text-sm sm:text-base">Purchase a plan above to start advertising your properties</p>
                </div>
            @endforelse
        </div>
    </div>
</div>

<script>
function switchPlacementType(type) {
    // Update tabs
    document.querySelectorAll('.placement-tab').forEach(tab => {
        if (tab.dataset.type === type) {
            tab.classList.add('active', 'bg-primary', 'text-white');
            tab.classList.remove('bg-gray-200', 'text-gray-700');
        } else {
            tab.classList.remove('active', 'bg-primary', 'text-white');
            tab.classList.add('bg-gray-200', 'text-gray-700');
        }
    });
    
    // Update sections
    document.querySelectorAll('.placement-section').forEach(section => {
        section.classList.add('hidden');
    });
    document.getElementById(`${type}-plans`).classList.remove('hidden');
}

// Initialize first tab
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.placement-tab').forEach(tab => {
        if (tab.classList.contains('active')) {
            tab.classList.add('bg-primary', 'text-white');
        } else {
            tab.classList.add('bg-gray-200', 'text-gray-700');
        }
    });
});
</script>

<style>
.placement-tab {
    cursor: pointer;
}
</style>
@endsection