@extends('layouts.app')

@section('content')
<div class="container mx-auto px-4 py-4 md:py-8">
    <div class="max-w-6xl mx-auto">
        <!-- Header -->
        <div class="mb-6 md:mb-8">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div>
                    <h1 class="text-2xl md:text-3xl font-bold text-secondary mb-1 md:mb-2">My Transactions</h1>
                    <p class="text-sm md:text-base text-gray-600">View all your bookings and refunds</p>
                </div>
                <a href="{{ route('bookings.index') }}" class="bg-gray-600 text-white px-4 md:px-6 py-2 md:py-3 rounded-lg hover:bg-gray-700 transition font-semibold text-sm md:text-base text-center">
                    <i class="fas fa-arrow-left mr-2"></i>Back to My Bookings
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-md p-4 md:p-6 mb-4 md:mb-6">
            <form method="GET" action="{{ route('transactions.index') }}">
                <select name="type" class="w-full border-gray-300 rounded-lg text-sm md:text-base" onchange="this.form.submit()">
                    <option value="all" {{ $type === 'all' ? 'selected' : '' }}>All Transactions</option>
                    <option value="bookings" {{ $type === 'bookings' ? 'selected' : '' }}>Bookings Only</option>
                    <option value="refunds" {{ $type === 'refunds' ? 'selected' : '' }}>Refunds Only</option>
                </select>
            </form>
        </div>

        <!-- Transactions List -->
        @if($transactions->count() > 0)
            <div class="space-y-3 md:space-y-4">
                @foreach($transactions as $transaction)
                    <div class="bg-white rounded-xl shadow-md p-4 md:p-6 hover:shadow-lg transition">
                        <!-- Mobile Layout -->
                        <div class="flex flex-col gap-3">
                            <!-- Badges Row -->
                            <div class="flex flex-wrap items-center gap-2">
                                @if($transaction['type'] === 'booking')
                                    <span class="px-2 md:px-3 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-shopping-cart mr-1"></i>Booking
                                    </span>
                                @else
                                    <span class="px-2 md:px-3 py-1 bg-green-100 text-green-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-money-bill-wave mr-1"></i>Refund
                                    </span>
                                @endif
                                
                                @if($transaction['service'] === 'property')
                                    <span class="px-2 md:px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-home mr-1"></i>Property
                                    </span>
                                @else
                                    <span class="px-2 md:px-3 py-1 bg-orange-100 text-orange-800 rounded-full text-xs font-semibold">
                                        <i class="fas fa-car mr-1"></i>Car
                                    </span>
                                @endif

                                <span class="px-2 md:px-3 py-1 
                                    @if($transaction['status'] === 'paid') bg-green-100 text-green-800
                                    @elseif($transaction['status'] === 'requested') bg-blue-100 text-blue-800
                                    @elseif($transaction['status'] === 'processing') bg-yellow-100 text-yellow-800
                                    @else bg-gray-100 text-gray-800
                                    @endif rounded-full text-xs font-semibold">
                                    {{ ucfirst(str_replace('_', ' ', $transaction['status'])) }}
                                </span>
                            </div>

                            <!-- Title and Reference -->
                            <div>
                                <h3 class="font-bold text-base md:text-lg text-gray-800 mb-1">{{ $transaction['description'] }}</h3>
                                <p class="text-xs md:text-sm text-gray-600">Reference: #{{ $transaction['reference'] }}</p>
                            </div>

                            <!-- Details -->
                            @if($transaction['type'] === 'booking')
                                <div class="text-xs md:text-sm text-gray-600">
                                    @if(isset($transaction['details']['check_in']))
                                        <p class="flex items-start gap-2">
                                            <i class="fas fa-calendar mt-0.5 flex-shrink-0"></i>
                                            <span>{{ $transaction['details']['check_in']->format('M d, Y') }} - {{ $transaction['details']['check_out']->format('M d, Y') }} ({{ $transaction['details']['nights'] }} nights)</span>
                                        </p>
                                    @elseif(isset($transaction['details']['pickup_date']))
                                        <p class="flex items-start gap-2">
                                            <i class="fas fa-calendar mt-0.5 flex-shrink-0"></i>
                                            <span>{{ $transaction['details']['pickup_date']->format('M d, Y') }} - {{ $transaction['details']['return_date']->format('M d, Y') }} ({{ $transaction['details']['days'] }} days)</span>
                                        </p>
                                    @endif
                                </div>
                            @else
                                <div class="text-xs md:text-sm">
                                    @if(isset($transaction['details']['payout_status']))
                                        <span class="
                                            @if($transaction['details']['payout_status'] === 'paid') text-green-600
                                            @elseif($transaction['details']['payout_status'] === 'requested') text-blue-600
                                            @elseif($transaction['details']['payout_status'] === 'processing') text-yellow-600
                                            @else text-gray-600
                                            @endif font-semibold">
                                            <i class="fas fa-circle text-xs mr-1"></i>{{ ucfirst(str_replace('_', ' ', $transaction['details']['payout_status'])) }}
                                        </span>
                                    @endif
                                </div>
                            @endif

                            <!-- Amount and Date Row -->
                            <div class="flex items-center justify-between pt-2 border-t border-gray-100">
                                <div>
                                    <p class="font-bold text-xl md:text-2xl 
                                        @if($transaction['type'] === 'booking') text-red-600
                                        @else text-green-600
                                        @endif">
                                        @if($transaction['type'] === 'booking')-@else+@endif₦{{ number_format($transaction['amount']) }}
                                    </p>
                                    <p class="text-xs text-gray-500 mt-1">
                                        {{ $transaction['date'] ? $transaction['date']->format('M d, Y') : 'N/A' }}
                                    </p>
                                </div>
                                
                                @if($transaction['type'] === 'booking' && $transaction['status'] === 'paid' && $transaction['service'] === 'property')
                                    <a href="{{ route('bookings.receipt', $transaction['id']) }}" 
                                       target="_blank"
                                       class="px-3 md:px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition text-xs font-semibold whitespace-nowrap">
                                        <i class="fas fa-file-invoice mr-1"></i><span class="hidden sm:inline">View </span>Receipt
                                    </a>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="bg-white rounded-xl shadow-md p-8 md:p-12 text-center">
                <i class="fas fa-receipt text-4xl md:text-6xl text-gray-300 mb-3 md:mb-4"></i>
                <h3 class="text-lg md:text-xl font-bold text-gray-700 mb-2">No Transactions Found</h3>
                <p class="text-sm md:text-base text-gray-600">You don't have any transactions yet.</p>
            </div>
        @endif
    </div>
</div>
@endsection