@extends('layouts.app')

@section('title', $property->title)
@section('description', substr($property->description, 0, 160))

@section('content')
<div class="max-w-7xl mx-auto px-4 py-6">
    <!-- Back Button -->
    <div class="mb-4">
        <a href="{{ route('properties.index') }}" class="text-primary hover:text-primary-dark font-semibold">
            <i class="fas fa-arrow-left mr-2"></i> Back to Properties
        </a>
    </div>

    <!-- Hero Section with Photos -->
    <div class="mb-6">
        @if($property->photos && count($property->photos) > 0)
            <div class="grid grid-cols-4 gap-2 rounded-xl overflow-hidden">
                <!-- Main large photo -->
                <div class="col-span-4 md:col-span-2 md:row-span-2">
                    <img src="{{ asset('storage/' . $property->photos[0]) }}" 
                        alt="{{ $property->title }}"
                        class="w-full h-full object-cover cursor-pointer hover:opacity-90 transition"
                        onclick="openGallery(0)">
                </div>
                <!-- Smaller photos -->
                @foreach(array_slice($property->photos, 1, 4) as $index => $photo)
                    <div class="col-span-2 md:col-span-1">
                        <img src="{{ asset('storage/' . $photo) }}" 
                            alt="{{ $property->title }}"
                            class="w-full h-48 object-cover cursor-pointer hover:opacity-90 transition"
                            onclick="openGallery({{ $index + 1 }})">
                    </div>
                @endforeach
                
                @if(count($property->photos) > 5)
                    <button onclick="openGallery(0)" 
                        class="absolute bottom-4 right-4 bg-white px-4 py-2 rounded-lg shadow-lg hover:bg-gray-100 font-semibold">
                        <i class="fas fa-images mr-2"></i> Show all {{ count($property->photos) }} photos
                    </button>
                @endif
            </div>
        @endif
    </div>

    <div class="grid lg:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Title & Location -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-start justify-between mb-4">
                    <div class="flex-1">
                        @if($property->isFeatured())
                            <span class="inline-block bg-gradient-to-r from-yellow-400 to-orange-500 text-white px-3 py-1 rounded-full text-xs font-bold mb-2">
                                <i class="fas fa-star mr-1"></i> FEATURED
                            </span>
                        @endif
                        <h1 class="text-3xl font-bold text-secondary mb-2">{{ $property->title }}</h1>
                        <p class="text-gray-600 flex items-center">
                            <i class="fas fa-map-marker-alt text-primary mr-2"></i>
                            @auth
                                @php
                                    $userBooking = $property->bookings()
                                        ->where('user_id', auth()->id())
                                        ->where('payment_status', 'paid')
                                        ->where('admin_verified', true)
                                        ->first();
                                @endphp
                                @if($userBooking && $userBooking->map_visible)
                                    {{ $property->address }}, {{ $property->city }}, {{ $property->state }}
                                @else
                                    {{ $property->city }}, {{ $property->state }}
                                    <span class="text-sm text-gray-500 ml-2">(Full address after booking)</span>
                                @endif
                            @else
                                {{ $property->city }}, {{ $property->state }}
                                <span class="text-sm text-gray-500 ml-2">(Full address after booking)</span>
                            @endauth
                        </p>
                    </div>
                    
                    <!-- Favorite Button -->
                    @auth
                        <button onclick="toggleFavorite({{ $property->id }}, this)" 
                            class="ml-4 w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center hover:scale-110 transition">
                            <i class="fas fa-heart text-xl {{ auth()->user()->hasFavorited($property->id) ? 'text-red-500' : 'text-gray-400' }}"></i>
                        </button>
                    @else
                        <a href="{{ route('login') }}" 
                            class="ml-4 w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center hover:scale-110 transition">
                            <i class="fas fa-heart text-xl text-gray-400"></i>
                        </a>
                    @endauth
                </div>

                <!-- Badges -->
                <div class="flex flex-wrap gap-2">
                    @if($property->quality_standard)
                        <span class="bg-blue-100 text-blue-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-certificate mr-1"></i> Quality Standard
                        </span>
                    @endif
                    @if($property->verified)
                        <span class="bg-green-100 text-green-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-check-circle mr-1"></i> Verified
                        </span>
                    @endif
                    @if($property->quality_assured)
                        <span class="bg-purple-100 text-purple-800 px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-shield-alt mr-1"></i> Quality Assured
                        </span>
                    @endif
                    @if($property->allow_parties)
                        <span class="bg-primary/10 text-primary px-3 py-1 text-sm rounded-full font-semibold">
                            <i class="fas fa-glass-cheers mr-1"></i> Party Friendly
                        </span>
                    @endif
                </div>
            </div>

            <!-- Property Details Grid -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-info-circle text-primary mr-3"></i> Property Details
                </h2>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-home text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Type</p>
                        <p class="font-bold text-secondary">{{ $property->house_type }}</p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bed text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Bedrooms</p>
                        <p class="font-bold text-secondary">{{ $property->bedrooms }}</p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bed text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Beds</p>
                        <p class="font-bold text-secondary">{{ $property->beds }}</p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-bath text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Bathrooms</p>
                        <p class="font-bold text-secondary">{{ $property->bathrooms }}</p>
                    </div>
                    <div class="bg-primary/5 rounded-lg p-4 text-center">
                        <i class="fas fa-users text-primary text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Max Guests</p>
                        <p class="font-bold text-secondary">{{ $property->max_guests }}</p>
                    </div>
                    <div class="bg-green-50 rounded-lg p-4 text-center">
                        <i class="fas fa-money-bill-wave text-green-600 text-2xl mb-2"></i>
                        <p class="text-xs text-gray-600">Per Night</p>
                        <p class="font-bold text-green-600">₦{{ number_format($property->price_per_night) }}</p>
                    </div>
                </div>
            </div>
            

            <!-- Description -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-align-left text-primary mr-3"></i> About This Place
                </h2>
                <p class="text-gray-700 whitespace-pre-line leading-relaxed">{{ $property->description }}</p>
                
                @if($property->highlighted_features)
                    <div class="mt-6">
                        <h3 class="font-bold text-lg mb-3">Highlighted Features</h3>
                        <div class="grid md:grid-cols-2 gap-3">
                            @foreach($property->highlighted_features as $feature)
                                <div class="flex items-start bg-green-50 rounded-lg p-3">
                                    <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                    <span class="text-gray-700">{{ $feature }}</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            <!-- Amenities -->
            @if($property->amenities)
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                        <i class="fas fa-star text-primary mr-3"></i> Amenities
                    </h2>
                    <div class="grid md:grid-cols-2 gap-6">
                        @foreach($property->amenities as $category => $items)
                            <div>
                                <h3 class="font-semibold mb-3 flex items-center text-lg">
                                    @if($category === 'Essentials')
                                        <i class="fas fa-home text-primary mr-2"></i>
                                    @elseif($category === 'Kitchen & Dining')
                                        <i class="fas fa-utensils text-green-600 mr-2"></i>
                                    @elseif($category === 'Outdoor & Facilities')
                                        <i class="fas fa-tree text-primary mr-2"></i>
                                    @elseif($category === 'Safety & Other')
                                        <i class="fas fa-shield-alt text-red-600 mr-2"></i>
                                    @else
                                        <i class="fas fa-star text-yellow-600 mr-2"></i>
                                    @endif
                                    {{ $category }}
                                </h3>
                                <ul class="space-y-2">
                                    @foreach($items as $item)
                                        <li class="text-gray-700 flex items-center">
                                            @php
                                                $itemLower = strtolower($item);
                                                $iconClass = 'fas fa-check text-green-600';
                                                
                                                // Map specific amenities to icons
                                                if (str_contains($itemLower, 'wifi') || str_contains($itemLower, 'internet')) {
                                                    $iconClass = 'fas fa-wifi text-blue-600';
                                                } elseif (str_contains($itemLower, 'tv') || str_contains($itemLower, 'television')) {
                                                    $iconClass = 'fas fa-tv text-purple-600';
                                                } elseif (str_contains($itemLower, 'air conditioning') || str_contains($itemLower, 'ac')) {
                                                    $iconClass = 'fas fa-snowflake text-blue-400';
                                                } elseif (str_contains($itemLower, 'heating')) {
                                                    $iconClass = 'fas fa-fire text-orange-600';
                                                } elseif (str_contains($itemLower, 'kitchen')) {
                                                    $iconClass = 'fas fa-utensils text-green-600';
                                                } elseif (str_contains($itemLower, 'refrigerator') || str_contains($itemLower, 'fridge')) {
                                                    $iconClass = 'fas fa-temperature-low text-blue-500';
                                                } elseif (str_contains($itemLower, 'microwave')) {
                                                    $iconClass = 'fas fa-microwave text-gray-600';
                                                } elseif (str_contains($itemLower, 'coffee') || str_contains($itemLower, 'tea')) {
                                                    $iconClass = 'fas fa-mug-hot text-brown-600';
                                                } elseif (str_contains($itemLower, 'dishwasher')) {
                                                    $iconClass = 'fas fa-sink text-blue-600';
                                                } elseif (str_contains($itemLower, 'washing machine') || str_contains($itemLower, 'washer')) {
                                                    $iconClass = 'fas fa-tshirt text-indigo-600';
                                                } elseif (str_contains($itemLower, 'dryer')) {
                                                    $iconClass = 'fas fa-wind text-cyan-600';
                                                } elseif (str_contains($itemLower, 'iron')) {
                                                    $iconClass = 'fas fa-iron text-gray-700';
                                                } elseif (str_contains($itemLower, 'pool') || str_contains($itemLower, 'swimming')) {
                                                    $iconClass = 'fas fa-swimming-pool text-blue-500';
                                                } elseif (str_contains($itemLower, 'gym') || str_contains($itemLower, 'fitness')) {
                                                    $iconClass = 'fas fa-dumbbell text-red-600';
                                                } elseif (str_contains($itemLower, 'parking')) {
                                                    $iconClass = 'fas fa-parking text-blue-700';
                                                } elseif (str_contains($itemLower, 'elevator') || str_contains($itemLower, 'lift')) {
                                                    $iconClass = 'fas fa-elevator text-gray-600';
                                                } elseif (str_contains($itemLower, 'balcony') || str_contains($itemLower, 'terrace')) {
                                                    $iconClass = 'fas fa-building text-green-600';
                                                } elseif (str_contains($itemLower, 'garden') || str_contains($itemLower, 'yard')) {
                                                    $iconClass = 'fas fa-tree text-green-700';
                                                } elseif (str_contains($itemLower, 'bbq') || str_contains($itemLower, 'grill')) {
                                                    $iconClass = 'fas fa-fire-burner text-orange-600';
                                                } elseif (str_contains($itemLower, 'security') || str_contains($itemLower, 'alarm')) {
                                                    $iconClass = 'fas fa-shield-halved text-red-600';
                                                } elseif (str_contains($itemLower, 'smoke detector')) {
                                                    $iconClass = 'fas fa-bell text-red-500';
                                                } elseif (str_contains($itemLower, 'fire extinguisher')) {
                                                    $iconClass = 'fas fa-fire-extinguisher text-red-600';
                                                } elseif (str_contains($itemLower, 'first aid')) {
                                                    $iconClass = 'fas fa-kit-medical text-red-500';
                                                } elseif (str_contains($itemLower, 'lock') || str_contains($itemLower, 'safe')) {
                                                    $iconClass = 'fas fa-lock text-gray-700';
                                                } elseif (str_contains($itemLower, 'pet')) {
                                                    $iconClass = 'fas fa-paw text-brown-600';
                                                } elseif (str_contains($itemLower, 'wheelchair') || str_contains($itemLower, 'accessible')) {
                                                    $iconClass = 'fas fa-wheelchair text-blue-600';
                                                } elseif (str_contains($itemLower, 'crib') || str_contains($itemLower, 'baby')) {
                                                    $iconClass = 'fas fa-baby text-pink-500';
                                                } elseif (str_contains($itemLower, 'beach')) {
                                                    $iconClass = 'fas fa-umbrella-beach text-yellow-500';
                                                } elseif (str_contains($itemLower, 'generator')) {
                                                    $iconClass = 'fas fa-bolt text-yellow-600';
                                                } elseif (str_contains($itemLower, 'water') || str_contains($itemLower, 'borehole')) {
                                                    $iconClass = 'fas fa-droplet text-blue-500';
                                                } elseif (str_contains($itemLower, 'ps5') || str_contains($itemLower, 'playstation')) {
                                                    $iconClass = 'fab fa-playstation text-blue-600';
                                                } elseif (str_contains($itemLower, 'snooker') || str_contains($itemLower, 'pool') || str_contains($itemLower, 'billiards')) {
                                                    $iconClass = 'fas fa-bowling-ball text-green-600';
                                                }
                                            @endphp
                                            <i class="{{ $iconClass }} mr-2"></i>
                                            {{ $item }}
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- House Rules -->
            @if($property->house_rules)
                <div class="bg-white rounded-xl shadow-md p-6">
                    <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                        <i class="fas fa-list-check text-primary mr-3"></i> House Rules
                    </h2>
                    <ul class="space-y-3">
                        @foreach($property->house_rules as $rule)
                            <li class="flex items-start">
                                <i class="fas fa-circle text-primary text-xs mt-2 mr-3"></i>
                                <span class="text-gray-700">{{ $rule }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <!-- Reviews -->
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                    <i class="fas fa-star text-primary mr-3"></i> Reviews
                    @if($averageRating)
                        <span class="ml-2 text-yellow-500">★ {{ number_format($averageRating, 1) }}</span>
                        <span class="ml-2 text-sm text-gray-600">({{ $property->reviews()->visible()->count() }} reviews)</span>
                    @endif
                </h2>

                @forelse($property->reviews()->visible()->latest()->take(5)->get() as $review)
                    <div class="border-b pb-4 mb-4 last:border-b-0">
                        <div class="flex items-start mb-2">
                            @if($review->user->profile_photo)
                                <img src="{{ asset('storage/' . $review->user->profile_photo) }}" 
                                    alt="{{ $review->user->name }}"
                                    class="w-12 h-12 rounded-full object-cover">
                            @else
                                <div class="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-white font-bold text-lg">
                                    {{ substr($review->user->name, 0, 1) }}
                                </div>
                            @endif
                            <div class="ml-3 flex-1">
                                <div class="flex items-center justify-between">
                                    <div>
                                        <p class="font-semibold">{{ $review->user->name }}</p>
                                        <p class="text-sm text-gray-600">{{ $review->created_at->format('F Y') }}</p>
                                    </div>
                                    <div class="text-yellow-500 text-lg">
                                        {{ str_repeat('★', $review->rating) }}{{ str_repeat('☆', 5 - $review->rating) }}
                                    </div>
                                </div>
                                <p class="text-gray-700 mt-2">{{ $review->comment }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <div class="text-center py-8">
                        <i class="fas fa-comments text-gray-300 text-4xl mb-3"></i>
                        <p class="text-gray-600">No reviews yet. Be the first to review!</p>
                    </div>
                @endforelse

                @if($property->reviews()->visible()->count() > 5)
                    <div class="text-center mt-4">
                        <button class="text-primary hover:text-primary-dark font-semibold">
                            View all {{ $property->reviews()->visible()->count() }} reviews
                        </button>
                    </div>
                @endif
            </div>

            <!-- Location & Map (Unlocked after booking) -->
            @auth
                @php
                    $userBooking = $property->bookings()
                        ->where('user_id', auth()->id())
                        ->where('payment_status', 'paid')
                        ->where('admin_verified', true)
                        ->first();
                @endphp

                @if($userBooking && $userBooking->map_visible)
                    <div class="bg-white rounded-xl shadow-md p-6">
                        <h2 class="text-xl font-bold text-secondary mb-4 flex items-center">
                            <i class="fas fa-map-marker-alt text-primary mr-3"></i> Location
                        </h2>
                        
                        @if($property->location_lat && $property->location_lng)
                            <div id="map" class="w-full h-80 bg-gray-200 rounded-lg mb-4"></div>
                            <p class="text-sm text-gray-700 mb-4 flex items-center">
                                <i class="fas fa-location-dot text-primary mr-2"></i>
                                <strong>Address:</strong> <span class="ml-2">{{ $property->address }}, {{ $property->city }}, {{ $property->state }}</span>
                            </p>
                            
                            <a href="{{ route('properties.nearby-attractions', $property) }}" 
                                class="inline-flex items-center text-primary hover:text-primary-dark font-semibold">
                                <i class="fas fa-map mr-2"></i> View Nearby Attractions & Full Map
                            </a>

                            @push('scripts')
                            <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}"></script>
                            <script>
                                function initMap() {
                                    const location = { lat: {{ $property->location_lat }}, lng: {{ $property->location_lng }} };
                                    const map = new google.maps.Map(document.getElementById('map'), {
                                        zoom: 15,
                                        center: location,
                                        styles: [
                                            {
                                                featureType: "poi",
                                                elementType: "labels",
                                                stylers: [{ visibility: "on" }]
                                            }
                                        ]
                                    });
                                    new google.maps.Marker({ 
                                        position: location, 
                                        map: map,
                                        title: "{{ $property->title }}"
                                    });
                                }
                                initMap();
                            </script>
                            @endpush
                        @else
                            <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                                <p class="text-yellow-800 font-semibold mb-2">
                                    <i class="fas fa-map-marker-alt mr-2"></i>
                                    <strong>Address:</strong> {{ $property->address }}, {{ $property->city }}, {{ $property->state }}
                                </p>
                                <p class="text-sm text-gray-600">
                                    Map coordinates not available for this property.
                                </p>
                            </div>
                        @endif
                    </div>
                @endif
            @endauth
        </div>

        <!-- Booking Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-xl shadow-lg p-6 sticky top-4">
                <div class="text-center mb-6">
                    <div class="text-4xl font-bold text-primary mb-2">
                        ₦{{ number_format($property->price_per_night) }}
                    </div>
                    <p class="text-gray-600">per night</p>
                </div>

                @auth
                    <a href="{{ route('bookings.create', $property) }}" 
                        class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                        <i class="fas fa-calendar-check mr-2"></i> Book Now
                    </a>
                @else
                    <a href="{{ route('login') }}" 
                        class="block w-full bg-gradient-to-r from-primary to-primary-dark text-white text-center py-4 rounded-lg hover:shadow-xl font-bold text-lg transition transform hover:scale-105">
                        <i class="fas fa-sign-in-alt mr-2"></i> Login to Book
                    </a>
                @endauth

                <div class="mt-6 space-y-3">
                    <div class="flex justify-between items-center py-3 border-b">
                        <span class="text-gray-600">Caution Fee</span>
                        <span class="font-bold text-yellow-600">₦{{ number_format($property->caution_fee) }}</span>
                    </div>
                    <p class="text-xs text-gray-500">
                        <i class="fas fa-info-circle mr-1"></i>
                        Caution fee is fully refundable after stay
                    </p>
                </div>

                @if(!$property->allow_parties)
                    <div class="mt-4 bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                        <p class="text-sm text-yellow-800 font-semibold">
                            <i class="fas fa-ban mr-2"></i>
                            No parties or events allowed
                        </p>
                    </div>
                @endif

                <!-- Contact Host -->
                <div class="mt-6 pt-6 border-t">
                    <h3 class="font-bold text-secondary mb-3">Hosted by</h3>
                    <div class="flex items-center">
                        @if($property->vendor->user->profile_photo)
                            <img src="{{ asset('storage/' . $property->vendor->user->profile_photo) }}" 
                                alt="{{ $property->vendor->company_name }}"
                                class="w-12 h-12 rounded-full object-cover">
                        @else
                            <div class="w-12 h-12 bg-primary rounded-full flex items-center justify-center text-white font-bold text-lg">
                                {{ substr($property->vendor->company_name, 0, 1) }}
                            </div>
                        @endif
                        <div class="ml-3">
                            <p class="font-semibold">{{ $property->vendor->company_name }}</p>
                            <p class="text-sm text-gray-600">Property Host</p>
                        </div>
                    </div>
                </div>

                <!-- Share -->
                <div class="mt-6 pt-6 border-t">
                    <button onclick="shareProperty()" class="w-full border-2 border-gray-300 text-gray-700 py-3 rounded-lg hover:bg-gray-50 font-semibold transition">
                        <i class="fas fa-share-alt mr-2"></i> Share Property
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function toggleFavorite(propertyId, button) {
    fetch(`/favorites/toggle/${propertyId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const icon = button.querySelector('i');
            if (data.favorited) {
                icon.classList.remove('text-gray-400');
                icon.classList.add('text-red-500');
            } else {
                icon.classList.remove('text-red-500');
                icon.classList.add('text-gray-400');
            }
        }
    })
    .catch(error => console.error('Error:', error));
}

function openGallery(index) {
    // Implement photo gallery modal here
    console.log('Open gallery at index:', index);
}

function shareProperty() {
    const propertyTitle = "{{ $property->title }}";
    const propertyUrl = "{{ url()->current() }}";
    const propertyDescription = "{{ substr($property->description, 0, 100) }}...";
    
    // Check if Web Share API is supported
    if (navigator.share) {
        navigator.share({
            title: propertyTitle,
            text: propertyDescription,
            url: propertyUrl
        })
        .then(() => console.log('Shared successfully'))
        .catch((error) => console.log('Error sharing:', error));
    } else {
        // Fallback: Copy to clipboard
        const shareText = `${propertyTitle}\n${propertyDescription}\n${propertyUrl}`;
        
        if (navigator.clipboard) {
            navigator.clipboard.writeText(propertyUrl)
                .then(() => {
                    alert('Property link copied to clipboard! Share it with your friends.');
                })
                .catch(() => {
                    showShareModal(propertyUrl);
                });
        } else {
            showShareModal(propertyUrl);
        }
    }
}

function showShareModal(url) {
    // Create a temporary modal for sharing
    const modal = document.createElement('div');
    modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50';
    modal.innerHTML = `
        <div class="bg-white rounded-xl p-6 max-w-md mx-4">
            <h3 class="text-xl font-bold text-secondary mb-4">Share Property</h3>
            <p class="text-gray-600 mb-4">Share this property on:</p>
            <div class="space-y-3">
                <a href="https://wa.me/?text=${encodeURIComponent(url)}" target="_blank" 
                   class="block w-full bg-green-500 text-white py-3 rounded-lg hover:bg-green-600 text-center font-semibold">
                    <i class="fab fa-whatsapp mr-2"></i> WhatsApp
                </a>
                <a href="https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}" target="_blank"
                   class="block w-full bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 text-center font-semibold">
                    <i class="fab fa-facebook mr-2"></i> Facebook
                </a>
                <a href="https://twitter.com/intent/tweet?url=${encodeURIComponent(url)}&text={{ urlencode($property->title) }}" target="_blank"
                   class="block w-full bg-sky-500 text-white py-3 rounded-lg hover:bg-sky-600 text-center font-semibold">
                    <i class="fab fa-twitter mr-2"></i> Twitter
                </a>
                <button onclick="copyToClipboard('${url}')" 
                   class="block w-full bg-gray-600 text-white py-3 rounded-lg hover:bg-gray-700 text-center font-semibold">
                    <i class="fas fa-copy mr-2"></i> Copy Link
                </button>
            </div>
            <button onclick="this.closest('.fixed').remove()" 
                class="mt-4 w-full border-2 border-gray-300 text-gray-700 py-2 rounded-lg hover:bg-gray-50 font-semibold">
                Close
            </button>
        </div>
    `;
    document.body.appendChild(modal);
    
    // Close on background click
    modal.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.remove();
        }
    });
}

function copyToClipboard(text) {
    const textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();
    
    try {
        document.execCommand('copy');
        alert('Link copied to clipboard!');
    } catch (err) {
        alert('Failed to copy link');
    }
    
    document.body.removeChild(textarea);
}

// Track property view for guest activity
document.addEventListener('DOMContentLoaded', function() {
    fetch('/guest/track-property/{{ $property->id }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    }).catch(error => console.error('Error tracking property view:', error));
});
</script>
@endpush
@endsection
