@extends('layouts.app')

@section('title', $property->title . ' - ShortStayNG')

@section('content')
<div class="max-w-6xl mx-auto">
    <!-- Photos Gallery -->
    <div class="grid grid-cols-2 gap-2 mb-6">
        @if($property->photos && count($property->photos) > 0)
            @foreach(array_slice($property->photos, 0, 4) as $photo)
                <img src="{{ asset('storage/' . $photo) }}" alt="{{ $property->title }}" class="w-full h-64 object-cover rounded">
            @endforeach
        @else
            <img src="/images/placeholder.jpg" alt="{{ $property->title }}" class="w-full h-64 object-cover rounded">
        @endif
    </div>

    <div class="grid md:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="md:col-span-2">
            <div class="mb-6">
                @if($property->isFeatured())
                    <span class="bg-yellow-400 text-black px-3 py-1 text-sm font-bold rounded">⭐ FEATURED</span>
                @endif
                <h1 class="text-3xl font-bold mt-2">{{ $property->title }}</h1>
                <p class="text-gray-600">{{ $property->address }}, {{ $property->city }}, {{ $property->state }}</p>
            </div>

            <!-- Quality Badges -->
            <div class="flex gap-2 mb-6">
                @if($property->quality_standard)
                    <span class="bg-primary/10 text-blue-800 px-3 py-1 text-sm rounded">Quality Standard</span>
                @endif
                @if($property->verified)
                    <span class="bg-green-100 text-green-800 px-3 py-1 text-sm rounded">✓ Verified</span>
                @endif
                @if($property->quality_assured)
                    <span class="bg-primary/10 text-purple-800 px-3 py-1 text-sm rounded">Quality Assured</span>
                @endif
            </div>

            <!-- Price & House Type -->
            <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                <h2 class="font-bold text-xl mb-4">Price & Capacity</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-gray-600">House Type</p>
                        <p class="font-semibold">{{ $property->house_type }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Price per Night</p>
                        <p class="font-semibold text-2xl text-primary">₦{{ number_format($property->price_per_night) }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Bedrooms</p>
                        <p class="font-semibold">{{ $property->bedrooms }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Beds</p>
                        <p class="font-semibold">{{ $property->beds }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Bathrooms</p>
                        <p class="font-semibold">{{ $property->bathrooms }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Max Guests</p>
                        <p class="font-semibold">{{ $property->max_guests }}</p>
                    </div>
                </div>
            </div>

            <!-- Tabs Navigation -->
            <div class="bg-white rounded-lg shadow-md mb-6">
                <div class="border-b">
                    <nav class="flex overflow-x-auto">
                        <button onclick="switchTab('about')" id="tab-about" class="tab-button px-6 py-4 font-semibold border-b-2 border-primary text-primary">
                            About this place
                        </button>
                        <button onclick="switchTab('amenities')" id="tab-amenities" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary">
                            Amenities
                        </button>
                        <button onclick="switchTab('rules')" id="tab-rules" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary">
                            Things to Know
                        </button>
                        @auth
                            @php
                                $userBooking = $property->bookings()
                                    ->where('user_id', auth()->id())
                                    ->where('payment_status', 'paid')
                                    ->where('admin_verified', true)
                                    ->first();
                            @endphp
                            @if($userBooking && $userBooking->map_visible)
                                <button onclick="switchTab('location')" id="tab-location" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary">
                                    Location
                                </button>
                            @endif
                        @endauth
                        <button onclick="switchTab('reviews')" id="tab-reviews" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary">
                            Reviews @if($averageRating) <span class="text-yellow-500">★ {{ number_format($averageRating, 1) }}</span> @endif
                        </button>
                    </nav>
                </div>

                <!-- Tab Content -->
                <div class="p-6">
                    <!-- About Tab -->
                    <div id="content-about" class="tab-content">
                        <h2 class="font-bold text-xl mb-4">About this place</h2>
                        <p class="text-gray-700 whitespace-pre-line mb-6">{{ $property->description }}</p>

                        <!-- Highlighted Features -->
                        @if($property->highlighted_features)
                            <h3 class="font-bold text-lg mb-3 mt-6">Highlighted Features</h3>
                            <ul class="space-y-3">
                                @foreach($property->highlighted_features as $feature)
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                        <span>{{ $feature }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </div>

                    <!-- Amenities Tab -->
                    <div id="content-amenities" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">Amenities</h2>
                        @if($property->amenities)
                            <div class="grid grid-cols-2 gap-6">
                                @foreach($property->amenities as $category => $items)
                            <div>
                                <h3 class="font-semibold mb-2">{{ $category }}</h3>
                                <ul class="space-y-1">
                                    @foreach($items as $item)
                                        <li class="text-gray-700">• {{ $item }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    </div>
                        @else
                            <p class="text-gray-600">No amenities listed</p>
                        @endif
                    </div>

                    <!-- Things to Know Tab -->
                    <div id="content-rules" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">Things to Know</h2>
                        <div class="space-y-6">
                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-clock mr-2 text-primary"></i> Check-in / Check-out
                                </h3>
                                <p class="text-gray-700">Check-in: {{ date('H:i', strtotime($property->check_in_from)) }} - {{ date('H:i', strtotime($property->check_in_until)) }}</p>
                                <p class="text-gray-700">Check-out: {{ date('H:i', strtotime($property->check_out_time)) }}</p>
                            </div>
                            
                            @if($property->house_rules)
                                <div>
                                    <h3 class="font-semibold mb-2 flex items-center">
                                        <i class="fas fa-list-ul mr-2 text-primary"></i> House Rules
                                    </h3>
                                    <ul class="space-y-2">
                                        @foreach($property->house_rules as $rule)
                                            <li class="text-gray-700 flex items-start">
                                                <i class="fas fa-check text-green-600 mt-1 mr-2"></i>
                                                <span>{{ $rule }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-shield-alt mr-2 text-primary"></i> Caution Fee
                                </h3>
                                <p class="text-gray-700">₦{{ number_format($property->caution_fee) }} - Refundable after stay (subject to property condition)</p>
                            </div>

                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-users mr-2 text-primary"></i> Parties
                                </h3>
                                <p class="text-gray-700">
                                    @if($property->allow_parties)
                                        <span class="text-green-600">✓ Parties allowed</span>
                                    @else
                                        <span class="text-red-600">✗ No parties allowed</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Location Tab -->
                    @auth
                        @if($userBooking && $userBooking->map_visible)
                            <div id="content-location" class="tab-content hidden">
                                <h2 class="font-bold text-xl mb-4">Location</h2>
                                
                                @if($property->location_lat && $property->location_lng)
                        ->where('admin_verified', true)
                        ->first();
                @endphp

                @if($userBooking && $userBooking->map_visible)
                    <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                        <h2 class="font-bold text-xl mb-4">Location</h2>
                        
                        @if($property->location_lat && $property->location_lng)
                            <div id="map" class="w-full h-64 bg-gray-200 rounded mb-4"></div>
                            <p class="text-sm text-gray-600 mb-4">{{ $property->address }}, {{ $property->city }}</p>
                            
                            <a href="{{ route('properties.nearby-attractions', $property) }}" 
                                class="text-primary hover:underline">
                                View Nearby Attractions →
                            </a>

                            @push('scripts')
                            <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}"></script>
                            <script>
                                function initMap() {
                                    const location = { lat: {{ $property->location_lat }}, lng: {{ $property->location_lng }} };
                                    const map = new google.maps.Map(document.getElementById('map'), {
                                        zoom: 15,
                                        center: location
                                    });
                                    new google.maps.Marker({ position: location, map: map });
                                }
                                initMap();
                            </script>
                            @endpush
                        @else
                            <div class="bg-yellow-50 border border-yellow-200 rounded p-4">
                                <p class="text-yellow-800">
                                    <i class="fas fa-map-marker-alt mr-2"></i>
                                    <strong>Address:</strong> {{ $property->address }}, {{ $property->city }}, {{ $property->state }}
                                </p>
                                <p class="text-sm text-gray-600 mt-2">
                                    Map coordinates not available for this property.
                                </p>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="bg-gray-100 p-6 rounded-lg mb-6 text-center">
                        <i class="fas fa-lock text-gray-400 text-4xl mb-3"></i>
                        <p class="text-gray-600">Location details will be revealed after booking confirmation and admin verification</p>
                    </div>
                @endif
            @endauth

            <!-- Reviews -->
            <div class="bg-white p-6 rounded-lg shadow-md">
                <h2 class="font-bold text-xl mb-4">
                    Reviews 
                    @if($averageRating)
                        <span class="text-yellow-500">★ {{ number_format($averageRating, 1) }}</span>
                    @endif
                </h2>

                @forelse($property->reviews()->visible()->latest()->take(5)->get() as $review)
                    <div class="border-b pb-4 mb-4">
                        <div class="flex items-center mb-2">
                            <div class="w-10 h-10 bg-primary rounded-full flex items-center justify-center text-white font-bold">
                                {{ substr($review->user->name, 0, 1) }}
                            </div>
                            <div class="ml-3">
                                <p class="font-semibold">{{ $review->user->name }}</p>
                                <p class="text-sm text-gray-600">{{ $review->created_at->format('F Y') }}</p>
                            </div>
                        </div>
                        <div class="text-yellow-500 mb-2">
                            @for($i = 0; $i < $review->rating; $i++)★@endfor
                        </div>
                        <p class="text-gray-700">{{ $review->comment }}</p>
                    </div>
                @empty
                    <p class="text-gray-600">No reviews yet. Be the first to review!</p>
                @endforelse
            </div>
        </div>

        <!-- Booking Card -->
        <div class="md:col-span-1">
            <div class="bg-white p-6 rounded-lg shadow-lg sticky top-4">
                <div class="text-2xl font-bold text-primary mb-4">
                    ₦{{ number_format($property->price_per_night) }}
                    <span class="text-sm text-gray-600 font-normal">/night</span>
                </div>

                @auth
                    <a href="{{ route('bookings.create', $property) }}" 
                        class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold">
                        Book Now
                    </a>
                @else
                    <a href="{{ route('login') }}" 
                        class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold">
                        Login to Book
                    </a>
                @endauth

                <div class="mt-4 text-sm text-gray-600">
                    <p class="flex justify-between py-2 border-b">
                        <span>Caution Fee</span>
                        <span>₦{{ number_format($property->caution_fee) }}</span>
                    </p>
                    <p class="text-xs mt-2 text-gray-500">*Caution fee is refundable after stay</p>
                </div>

                @if(!$property->allow_parties)
                    <div class="mt-4 bg-yellow-50 border border-yellow-200 rounded p-3 text-sm">
                        <i class="fas fa-info-circle text-yellow-600"></i>
                        <span class="text-yellow-800 ml-2">No parties or events allowed</span>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
