@extends('layouts.app')

@section('title', $property->title . ' - ShortStayNG')

@section('content')
<div class="max-w-6xl mx-auto">
    <!-- Photos Gallery -->
    <div class="grid grid-cols-2 gap-2 mb-6">
        @if($property->photos && count($property->photos) > 0)
            @foreach(array_slice($property->photos, 0, 4) as $photo)
                <img src="{{ asset('storage/' . $photo) }}" alt="{{ $property->title }}" class="w-full h-64 object-cover rounded">
            @endforeach
        @else
            <img src="/images/placeholder.jpg" alt="{{ $property->title }}" class="w-full h-64 object-cover rounded">
        @endif
    </div>

    <div class="grid md:grid-cols-3 gap-8">
        <!-- Main Content -->
        <div class="md:col-span-2">
            <!-- Header -->
            <div class="mb-6">
                @if($property->isFeatured())
                    <span class="bg-yellow-400 text-black px-3 py-1 text-sm font-bold rounded">⭐ FEATURED</span>
                @endif
                <h1 class="text-3xl font-bold mt-2">{{ $property->title }}</h1>
                <p class="text-gray-600">
                    <i class="fas fa-map-marker-alt mr-1"></i>
                    @auth
                        @php
                            $userBooking = $property->bookings()
                                ->where('user_id', auth()->id())
                                ->where('payment_status', 'paid')
                                ->where('admin_verified', true)
                                ->first();
                        @endphp
                        @if($userBooking && $userBooking->map_visible)
                            {{ $property->address }}, {{ $property->city }}, {{ $property->state }}
                        @else
                            {{ $property->city }}, {{ $property->state }}
                            <span class="text-sm text-gray-500">(Full address shown after booking)</span>
                        @endif
                    @else
                        {{ $property->city }}, {{ $property->state }}
                        <span class="text-sm text-gray-500">(Full address shown after booking)</span>
                    @endauth
                </p>
            </div>

            <!-- Quality Badges -->
            <div class="flex gap-2 mb-6">
                @if($property->quality_standard)
                    <span class="bg-primary/10 text-blue-800 px-3 py-1 text-sm rounded">Quality Standard</span>
                @endif
                @if($property->verified)
                    <span class="bg-green-100 text-green-800 px-3 py-1 text-sm rounded">✓ Verified</span>
                @endif
                @if($property->quality_assured)
                    <span class="bg-primary/10 text-purple-800 px-3 py-1 text-sm rounded">Quality Assured</span>
                @endif
            </div>

            <!-- Price & Capacity -->
            <div class="bg-white p-6 rounded-lg shadow-md mb-6">
                <h2 class="font-bold text-xl mb-4">Price & Capacity</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-gray-600">House Type</p>
                        <p class="font-semibold">{{ $property->house_type }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Price per Night</p>
                        <p class="font-semibold text-2xl text-primary">₦{{ number_format($property->price_per_night) }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Bedrooms</p>
                        <p class="font-semibold">{{ $property->bedrooms }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Beds</p>
                        <p class="font-semibold">{{ $property->beds }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Bathrooms</p>
                        <p class="font-semibold">{{ $property->bathrooms }}</p>
                    </div>
                    <div>
                        <p class="text-gray-600">Max Guests</p>
                        <p class="font-semibold">{{ $property->max_guests }}</p>
                    </div>
                </div>
            </div>

            <!-- Tabbed Content -->
            <div class="bg-white rounded-lg shadow-md mb-6">
                <!-- Tab Navigation -->
                <div class="border-b">
                    <nav class="flex overflow-x-auto">
                        <button onclick="switchTab('about')" id="tab-about" class="tab-button px-6 py-4 font-semibold border-b-2 border-primary text-primary whitespace-nowrap">
                            About this place
                        </button>
                        <button onclick="switchTab('amenities')" id="tab-amenities" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary whitespace-nowrap">
                            Amenities
                        </button>
                        <button onclick="switchTab('availability')" id="tab-availability" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary whitespace-nowrap">
                            <i class="fas fa-calendar-alt mr-1"></i> Availability
                        </button>
                        <button onclick="switchTab('rules')" id="tab-rules" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary whitespace-nowrap">
                            Things to Know
                        </button>
                        @auth
                            @php
                                $userBooking = $property->bookings()
                                    ->where('user_id', auth()->id())
                                    ->where('payment_status', 'paid')
                                    ->where('admin_verified', true)
                                    ->first();
                            @endphp
                            @if($userBooking && $userBooking->map_visible)
                                <button onclick="switchTab('location')" id="tab-location" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary whitespace-nowrap">
                                    Location
                                </button>
                            @endif
                        @endauth
                        <button onclick="switchTab('reviews')" id="tab-reviews" class="tab-button px-6 py-4 font-semibold border-b-2 border-transparent text-gray-600 hover:text-secondary whitespace-nowrap">
                            Reviews @if($averageRating) <span class="text-yellow-500">★ {{ number_format($averageRating, 1) }}</span> @endif
                        </button>
                    </nav>
                </div>

                <!-- Tab Content -->
                <div class="p-6">
                    <!-- About Tab -->
                    <div id="content-about" class="tab-content">
                        <h2 class="font-bold text-xl mb-4">About this place</h2>
                        <p class="text-gray-700 whitespace-pre-line mb-6">{{ $property->description }}</p>

                        @if($property->highlighted_features)
                            <h3 class="font-bold text-lg mb-3 mt-6">Highlighted Features</h3>
                            <ul class="space-y-3">
                                @foreach($property->highlighted_features as $feature)
                                    <li class="flex items-start">
                                        <i class="fas fa-check-circle text-green-600 mt-1 mr-3"></i>
                                        <span>{{ $feature }}</span>
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </div>

                    <!-- Amenities Tab -->
                    <div id="content-amenities" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">Amenities</h2>
                        @if($property->amenities)
                            <div class="grid md:grid-cols-2 gap-6">
                                @foreach($property->amenities as $category => $items)
                                    <div class="bg-light-bg rounded-lg p-4">
                                        <h3 class="font-semibold mb-3 flex items-center text-lg">
                                            @if($category === 'Essentials')
                                                <i class="fas fa-home text-primary mr-2"></i>
                                            @elseif($category === 'Kitchen & Dining')
                                                <i class="fas fa-utensils text-green-600 mr-2"></i>
                                            @elseif($category === 'Outdoor & Facilities')
                                                <i class="fas fa-tree text-primary mr-2"></i>
                                            @elseif($category === 'Safety & Other')
                                                <i class="fas fa-shield-alt text-red-600 mr-2"></i>
                                            @else
                                                <i class="fas fa-star text-yellow-600 mr-2"></i>
                                            @endif
                                            {{ $category }}
                                        </h3>
                                        <ul class="space-y-2">
                                            @foreach($items as $item)
                                                <li class="text-gray-700 flex items-start">
                                                    @php
                                                        $iconClass = 'fas fa-check text-green-600';
                                                        $itemLower = strtolower($item);
                                                        
                                                        // Map specific amenities to icons
                                                        if (str_contains($itemLower, 'wifi') || str_contains($itemLower, 'internet')) {
                                                            $iconClass = 'fas fa-wifi text-primary';
                                                        } elseif (str_contains($itemLower, 'tv') || str_contains($itemLower, 'television')) {
                                                            $iconClass = 'fas fa-tv text-primary';
                                                        } elseif (str_contains($itemLower, 'air conditioning') || str_contains($itemLower, 'ac')) {
                                                            $iconClass = 'fas fa-snowflake text-primary-light';
                                                        } elseif (str_contains($itemLower, 'heating')) {
                                                            $iconClass = 'fas fa-fire text-orange-600';
                                                        } elseif (str_contains($itemLower, 'kitchen')) {
                                                            $iconClass = 'fas fa-utensils text-green-600';
                                                        } elseif (str_contains($itemLower, 'refrigerator') || str_contains($itemLower, 'fridge')) {
                                                            $iconClass = 'fas fa-temperature-low text-primary';
                                                        } elseif (str_contains($itemLower, 'microwave')) {
                                                            $iconClass = 'fas fa-microwave text-gray-600';
                                                        } elseif (str_contains($itemLower, 'coffee') || str_contains($itemLower, 'tea')) {
                                                            $iconClass = 'fas fa-coffee text-brown-600';
                                                        } elseif (str_contains($itemLower, 'dishwasher')) {
                                                            $iconClass = 'fas fa-sink text-primary';
                                                        } elseif (str_contains($itemLower, 'washing machine') || str_contains($itemLower, 'washer')) {
                                                            $iconClass = 'fas fa-tshirt text-indigo-600';
                                                        } elseif (str_contains($itemLower, 'dryer')) {
                                                            $iconClass = 'fas fa-wind text-cyan-600';
                                                        } elseif (str_contains($itemLower, 'pool') || str_contains($itemLower, 'swimming')) {
                                                            $iconClass = 'fas fa-swimming-pool text-primary';
                                                        } elseif (str_contains($itemLower, 'gym') || str_contains($itemLower, 'fitness')) {
                                                            $iconClass = 'fas fa-dumbbell text-red-600';
                                                        } elseif (str_contains($itemLower, 'parking')) {
                                                            $iconClass = 'fas fa-parking text-gray-700';
                                                        } elseif (str_contains($itemLower, 'elevator') || str_contains($itemLower, 'lift')) {
                                                            $iconClass = 'fas fa-elevator text-gray-600';
                                                        } elseif (str_contains($itemLower, 'balcony') || str_contains($itemLower, 'terrace')) {
                                                            $iconClass = 'fas fa-door-open text-green-600';
                                                        } elseif (str_contains($itemLower, 'garden')) {
                                                            $iconClass = 'fas fa-leaf text-green-700';
                                                        } elseif (str_contains($itemLower, 'security') || str_contains($itemLower, 'guard')) {
                                                            $iconClass = 'fas fa-user-shield text-red-600';
                                                        } elseif (str_contains($itemLower, 'smoke detector') || str_contains($itemLower, 'alarm')) {
                                                            $iconClass = 'fas fa-bell text-red-600';
                                                        } elseif (str_contains($itemLower, 'fire extinguisher')) {
                                                            $iconClass = 'fas fa-fire-extinguisher text-red-700';
                                                        } elseif (str_contains($itemLower, 'first aid')) {
                                                            $iconClass = 'fas fa-first-aid text-red-500';
                                                        } elseif (str_contains($itemLower, 'cctv') || str_contains($itemLower, 'camera')) {
                                                            $iconClass = 'fas fa-video text-gray-700';
                                                        } elseif (str_contains($itemLower, 'generator') || str_contains($itemLower, 'backup power')) {
                                                            $iconClass = 'fas fa-bolt text-yellow-600';
                                                        } elseif (str_contains($itemLower, 'workspace') || str_contains($itemLower, 'desk')) {
                                                            $iconClass = 'fas fa-laptop text-primary';
                                                        } elseif (str_contains($itemLower, 'iron')) {
                                                            $iconClass = 'fas fa-tshirt text-gray-600';
                                                        } elseif (str_contains($itemLower, 'hair dryer')) {
                                                            $iconClass = 'fas fa-wind text-pink-600';
                                                        } elseif (str_contains($itemLower, 'towel') || str_contains($itemLower, 'linen')) {
                                                            $iconClass = 'fas fa-bath text-primary-light';
                                                        } elseif (str_contains($itemLower, 'shampoo') || str_contains($itemLower, 'toiletries')) {
                                                            $iconClass = 'fas fa-pump-soap text-primary';
                                                        } elseif (str_contains($itemLower, 'pet')) {
                                                            $iconClass = 'fas fa-paw text-brown-600';
                                                        } elseif (str_contains($itemLower, 'bbq') || str_contains($itemLower, 'grill')) {
                                                            $iconClass = 'fas fa-fire text-orange-600';
                                                        }
                                                    @endphp
                                                    <i class="{{ $iconClass }} mt-1 mr-3 w-4"></i>
                                                    <span>{{ $item }}</span>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <p class="text-gray-600">No amenities listed</p>
                        @endif
                    </div>

                    <!-- Availability Calendar Tab -->
                    <div id="content-availability" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">
                            <i class="fas fa-calendar-alt mr-2 text-primary"></i> Availability Calendar
                        </h2>
                        <p class="text-gray-600 mb-6">Red dates are already booked. Select available dates for your stay.</p>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <!-- Current Month Calendar -->
                            <div class="bg-light-bg rounded-lg p-4">
                                <div class="flex justify-between items-center mb-4">
                                    <button onclick="previousMonth()" class="p-2 hover:bg-gray-200 rounded">
                                        <i class="fas fa-chevron-left"></i>
                                    </button>
                                    <h3 class="font-bold text-lg" id="current-month"></h3>
                                    <button onclick="nextMonth()" class="p-2 hover:bg-gray-200 rounded">
                                        <i class="fas fa-chevron-right"></i>
                                    </button>
                                </div>
                                <div id="calendar-current"></div>
                            </div>

                            <!-- Next Month Calendar -->
                            <div class="bg-light-bg rounded-lg p-4">
                                <div class="flex justify-between items-center mb-4">
                                    <h3 class="font-bold text-lg" id="next-month"></h3>
                                </div>
                                <div id="calendar-next"></div>
                            </div>
                        </div>

                        <!-- Legend -->
                        <div class="mt-6 flex gap-6 justify-center">
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-white border-2 border-gray-300 rounded mr-2"></div>
                                <span class="text-sm text-gray-600">Available</span>
                            </div>
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-red-100 border-2 border-red-300 rounded mr-2"></div>
                                <span class="text-sm text-gray-600">Booked</span>
                            </div>
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-gray-200 border-2 border-gray-300 rounded mr-2"></div>
                                <span class="text-sm text-gray-600">Past Date</span>
                            </div>
                        </div>

                        @auth
                            <div class="mt-6 text-center">
                                <a href="{{ route('bookings.create', $property) }}" 
                                    class="inline-block bg-primary text-white px-8 py-3 rounded-lg hover:bg-primary-dark font-semibold">
                                    <i class="fas fa-calendar-check mr-2"></i> Book Now
                                </a>
                            </div>
                        @endauth
                    </div>

                    <!-- Things to Know Tab -->
                    <div id="content-rules" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">Things to Know</h2>
                        <div class="space-y-6">
                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-clock mr-2 text-primary"></i> Check-in / Check-out
                                </h3>
                                <p class="text-gray-700">Check-in: {{ date('H:i', strtotime($property->check_in_from)) }} - {{ date('H:i', strtotime($property->check_in_until)) }}</p>
                                <p class="text-gray-700">Check-out: {{ date('H:i', strtotime($property->check_out_time)) }}</p>
                            </div>
                            
                            @if($property->house_rules)
                                <div>
                                    <h3 class="font-semibold mb-2 flex items-center">
                                        <i class="fas fa-list-ul mr-2 text-primary"></i> House Rules
                                    </h3>
                                    <ul class="space-y-2">
                                        @foreach($property->house_rules as $rule)
                                            <li class="text-gray-700 flex items-start">
                                                <i class="fas fa-check text-green-600 mt-1 mr-2"></i>
                                                <span>{{ $rule }}</span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-shield-alt mr-2 text-primary"></i> Caution Fee
                                </h3>
                                <p class="text-gray-700">₦{{ number_format($property->caution_fee) }} - Refundable after stay (subject to property condition)</p>
                            </div>

                            <div>
                                <h3 class="font-semibold mb-2 flex items-center">
                                    <i class="fas fa-users mr-2 text-primary"></i> Parties
                                </h3>
                                <p class="text-gray-700">
                                    @if($property->allow_parties)
                                        <span class="text-green-600">✓ Parties allowed</span>
                                    @else
                                        <span class="text-red-600">✗ No parties allowed</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Location Tab -->
                    @auth
                        @php
                            $userBooking = $property->bookings()
                                ->where('user_id', auth()->id())
                                ->where('payment_status', 'paid')
                                ->where('admin_verified', true)
                                ->first();
                        @endphp
                        @if($userBooking && $userBooking->map_visible)
                            <div id="content-location" class="tab-content hidden">
                                <h2 class="font-bold text-xl mb-4">Location</h2>
                                
                                @if($property->location_lat && $property->location_lng)
                                    <div id="map" class="w-full h-96 bg-gray-200 rounded mb-4"></div>
                                    <p class="text-sm text-gray-600 mb-4">{{ $property->address }}, {{ $property->city }}</p>
                                    
                                    <a href="{{ route('properties.nearby-attractions', $property) }}" 
                                        class="inline-block bg-primary text-white px-4 py-2 rounded hover:bg-primary-dark">
                                        <i class="fas fa-map-marked-alt mr-2"></i> View Nearby Attractions
                                    </a>

                                    @push('scripts')
                                    <script src="https://maps.googleapis.com/maps/api/js?key={{ config('services.google.maps_api_key') }}"></script>
                                    <script>
                                        function initMap() {
                                            const location = { lat: {{ $property->location_lat }}, lng: {{ $property->location_lng }} };
                                            const map = new google.maps.Map(document.getElementById('map'), {
                                                zoom: 15,
                                                center: location
                                            });
                                            new google.maps.Marker({ position: location, map: map });
                                        }
                                        window.addEventListener('load', initMap);
                                    </script>
                                    @endpush
                                @else
                                    <div class="bg-yellow-50 border border-yellow-200 rounded p-4">
                                        <p class="text-yellow-800">
                                            <i class="fas fa-map-marker-alt mr-2"></i>
                                            <strong>Address:</strong> {{ $property->address }}, {{ $property->city }}, {{ $property->state }}
                                        </p>
                                        <p class="text-sm text-gray-600 mt-2">
                                            Map coordinates not available for this property.
                                        </p>
                                    </div>
                                @endif
                            </div>
                        @endif
                    @endauth

                    <!-- Reviews Tab -->
                    <div id="content-reviews" class="tab-content hidden">
                        <h2 class="font-bold text-xl mb-4">
                            Reviews 
                            @if($averageRating)
                                <span class="text-yellow-500">★ {{ number_format($averageRating, 1) }}</span>
                            @endif
                        </h2>

                        @forelse($property->reviews()->visible()->latest()->take(5)->get() as $review)
                            <div class="border-b pb-4 mb-4 last:border-b-0">
                                <div class="flex items-center mb-2">
                                    <div class="w-10 h-10 bg-primary rounded-full flex items-center justify-center text-white font-bold">
                                        {{ substr($review->user->name, 0, 1) }}
                                    </div>
                                    <div class="ml-3">
                                        <p class="font-semibold">{{ $review->user->name }}</p>
                                        <p class="text-sm text-gray-600">{{ $review->created_at->format('F Y') }}</p>
                                    </div>
                                    <div class="ml-auto">
                                        <span class="text-yellow-500">{{ str_repeat('★', $review->rating) }}</span>
                                    </div>
                                </div>
                                <p class="text-gray-700">{{ $review->comment }}</p>
                            </div>
                        @empty
                            <p class="text-gray-600 text-center py-8">No reviews yet. Be the first to review!</p>
                        @endforelse

                        @if($property->reviews()->visible()->count() > 5)
                            <div class="text-center mt-4">
                                <a href="#" class="text-primary hover:underline">View all {{ $property->reviews()->visible()->count() }} reviews</a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Booking Sidebar -->
        <div class="md:col-span-1">
            <div class="bg-white p-6 rounded-lg shadow-md sticky top-4">
                <div class="text-2xl font-bold text-primary mb-4">
                    ₦{{ number_format($property->price_per_night) }}
                    <span class="text-sm text-gray-600 font-normal">/night</span>
                </div>

                @auth
                    <a href="{{ route('bookings.create', $property) }}" 
                        class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold">
                        Book Now
                    </a>
                @else
                    <a href="{{ route('login') }}" 
                        class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold">
                        Login to Book
                    </a>
                @endauth

                <div class="mt-4 text-sm text-gray-600">
                    <p class="flex justify-between py-2 border-b">
                        <span>Caution Fee</span>
                        <span>₦{{ number_format($property->caution_fee) }}</span>
                    </p>
                    <p class="text-xs mt-2 text-gray-500">*Caution fee is refundable after stay</p>
                </div>

                @if(!$property->allow_parties)
                    <div class="mt-4 bg-yellow-50 border border-yellow-200 rounded p-3 text-sm">
                        <i class="fas fa-info-circle text-yellow-600"></i>
                        <span class="text-yellow-800 ml-2">No parties or events allowed</span>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
function switchTab(tabName) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });
    
    // Remove active state from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('border-primary', 'text-primary');
        button.classList.add('border-transparent', 'text-gray-600');
    });
    
    // Show selected tab content
    document.getElementById('content-' + tabName).classList.remove('hidden');
    
    // Add active state to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.remove('border-transparent', 'text-gray-600');
    activeTab.classList.add('border-primary', 'text-primary');
    
    // Initialize calendar when availability tab is opened
    if (tabName === 'availability' && !window.calendarInitialized) {
        initializeCalendar();
        window.calendarInitialized = true;
    }
}

// Calendar functionality
let currentDate = new Date();
let bookedDates = [];

// Fetch booked dates from server
async function fetchBookedDates() {
    try {
        const response = await fetch('/api/properties/{{ $property->id }}/booked-dates');
        const data = await response.json();
        bookedDates = data.booked_dates || [];
        console.log('Fetched booked dates:', bookedDates);
    } catch (error) {
        console.error('Error fetching booked dates:', error);
        bookedDates = [];
    }
}

function isDateBooked(date) {
    // Format date as YYYY-MM-DD in local timezone
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, '0');
    const day = String(date.getDate()).padStart(2, '0');
    const dateStr = `${year}-${month}-${day}`;
    
    const isBooked = bookedDates.includes(dateStr);
    if (isBooked) {
        console.log(`Date ${dateStr} is booked`);
    }
    return isBooked;
}

function renderCalendar(month, year, elementId) {
    const firstDay = new Date(year, month, 1);
    const lastDay = new Date(year, month + 1, 0);
    const daysInMonth = lastDay.getDate();
    const startingDayOfWeek = firstDay.getDay();
    
    let html = '<div class="grid grid-cols-7 gap-1">';
    
    // Day headers
    const days = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
    days.forEach(day => {
        html += `<div class="text-center font-semibold text-sm text-gray-600 py-2">${day}</div>`;
    });
    
    // Empty cells for days before month starts
    for (let i = 0; i < startingDayOfWeek; i++) {
        html += '<div class="aspect-square"></div>';
    }
    
    // Calendar days
    const today = new Date();
    today.setHours(0, 0, 0, 0);
    
    for (let day = 1; day <= daysInMonth; day++) {
        const date = new Date(year, month, day);
        date.setHours(0, 0, 0, 0); // Normalize time
        const isPast = date < today;
        const isBooked = isDateBooked(date);
        
        let classes = 'aspect-square flex items-center justify-center rounded cursor-pointer text-sm ';
        
        if (isPast) {
            classes += 'bg-gray-200 text-gray-400 cursor-not-allowed';
        } else if (isBooked) {
            classes += 'bg-red-100 border-2 border-red-300 text-red-700 font-semibold';
        } else {
            classes += 'bg-white border-2 border-gray-300 hover:border-primary hover:bg-primary/5';
        }
        
        html += `<div class="${classes}" title="${isBooked ? 'Booked' : (isPast ? 'Past date' : 'Available')}">${day}</div>`;
    }
    
    html += '</div>';
    document.getElementById(elementId).innerHTML = html;
}

function updateCalendars() {
    const current = new Date(currentDate);
    const next = new Date(currentDate);
    next.setMonth(next.getMonth() + 1);
    
    // Update month labels
    const monthNames = ['January', 'February', 'March', 'April', 'May', 'June',
                       'July', 'August', 'September', 'October', 'November', 'December'];
    
    document.getElementById('current-month').textContent = 
        `${monthNames[current.getMonth()]} ${current.getFullYear()}`;
    document.getElementById('next-month').textContent = 
        `${monthNames[next.getMonth()]} ${next.getFullYear()}`;
    
    // Render calendars
    renderCalendar(current.getMonth(), current.getFullYear(), 'calendar-current');
    renderCalendar(next.getMonth(), next.getFullYear(), 'calendar-next');
}

function previousMonth() {
    currentDate.setMonth(currentDate.getMonth() - 1);
    updateCalendars();
}

function nextMonth() {
    currentDate.setMonth(currentDate.getMonth() + 1);
    updateCalendars();
}

async function initializeCalendar() {
    await fetchBookedDates();
    updateCalendars();
}
</script>
@endsection
