{{-- Property Card Component --}}
<a href="{{ route('properties.show', $property) }}" class="block bg-white rounded-xl shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden group">
    <div class="relative h-48 overflow-hidden">
        <img src="{{ isset($property->photos[0]) ? asset('storage/' . $property->photos[0]) : '/images/placeholder.jpg' }}" 
            alt="{{ $property->title }}" 
            class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
        
        {{-- Placement Type Badge --}}
        @if(isset($badge))
            @if($badge === 'featured')
                <div class="absolute top-3 left-3 bg-gradient-to-r from-blue-500 to-blue-600 text-white px-3 py-1.5 rounded-full text-xs font-bold shadow-lg z-10">
                    <i class="fas fa-star mr-1"></i> FEATURED
                </div>
            @elseif($badge === 'weekend')
                <div class="absolute top-3 left-3 bg-gradient-to-r from-orange-500 to-orange-600 text-white px-3 py-1.5 rounded-full text-xs font-bold shadow-lg z-10">
                    <i class="fas fa-calendar-week mr-1"></i> WEEKEND DEAL
                </div>
            @elseif($badge === 'unique')
                <div class="absolute top-3 left-3 bg-gradient-to-r from-purple-500 to-purple-600 text-white px-3 py-1.5 rounded-full text-xs font-bold shadow-lg z-10">
                    <i class="fas fa-gem mr-1"></i> TOP UNIQUE
                </div>
            @endif
        @endif

        {{-- Rating Badge --}}
        @if($property->averageRating())
            <div class="absolute top-3 right-3 bg-white px-3 py-1 rounded-full shadow-lg z-10">
                <i class="fas fa-star text-yellow-500"></i>
                <span class="font-bold text-gray-800 ml-1">{{ number_format($property->averageRating(), 1) }}</span>
            </div>
        @endif

        {{-- Verified Badge --}}
        @if($property->verified)
            <div class="absolute bottom-3 right-3 bg-green-500 text-white px-2 py-1 rounded-full text-xs font-semibold shadow-lg z-10">
                <i class="fas fa-check-circle mr-1"></i> Verified
            </div>
        @endif
    </div>
    
    <div class="p-4">
        <h3 class="font-bold text-lg text-gray-800 mb-2 line-clamp-2 group-hover:text-primary transition">
            {{ $property->title }}
        </h3>
        
        <p class="text-sm text-gray-600 mb-3 flex items-center">
            <i class="fas fa-map-marker-alt text-primary mr-1"></i>
            {{ $property->city }}, {{ $property->state }}
        </p>

        <div class="flex items-center gap-3 text-xs text-gray-600 mb-3">
            <span class="flex items-center">
                <i class="fas fa-bed text-primary mr-1"></i>
                {{ $property->bedrooms }} Bed{{ $property->bedrooms > 1 ? 's' : '' }}
            </span>
            <span class="flex items-center">
                <i class="fas fa-bath text-primary mr-1"></i>
                {{ $property->bathrooms }} Bath{{ $property->bathrooms > 1 ? 's' : '' }}
            </span>
            <span class="flex items-center">
                <i class="fas fa-users text-primary mr-1"></i>
                {{ $property->max_guests }} Guest{{ $property->max_guests > 1 ? 's' : '' }}
            </span>
        </div>
        
        <div class="flex items-center justify-between pt-3 border-t">
            <div>
                <span class="text-primary font-bold text-xl">₦{{ number_format($property->price_per_night) }}</span>
                <span class="text-gray-500 text-sm">/night</span>
            </div>
            @if($property->reviews->count() > 0)
                <span class="text-xs text-gray-500">
                    {{ $property->reviews->count() }} review{{ $property->reviews->count() > 1 ? 's' : '' }}
                </span>
            @endif
        </div>
    </div>
</a>