@extends('layouts.app')

@section('title', 'Frequently Asked Questions')

@section('content')
<div class="max-w-6xl mx-auto px-3 sm:px-4">
    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-primary to-primary-dark rounded-xl sm:rounded-2xl p-6 sm:p-8 md:p-12 mb-4 sm:mb-8 text-white">
        <div class="text-center">
            <i class="fas fa-question-circle text-4xl sm:text-5xl md:text-6xl mb-3 sm:mb-4 opacity-90"></i>
            <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-2 sm:mb-4">Frequently Asked Questions</h1>
            <p class="text-sm sm:text-base md:text-lg lg:text-xl opacity-90">Find answers to common questions about our services</p>
        </div>
    </div>

    @php
        $categories = \App\Models\Faq::categories();
        $faqsByCategory = [];
        foreach($categories as $key => $label) {
            $faqsByCategory[$key] = \App\Models\Faq::active()->byCategory($key)->ordered()->get();
        }
    @endphp

    <!-- Category Tabs -->
    <div class="mb-4 sm:mb-8">
        <div class="flex flex-wrap gap-2 sm:gap-3 justify-center">
            @foreach($categories as $key => $label)
                @php
                    $count = $faqsByCategory[$key]->count();
                @endphp
                @if($count > 0)
                    <button onclick="showCategory('{{ $key }}')" 
                            data-category="{{ $key }}"
                            class="category-tab px-3 sm:px-4 md:px-6 py-2 sm:py-3 rounded-lg font-semibold transition shadow-md text-sm sm:text-base
                                   {{ $loop->first ? 'bg-primary text-white' : 'bg-white text-gray-700 hover:bg-gray-50' }}">
                        <i class="fas 
                            @if($key === 'general') fa-info-circle
                            @elseif($key === 'booking') fa-calendar-check
                            @elseif($key === 'payment') fa-credit-card
                            @elseif($key === 'car_rental') fa-car
                            @else fa-home
                            @endif mr-1 sm:mr-2"></i>
                        <span class="hidden sm:inline">{{ $label }}</span>
                        <span class="sm:hidden">{{ substr($label, 0, strpos($label, ' ') ?: strlen($label)) }}</span>
                        <span class="ml-1 sm:ml-2 px-1.5 sm:px-2 py-0.5 sm:py-1 text-xs rounded-full 
                              {{ $loop->first ? 'bg-white/20' : 'bg-gray-200' }}">
                            {{ $count }}
                        </span>
                    </button>
                @endif
            @endforeach
        </div>
    </div>

    <!-- FAQ Content -->
    @foreach($categories as $key => $label)
        @if($faqsByCategory[$key]->count() > 0)
            <div id="category-{{ $key }}" class="category-content {{ $loop->first ? '' : 'hidden' }}">
                <div class="bg-white rounded-xl shadow-lg p-4 sm:p-6 md:p-8 mb-4 sm:mb-8">
                    <h2 class="text-xl sm:text-2xl md:text-3xl font-bold text-primary mb-4 sm:mb-6 flex items-center">
                        <i class="fas 
                            @if($key === 'general') fa-info-circle
                            @elseif($key === 'booking') fa-calendar-check
                            @elseif($key === 'payment') fa-credit-card
                            @elseif($key === 'car_rental') fa-car
                            @else fa-home
                            @endif mr-2 sm:mr-3"></i>
                        {{ $label }}
                    </h2>

                    <div class="space-y-3 sm:space-y-4">
                        @foreach($faqsByCategory[$key] as $faq)
                            <div class="border border-gray-200 rounded-lg overflow-hidden hover:shadow-md transition">
                                <button onclick="toggleFaq({{ $faq->id }})" 
                                        class="w-full text-left px-4 sm:px-6 py-3 sm:py-4 bg-gray-50 hover:bg-gray-100 transition flex items-center justify-between gap-3">
                                    <span class="font-semibold text-gray-800 text-sm sm:text-base flex-1">
                                        <i class="fas fa-question-circle text-primary mr-2"></i>
                                        {{ $faq->question }}
                                    </span>
                                    <i id="icon-{{ $faq->id }}" class="fas fa-chevron-down text-primary transition-transform flex-shrink-0"></i>
                                </button>
                                <div id="answer-{{ $faq->id }}" class="hidden px-4 sm:px-6 py-3 sm:py-4 bg-white">
                                    <div class="text-gray-700 leading-relaxed whitespace-pre-line text-sm sm:text-base">
                                        {{ $faq->answer }}
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
    @endforeach

    <!-- Still Have Questions -->
    <div class="bg-gradient-to-br from-primary to-primary-dark rounded-xl shadow-lg p-6 sm:p-8 text-white text-center mb-4 sm:mb-8">
        <i class="fas fa-headset text-4xl sm:text-5xl mb-3 sm:mb-4 opacity-90"></i>
        <h3 class="text-xl sm:text-2xl font-bold mb-2 sm:mb-3">Still Have Questions?</h3>
        <p class="text-sm sm:text-base md:text-lg mb-4 sm:mb-6 opacity-90">Our support team is here to help you 24/7</p>
        <div class="flex flex-col sm:flex-row flex-wrap gap-3 sm:gap-4 justify-center">
            <a href="{{ route('contact') }}" 
               class="bg-white text-primary px-6 sm:px-8 py-2.5 sm:py-3 rounded-lg font-bold hover:bg-gray-100 transition shadow-md text-sm sm:text-base">
                <i class="fas fa-envelope mr-2"></i>Contact Us
            </a>
            @php
                $whatsappNumber = \App\Models\Setting::get('whatsapp_number');
                $whatsappNumber = preg_replace('/[^0-9]/', '', $whatsappNumber);
            @endphp
            @if($whatsappNumber)
                <a href="https://wa.me/{{ $whatsappNumber }}?text=Hi! I have a question about ShortStayNG" 
                   target="_blank"
                   class="bg-green-500 text-white px-6 sm:px-8 py-2.5 sm:py-3 rounded-lg font-bold hover:bg-green-600 transition shadow-md text-sm sm:text-base">
                    <i class="fab fa-whatsapp mr-2"></i>Chat on WhatsApp
                </a>
            @endif
        </div>
    </div>
</div>

<script>
function showCategory(category) {
    // Hide all categories
    document.querySelectorAll('.category-content').forEach(el => {
        el.classList.add('hidden');
    });
    
    // Show selected category
    document.getElementById('category-' + category).classList.remove('hidden');
    
    // Update tab styles
    document.querySelectorAll('.category-tab').forEach(tab => {
        if (tab.dataset.category === category) {
            tab.classList.remove('bg-white', 'text-gray-700', 'hover:bg-gray-50');
            tab.classList.add('bg-primary', 'text-white');
        } else {
            tab.classList.remove('bg-primary', 'text-white');
            tab.classList.add('bg-white', 'text-gray-700', 'hover:bg-gray-50');
        }
    });
    
    // Scroll to top
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

function toggleFaq(id) {
    const answer = document.getElementById('answer-' + id);
    const icon = document.getElementById('icon-' + id);
    
    if (answer.classList.contains('hidden')) {
        answer.classList.remove('hidden');
        icon.style.transform = 'rotate(180deg)';
    } else {
        answer.classList.add('hidden');
        icon.style.transform = 'rotate(0deg)';
    }
}
</script>
@endsection