@extends('layouts.app')

@section('title', 'About Us')

@section('content')
<div class="max-w-6xl mx-auto px-3 sm:px-4">
    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-primary to-primary-dark rounded-xl sm:rounded-2xl p-6 sm:p-8 md:p-12 mb-4 sm:mb-8 text-white">
        <h1 class="text-2xl sm:text-3xl md:text-4xl lg:text-5xl font-bold mb-2 sm:mb-4">About ShortStayNG</h1>
        <p class="text-sm sm:text-base md:text-lg lg:text-xl opacity-90">Your Trusted Partner for Accommodation & Travel Solutions in Nigeria</p>
    </div>

    <!-- Main Content -->
    <div class="grid md:grid-cols-3 gap-4 sm:gap-6 md:gap-8 mb-4 sm:mb-8">
        <div class="md:col-span-2">
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8 mb-4 sm:mb-6">
                <h2 class="text-xl sm:text-2xl md:text-3xl font-bold mb-4 sm:mb-6 text-primary">Who We Are</h2>
                
                <p class="text-base sm:text-lg text-gray-700 mb-3 sm:mb-4 leading-relaxed">
                    ShortStayNG is Nigeria's leading comprehensive travel and accommodation platform, revolutionizing 
                    the way Nigerians and visitors experience hospitality services. We are a one-stop solution for all 
                    your travel needs, offering premium shortlet accommodations, luxury hotels, and reliable car rental services.
                </p>

                <p class="text-sm sm:text-base text-gray-700 mb-3 sm:mb-4 leading-relaxed">
                    Founded in 2024, we've quickly become the go-to platform for travelers seeking quality, convenience, 
                    and affordability. Our mission is to make finding and booking accommodation and transportation easy, 
                    secure, and transparent across Nigeria.
                </p>

                <p class="text-sm sm:text-base text-gray-700 mb-4 sm:mb-6 leading-relaxed">
                    We verify all properties, vendors, and vehicles to ensure the highest standards of quality, safety, 
                    and reliability. Whether you're planning a business trip, family vacation, or need a comfortable 
                    place for a weekend getaway, ShortStayNG has you covered.
                </p>

                <h2 class="text-xl sm:text-2xl md:text-3xl font-bold mb-4 sm:mb-6 text-primary mt-6 sm:mt-8">Our Services</h2>
                
                <div class="space-y-3 sm:space-y-4">
                    <div class="flex items-start space-x-3 sm:space-x-4 p-3 sm:p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-home text-primary text-2xl sm:text-3xl mt-1 flex-shrink-0"></i>
                        <div>
                            <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Shortlet Accommodations</h3>
                            <p class="text-gray-600 text-sm sm:text-base">Fully furnished apartments and homes for short-term stays, perfect for 
                            business travelers, tourists, and anyone seeking a home away from home.</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-3 sm:space-x-4 p-3 sm:p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-hotel text-primary text-2xl sm:text-3xl mt-1 flex-shrink-0"></i>
                        <div>
                            <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Hotel Bookings</h3>
                            <p class="text-gray-600 text-sm sm:text-base">Access to a wide range of hotels from budget-friendly to luxury 
                            accommodations across major cities in Nigeria.</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-3 sm:space-x-4 p-3 sm:p-4 bg-gray-50 rounded-lg">
                        <i class="fas fa-car text-primary text-2xl sm:text-3xl mt-1 flex-shrink-0"></i>
                        <div>
                            <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Car Rental Services</h3>
                            <p class="text-gray-600 text-sm sm:text-base">Reliable and affordable car rental options for your convenience. 
                            Choose from economy to luxury vehicles with or without drivers.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
                <h2 class="text-xl sm:text-2xl md:text-3xl font-bold mb-4 sm:mb-6 text-primary">Why Choose ShortStayNG?</h2>
                
                <div class="grid sm:grid-cols-2 gap-3 sm:gap-4 md:gap-6">
                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-shield-alt text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Verified & Trusted</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">All properties, vendors, and vehicles are thoroughly verified 
                        to meet our strict quality and safety standards.</p>
                    </div>

                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-lock text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Secure Payments</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">Multiple secure payment options with buyer protection and 
                        transparent pricing - no hidden fees.</p>
                    </div>

                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-headset text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">24/7 Customer Support</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">Our dedicated support team is always ready to assist you 
                        before, during, and after your booking.</p>
                    </div>

                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-star text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Best Value</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">Competitive rates, exclusive deals, and special discounts 
                        to give you the best value for your money.</p>
                    </div>

                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-map-marked-alt text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Nationwide Coverage</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">Properties and services available across major cities 
                        and locations throughout Nigeria.</p>
                    </div>

                    <div class="border-l-4 border-primary rounded-lg p-3 sm:p-4 bg-gray-50">
                        <i class="fas fa-mobile-alt text-primary text-2xl sm:text-3xl mb-2 sm:mb-3"></i>
                        <h3 class="font-bold text-base sm:text-lg mb-1 sm:mb-2">Easy Booking</h3>
                        <p class="text-gray-600 text-xs sm:text-sm">User-friendly platform with instant booking confirmation 
                        and easy cancellation policies.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="md:col-span-1">
            <!-- CAC Certificate -->
            @php
                $cacCertificate = \App\Models\Setting::get('cac_certificate');
            @endphp
            @if($cacCertificate)
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 mb-4 sm:mb-6">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4 text-primary">
                    <i class="fas fa-certificate mr-2"></i>CAC Registered
                </h3>
                <div class="border-2 border-primary rounded-lg overflow-hidden">
                    <img src="{{ asset('storage/' . $cacCertificate) }}" 
                         alt="CAC Certificate" 
                         class="w-full h-auto cursor-pointer hover:opacity-90 transition"
                         onclick="window.open('{{ asset('storage/' . $cacCertificate) }}', '_blank')">
                </div>
                <p class="text-xs sm:text-sm text-gray-600 mt-2 sm:mt-3 text-center">
                    <i class="fas fa-check-circle text-green-500"></i> Officially Registered Business
                </p>
            </div>
            @endif

            <!-- Quick Stats -->
            <div class="bg-gradient-to-br from-primary to-primary-dark rounded-lg shadow-md p-4 sm:p-6 text-white mb-4 sm:mb-6">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4">Our Impact</h3>
                <div class="space-y-3 sm:space-y-4">
                    <div class="border-b border-white/20 pb-2 sm:pb-3">
                        <div class="text-2xl sm:text-3xl font-bold">1000+</div>
                        <div class="text-xs sm:text-sm opacity-90">Verified Properties</div>
                    </div>
                    <div class="border-b border-white/20 pb-2 sm:pb-3">
                        <div class="text-2xl sm:text-3xl font-bold">50+</div>
                        <div class="text-xs sm:text-sm opacity-90">Car Rental Options</div>
                    </div>
                    <div class="border-b border-white/20 pb-2 sm:pb-3">
                        <div class="text-2xl sm:text-3xl font-bold">5000+</div>
                        <div class="text-xs sm:text-sm opacity-90">Happy Customers</div>
                    </div>
                    <div>
                        <div class="text-2xl sm:text-3xl font-bold">20+</div>
                        <div class="text-xs sm:text-sm opacity-90">Cities Covered</div>
                    </div>
                </div>
            </div>

            <!-- Contact Card -->
            <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
                <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4 text-primary">Get in Touch</h3>
                <p class="text-gray-700 mb-3 sm:mb-4 text-xs sm:text-sm">Have questions or need assistance? We're here to help!</p>
                <a href="{{ route('contact') }}" 
                   class="block w-full text-center bg-primary text-white px-4 sm:px-6 py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark transition text-sm sm:text-base">
                    <i class="fas fa-envelope mr-2"></i>Contact Us
                </a>
            </div>
        </div>
    </div>
</div>
@endsection