{{-- resources/views/layouts/app.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @php
        $favicon = \App\Models\Setting::get('favicon');
        $logo = \App\Models\Setting::get('logo');
        $siteName = \App\Models\Setting::get('site_name', 'ShortStayNG');
        $siteDescription = \App\Models\Setting::get('site_description', 'Book Hotels & Shortlets in Nigeria');
        $pageTitle = View::yieldContent('title') ?: $siteName . ' - ' . $siteDescription;
        $pageDescription = View::yieldContent('description') ?: $siteDescription;
        $ogImage = $logo ? asset('storage/' . $logo) : asset('images/og-default.jpg');
    @endphp
    
    <title>{{ $pageTitle }}</title>
    <meta name="description" content="{{ $pageDescription }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="{{ $pageTitle }}">
    <meta property="og:description" content="{{ $pageDescription }}">
    <meta property="og:image" content="{{ $ogImage }}">
    <meta property="og:site_name" content="{{ $siteName }}">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="{{ url()->current() }}">
    <meta name="twitter:title" content="{{ $pageTitle }}">
    <meta name="twitter:description" content="{{ $pageDescription }}">
    <meta name="twitter:image" content="{{ $ogImage }}">
    
    <!-- WhatsApp / Telegram -->
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="{{ $siteName }} Logo">
    
    @if($favicon)
        <link rel="icon" type="image/x-icon" href="{{ asset('storage/' . $favicon) }}">
        <link rel="shortcut icon" type="image/x-icon" href="{{ asset('storage/' . $favicon) }}">
        <link rel="apple-touch-icon" href="{{ asset('storage/' . $favicon) }}">
    @else
        <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    @endif
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#136D73',
                        'primary-dark': '#0f5a5f',
                        'primary-light': '#1a8891',
                        secondary: '#2E2E2E',
                        'light-bg': '#F4F6F7',
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    @stack('styles')
</head>
<body class="bg-light-bg">
    <!-- Navigation -->
    <nav class="bg-white shadow-md sticky top-0 z-40">
        <div class="container mx-auto px-3 sm:px-4 py-3 sm:py-4">
            <div class="flex justify-between items-center">
                <a href="{{ route('home') }}" class="flex items-center gap-2 sm:gap-3">
                    @php
                        $logo = \App\Models\Setting::get('logo');
                    @endphp
                    @if($logo)
                        <img src="{{ asset('storage/' . $logo) }}" 
                             alt="ShortStayNG Logo" 
                             class="h-8 sm:h-10 md:h-14 w-auto object-contain">
                    @else
                        <span class="text-lg sm:text-xl md:text-2xl font-bold text-primary">🏨 ShortStayNG</span>
                    @endif
                </a>
                
                <!-- Mobile Menu Button -->
                <button onclick="toggleMobileNav()" class="md:hidden text-primary focus:outline-none">
                    <i id="menu-icon" class="fas fa-bars text-xl sm:text-2xl"></i>
                </button>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex space-x-4 lg:space-x-6 items-center">
                    <a href="{{ route('properties.index') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">Properties</a>
                    @if(\App\Models\Setting::get('car_rental_enabled', false))
                        <a href="{{ route('cars.index') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">
                            <i class="fas fa-car mr-1"></i>Car Rentals
                        </a>
                    @endif
                    
                    @guest
                        <a href="{{ route('login') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">Login</a>
                        <a href="{{ route('register') }}" class="bg-primary text-white px-3 lg:px-4 py-2 rounded hover:bg-primary-dark text-sm lg:text-base transition">Sign Up</a>
                    @endguest
                    @auth
                        <a href="{{ route('favorites.index') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">
                            <i class="fas fa-heart mr-1"></i> Favorites
                        </a>
                        <a href="{{ route('bookings.index') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">
                            <i class="fas fa-calendar-check mr-1"></i>My Bookings
                        </a>
                        
                        @if(auth()->user()->isVendor())
                            <a href="{{ route('vendor.dashboard') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">Vendor Dashboard</a>
                        @endif
                        @if(auth()->user()->isAdmin())
                            <a href="{{ route('admin.dashboard') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">Admin Panel</a>
                        @endif
                        <a href="{{ route('profile') }}" class="text-secondary hover:text-primary text-sm lg:text-base transition">Profile</a>
                        <form action="{{ route('logout') }}" method="POST" class="inline">
                            @csrf
                            <button class="text-secondary hover:text-primary text-sm lg:text-base transition">Logout</button>
                        </form>
                    @endauth
                </div>
            </div>
            
            <!-- Mobile Menu Dropdown -->
            <div id="mobileMenu" class="hidden md:hidden mt-3 sm:mt-4 pb-3 sm:pb-4 space-y-2 border-t pt-3 sm:pt-4">
                <a href="{{ route('properties.index') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                    <i class="fas fa-home mr-2"></i>Properties
                </a>
                @if(\App\Models\Setting::get('car_rental_enabled', false))
                    <a href="{{ route('cars.index') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                        <i class="fas fa-car mr-2"></i>Car Rentals
                    </a>
                @endif
                @guest
                    <a href="{{ route('login') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                        <i class="fas fa-sign-in-alt mr-2"></i>Login
                    </a>
                    <a href="{{ route('register') }}" class="block py-2 text-sm sm:text-base bg-primary text-white px-2 rounded hover:bg-primary-dark text-center transition">
                        <i class="fas fa-user-plus mr-2"></i>Sign Up
                    </a>
                @endguest
                @auth
                    <a href="{{ route('favorites.index') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                        <i class="fas fa-heart mr-2"></i>Favorites
                    </a>
                    <a href="{{ route('bookings.index') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                        <i class="fas fa-calendar-check mr-2"></i>My Bookings
                    </a>
                    
                    @if(auth()->user()->isVendor())
                        <a href="{{ route('vendor.dashboard') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                            <i class="fas fa-store mr-2"></i>Vendor Dashboard
                        </a>
                    @endif
                    @if(auth()->user()->isAdmin())
                        <a href="{{ route('admin.dashboard') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                            <i class="fas fa-user-shield mr-2"></i>Admin Panel
                        </a>
                    @endif
                    <a href="{{ route('profile') }}" class="block py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                        <i class="fas fa-user mr-2"></i>Profile
                    </a>
                    <form action="{{ route('logout') }}" method="POST">
                        @csrf
                        <button class="block w-full text-left py-2 text-sm sm:text-base text-secondary hover:text-primary hover:bg-gray-50 px-2 rounded transition">
                            <i class="fas fa-sign-out-alt mr-2"></i>Logout
                        </button>
                    </form>
                @endauth
            </div>
        </div>
    </nav>

    <!-- Flash Messages -->
    @if(session('success'))
        <div class="container mx-auto px-3 sm:px-4 mt-3 sm:mt-4">
            <div class="bg-green-100 border border-green-400 text-green-700 px-3 sm:px-4 py-2 sm:py-3 rounded text-sm sm:text-base flex items-start">
                <i class="fas fa-check-circle mr-2 mt-0.5"></i>
                <span>{{ session('success') }}</span>
            </div>
        </div>
    @endif

    @if(session('error') || $errors->any())
        <div class="container mx-auto px-3 sm:px-4 mt-3 sm:mt-4">
            <div class="bg-red-100 border border-red-400 text-red-700 px-3 sm:px-4 py-2 sm:py-3 rounded text-sm sm:text-base flex items-start">
                <i class="fas fa-exclamation-circle mr-2 mt-0.5"></i>
                <span>{{ session('error') ?? $errors->first() }}</span>
            </div>
        </div>
    @endif

    <!-- Main Content -->
    <main class="container mx-auto px-3 sm:px-4 py-4 sm:py-6 md:py-8">
        @yield('content')
    </main>

    <!-- Advanced Footer -->
    <footer class="bg-secondary text-white mt-12 sm:mt-16 py-6 sm:py-8">
        <div class="container mx-auto px-3 sm:px-4">
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-6 sm:gap-8">
                <div>
                    @if($logo)
                        <img src="{{ asset('storage/' . $logo) }}" 
                             alt="ShortStayNG Logo" 
                             class="h-8 sm:h-10 w-auto object-contain mb-3 sm:mb-4 brightness-0 invert">
                    @else
                        <h3 class="font-bold text-base sm:text-lg mb-3 sm:mb-4">ShortStayNG</h3>
                    @endif
                    <p class="text-gray-400 text-xs sm:text-sm">Your trusted platform for booking hotels and shortlets across Nigeria.</p>
                </div>
                <div>
                    <h4 class="font-bold mb-3 sm:mb-4 text-sm sm:text-base">Quick Links</h4>
                    <ul class="space-y-1.5 sm:space-y-2 text-xs sm:text-sm">
                        <li><a href="{{ route('about') }}" class="text-gray-400 hover:text-white transition">About Us</a></li>
                        <li><a href="{{ route('faq') }}" class="text-gray-400 hover:text-white transition">FAQ</a></li>
                        <li><a href="{{ route('contact') }}" class="text-gray-400 hover:text-white transition">Contact</a></li>
                        <li><a href="{{ route('properties.index') }}" class="text-gray-400 hover:text-primary-light transition flex items-center">
                            <i class="fas fa-map-marker-alt text-sm sm:text-base text-primary-light mr-2"></i> Properties
                        </a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold mb-3 sm:mb-4 text-sm sm:text-base">For Vendors</h4>
                    <ul class="space-y-1.5 sm:space-y-2 text-xs sm:text-sm">
                        <li><a href="{{ route('vendor.register') }}" class="text-gray-400 hover:text-white transition">Become a Vendor</a></li>
                        <li><a href="{{ route('vendor.login') }}" class="text-gray-400 hover:text-white transition">Vendor Login</a></li>
                    </ul>
                </div>
                <div>
                    <h4 class="font-bold mb-3 sm:mb-4 text-sm sm:text-base">Connect With Us</h4>
                    <div class="space-y-1.5 sm:space-y-2 text-xs sm:text-sm">
                        @if($facebook_url = \App\Models\Setting::get('facebook_url'))
                            <a href="{{ $facebook_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-blue-600 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-facebook-f text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>Facebook</span>
                            </a>
                        @endif
                        @if($instagram_url = \App\Models\Setting::get('instagram_url'))
                            <a href="{{ $instagram_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-pink-600 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-instagram text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>Instagram</span>
                            </a>
                        @endif
                        @if($twitter_url = \App\Models\Setting::get('twitter_url'))
                            <a href="{{ $twitter_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-blue-400 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-twitter text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>Twitter</span>
                            </a>
                        @endif
                        @if($tiktok_url = \App\Models\Setting::get('tiktok_url'))
                            <a href="{{ $tiktok_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-gray-900 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-tiktok text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>TikTok</span>
                            </a>
                        @endif
                        @if($whatsapp_number = \App\Models\Setting::get('whatsapp_number'))
                            <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $whatsapp_number) }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-green-500 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-whatsapp text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>WhatsApp</span>
                            </a>
                        @endif
                        @if($linkedin_url = \App\Models\Setting::get('linkedin_url'))
                            <a href="{{ $linkedin_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-blue-700 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-linkedin-in text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>LinkedIn</span>
                            </a>
                        @endif
                        @if($youtube_url = \App\Models\Setting::get('youtube_url'))
                            <a href="{{ $youtube_url }}" target="_blank" 
                                class="flex items-center text-gray-400 hover:text-white transition group">
                                <div class="w-7 h-7 sm:w-8 sm:h-8 bg-gray-800 group-hover:bg-red-600 rounded flex items-center justify-center transition mr-2 sm:mr-3">
                                    <i class="fab fa-youtube text-white text-xs sm:text-sm"></i>
                                </div>
                                <span>YouTube</span>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
            <div class="border-t border-gray-700 mt-6 sm:mt-8 pt-6 sm:pt-8 text-center">
                <p class="text-gray-400 text-xs sm:text-sm mb-3">&copy; {{ date('Y') }} {{ $siteName }}. All rights reserved.</p>
                <p class="text-gray-400 text-xs sm:text-sm mb-3">
                    Registered under the Corporate Affairs Commission (CAC) — <strong>RC 8918879</strong>.
                </p>
                <!-- Trust Badges -->
                <div class="flex flex-wrap items-center justify-center gap-2 sm:gap-3">
                    <span class="px-2 sm:px-3 py-1 bg-green-100 text-green-700 text-xs rounded-full border border-green-300">
                        ✅ Verified by CAC
                    </span>
                    <span class="px-2 sm:px-3 py-1 bg-blue-100 text-blue-700 text-xs rounded-full border border-blue-300">
                        🔒 Secured by Flutterwave
                    </span>
                    <span class="px-2 sm:px-3 py-1 bg-yellow-100 text-yellow-700 text-xs rounded-full border border-yellow-300">
                        🏠 Trusted Property Listings
                    </span>
                </div>
            </div>
        </div>
    </footer>

    <!-- WhatsApp Float Button -->
    @php
        $whatsappNumber = \App\Models\Setting::get('whatsapp_number') ?? \App\Models\Setting::get('support_phone');
        $whatsappNumber = preg_replace('/[^0-9]/', '', $whatsappNumber);
    @endphp
    @if($whatsappNumber)
    <a href="https://wa.me/{{ $whatsappNumber }}?text=Hi! I need help booking a property on ShortStayNG" 
       target="_blank"
       class="fixed bottom-4 sm:bottom-6 left-4 sm:left-6 bg-green-500 text-white w-12 h-12 sm:w-16 sm:h-16 rounded-full shadow-2xl flex items-center justify-center hover:bg-green-600 transition z-50 group">
        <i class="fab fa-whatsapp text-2xl sm:text-3xl group-hover:scale-110 transition"></i>
        <span class="absolute -top-1 sm:-top-2 -right-1 sm:-right-2 bg-red-500 text-white text-xs rounded-full w-5 h-5 sm:w-6 sm:h-6 flex items-center justify-center animate-pulse">
            <i class="fas fa-comment-dots text-xs"></i>
        </span>
    </a>
    @endif

    @stack('scripts')
    
    <script>
        function toggleMobileNav() {
            const mobileMenu = document.getElementById('mobileMenu');
            const menuIcon = document.getElementById('menu-icon');
            
            mobileMenu.classList.toggle('hidden');
            
            // Toggle icon
            if (mobileMenu.classList.contains('hidden')) {
                menuIcon.classList.remove('fa-times');
                menuIcon.classList.add('fa-bars');
            } else {
                menuIcon.classList.remove('fa-bars');
                menuIcon.classList.add('fa-times');
            }
        }

        // Close mobile menu when clicking outside
        document.addEventListener('click', function(event) {
            const mobileMenu = document.getElementById('mobileMenu');
            const nav = event.target.closest('nav');
            
            if (!nav && !mobileMenu.classList.contains('hidden')) {
                toggleMobileNav();
            }
        });
    </script>
</body>
</html>