@extends('layouts.app')

@section('title', 'Review Your Car Rental')

@section('content')
<div class="min-h-screen bg-gray-50 py-4 sm:py-8">
    <div class="container mx-auto px-3 sm:px-4 max-w-3xl">
        <!-- Header -->
        <div class="mb-4 sm:mb-8">
            <a href="{{ route('bookings.index') }}" class="text-primary hover:text-primary-dark font-semibold mb-3 sm:mb-4 inline-block text-sm sm:text-base">
                <i class="fas fa-arrow-left mr-2"></i>Back to Bookings
            </a>
            <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
                <h1 class="text-xl sm:text-2xl md:text-3xl font-bold mb-1 sm:mb-2">
                    <i class="fas fa-star mr-2 sm:mr-3"></i>Review Your Car Rental
                </h1>
                <p class="text-green-100 text-sm sm:text-base">Share your experience with {{ $booking->car->full_name }}</p>
            </div>
        </div>

        <!-- Car Details -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 mb-4 sm:mb-6">
            <div class="flex flex-col md:flex-row gap-4 sm:gap-6">
                @if($booking->car->main_photo)
                    <img src="{{ asset('storage/' . $booking->car->main_photo) }}" 
                        alt="{{ $booking->car->full_name }}"
                        class="w-full md:w-48 h-32 object-cover rounded-lg">
                @endif
                
                <div class="flex-1">
                    <h2 class="text-lg sm:text-xl font-bold text-gray-800 mb-2">{{ $booking->car->full_name }}</h2>
                    <p class="text-gray-600 mb-1 text-sm sm:text-base">
                        <i class="fas fa-building text-primary mr-2"></i>{{ $booking->car->vendor->business_name }}
                    </p>
                    <p class="text-gray-600 text-sm sm:text-base">
                        <i class="fas fa-calendar text-primary mr-2"></i>
                        {{ \Carbon\Carbon::parse($booking->pickup_date)->format('M d, Y') }} - 
                        {{ \Carbon\Carbon::parse($booking->return_date)->format('M d, Y') }}
                    </p>
                </div>
            </div>
        </div>

        <!-- Review Form -->
        <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6">
            <form method="POST" action="{{ route('cars.reviews.store', $booking) }}">
                @csrf
                
                <!-- Rating -->
                <div class="mb-4 sm:mb-6">
                    <label class="block text-sm font-semibold text-gray-700 mb-3">
                        Overall Rating <span class="text-red-500">*</span>
                    </label>
                    <div class="flex gap-1 sm:gap-2" id="star-rating">
                        @for($i = 1; $i <= 5; $i++)
                            <button type="button" 
                                class="star text-3xl sm:text-4xl text-gray-300 hover:text-yellow-400 transition p-1"
                                data-rating="{{ $i }}">
                                <i class="fas fa-star"></i>
                            </button>
                        @endfor
                    </div>
                    <input type="hidden" name="rating" id="rating-input" value="{{ old('rating') }}" required>
                    @error('rating')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Comment -->
                <div class="mb-4 sm:mb-6">
                    <label for="comment" class="block text-sm font-semibold text-gray-700 mb-2">
                        Your Review <span class="text-red-500">*</span>
                    </label>
                    <textarea name="comment" id="comment" rows="6" required
                        class="w-full border-gray-300 rounded-lg focus:ring-primary focus:border-primary text-sm sm:text-base px-3 sm:px-4 py-2"
                        placeholder="Share your experience with this car rental...">{{ old('comment') }}</textarea>
                    <p class="text-xs sm:text-sm text-gray-500 mt-1">Minimum 10 characters</p>
                    @error('comment')
                        <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="flex flex-col sm:flex-row gap-3 sm:gap-4">
                    <button type="submit" 
                        class="flex-1 bg-gradient-to-r from-green-600 to-teal-600 text-white py-2.5 sm:py-3 rounded-lg hover:shadow-xl transition font-bold text-sm sm:text-base">
                        <i class="fas fa-paper-plane mr-2"></i>Submit Review
                    </button>
                    <a href="{{ route('bookings.index') }}" 
                        class="flex-1 bg-gray-200 text-gray-700 text-center py-2.5 sm:py-3 rounded-lg hover:bg-gray-300 transition font-bold text-sm sm:text-base">
                        <i class="fas fa-times mr-2"></i>Cancel
                    </a>
                </div>
            </form>
        </div>

        <!-- Info Notice -->
        <div class="mt-4 sm:mt-6 bg-blue-50 border-l-4 border-blue-500 rounded-lg p-3 sm:p-4 text-xs sm:text-sm">
            <p class="text-blue-800">
                <i class="fas fa-info-circle mr-2"></i>
                Your review will be published after admin approval. Thank you for helping others make informed decisions!
            </p>
        </div>
    </div>
</div>

<script>
    // Star rating functionality
    const stars = document.querySelectorAll('.star');
    const ratingInput = document.getElementById('rating-input');
    let selectedRating = {{ old('rating', 0) }};

    // Set initial rating if exists
    if (selectedRating > 0) {
        updateStars(selectedRating);
    }

    stars.forEach(star => {
        star.addEventListener('click', function() {
            selectedRating = parseInt(this.dataset.rating);
            ratingInput.value = selectedRating;
            updateStars(selectedRating);
        });

        star.addEventListener('mouseenter', function() {
            const hoverRating = parseInt(this.dataset.rating);
            updateStars(hoverRating);
        });
    });

    document.getElementById('star-rating').addEventListener('mouseleave', function() {
        updateStars(selectedRating);
    });

    function updateStars(rating) {
        stars.forEach((star, index) => {
            if (index < rating) {
                star.classList.remove('text-gray-300');
                star.classList.add('text-yellow-400');
            } else {
                star.classList.remove('text-yellow-400');
                star.classList.add('text-gray-300');
            }
        });
    }
</script>
@endsection