@extends('layouts.app')

@section('title', 'Car Booking Details')

@section('content')
<div class="min-h-screen bg-gray-50 py-8">
    <div class="container mx-auto px-4 max-w-6xl">
        <!-- Success Message -->
        @if(session('success'))
            <div class="bg-green-100 border border-green-400 text-green-800 px-6 py-4 rounded-lg mb-6">
                <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            </div>
        @endif

        <!-- Header -->
        <div class="mb-6">
            <a href="{{ route('bookings.index') }}" class="text-green-600 hover:text-green-700 font-semibold mb-4 inline-block">
                <i class="fas fa-arrow-left mr-2"></i>Back to My Bookings
            </a>
            <div class="bg-gradient-to-r from-green-600 to-teal-600 text-white rounded-xl shadow-lg p-6">
                <div class="flex justify-between items-start">
                    <div>
                        <h1 class="text-3xl font-bold mb-2">Car Booking Details</h1>
                        <p class="text-green-100">Booking Reference: <span class="font-mono font-bold">{{ $booking->booking_reference }}</span></p>
                    </div>
                    <span class="px-4 py-2 rounded-full text-sm font-bold
                        @if($booking->status === 'confirmed') bg-green-200 text-green-900
                        @elseif($booking->status === 'pending') bg-yellow-200 text-yellow-900
                        @elseif($booking->status === 'active') bg-blue-200 text-blue-900
                        @elseif($booking->status === 'completed') bg-gray-200 text-gray-900
                        @elseif($booking->status === 'cancelled') bg-red-200 text-red-900
                        @else bg-white text-gray-900
                        @endif">
                        {{ ucfirst($booking->status) }}
                    </span>
                </div>
            </div>
        </div>

        <div class="grid lg:grid-cols-3 gap-6">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Car Details -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-car text-green-600 mr-2"></i>Car Details
                    </h2>
                    
                    <div class="flex flex-col md:flex-row gap-6">
                        @if($booking->car->main_photo)
                            <img src="{{ asset('storage/' . $booking->car->main_photo) }}" 
                                alt="{{ $booking->car->full_name }}"
                                class="w-full md:w-64 h-48 object-cover rounded-lg">
                        @endif
                        
                        <div class="flex-1">
                            <h3 class="text-2xl font-bold text-gray-800 mb-2">{{ $booking->car->full_name }}</h3>
                            <p class="text-gray-600 mb-3">{{ $booking->car->category->name }}</p>
                            
                            <div class="grid grid-cols-2 gap-3 text-sm">
                                <div>
                                    <p class="text-gray-600">Transmission</p>
                                    <p class="font-semibold">{{ ucfirst($booking->car->transmission) }}</p>
                                </div>
                                <div>
                                    <p class="text-gray-600">Fuel Type</p>
                                    <p class="font-semibold">{{ ucfirst($booking->car->fuel_type) }}</p>
                                </div>
                                <div>
                                    <p class="text-gray-600">Seats</p>
                                    <p class="font-semibold">{{ $booking->car->seats }} Passengers</p>
                                </div>
                                <div>
                                    <p class="text-gray-600">Location</p>
                                    <p class="font-semibold">{{ $booking->car->city }}, {{ $booking->car->state }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Rental Period -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-calendar text-green-600 mr-2"></i>Rental Period
                    </h2>
                    
                    <div class="grid md:grid-cols-2 gap-6">
                        <div class="bg-green-50 rounded-lg p-4">
                            <p class="text-sm text-gray-600 mb-1">Pickup</p>
                            <p class="text-lg font-bold text-gray-800">{{ \Carbon\Carbon::parse($booking->pickup_date)->format('l, M d, Y') }}</p>
                            <p class="text-gray-600">{{ \Carbon\Carbon::parse($booking->pickup_time, 'UTC')->format('h:i A') }}</p>
                        </div>
                        
                        <div class="bg-red-50 rounded-lg p-4">
                            <p class="text-sm text-gray-600 mb-1">Return</p>
                            <p class="text-lg font-bold text-gray-800">{{ \Carbon\Carbon::parse($booking->return_date)->format('l, M d, Y') }}</p>
                            <p class="text-gray-600">{{ \Carbon\Carbon::parse($booking->return_time, 'UTC')->format('h:i A') }}</p>
                        </div>
                    </div>
                    
                    <div class="mt-4 p-4 bg-blue-50 rounded-lg">
                        <p class="text-center text-gray-700">
                            <span class="font-bold text-2xl text-blue-600">{{ $booking->total_days }}</span>
                            <span class="text-gray-600 ml-2">{{ Str::plural('day', $booking->total_days) }} rental</span>
                        </p>
                    </div>
                </div>

                <!-- Driver Information -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-user text-green-600 mr-2"></i>Driver Information
                    </h2>
                    
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-sm text-gray-600">Name</p>
                            <p class="font-semibold">{{ $booking->driver_name }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Phone</p>
                            <p class="font-semibold">{{ $booking->driver_phone }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Email</p>
                            <p class="font-semibold">{{ $booking->driver_email }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Age</p>
                            <p class="font-semibold">{{ $booking->driver_age }} years</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">License Number</p>
                            <p class="font-semibold">{{ $booking->driver_license_number }}</p>
                        </div>
                        <div>
                            <p class="text-sm text-gray-600">Driving Experience</p>
                            <p class="font-semibold">{{ $booking->driver_experience_years }} years</p>
                        </div>
                    </div>
                    
                    @if($booking->special_requests)
                        <div class="mt-4 p-4 bg-gray-50 rounded-lg">
                            <p class="text-sm text-gray-600 mb-1">Special Requests</p>
                            <p class="text-gray-800">{{ $booking->special_requests }}</p>
                        </div>
                    @endif
                </div>

                <!-- Payment Information -->
                <div class="bg-white rounded-xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-800 mb-4 flex items-center">
                        <i class="fas fa-credit-card text-green-600 mr-2"></i>Payment Information
                    </h2>
                    
                    <div class="mb-4">
                        <span class="px-3 py-1 rounded-full text-sm font-semibold
                            @if($booking->payment_status === 'paid') bg-green-100 text-green-800
                            @elseif($booking->payment_status === 'pending_verification') bg-yellow-100 text-yellow-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            Payment Status: {{ ucfirst(str_replace('_', ' ', $booking->payment_status)) }}
                        </span>
                    </div>
                    
                    @if($booking->payment_method)
                        <p class="text-sm text-gray-600 mb-2">Payment Method: <span class="font-semibold">{{ ucfirst(str_replace('_', ' ', $booking->payment_method)) }}</span></p>
                    @endif
                    
                    @if($booking->payment_reference)
                        <p class="text-sm text-gray-600">Payment Reference: <span class="font-mono font-semibold">{{ $booking->payment_reference }}</span></p>
                    @endif
                    
                    @if($booking->paid_at)
                        <p class="text-sm text-gray-600 mt-2">Paid on: <span class="font-semibold">{{ $booking->paid_at->format('M d, Y h:i A') }}</span></p>
                    @endif
                </div>
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <!-- Cost Breakdown -->
                <div class="bg-white rounded-xl shadow-lg p-6 mb-6 sticky top-4">
                    <h3 class="font-bold text-lg text-gray-800 mb-4">Cost Breakdown</h3>
                    
                    <div class="space-y-3 mb-4">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Rental Cost</span>
                            <span class="font-semibold">₦{{ number_format($booking->rental_cost) }}</span>
                        </div>
                        
                        @if($booking->insurance_cost > 0)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Insurance</span>
                                <span class="font-semibold">₦{{ number_format($booking->insurance_cost) }}</span>
                            </div>
                        @endif
                        
                        @if($booking->security_deposit > 0)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Security Deposit <span class="text-xs text-gray-500">(Refundable)</span></span>
                                <span class="font-semibold text-yellow-600">₦{{ number_format($booking->security_deposit) }}</span>
                            </div>
                        @endif
                        
                        @if($booking->extra_charges > 0)
                            <div class="flex justify-between text-sm">
                                <span class="text-gray-600">Extra Charges</span>
                                <span class="font-semibold">₦{{ number_format($booking->extra_charges) }}</span>
                            </div>
                        @endif
                    </div>
                    
                    <div class="border-t pt-3">
                        <div class="flex justify-between items-center">
                            <span class="font-bold text-gray-800">Total Amount</span>
                            <span class="font-bold text-2xl text-green-600">₦{{ number_format($booking->total_amount) }}</span>
                        </div>
                    </div>
                    
                    <!-- Security Deposit Status -->
                    @if($booking->security_deposit > 0)
                        <div class="mt-4 border-t pt-3">
                            <h4 class="font-bold text-gray-800 mb-3 text-sm">Security Deposit Status</h4>
                            
                            @if($booking->deposit_status === 'held')
                                <div class="p-3 bg-yellow-50 border-l-4 border-yellow-500 rounded text-xs">
                                    <p class="text-yellow-800 font-semibold mb-1">
                                        <i class="fas fa-lock mr-1"></i>Held (₦{{ number_format($booking->security_deposit) }})
                                    </p>
                                    <p class="text-yellow-700">
                                        Security deposit will be refunded after vehicle inspection upon return.
                                    </p>
                                </div>
                            @elseif($booking->deposit_status === 'pending_inspection')
                                <div class="p-3 bg-blue-50 border-l-4 border-blue-500 rounded text-xs">
                                    <p class="text-blue-800 font-semibold mb-1">
                                        <i class="fas fa-search mr-1"></i>Pending Inspection
                                    </p>
                                    <p class="text-blue-700">
                                        Vendor is inspecting the vehicle. Your deposit will be refunded if no damages are found.
                                    </p>
                                </div>
                            @elseif($booking->deposit_status === 'dispute_pending')
                                <div class="p-3 bg-orange-50 border-l-4 border-orange-500 rounded text-xs">
                                    <p class="text-orange-800 font-semibold mb-1">
                                        <i class="fas fa-exclamation-triangle mr-1"></i>Under Review
                                    </p>
                                    <p class="text-orange-700 mb-2">
                                        Vendor has reported damage. Admin is reviewing the claim.
                                    </p>
                                    @if($booking->damage_report)
                                        <p class="text-orange-700 font-semibold">Damage Report:</p>
                                        <p class="text-orange-600 italic">{{ $booking->damage_report }}</p>
                                    @endif
                                </div>
                            @elseif($booking->deposit_status === 'refunded')
                                <div class="p-3 bg-green-50 border-l-4 border-green-500 rounded text-xs">
                                    <p class="text-green-800 font-semibold mb-1">
                                        <i class="fas fa-check-circle mr-1"></i>Refund Approved
                                    </p>
                                    <p class="text-green-700">
                                        Full deposit of ₦{{ number_format($booking->deposit_refund_amount ?? $booking->security_deposit) }} approved for refund.
                                    </p>
                                    @if($booking->deposit_refunded_at)
                                        <p class="text-green-600 mt-1">
                                            Approved on {{ $booking->deposit_refunded_at->format('M d, Y') }}
                                        </p>
                                    @endif
                                </div>
                            @elseif($booking->deposit_status === 'deducted')
                                <div class="p-3 bg-red-50 border-l-4 border-red-500 rounded text-xs">
                                    <p class="text-red-800 font-semibold mb-1">
                                        <i class="fas fa-exclamation-circle mr-1"></i>Deducted for Damages
                                    </p>
                                    <div class="space-y-1 text-red-700">
                                        <p>Deduction Amount: ₦{{ number_format($booking->deposit_deduction_amount) }}</p>
                                        <p>Refund Amount: ₦{{ number_format($booking->deposit_refund_amount) }}</p>
                                    </div>
                                    @if($booking->deposit_deduction_reason)
                                        <p class="text-red-600 mt-2">
                                            <strong>Reason:</strong> {{ $booking->deposit_deduction_reason }}
                                        </p>
                                    @endif
                                </div>
                            @elseif($booking->deposit_status === 'partially_deducted')
                                <div class="p-3 bg-orange-50 border-l-4 border-orange-500 rounded text-xs">
                                    <p class="text-orange-800 font-semibold mb-1">
                                        <i class="fas fa-info-circle mr-1"></i>Partially Deducted
                                    </p>
                                    <div class="space-y-1 text-orange-700">
                                        <p>Original Deposit: ₦{{ number_format($booking->security_deposit) }}</p>
                                        <p>Deduction Amount: ₦{{ number_format($booking->deposit_deduction_amount) }}</p>
                                        <p class="font-semibold">Refund Amount: ₦{{ number_format($booking->deposit_refund_amount) }}</p>
                                    </div>
                                    @if($booking->deposit_deduction_reason)
                                        <p class="text-orange-600 mt-2">
                                            <strong>Reason:</strong> {{ $booking->deposit_deduction_reason }}
                                        </p>
                                    @endif
                                </div>
                            @endif
                        </div>
                    @endif
                </div>

                <!-- Actions -->
                @if($booking->payment_status === 'pending')
                    <div class="bg-white rounded-xl shadow-lg p-6">
                        <a href="{{ route('cars.booking.payment', $booking) }}" 
                            class="block w-full bg-gradient-to-r from-green-600 to-teal-600 text-white text-center py-3 rounded-lg hover:shadow-xl transition font-bold">
                            <i class="fas fa-credit-card mr-2"></i>Complete Payment
                        </a>
                    </div>
                @endif

                <!-- Vendor Contact (After Payment) -->
                @if($booking->payment_status === 'paid' || $booking->payment_status === 'verified')
                    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                        <h3 class="font-bold text-lg text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-store text-green-600 mr-2"></i>Vendor Contact
                        </h3>
                        
                        <div class="space-y-3 mb-4">
                            <div>
                                <p class="text-sm text-gray-600">Business Name</p>
                                <p class="font-semibold text-gray-800">{{ $booking->vendor->business_name }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Contact Person</p>
                                <p class="font-semibold text-gray-800">{{ $booking->vendor->user->name }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Phone</p>
                                <p class="font-semibold text-gray-800">{{ $booking->vendor->user->phone }}</p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600">Email</p>
                                <p class="font-semibold text-gray-800">{{ $booking->vendor->user->email }}</p>
                            </div>
                        </div>

                        <div class="space-y-3">
                            <a href="tel:{{ str_replace(' ', '', $booking->vendor->user->phone) }}" 
                                class="block w-full bg-green-600 text-white text-center py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                <i class="fas fa-phone mr-2"></i>Call Vendor
                            </a>
                            <a href="mailto:{{ $booking->vendor->user->email }}" 
                                class="block w-full bg-primary text-white text-center py-3 rounded-lg hover:bg-primary-dark font-semibold transition">
                                <i class="fas fa-envelope mr-2"></i>Email Vendor
                            </a>
                            @if($booking->vendor->whatsapp_number)
                                <a href="https://wa.me/{{ str_replace(['+', ' '], '', $booking->vendor->whatsapp_number) }}" 
                                    target="_blank"
                                    class="block w-full bg-green-500 text-white text-center py-3 rounded-lg hover:bg-green-600 font-semibold transition">
                                    <i class="fab fa-whatsapp mr-2"></i>WhatsApp Vendor
                                </a>
                            @endif
                        </div>

                        <div class="mt-4 p-3 bg-blue-50 border-l-4 border-blue-500 rounded text-xs">
                            <p class="text-blue-800">
                                <i class="fas fa-info-circle mr-1"></i>
                                Contact the vendor to arrange pickup details and confirm your booking.
                            </p>
                        </div>
                    </div>
                @elseif($booking->payment_status === 'pending' || $booking->payment_status === 'pending_verification')
                    <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                        <h3 class="font-bold text-lg text-gray-800 mb-4 flex items-center">
                            <i class="fas fa-store text-green-600 mr-2"></i>Vendor Contact
                        </h3>
                        
                        <div class="p-6 bg-yellow-50 border-l-4 border-yellow-500 rounded">
                            <div class="flex items-start">
                                <i class="fas fa-lock text-yellow-600 text-2xl mr-3 mt-1"></i>
                                <div>
                                    <p class="font-semibold text-yellow-800 mb-2">Payment Required</p>
                                    <p class="text-sm text-yellow-700">
                                        Vendor contact information will be available once your payment is confirmed.
                                    </p>
                                    @if($booking->payment_status === 'pending_verification')
                                        <p class="text-sm text-yellow-700 mt-2">
                                            <i class="fas fa-clock mr-1"></i>Your payment proof is being verified by admin.
                                        </p>
                                    @else
                                        <p class="text-sm text-yellow-700 mt-2">
                                            <i class="fas fa-arrow-up mr-1"></i>Please complete your payment to unlock vendor details.
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Pickup/Return Actions -->
                @if($booking->payment_status === 'paid')
                    @if($booking->status === 'confirmed' && !$booking->pickup_at)
                        <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                            <h3 class="font-bold text-lg text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-key text-green-600 mr-2"></i>Confirm Pickup
                            </h3>
                            <p class="text-sm text-gray-600 mb-4">
                                Once you've picked up the vehicle, confirm the pickup to start your rental period.
                            </p>
                            <form method="POST" action="{{ route('cars.booking.confirm-pickup', $booking) }}">
                                @csrf
                                <button type="submit" 
                                    class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                    <i class="fas fa-check-circle mr-2"></i>Confirm Vehicle Pickup
                                </button>
                            </form>
                        </div>
                    @endif

                    @if($booking->status === 'active' && $booking->pickup_at && !$booking->returned_at)
                        <div class="bg-white rounded-xl shadow-lg p-6 mb-6">
                            <h3 class="font-bold text-lg text-gray-800 mb-4 flex items-center">
                                <i class="fas fa-undo text-blue-600 mr-2"></i>Confirm Return
                            </h3>
                            <p class="text-sm text-gray-600 mb-4">
                                Once you've returned the vehicle to the vendor, confirm the return.
                            </p>
                            <form method="POST" action="{{ route('cars.booking.confirm-return', $booking) }}">
                                @csrf
                                <button type="submit" 
                                    class="w-full bg-blue-600 text-white py-3 rounded-lg hover:bg-blue-700 font-semibold transition">
                                    <i class="fas fa-check-circle mr-2"></i>Confirm Vehicle Return
                                </button>
                            </form>
                        </div>
                    @endif
                @endif
            </div>
        </div>

        <!-- Security Deposit Refund Section -->
        @if(in_array($booking->status, ['completed', 'pending_inspection']) || $booking->returned_at)
            <div class="bg-white rounded-xl shadow-md p-6 mt-6">
                <h2 class="text-xl font-bold text-secondary mb-6 flex items-center">
                    <i class="fas fa-money-check-alt text-green-600 mr-3"></i> Security Deposit Refund
                </h2>
                
                <div class="bg-gradient-to-r from-blue-50 to-purple-50 border-2 border-blue-200 rounded-lg p-6 mb-6">
                    <div class="flex justify-between items-center">
                        <div>
                            <p class="font-bold text-2xl text-green-600">₦{{ number_format($booking->security_deposit) }}</p>
                            <p class="text-sm text-gray-600">Refundable Deposit</p>
                        </div>
                        <span class="px-6 py-3 rounded-full font-bold text-sm
                            @if($booking->deposit_status === 'refunded') bg-green-500 text-white
                            @elseif($booking->deposit_status === 'deducted') bg-red-500 text-white
                            @elseif($booking->deposit_status === 'partially_deducted') bg-orange-500 text-white
                            @elseif($booking->deposit_status === 'dispute_pending') bg-orange-400 text-gray-900
                            @else bg-yellow-400 text-gray-900
                            @endif">
                            {{ ucfirst(str_replace('_', ' ', $booking->deposit_status)) }}
                        </span>
                    </div>
                </div>

                @if($booking->deposit_status === 'pending_inspection')
                    <div class="bg-yellow-50 border-l-4 border-yellow-400 rounded-lg p-4">
                        <p class="text-yellow-800 font-semibold mb-2">
                            <i class="fas fa-clock mr-2"></i> Waiting for Vendor Inspection
                        </p>
                        <p class="text-sm text-gray-700">
                            The vendor will inspect the vehicle condition and decide on your security deposit refund. 
                            This typically takes 1-3 business days after vehicle return.
                        </p>
                    </div>
                @elseif($booking->deposit_status === 'dispute_pending')
                    <div class="bg-orange-50 border-l-4 border-orange-400 rounded-lg p-4">
                        <p class="text-orange-800 font-semibold mb-2">
                            <i class="fas fa-exclamation-triangle mr-2"></i> Damage Claim Under Review
                        </p>
                        <p class="text-sm text-gray-700 mb-3">
                            The vendor has reported vehicle damage. Admin is reviewing the claim.
                        </p>
                        @if($booking->deposit_deduction_amount)
                            <div class="bg-white rounded p-3 mt-2">
                                <p class="text-sm"><strong>Requested Deduction:</strong> ₦{{ number_format($booking->deposit_deduction_amount) }}</p>
                                @if($booking->damage_report)
                                    <p class="text-sm mt-1"><strong>Reason:</strong> {{ $booking->damage_report }}</p>
                                @endif
                            </div>
                        @endif
                    </div>
                @elseif($booking->deposit_status === 'deducted')
                    <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4">
                        <p class="text-red-800 font-semibold mb-2">
                            <i class="fas fa-times-circle mr-2"></i> Security Deposit Forfeited
                        </p>
                        <p class="text-sm text-gray-700 mb-2">
                            Your security deposit has been forfeited due to vehicle damage or policy violation.
                        </p>
                        @if($booking->deposit_deduction_reason)
                            <div class="bg-white rounded p-3 mt-2">
                                <p class="text-sm"><strong>Reason:</strong> {{ $booking->deposit_deduction_reason }}</p>
                            </div>
                        @endif
                        @if($booking->admin_notes)
                            <div class="bg-white rounded p-3 mt-2">
                                <p class="text-sm"><strong>Admin Notes:</strong> {{ $booking->admin_notes }}</p>
                            </div>
                        @endif
                    </div>
                @elseif($booking->deposit_status === 'partially_deducted')
                    <div class="bg-orange-50 border-l-4 border-orange-500 rounded-lg p-4">
                        <p class="text-orange-800 font-semibold mb-2">
                            <i class="fas fa-info-circle mr-2"></i> Partial Refund - Deduction Applied
                        </p>
                        <div class="grid md:grid-cols-3 gap-4 mt-3">
                            <div class="bg-white rounded p-3">
                                <p class="text-xs text-gray-600">Original Deposit</p>
                                <p class="font-bold text-lg">₦{{ number_format($booking->security_deposit) }}</p>
                            </div>
                            <div class="bg-white rounded p-3">
                                <p class="text-xs text-gray-600">Deduction</p>
                                <p class="font-bold text-lg text-red-600">-₦{{ number_format($booking->deposit_deduction_amount ?? 0) }}</p>
                            </div>
                            <div class="bg-white rounded p-3">
                                <p class="text-xs text-gray-600">Your Refund</p>
                                <p class="font-bold text-lg text-green-600">₦{{ number_format($booking->deposit_refund_amount ?? 0) }}</p>
                            </div>
                        </div>
                        @if($booking->deposit_deduction_reason)
                            <div class="mt-3 p-3 bg-white rounded">
                                <p class="text-sm"><strong>Deduction Reason:</strong> {{ $booking->deposit_deduction_reason }}</p>
                            </div>
                        @endif
                        @if($booking->admin_notes)
                            <div class="mt-3 p-3 bg-white rounded">
                                <p class="text-sm"><strong>Admin Decision:</strong> {{ $booking->admin_notes }}</p>
                            </div>
                        @endif
                        
                        @if($booking->refund_payout_status === 'pending' && $booking->deposit_refund_amount > 0)
                            <form method="POST" action="{{ route('cars.booking.request-refund', $booking) }}" class="mt-4">
                                @csrf
                                <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                    <i class="fas fa-hand-holding-usd mr-2"></i> Request Refund Payout (₦{{ number_format($booking->deposit_refund_amount) }})
                                </button>
                            </form>
                        @elseif($booking->refund_payout_status === 'requested')
                            <div class="mt-4 bg-blue-50 border border-blue-200 rounded-lg p-3">
                                <p class="text-blue-800 text-sm">
                                    <i class="fas fa-clock mr-2"></i> Refund request submitted on {{ $booking->refund_requested_at->format('M d, Y') }}. Admin is processing your payout.
                                </p>
                            </div>
                        @elseif($booking->refund_payout_status === 'processing')
                            <div class="mt-4 bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                                <p class="text-yellow-800 text-sm">
                                    <i class="fas fa-spinner fa-spin mr-2"></i> Your refund is being processed. You'll receive it soon.
                                </p>
                            </div>
                        @elseif($booking->refund_payout_status === 'paid')
                            <div class="mt-4 bg-green-50 border border-green-200 rounded-lg p-3">
                                <p class="text-green-800 text-sm">
                                    <i class="fas fa-check-circle mr-2"></i> Refund paid on {{ $booking->refund_paid_at->format('M d, Y') }}
                                    @if($booking->refund_payment_method)
                                        via {{ ucfirst(str_replace('_', ' ', $booking->refund_payment_method)) }}
                                    @endif
                                </p>
                            </div>
                        @endif
                    </div>
                @elseif($booking->deposit_status === 'refunded')
                    <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-4">
                        <p class="text-green-800 font-semibold mb-2">
                            <i class="fas fa-check-circle mr-2"></i> Full Refund Approved!
                        </p>
                        <p class="text-sm text-gray-700 mb-3">
                            Your full security deposit of ₦{{ number_format($booking->deposit_refund_amount ?? $booking->security_deposit) }} is ready for payout.
                        </p>
                        @if($booking->deposit_refunded_at)
                            <p class="text-xs text-gray-500 mb-3">
                                Approved on {{ $booking->deposit_refunded_at->format('M d, Y H:i') }}
                            </p>
                        @endif
                        
                        @if($booking->refund_payout_status === 'pending' && ($booking->deposit_refund_amount ?? 0) > 0)
                            <form method="POST" action="{{ route('cars.booking.request-refund', $booking) }}" class="mt-3">
                                @csrf
                                <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-lg hover:bg-green-700 font-semibold transition">
                                    <i class="fas fa-hand-holding-usd mr-2"></i> Request Refund Payout (₦{{ number_format($booking->deposit_refund_amount ?? $booking->security_deposit) }})
                                </button>
                            </form>
                        @elseif($booking->refund_payout_status === 'requested')
                            <div class="mt-3 bg-blue-50 border border-blue-200 rounded-lg p-3">
                                <p class="text-blue-800 text-sm">
                                    <i class="fas fa-clock mr-2"></i> Refund request submitted on {{ $booking->refund_requested_at->format('M d, Y') }}. Admin is processing your payout.
                                </p>
                            </div>
                        @elseif($booking->refund_payout_status === 'processing')
                            <div class="mt-3 bg-yellow-50 border border-yellow-200 rounded-lg p-3">
                                <p class="text-yellow-800 text-sm">
                                    <i class="fas fa-spinner fa-spin mr-2"></i> Your refund is being processed. You'll receive it soon.
                                </p>
                            </div>
                        @elseif($booking->refund_payout_status === 'paid')
                            <div class="mt-3 bg-green-50 border border-green-200 rounded-lg p-3">
                                <p class="text-green-800 text-sm">
                                    <i class="fas fa-check-circle mr-2"></i> Refund paid on {{ $booking->refund_paid_at->format('M d, Y') }}
                                    @if($booking->refund_payment_method)
                                        via {{ ucfirst(str_replace('_', ' ', $booking->refund_payment_method)) }}
                                    @endif
                                </p>
                            </div>
                        @endif
                    </div>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection