@extends('layouts.app')

@section('title', 'Booking Details')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="mb-6">
        <a href="{{ route('bookings.index') }}" class="text-primary hover:underline">← Back to Bookings</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6 mb-6">
        <div class="flex justify-between items-start mb-6">
            <div>
                <h1 class="text-2xl font-bold mb-2">Booking #{{ $booking->id }}</h1>
                <p class="text-gray-600">Reference: {{ $booking->payment_reference }}</p>
            </div>
            <div class="text-right">
                <span class="px-4 py-2 rounded-full text-sm font-semibold
                    @if($booking->booking_status === 'confirmed') bg-green-100 text-green-800
                    @elseif($booking->booking_status === 'pending') bg-yellow-100 text-yellow-800
                    @elseif($booking->booking_status === 'cancelled') bg-red-100 text-red-800
                    @else bg-primary/10 text-blue-800
                    @endif">
                    {{ ucfirst($booking->booking_status) }}
                </span>
            </div>
        </div>

        <!-- Status Timeline -->
        <div class="mb-6">
            <div class="flex items-center justify-between relative">
                <div class="absolute top-5 left-0 right-0 h-0.5 bg-gray-200"></div>
                
                <!-- Booking Created -->
                <div class="relative z-10 text-center">
                    <div class="w-10 h-10 bg-green-500 rounded-full flex items-center justify-center text-white mx-auto mb-2">
                        <i class="fas fa-check"></i>
                    </div>
                    <p class="text-xs text-gray-600">Created</p>
                </div>

                <!-- Vendor Approval -->
                @if($booking->requires_vendor_approval)
                    <div class="relative z-10 text-center">
                        <div class="w-10 h-10 rounded-full flex items-center justify-center text-white mx-auto mb-2
                            {{ $booking->vendor_approval_status === 'approved' ? 'bg-green-500' : ($booking->vendor_approval_status === 'rejected' ? 'bg-red-500' : 'bg-gray-300') }}">
                            <i class="fas {{ $booking->vendor_approval_status === 'approved' ? 'fa-check' : ($booking->vendor_approval_status === 'rejected' ? 'fa-times' : 'fa-clock') }}"></i>
                        </div>
                        <p class="text-xs text-gray-600">Vendor</p>
                    </div>
                @endif

                <!-- Payment -->
                <div class="relative z-10 text-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center text-white mx-auto mb-2
                        {{ $booking->payment_status === 'paid' ? 'bg-green-500' : 'bg-gray-300' }}">
                        <i class="fas {{ $booking->payment_status === 'paid' ? 'fa-check' : 'fa-credit-card' }}"></i>
                    </div>
                    <p class="text-xs text-gray-600">Payment</p>
                </div>

                <!-- Admin Verification -->
                <div class="relative z-10 text-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center text-white mx-auto mb-2
                        {{ $booking->admin_verified ? 'bg-green-500' : 'bg-gray-300' }}">
                        <i class="fas {{ $booking->admin_verified ? 'fa-check' : 'fa-user-shield' }}"></i>
                    </div>
                    <p class="text-xs text-gray-600">Verified</p>
                </div>

                <!-- Completed -->
                <div class="relative z-10 text-center">
                    <div class="w-10 h-10 rounded-full flex items-center justify-center text-white mx-auto mb-2
                        {{ $booking->booking_status === 'completed' ? 'bg-green-500' : 'bg-gray-300' }}">
                        <i class="fas {{ $booking->booking_status === 'completed' ? 'fa-flag-checkered' : 'fa-flag' }}"></i>
                    </div>
                    <p class="text-xs text-gray-600">Stay</p>
                </div>
            </div>
        </div>

        <!-- Booking Details -->
        <div class="grid md:grid-cols-2 gap-6 mb-6">
            <div>
                <h3 class="font-bold mb-3">Property Details</h3>
                <div class="space-y-2">
                    <p><strong>Property:</strong> {{ $booking->property->title }}</p>
                    <p><strong>Location:</strong> {{ $booking->property->city }}, {{ $booking->property->state }}</p>
                    <p><strong>House Type:</strong> {{ $booking->property->house_type }}</p>
                </div>
            </div>

            <div>
                <h3 class="font-bold mb-3">Stay Details</h3>
                <div class="space-y-2">
                    <p><strong>Check-in:</strong> {{ $booking->start_date->format('M d, Y') }}</p>
                    <p><strong>Check-out:</strong> {{ $booking->end_date->format('M d, Y') }}</p>
                    <p><strong>Nights:</strong> {{ $booking->nights_count }}</p>
                    <p><strong>Guests:</strong> {{ $booking->adults_count }} adults, {{ $booking->children_count }} children</p>
                    <p><strong>Trip Type:</strong> {{ ucfirst($booking->trip_type) }}</p>
                </div>
            </div>
        </div>

        <!-- Payment Summary -->
        <div class="border-t pt-6">
            <h3 class="font-bold mb-3">Payment Summary</h3>
            <div class="space-y-2">
                <div class="flex justify-between">
                    <span>Subtotal ({{ $booking->nights_count }} nights × ₦{{ number_format($booking->property_price_per_night) }})</span>
                    <span>₦{{ number_format($booking->subtotal) }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Caution Fee</span>
                    <span>₦{{ number_format($booking->caution_fee_amount) }}</span>
                </div>
                <div class="flex justify-between font-bold text-lg border-t pt-2">
                    <span>Total</span>
                    <span>₦{{ number_format($booking->total_amount) }}</span>
                </div>
                <div class="flex justify-between text-sm text-gray-600">
                    <span>Payment Status</span>
                    <span class="font-semibold {{ $booking->payment_status === 'paid' ? 'text-green-600' : 'text-yellow-600' }}">
                        {{ ucfirst($booking->payment_status) }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="mt-6 flex gap-3">
            @if($booking->payment_status === 'pending' && $booking->vendor_approval_status === 'approved')
                <a href="{{ route('bookings.payment', $booking) }}" 
                    class="bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark">
                    Complete Payment
                </a>
            @endif

            @if($booking->requires_vendor_approval && $booking->vendor_approval_status === 'pending')
                <div class="bg-yellow-50 border border-yellow-200 rounded p-4 w-full">
                    <p class="text-yellow-800">
                        <i class="fas fa-clock"></i> Waiting for vendor approval...
                    </p>
                </div>
            @endif

            @if($booking->booking_status === 'confirmed' && $booking->end_date->isPast())
                <form method="POST" action="{{ route('bookings.complete', $booking) }}" class="w-full">
                    @csrf
                    <button type="submit" 
                        class="w-full bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 font-semibold">
                        <i class="fas fa-check-circle mr-2"></i> Mark Stay as Completed
                    </button>
                </form>
            @endif
        </div>
    </div>

    <!-- Vendor & Location Info (Unlocked after verification) -->
    @if($booking->user_visible_vendor_info && $booking->map_visible)
        <div class="bg-white rounded-lg shadow-md p-6 mb-6">
            <h3 class="font-bold text-xl mb-4">🎉 Booking Confirmed - Details Unlocked!</h3>
            
            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <h4 class="font-semibold mb-2">Vendor Contact</h4>
                    <p><strong>Company:</strong> {{ $booking->vendor->company_name }}</p>
                    <p><strong>Name:</strong> {{ $booking->vendor->user->name }}</p>
                    <p><strong>Phone:</strong> {{ $booking->vendor->user->phone }}</p>
                    <p><strong>Email:</strong> {{ $booking->vendor->user->email }}</p>
                </div>

                <div>
                    <h4 class="font-semibold mb-2">Property Location</h4>
                    <p class="mb-3">{{ $booking->property->address }}</p>
                    <a href="{{ route('properties.nearby-attractions', $booking->property) }}" 
                        class="text-primary hover:underline">
                        View Location & Nearby Attractions →
                    </a>
                </div>
            </div>
        </div>
    @endif

    <!-- Write Review Section -->
    @if($booking->booking_status === 'completed' || $booking->end_date->isPast())
        @php
            $userReview = $booking->property->reviews()->where('user_id', auth()->id())->first();
        @endphp
        
        @if(!$userReview)
            <div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-lg shadow-md p-6 mb-6 border-2 border-blue-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="font-bold text-xl mb-2">
                            <i class="fas fa-star text-yellow-500 mr-2"></i>
                            How was your stay?
                        </h3>
                        <p class="text-gray-700">Share your experience and help other travelers make informed decisions.</p>
                    </div>
                    <a href="{{ route('reviews.create', ['property' => $booking->property->id, 'booking' => $booking->id]) }}" 
                        class="bg-gradient-to-r from-primary to-primary-dark text-white px-8 py-3 rounded-lg hover:from-primary-dark hover:to-primary-dark font-semibold shadow-lg whitespace-nowrap">
                        <i class="fas fa-pen mr-2"></i> Write Review
                    </a>
                </div>
            </div>
        @else
            <div class="bg-green-50 rounded-lg shadow-md p-6 mb-6 border-2 border-green-200">
                <div class="flex items-center">
                    <i class="fas fa-check-circle text-green-600 text-2xl mr-3"></i>
                    <div>
                        <h3 class="font-bold text-lg text-green-800">Thank you for your review!</h3>
                        <p class="text-gray-700">You rated this property {{ $userReview->rating }} stars on {{ $userReview->created_at->format('M d, Y') }}</p>
                    </div>
                </div>
            </div>
        @endif
    @endif

    <!-- Caution Fee Status -->
    @if($booking->booking_status === 'completed')
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="font-bold text-xl mb-4">Caution Fee Refund</h3>
            
            <div class="bg-primary/5 border border-blue-200 rounded p-4 mb-4">
                <div class="flex justify-between items-center">
                    <div>
                        <p class="font-semibold text-lg">₦{{ number_format($booking->caution_fee_amount) }}</p>
                        <p class="text-sm text-gray-600">Refundable Deposit</p>
                    </div>
                    <span class="px-4 py-2 rounded-full font-semibold
                        @if($booking->caution_refund_status === 'approved') bg-green-100 text-green-800
                        @elseif($booking->caution_refund_status === 'rejected') bg-red-100 text-red-800
                        @elseif($booking->caution_refund_status === 'refunded') bg-primary/10 text-blue-800
                        @else bg-yellow-100 text-yellow-800
                        @endif">
                        {{ ucfirst(str_replace('_', ' ', $booking->caution_refund_status)) }}
                    </span>
                </div>
            </div>

            @if($booking->caution_refund_status === 'pending')
                <div class="bg-yellow-50 border border-yellow-200 rounded p-4 mb-4">
                    <p class="text-yellow-800 mb-2">
                        <i class="fas fa-clock mr-2"></i>
                        <strong>Waiting for Vendor Decision</strong>
                    </p>
                    <p class="text-sm text-gray-700">
                        The vendor will review the property condition and decide on your caution fee refund. 
                        This typically takes 1-3 business days after checkout.
                    </p>
                </div>
            @elseif($booking->caution_refund_status === 'approved')
                <div class="bg-green-50 border border-green-200 rounded p-4 mb-4">
                    <p class="text-green-800 mb-2">
                        <i class="fas fa-check-circle mr-2"></i>
                        <strong>Refund Approved!</strong>
                    </p>
                    <p class="text-sm text-gray-700 mb-3">
                        Your caution fee has been approved for refund. The amount will be processed to your bank account within 3-5 business days.
                    </p>
                    @if($booking->caution_refund_reason)
                        <p class="text-sm text-gray-600">
                            <strong>Note:</strong> {{ $booking->caution_refund_reason }}
                        </p>
                    @endif
                    @if($booking->caution_refund_decided_at)
                        <p class="text-xs text-gray-500 mt-2">
                            Approved on {{ $booking->caution_refund_decided_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'rejected')
                <div class="bg-red-50 border border-red-200 rounded p-4 mb-4">
                    <p class="text-red-800 mb-2">
                        <i class="fas fa-times-circle mr-2"></i>
                        <strong>Refund Denied</strong>
                    </p>
                    <p class="text-sm text-gray-700 mb-2">
                        The vendor has decided to forfeit your caution fee due to property damage or policy violation.
                    </p>
                    @if($booking->caution_refund_reason)
                        <p class="text-sm text-gray-700 mb-2">
                            <strong>Reason:</strong> {{ $booking->caution_refund_reason }}
                        </p>
                    @endif
                    @if($booking->caution_refund_decided_at)
                        <p class="text-xs text-gray-500">
                            Decided on {{ $booking->caution_refund_decided_at->format('M d, Y H:i') }}
                        </p>
                    @endif
                </div>
            @elseif($booking->caution_refund_status === 'refunded')
                <div class="bg-primary/5 border border-blue-200 rounded p-4">
                    <p class="text-blue-800 mb-2">
                        <i class="fas fa-money-bill-wave mr-2"></i>
                        <strong>Refund Completed</strong>
                    </p>
                    <p class="text-sm text-gray-700">
                        Your caution fee of ₦{{ number_format($booking->caution_fee_amount) }} has been refunded to your bank account.
                    </p>
                </div>
            @endif

            <!-- Caution Fee Logs -->
            @if($booking->cautionRefundLogs && $booking->cautionRefundLogs->count() > 0)
                <div class="border-t pt-4 mt-4">
                    <h4 class="font-semibold mb-3 text-sm">Refund History</h4>
                    <div class="space-y-2">
                        @foreach($booking->cautionRefundLogs as $log)
                            <div class="text-sm bg-light-bg p-3 rounded">
                                <p class="font-semibold">{{ ucfirst($log->new_status) }}</p>
                                <p class="text-gray-600 text-xs">
                                    by {{ $log->actor->name }} on {{ $log->created_at->format('M d, Y H:i') }}
                                </p>
                                @if($log->reason)
                                    <p class="text-gray-700 text-xs mt-1">{{ $log->reason }}</p>
                                @endif
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    @endif
</div>
@endsection