<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - Booking #{{ $booking->id }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#136D73',
                        'primary-dark': '#0f5a5f',
                        secondary: '#2E2E2E',
                    }
                }
            }
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @media print {
            .no-print { 
                display: none !important; 
            }
            body { 
                print-color-adjust: exact; 
                -webkit-print-color-adjust: exact; 
            }
            .container {
                margin: 0;
                padding: 0;
            }
            .bg-gray-100 {
                background-color: white;
            }
        }
        
        /* Mobile table improvements */
        @media (max-width: 640px) {
            .mobile-table-row {
                display: flex;
                flex-direction: column;
                border-bottom: 1px solid #e5e7eb;
                padding: 1rem;
            }
            .mobile-table-row:last-child {
                border-bottom: none;
            }
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto px-2 sm:px-4 py-4 sm:py-8">
        <!-- Print/Download Buttons - Hidden on Print -->
        <div class="no-print mb-4 sm:mb-6 flex flex-col sm:flex-row gap-3 sm:gap-4 justify-center">
            <button onclick="window.print()" class="bg-primary text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-primary-dark transition text-sm sm:text-base">
                <i class="fas fa-print mr-2"></i>Print Receipt
            </button>
            <a href="{{ route('bookings.show', $booking) }}" class="bg-gray-600 text-white px-4 sm:px-6 py-2 sm:py-3 rounded-lg hover:bg-gray-700 transition text-center text-sm sm:text-base">
                <i class="fas fa-arrow-left mr-2"></i>Back to Booking
            </a>
        </div>

        <!-- Receipt -->
        <div class="max-w-4xl mx-auto bg-white shadow-2xl rounded-lg overflow-hidden">
            <!-- Header -->
            <div class="bg-gradient-to-r from-primary to-primary-dark text-white p-4 sm:p-8">
                <div class="flex flex-col sm:flex-row justify-between items-start gap-4">
                    <div class="w-full sm:w-auto">
                        @php
                            $logo = \App\Models\Setting::get('logo');
                            $siteName = \App\Models\Setting::get('site_name', 'ShortStayNG');
                        @endphp
                        @if($logo)
                            <img src="{{ asset('storage/' . $logo) }}" alt="{{ $siteName }}" class="h-12 sm:h-16 w-auto mb-2 sm:mb-4 brightness-0 invert">
                        @else
                            <h1 class="text-2xl sm:text-3xl font-bold mb-2">{{ $siteName }}</h1>
                        @endif
                        <p class="text-xs sm:text-sm opacity-90">{{ \App\Models\Setting::get('site_description', 'Book Hotels & Shortlets in Nigeria') }}</p>
                    </div>
                    <div class="text-left sm:text-right w-full sm:w-auto">
                        <h2 class="text-xl sm:text-2xl font-bold mb-1 sm:mb-2">RECEIPT</h2>
                        <p class="text-xs sm:text-sm opacity-90">Booking #{{ $booking->id }}</p>
                        <p class="text-xs sm:text-sm opacity-90">{{ $booking->paid_at ? $booking->paid_at->format('M d, Y') : now()->format('M d, Y') }}</p>
                    </div>
                </div>
            </div>

            <!-- Customer & Property Info -->
            <div class="p-4 sm:p-8">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 sm:gap-8 mb-6 sm:mb-8">
                    <!-- Customer Details -->
                    <div>
                        <h3 class="text-xs sm:text-sm font-semibold text-gray-600 uppercase mb-2 sm:mb-3">Billed To:</h3>
                        <div class="bg-gray-50 rounded-lg p-3 sm:p-4">
                            <p class="font-bold text-base sm:text-lg text-gray-800">{{ $booking->user->name }}</p>
                            <p class="text-xs sm:text-sm text-gray-600 break-all">{{ $booking->user->email }}</p>
                            @if($booking->user->phone)
                                <p class="text-xs sm:text-sm text-gray-600">{{ $booking->user->phone }}</p>
                            @endif
                        </div>
                    </div>

                    <!-- Property Details -->
                    <div>
                        <h3 class="text-xs sm:text-sm font-semibold text-gray-600 uppercase mb-2 sm:mb-3">Property:</h3>
                        <div class="bg-gray-50 rounded-lg p-3 sm:p-4">
                            <p class="font-bold text-base sm:text-lg text-gray-800">{{ $booking->property->title }}</p>
                            <p class="text-xs sm:text-sm text-gray-600">{{ $booking->property->address }}</p>
                            <p class="text-xs sm:text-sm text-gray-600">{{ $booking->property->city }}, {{ $booking->property->state }}</p>
                        </div>
                    </div>
                </div>

                <!-- Booking Details -->
                <div class="mb-6 sm:mb-8">
                    <h3 class="text-xs sm:text-sm font-semibold text-gray-600 uppercase mb-2 sm:mb-3">Booking Details:</h3>
                    <div class="bg-gray-50 rounded-lg p-3 sm:p-4">
                        <div class="grid grid-cols-3 gap-2 sm:gap-4">
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Check-In</p>
                                <p class="font-semibold text-gray-800 text-xs sm:text-base">{{ $booking->start_date->format('M d, Y') }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Check-Out</p>
                                <p class="font-semibold text-gray-800 text-xs sm:text-base">{{ $booking->end_date->format('M d, Y') }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 mb-1">Duration</p>
                                <p class="font-semibold text-gray-800 text-xs sm:text-base">{{ $booking->nights_count }} {{ $booking->nights_count > 1 ? 'Nights' : 'Night' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Breakdown -->
                <div class="mb-6 sm:mb-8">
                    <h3 class="text-xs sm:text-sm font-semibold text-gray-600 uppercase mb-2 sm:mb-3">Payment Breakdown:</h3>
                    
                    <!-- Desktop Table -->
                    <div class="hidden sm:block border border-gray-200 rounded-lg overflow-hidden">
                        <table class="w-full">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="text-left px-6 py-3 text-xs font-semibold text-gray-600 uppercase">Description</th>
                                    <th class="text-right px-6 py-3 text-xs font-semibold text-gray-600 uppercase">Amount</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-200">
                                <tr>
                                    <td class="px-6 py-4 text-gray-800">
                                        Accommodation ({{ $booking->nights_count }} {{ $booking->nights_count > 1 ? 'nights' : 'night' }} × ₦{{ number_format($booking->property_price_per_night) }})
                                    </td>
                                    <td class="px-6 py-4 text-right font-semibold text-gray-800">₦{{ number_format($booking->subtotal) }}</td>
                                </tr>
                                
                                @if($booking->caution_fee_amount > 0)
                                <tr>
                                    <td class="px-6 py-4 text-gray-800">
                                        Caution Fee <span class="text-xs text-gray-500">(Refundable)</span>
                                    </td>
                                    <td class="px-6 py-4 text-right font-semibold text-gray-800">₦{{ number_format($booking->caution_fee_amount) }}</td>
                                </tr>
                                @endif

                                @if($booking->discount_amount > 0)
                                <tr class="bg-green-50">
                                    <td class="px-6 py-4 text-green-700">
                                        Discount @if($booking->discount_code)<span class="text-xs">({{ $booking->discount_code }})</span>@endif
                                    </td>
                                    <td class="px-6 py-4 text-right font-semibold text-green-700">-₦{{ number_format($booking->discount_amount) }}</td>
                                </tr>
                                @endif

                                <tr class="bg-primary text-white">
                                    <td class="px-6 py-4 font-bold text-lg">Total Amount Paid</td>
                                    <td class="px-6 py-4 text-right font-bold text-2xl">₦{{ number_format($booking->total_amount) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- Mobile Cards -->
                    <div class="sm:hidden border border-gray-200 rounded-lg overflow-hidden">
                        <div class="mobile-table-row bg-white">
                            <div class="flex justify-between items-start mb-1">
                                <span class="text-sm text-gray-800 font-medium">Accommodation</span>
                                <span class="font-semibold text-gray-800">₦{{ number_format($booking->subtotal) }}</span>
                            </div>
                            <span class="text-xs text-gray-500">{{ $booking->nights_count }} {{ $booking->nights_count > 1 ? 'nights' : 'night' }} × ₦{{ number_format($booking->property_price_per_night) }}</span>
                        </div>
                        
                        @if($booking->caution_fee_amount > 0)
                        <div class="mobile-table-row bg-white">
                            <div class="flex justify-between items-center">
                                <div>
                                    <span class="text-sm text-gray-800 font-medium">Caution Fee</span>
                                    <span class="text-xs text-gray-500 block">(Refundable)</span>
                                </div>
                                <span class="font-semibold text-gray-800">₦{{ number_format($booking->caution_fee_amount) }}</span>
                            </div>
                        </div>
                        @endif

                        @if($booking->discount_amount > 0)
                        <div class="mobile-table-row bg-green-50">
                            <div class="flex justify-between items-start">
                                <div>
                                    <span class="text-sm text-green-700 font-medium">Discount</span>
                                    @if($booking->discount_code)
                                    <span class="text-xs text-green-600 block">({{ $booking->discount_code }})</span>
                                    @endif
                                </div>
                                <span class="font-semibold text-green-700">-₦{{ number_format($booking->discount_amount) }}</span>
                            </div>
                        </div>
                        @endif

                        <div class="mobile-table-row bg-primary text-white">
                            <div class="flex justify-between items-center">
                                <span class="font-bold text-base">Total Amount Paid</span>
                                <span class="font-bold text-xl">₦{{ number_format($booking->total_amount) }}</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Information -->
                <div class="mb-6 sm:mb-8">
                    <h3 class="text-xs sm:text-sm font-semibold text-gray-600 uppercase mb-2 sm:mb-3">Payment Information:</h3>
                    <div class="bg-green-50 border-l-4 border-green-500 rounded-lg p-3 sm:p-4">
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-3 sm:gap-4">
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Payment Method</p>
                                <p class="font-semibold text-gray-800 text-sm">{{ ucfirst(str_replace('_', ' ', $booking->payment_method)) }}</p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Payment Status</p>
                                <p class="font-semibold text-green-600 text-sm">
                                    <i class="fas fa-check-circle mr-1"></i>Paid
                                </p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Payment Date</p>
                                <p class="font-semibold text-gray-800 text-sm">{{ $booking->paid_at ? $booking->paid_at->format('M d, Y h:i A') : 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="border-t pt-4 sm:pt-6">
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-8">
                        <div>
                            <h4 class="font-semibold text-gray-800 mb-2 text-sm sm:text-base">Contact Information:</h4>
                            <p class="text-xs sm:text-sm text-gray-600">
                                @php
                                    $contactEmail = \App\Models\Setting::get('contact_email', 'info@shortstayng.com');
                                    $contactPhone = \App\Models\Setting::get('contact_phone', '+234 817 356 2180');
                                @endphp
                                <i class="fas fa-envelope mr-2"></i>{{ $contactEmail }}<br>
                                <i class="fas fa-phone mr-2"></i>{{ $contactPhone }}
                            </p>
                        </div>
                        <div class="text-left sm:text-right">
                            <p class="text-xs text-gray-500 mb-2">This is a computer-generated receipt</p>
                            <p class="text-xs text-gray-500">Generated on {{ now()->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                </div>

                <!-- Thank You Message -->
                <div class="mt-6 sm:mt-8 text-center bg-gradient-to-r from-primary/10 to-primary-dark/10 rounded-lg p-4 sm:p-6">
                    <h3 class="text-lg sm:text-2xl font-bold text-primary mb-2">Thank You for Your Booking!</h3>
                    <p class="text-sm sm:text-base text-gray-600">We look forward to hosting you. Have a wonderful stay!</p>
                </div>
            </div>
        </div>

        <!-- Print Instructions - Also Hidden on Print -->
        <div class="no-print mt-4 sm:mt-6 text-center text-xs sm:text-sm text-gray-600 px-4">
            <p><i class="fas fa-info-circle mr-2"></i>To save as PDF, use your browser's print function and select "Save as PDF"</p>
        </div>
    </div>
</body>
</html>