@extends('layouts.app')

@section('title', 'Verify Your Email')

@section('content')
<div class="max-w-2xl mx-auto px-3 sm:px-4 py-6 sm:py-12">
    <div class="bg-white rounded-lg sm:rounded-xl shadow-lg p-4 sm:p-6 md:p-8">
        <!-- Header -->
        <div class="text-center mb-6 sm:mb-8">
            <div class="bg-yellow-100 w-16 h-16 sm:w-20 sm:h-20 rounded-full flex items-center justify-center mx-auto mb-3 sm:mb-4">
                <i class="fas fa-envelope-open-text text-yellow-600 text-2xl sm:text-3xl"></i>
            </div>
            <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-800 mb-2">Verify Your Email Address</h1>
            <p class="text-gray-600 text-sm sm:text-base">Before proceeding, please check your email for a verification link.</p>
        </div>

        <!-- Success Message -->
        @if (session('resent'))
            <div class="mb-4 sm:mb-6 bg-green-50 border-l-4 border-green-500 p-3 sm:p-4 rounded-lg">
                <div class="flex items-start">
                    <i class="fas fa-check-circle text-green-500 text-lg sm:text-xl mr-2 sm:mr-3 flex-shrink-0 mt-0.5"></i>
                    <p class="text-green-700 font-semibold text-sm sm:text-base">A fresh verification link has been sent to your email address!</p>
                </div>
            </div>
        @endif

        <!-- Email Info -->
        <div class="bg-gradient-to-br from-blue-50 to-primary/5 rounded-lg p-4 sm:p-6 mb-4 sm:mb-6">
            <div class="flex items-start">
                <div class="bg-primary/10 p-2 sm:p-3 rounded-lg mr-3 sm:mr-4 flex-shrink-0">
                    <i class="fas fa-envelope text-primary text-xl sm:text-2xl"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <h3 class="font-bold text-gray-800 mb-1 sm:mb-2 text-sm sm:text-base">Verification Email Sent To:</h3>
                    <p class="text-base sm:text-lg font-semibold text-primary break-all">{{ auth()->user()->email }}</p>
                    <p class="text-xs sm:text-sm text-gray-600 mt-2">
                        <i class="fas fa-clock mr-1"></i>
                        Check your inbox and spam folder
                    </p>
                </div>
            </div>
        </div>

        <!-- Instructions -->
        <div class="mb-4 sm:mb-6">
            <h3 class="font-bold text-gray-800 mb-3 flex items-center text-sm sm:text-base">
                <i class="fas fa-list-check text-primary mr-2"></i>
                What to do next:
            </h3>
            <ol class="space-y-2 sm:space-y-3">
                <li class="flex items-start">
                    <span class="bg-primary text-white rounded-full w-5 h-5 sm:w-6 sm:h-6 flex items-center justify-center text-xs sm:text-sm font-bold mr-2 sm:mr-3 mt-0.5 flex-shrink-0">1</span>
                    <span class="text-gray-700 text-sm sm:text-base">Open your email inbox</span>
                </li>
                <li class="flex items-start">
                    <span class="bg-primary text-white rounded-full w-5 h-5 sm:w-6 sm:h-6 flex items-center justify-center text-xs sm:text-sm font-bold mr-2 sm:mr-3 mt-0.5 flex-shrink-0">2</span>
                    <span class="text-gray-700 text-sm sm:text-base">Look for an email from <strong>{{ config('app.name') }}</strong></span>
                </li>
                <li class="flex items-start">
                    <span class="bg-primary text-white rounded-full w-5 h-5 sm:w-6 sm:h-6 flex items-center justify-center text-xs sm:text-sm font-bold mr-2 sm:mr-3 mt-0.5 flex-shrink-0">3</span>
                    <span class="text-gray-700 text-sm sm:text-base">Click the <strong>"Verify Email Address"</strong> button</span>
                </li>
                <li class="flex items-start">
                    <span class="bg-primary text-white rounded-full w-5 h-5 sm:w-6 sm:h-6 flex items-center justify-center text-xs sm:text-sm font-bold mr-2 sm:mr-3 mt-0.5 flex-shrink-0">4</span>
                    <span class="text-gray-700 text-sm sm:text-base">You'll be redirected back to continue</span>
                </li>
            </ol>
        </div>

        <!-- Resend Button -->
        <div class="border-t pt-4 sm:pt-6">
            <p class="text-center text-gray-600 mb-3 sm:mb-4 text-sm sm:text-base">
                <i class="fas fa-question-circle text-primary mr-1"></i>
                Didn't receive the email?
            </p>
            <form method="POST" action="{{ route('verification.send') }}">
                @csrf
                <button type="submit" 
                    class="w-full bg-gradient-to-r from-primary to-primary-dark text-white py-2.5 sm:py-3 rounded-lg hover:shadow-lg font-semibold transition transform hover:scale-105 mb-3 text-sm sm:text-base">
                    <i class="fas fa-paper-plane mr-2"></i>Resend Verification Email
                </button>
            </form>
        </div>

        <!-- Help Section -->
        <div class="mt-4 sm:mt-6 bg-blue-50 border border-blue-200 rounded-lg p-3 sm:p-4">
            <div class="flex items-start">
                <i class="fas fa-info-circle text-blue-600 text-lg sm:text-xl mr-2 sm:mr-3 mt-1 flex-shrink-0"></i>
                <div>
                    <h4 class="font-semibold text-blue-900 mb-1 text-sm sm:text-base">Need Help?</h4>
                    <p class="text-xs sm:text-sm text-blue-800">
                        If you don't see the email, check your spam folder. 
                        Still having issues? <a href="{{ route('contact') }}" class="text-primary hover:underline font-semibold">Contact Support</a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Logout Option -->
        <div class="mt-4 sm:mt-6 text-center">
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button type="submit" class="text-gray-600 hover:text-gray-800 text-xs sm:text-sm">
                    <i class="fas fa-sign-out-alt mr-1"></i>
                    Logout and use a different account
                </button>
            </form>
        </div>
    </div>
</div>
@endsection