@extends('layouts.app')

@section('title', 'Login')

@section('content')
<div class="max-w-md mx-auto px-3 sm:px-4">
    <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 md:p-8">
        <h1 class="text-xl sm:text-2xl font-bold mb-4 sm:mb-6 text-center">Login to ShortStayNG</h1>

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Email</label>
                <input type="email" name="email" value="{{ old('email') }}" required autofocus
                    class="w-full border rounded-lg px-3 sm:px-4 py-2 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('email') border-red-500 @enderror">
                @error('email')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="block text-gray-700 mb-2 font-semibold text-sm sm:text-base">Password</label>
                <div class="relative">
                    <input type="password" id="password" name="password" required
                        class="w-full border rounded-lg px-3 sm:px-4 py-2 pr-10 sm:pr-12 text-sm sm:text-base focus:border-primary focus:outline-none transition @error('password') border-red-500 @enderror">
                    <button type="button" onclick="togglePassword('password', 'toggleIcon')" 
                        class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-500 hover:text-gray-700 p-1">
                        <i id="toggleIcon" class="fas fa-eye text-sm sm:text-base"></i>
                    </button>
                </div>
                @error('password')
                    <p class="text-red-500 text-xs sm:text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-3 sm:mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="remember" class="mr-2 flex-shrink-0">
                    <span class="text-xs sm:text-sm">Remember me</span>
                </label>
            </div>

            <button type="submit" 
                class="w-full bg-primary text-white py-2.5 sm:py-3 rounded-lg hover:bg-primary-dark font-semibold text-sm sm:text-base">
                Login
            </button>

            <div class="mt-3 sm:mt-4 text-center">
                <a href="{{ route('password.request') }}" class="text-primary hover:underline text-xs sm:text-sm">
                    Forgot your password?
                </a>
            </div>
        </form>

        <div class="mt-4 sm:mt-6 text-center">
            <p class="text-gray-600 text-sm sm:text-base">Don't have an account?</p>
            <a href="{{ route('register') }}" class="text-primary hover:underline text-sm sm:text-base">
                Register here
            </a>
        </div>
    </div>
</div>

<script>
function togglePassword(inputId, iconId) {
    const input = document.getElementById(inputId);
    const icon = document.getElementById(iconId);
    
    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
@endsection