@extends('layouts.admin')

@section('content')
<div class="container mx-auto px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-secondary mb-2">All Transactions</h1>
        <p class="text-gray-600">View all platform transactions</p>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-xl shadow-md p-6 mb-6">
        <form method="GET" action="{{ route('admin.transactions.index') }}" class="grid md:grid-cols-2 gap-4">
            <select name="type" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" {{ $type === 'all' ? 'selected' : '' }}>All Types</option>
                <option value="bookings" {{ $type === 'bookings' ? 'selected' : '' }}>Bookings Only</option>
                <option value="refunds" {{ $type === 'refunds' ? 'selected' : '' }}>Refunds Only</option>
            </select>
            
            <select name="service" class="border-gray-300 rounded-lg" onchange="this.form.submit()">
                <option value="all" {{ $service === 'all' ? 'selected' : '' }}>All Services</option>
                <option value="property" {{ $service === 'property' ? 'selected' : '' }}>Property Only</option>
                <option value="car" {{ $service === 'car' ? 'selected' : '' }}>Car Only</option>
            </select>
        </form>
    </div>

    <!-- Summary Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Transactions</p>
                    <p class="text-2xl font-bold text-secondary">{{ $transactions->count() }}</p>
                </div>
                <div class="bg-blue-100 rounded-full p-3">
                    <i class="fas fa-receipt text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Bookings</p>
                    <p class="text-2xl font-bold text-secondary">{{ $transactions->where('type', 'booking')->count() }}</p>
                </div>
                <div class="bg-purple-100 rounded-full p-3">
                    <i class="fas fa-shopping-cart text-purple-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Refunds</p>
                    <p class="text-2xl font-bold text-secondary">{{ $transactions->where('type', 'refund')->count() }}</p>
                </div>
                <div class="bg-green-100 rounded-full p-3">
                    <i class="fas fa-money-bill-wave text-green-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl shadow-md p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600 mb-1">Total Amount</p>
                    <p class="text-2xl font-bold text-secondary">₦{{ number_format($transactions->sum('amount')) }}</p>
                </div>
                <div class="bg-yellow-100 rounded-full p-3">
                    <i class="fas fa-coins text-yellow-600 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Transactions Table -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($transactions as $transaction)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center gap-2">
                                    @if($transaction['type'] === 'booking')
                                        <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded text-xs font-semibold">
                                            <i class="fas fa-shopping-cart mr-1"></i>Booking
                                        </span>
                                    @else
                                        <span class="px-2 py-1 bg-green-100 text-green-800 rounded text-xs font-semibold">
                                            <i class="fas fa-money-bill-wave mr-1"></i>Refund
                                        </span>
                                    @endif
                                    
                                    @if($transaction['service'] === 'property')
                                        <span class="px-2 py-1 bg-purple-100 text-purple-800 rounded text-xs">Property</span>
                                    @else
                                        <span class="px-2 py-1 bg-orange-100 text-orange-800 rounded text-xs">Car</span>
                                    @endif
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">{{ $transaction['user'] }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-gray-900">{{ $transaction['description'] }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500">#{{ $transaction['reference'] }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-bold 
                                    @if($transaction['type'] === 'booking') text-red-600
                                    @else text-green-600
                                    @endif">
                                    @if($transaction['type'] === 'booking')-@else+@endif₦{{ number_format($transaction['amount']) }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-500">
                                    {{ $transaction['date'] ? $transaction['date']->format('M d, Y') : 'N/A' }}
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 
                                    @if($transaction['status'] === 'paid') bg-green-100 text-green-800
                                    @elseif($transaction['status'] === 'requested') bg-blue-100 text-blue-800
                                    @elseif($transaction['status'] === 'processing') bg-yellow-100 text-yellow-800
                                    @else bg-gray-100 text-gray-800
                                    @endif rounded text-xs font-semibold">
                                    {{ ucfirst(str_replace('_', ' ', $transaction['status'])) }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="px-6 py-12 text-center">
                                <i class="fas fa-receipt text-4xl text-gray-300 mb-2"></i>
                                <p class="text-gray-500">No transactions found</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
