@extends('layouts.admin')

@section('title', 'System Settings')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-cog mr-3"></i>System Settings
                    </h1>
                    <p class="text-primary-light">Configure your platform settings and preferences</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                    <i class="fas fa-sliders-h text-4xl"></i>
                </div>
            </div>
        </div>
    </div>

    <form method="POST" action="{{ route('admin.settings.update') }}" enctype="multipart/form-data">
        @csrf

        <!-- Branding Section -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-primary">
            <div class="flex items-center mb-6">
                <div class="bg-primary/10 p-3 rounded-lg mr-4">
                    <i class="fas fa-palette text-primary text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Branding</h2>
                    <p class="text-sm text-gray-600">Customize your platform's visual identity</p>
                </div>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-tag text-primary mr-2"></i>Site Name *
                </label>
                <input type="text" name="site_name" value="{{ old('site_name', $settings['site_name']) }}" 
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition" required>
            </div>

            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-align-left text-primary mr-2"></i>Site Description
                </label>
                <textarea name="site_description" rows="3" 
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-primary focus:outline-none transition">{{ old('site_description', $settings['site_description']) }}</textarea>
            </div>

            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-gray-700 font-semibold mb-3">
                        <i class="fas fa-image text-primary mr-2"></i>Logo
                    </label>
                    @if($settings['logo'])
                        <div class="bg-white p-3 rounded-lg mb-3 border-2 border-gray-200">
                            <img src="{{ Storage::url($settings['logo']) }}" class="w-32 h-32 object-contain mx-auto">
                        </div>
                    @endif
                    <input type="file" name="logo" accept="image/*" 
                        class="w-full border-2 rounded-lg px-4 py-3 bg-white focus:border-primary focus:outline-none transition">
                    <p class="text-xs text-gray-500 mt-2">Recommended: 512x512px, PNG format</p>
                </div>

                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-gray-700 font-semibold mb-3">
                        <i class="fas fa-star text-primary mr-2"></i>Favicon
                    </label>
                    @if($settings['favicon'])
                        <div class="bg-white p-3 rounded-lg mb-3 border-2 border-gray-200">
                            <img src="{{ Storage::url($settings['favicon']) }}" class="w-16 h-16 object-contain mx-auto">
                        </div>
                    @endif
                    <input type="file" name="favicon" accept="image/*" 
                        class="w-full border-2 rounded-lg px-4 py-3 bg-white focus:border-primary focus:outline-none transition">
                    <p class="text-xs text-gray-500 mt-2">Recommended: 32x32px, ICO or PNG format</p>
                </div>
            </div>

            <!-- CAC Certificate -->
            <div class="bg-gray-50 p-4 rounded-lg">
                <label class="block text-gray-700 font-semibold mb-3">
                    <i class="fas fa-certificate text-primary mr-2"></i>CAC Certificate
                </label>
                @if($settings['cac_certificate'] ?? false)
                    <div class="bg-white p-3 rounded-lg mb-3 border-2 border-gray-200">
                        <img src="{{ Storage::url($settings['cac_certificate']) }}" class="w-full max-w-md object-contain mx-auto">
                        <p class="text-center text-sm text-green-600 mt-2">
                            <i class="fas fa-check-circle"></i> Certificate uploaded
                        </p>
                    </div>
                @endif
                <input type="file" name="cac_certificate" accept="image/*,application/pdf" 
                    class="w-full border-2 rounded-lg px-4 py-3 bg-white focus:border-primary focus:outline-none transition">
                <p class="text-xs text-gray-500 mt-2">Upload your CAC registration certificate (Image or PDF)</p>
            </div>
        </div>

        <!-- Financial Settings -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-green-500">
            <div class="flex items-center mb-6">
                <div class="bg-green-100 p-3 rounded-lg mr-4">
                    <i class="fas fa-percentage text-green-600 text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Financial Settings</h2>
                    <p class="text-sm text-gray-600">Configure commission rates and payment settings</p>
                </div>
            </div>

            <div class="bg-gradient-to-br from-green-50 to-green-100 p-6 rounded-lg">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-chart-line text-green-600 mr-2"></i>Global Commission Percentage (%) *
                </label>
                <input type="number" 
                    name="global_commission_percentage" 
                    value="{{ old('global_commission_percentage', $settings['global_commission_percentage']) }}" 
                    min="0" 
                    max="100" 
                    step="0.01"
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-green-500 focus:outline-none transition bg-white" 
                    required>
                <div class="mt-3 bg-white p-3 rounded-lg border-l-4 border-green-500">
                    <p class="text-sm text-gray-700">
                        <i class="fas fa-info-circle text-green-600 mr-2"></i>
                        This commission applies to all <strong>new vendors</strong>. Existing vendor rates remain unchanged.
                    </p>
                </div>
            </div>
        </div>

        <!-- Contact Information -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-blue-500">
            <div class="flex items-center mb-6">
                <div class="bg-blue-100 p-3 rounded-lg mr-4">
                    <i class="fas fa-address-book text-blue-600 text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Contact Information</h2>
                    <p class="text-sm text-gray-600">Your business contact details</p>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-envelope text-blue-600 mr-2"></i>Contact Email
                    </label>
                    <input type="email" 
                        name="contact_email" 
                        value="{{ old('contact_email', $settings['contact_email']) }}" 
                        placeholder="support@shortstayng.com"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-500 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-phone text-blue-600 mr-2"></i>Contact Phone
                    </label>
                    <input type="text" 
                        name="contact_phone" 
                        value="{{ old('contact_phone', $settings['contact_phone']) }}" 
                        placeholder="+234 800 000 0000"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-500 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-whatsapp text-green-600 mr-2"></i>WhatsApp Number
                    </label>
                    <input type="text" 
                        name="whatsapp_number" 
                        value="{{ old('whatsapp_number', $settings['whatsapp_number']) }}" 
                        placeholder="+234 800 000 0000"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-green-500 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-map-marker-alt text-blue-600 mr-2"></i>Office Address
                    </label>
                    <textarea 
                        name="contact_address" 
                        rows="3"
                        placeholder="123 Main Street, Lagos, Nigeria"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-500 focus:outline-none transition">{{ old('contact_address', $settings['contact_address']) }}</textarea>
                </div>
            </div>
        </div>

        <!-- Social Media Links -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-purple-500">
            <div class="flex items-center mb-6">
                <div class="bg-purple-100 p-3 rounded-lg mr-4">
                    <i class="fas fa-share-alt text-purple-600 text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Social Media Links</h2>
                    <p class="text-sm text-gray-600">Connect your social media profiles</p>
                </div>
            </div>

            <div class="grid md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-facebook text-blue-600 mr-2"></i>Facebook
                    </label>
                    <input type="url" 
                        name="facebook_url" 
                        value="{{ old('facebook_url', $settings['facebook_url']) }}" 
                        placeholder="https://facebook.com/shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-600 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-instagram text-pink-600 mr-2"></i>Instagram
                    </label>
                    <input type="url" 
                        name="instagram_url" 
                        value="{{ old('instagram_url', $settings['instagram_url']) }}" 
                        placeholder="https://instagram.com/shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-pink-600 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-twitter text-blue-400 mr-2"></i>Twitter (X)
                    </label>
                    <input type="url" 
                        name="twitter_url" 
                        value="{{ old('twitter_url', $settings['twitter_url']) }}" 
                        placeholder="https://twitter.com/shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-400 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-tiktok text-gray-800 mr-2"></i>TikTok
                    </label>
                    <input type="url" 
                        name="tiktok_url" 
                        value="{{ old('tiktok_url', $settings['tiktok_url']) }}" 
                        placeholder="https://tiktok.com/@shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-gray-800 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-linkedin text-blue-700 mr-2"></i>LinkedIn
                    </label>
                    <input type="url" 
                        name="linkedin_url" 
                        value="{{ old('linkedin_url', $settings['linkedin_url']) }}" 
                        placeholder="https://linkedin.com/company/shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-blue-700 focus:outline-none transition">
                </div>

                <div>
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fab fa-youtube text-red-600 mr-2"></i>YouTube
                    </label>
                    <input type="url" 
                        name="youtube_url" 
                        value="{{ old('youtube_url', $settings['youtube_url']) }}" 
                        placeholder="https://youtube.com/c/shortstayng"
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-red-600 focus:outline-none transition">
                </div>
            </div>
        </div>

        <!-- Car Rental Settings -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-teal-500">
            <div class="flex items-center mb-6">
                <div class="bg-teal-100 p-3 rounded-lg mr-4">
                    <i class="fas fa-car text-teal-600 text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Car Rental Settings</h2>
                    <p class="text-sm text-gray-600">Configure car rental feature and requirements</p>
                </div>
            </div>

            <!-- Enable/Disable Car Rental Feature -->
            <div class="mb-6">
                <div class="flex items-center justify-between p-4 bg-gradient-to-r from-teal-50 to-green-50 rounded-lg border-2 border-teal-200">
                    <div class="flex-1">
                        <label class="flex items-center cursor-pointer">
                            <div class="mr-4">
                                <i class="fas fa-car-side text-teal-600 text-3xl"></i>
                            </div>
                            <div>
                                <p class="font-bold text-gray-800 text-lg">Enable Car Rental Feature</p>
                                <p class="text-sm text-gray-600">Allow vendors to list vehicles and customers to rent cars</p>
                                <p class="text-xs text-teal-700 mt-1">
                                    <i class="fas fa-info-circle mr-1"></i>
                                    When disabled, car rental options will be hidden from vendor registration and customer pages
                                </p>
                            </div>
                        </label>
                    </div>
                    <div>
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox" name="car_rental_enabled" value="1" 
                                {{ old('car_rental_enabled', $settings['car_rental_enabled'] ?? false) ? 'checked' : '' }}
                                class="sr-only peer">
                            <div class="w-16 h-8 bg-gray-300 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-teal-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:left-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-7 after:w-7 after:transition-all peer-checked:bg-teal-600"></div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Car Rental Commission Rate -->
            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-percentage text-teal-600 mr-2"></i>Car Rental Commission Rate (%) *
                    </label>
                    <input type="number" name="car_rental_commission_rate" step="0.01" min="0" max="100"
                        value="{{ old('car_rental_commission_rate', $settings['car_rental_commission_rate'] ?? 15) }}" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-teal-600 focus:outline-none transition" required>
                    <p class="text-xs text-gray-500 mt-2">Platform commission for each car rental booking</p>
                </div>

                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-birthday-cake text-teal-600 mr-2"></i>Minimum Driver Age *
                    </label>
                    <input type="number" name="car_rental_minimum_age" min="18" max="100"
                        value="{{ old('car_rental_minimum_age', $settings['car_rental_minimum_age'] ?? 21) }}" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-teal-600 focus:outline-none transition" required>
                    <p class="text-xs text-gray-500 mt-2">Minimum age requirement for renting vehicles</p>
                </div>

                <div class="bg-gray-50 p-4 rounded-lg">
                    <label class="block text-gray-700 font-semibold mb-2">
                        <i class="fas fa-id-card text-teal-600 mr-2"></i>Minimum License Years *
                    </label>
                    <input type="number" name="car_rental_minimum_license_years" min="0" max="50"
                        value="{{ old('car_rental_minimum_license_years', $settings['car_rental_minimum_license_years'] ?? 1) }}" 
                        class="w-full border-2 rounded-lg px-4 py-3 focus:border-teal-600 focus:outline-none transition" required>
                    <p class="text-xs text-gray-500 mt-2">Minimum years of driving license required</p>
                </div>
            </div>

            <!-- Car Rental Terms -->
            <div class="bg-gray-50 p-4 rounded-lg">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-file-contract text-teal-600 mr-2"></i>Car Rental Terms & Conditions
                </label>
                <textarea name="car_rental_terms" rows="6" 
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-teal-600 focus:outline-none transition"
                    placeholder="Enter terms and conditions for car rentals...">{{ old('car_rental_terms', $settings['car_rental_terms'] ?? '') }}</textarea>
                <p class="text-xs text-gray-500 mt-2">These terms will be displayed to customers during car rental bookings</p>
            </div>

            <!-- Info Notice -->
            <div class="mt-6 bg-gradient-to-r from-teal-50 to-cyan-50 border-l-4 border-teal-500 p-4 rounded-lg">
                <div class="flex items-start">
                    <div class="bg-teal-500 p-2 rounded-lg mr-3">
                        <i class="fas fa-lightbulb text-white"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-teal-800 mb-1">Car Rental Feature</p>
                        <p class="text-sm text-teal-700">
                            Enable this feature when you're ready to accept car rental vendors. Vendors will need to complete separate KYC verification for car rental services.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Registration Settings -->
        <div class="bg-white rounded-xl shadow-lg p-6 mb-6 border-l-4 border-orange-500">
            <div class="flex items-center mb-6">
                <div class="bg-orange-100 p-3 rounded-lg mr-4">
                    <i class="fas fa-user-plus text-orange-600 text-2xl"></i>
                </div>
                <div>
                    <h2 class="font-bold text-xl text-gray-800">Registration Settings</h2>
                    <p class="text-sm text-gray-600">Control who can register on your platform</p>
                </div>
            </div>

            <div class="space-y-4">
                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div class="flex-1">
                        <label class="flex items-center cursor-pointer">
                            <div class="mr-4">
                                <i class="fas fa-users text-primary text-2xl"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-800">User Registration</p>
                                <p class="text-sm text-gray-600">Allow new users to register as guests</p>
                            </div>
                        </label>
                    </div>
                    <div>
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox" name="enable_user_registration" value="1" 
                                {{ old('enable_user_registration', $settings['enable_user_registration'] ?? true) ? 'checked' : '' }}
                                class="sr-only peer">
                            <div class="w-14 h-7 bg-gray-300 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:left-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>
                </div>

                <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                    <div class="flex-1">
                        <label class="flex items-center cursor-pointer">
                            <div class="mr-4">
                                <i class="fas fa-store text-primary text-2xl"></i>
                            </div>
                            <div>
                                <p class="font-semibold text-gray-800">Vendor Registration</p>
                                <p class="text-sm text-gray-600">Allow new vendors to register and list properties</p>
                            </div>
                        </label>
                    </div>
                    <div>
                        <label class="relative inline-flex items-center cursor-pointer">
                            <input type="checkbox" name="enable_vendor_registration" value="1" 
                                {{ old('enable_vendor_registration', $settings['enable_vendor_registration'] ?? true) ? 'checked' : '' }}
                                class="sr-only peer">
                            <div class="w-14 h-7 bg-gray-300 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-0.5 after:left-[4px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-6 after:w-6 after:transition-all peer-checked:bg-primary"></div>
                        </label>
                    </div>
                </div>
            </div>

            <div class="mt-6 bg-gradient-to-r from-yellow-50 to-orange-50 border-l-4 border-yellow-500 p-4 rounded-lg">
                <div class="flex items-start">
                    <div class="bg-yellow-500 p-2 rounded-lg mr-3">
                        <i class="fas fa-exclamation-triangle text-white"></i>
                    </div>
                    <div>
                        <p class="font-semibold text-yellow-800 mb-1">Important Notice</p>
                        <p class="text-sm text-yellow-700">
                            Disabling registration will prevent new users/vendors from signing up. Existing accounts will not be affected.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Save Button -->
        <div class="flex items-center justify-between bg-gradient-to-r from-gray-50 to-gray-100 p-6 rounded-xl shadow-lg">
            <div class="flex items-center">
                <div class="bg-primary/10 p-3 rounded-lg mr-4">
                    <i class="fas fa-info-circle text-primary text-2xl"></i>
                </div>
                <div>
                    <p class="font-semibold text-gray-800">Ready to save changes?</p>
                    <p class="text-sm text-gray-600">Make sure all information is correct before saving</p>
                </div>
            </div>
            <button type="submit" 
                class="bg-gradient-to-r from-primary to-primary-dark text-white px-8 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold flex items-center">
                <i class="fas fa-save mr-2"></i>Save All Settings
            </button>
        </div>
    </form>
</div>
@endsection