@extends('layouts.admin')

@section('title', 'Vendor Payouts')

@section('content')
<div class="px-4 py-8">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-primary to-primary-dark text-white rounded-xl shadow-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold mb-2">
                        <i class="fas fa-wallet mr-3"></i>Vendor Payout Requests
                    </h1>
                    <p class="text-primary-light">Review and process vendor payout requests</p>
                </div>
                <div class="bg-white/20 backdrop-blur-sm rounded-lg px-6 py-3">
                    <p class="text-sm opacity-90">Pending Requests</p>
                    <p class="text-3xl font-bold">{{ \App\Models\Payout::where('status', 'pending')->count() }}</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Filter -->
    <div class="bg-white rounded-xl shadow-lg p-6 mb-8">
        <div class="flex items-center gap-3 mb-4">
            <i class="fas fa-filter text-primary text-xl"></i>
            <h3 class="font-bold text-lg text-gray-800">Filter by Status:</h3>
        </div>
        <div class="flex gap-3">
            <a href="{{ route('admin.payouts.index', ['status' => 'pending']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'pending' ? 'bg-yellow-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-clock mr-2"></i>Pending
                <span class="ml-2 bg-white/30 px-2 py-1 rounded-full text-xs">{{ \App\Models\Payout::where('status', 'pending')->count() }}</span>
            </a>
            <a href="{{ route('admin.payouts.index', ['status' => 'completed']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'completed' ? 'bg-green-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-check-circle mr-2"></i>Completed
            </a>
            <a href="{{ route('admin.payouts.index', ['status' => 'rejected']) }}" 
                class="flex-1 px-6 py-3 rounded-lg font-semibold text-center transition transform hover:scale-105 {{ $status === 'rejected' ? 'bg-red-500 text-white shadow-lg' : 'bg-gray-100 text-gray-700 hover:bg-gray-200' }}">
                <i class="fas fa-times-circle mr-2"></i>Rejected
            </a>
        </div>
    </div>

    <!-- Payouts List -->
    <div class="space-y-6">
        @forelse($payouts as $payout)
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300">
                <!-- Card Header -->
                <div class="bg-gradient-to-r from-gray-50 to-gray-100 p-6 border-b-2 border-primary/20">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center gap-3 mb-3">
                                <div class="bg-primary/10 p-3 rounded-lg">
                                    <i class="fas fa-building text-primary text-2xl"></i>
                                </div>
                                <div>
                                    <h3 class="text-2xl font-bold text-gray-800">{{ $payout->vendor->company_name }}</h3>
                                    <p class="text-gray-600 flex items-center gap-2">
                                        <i class="fas fa-user text-primary"></i>
                                        {{ $payout->vendor->user->name }}
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center gap-4 text-sm text-gray-600">
                                <span class="flex items-center">
                                    <i class="fas fa-envelope text-primary mr-2"></i>
                                    {{ $payout->vendor->user->email }}
                                </span>
                                <span class="flex items-center">
                                    <i class="fas fa-hashtag text-primary mr-2"></i>
                                    {{ $payout->reference }}
                                </span>
                                <span class="flex items-center">
                                    <i class="fas fa-calendar text-primary mr-2"></i>
                                    {{ $payout->created_at->format('M d, Y H:i') }}
                                </span>
                            </div>
                        </div>
                        
                        <div class="text-right">
                            <p class="text-sm text-gray-600 mb-1">Payout Amount</p>
                            <p class="text-4xl font-bold text-primary">₦{{ number_format($payout->amount) }}</p>
                            <span class="inline-block mt-2 px-4 py-2 rounded-full text-sm font-bold shadow-lg
                                {{ $payout->status === 'pending' ? 'bg-yellow-500 text-white' : 
                                   ($payout->status === 'completed' ? 'bg-green-500 text-white' : 'bg-red-500 text-white') }}">
                                <i class="fas {{ $payout->status === 'pending' ? 'fa-clock' : ($payout->status === 'completed' ? 'fa-check-circle' : 'fa-times-circle') }} mr-1"></i>
                                {{ ucfirst($payout->status) }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Card Body -->
                <div class="p-6">

                    <!-- Bank Details -->
                    <div class="bg-green-50 border-2 border-green-200 rounded-xl p-5 mb-6">
                        <h4 class="font-bold text-lg mb-4 flex items-center text-green-800">
                            <i class="fas fa-university text-green-600 mr-2"></i>
                            Bank Account Details
                        </h4>
                        <div class="grid md:grid-cols-2 gap-4 mb-4">
                            <div class="bg-white rounded-lg p-3">
                                <span class="text-gray-600 text-xs">Bank Name</span>
                                <p class="font-bold text-gray-800">{{ $payout->bank_name }}</p>
                            </div>
                            <div class="bg-white rounded-lg p-3">
                                <span class="text-gray-600 text-xs">Account Name</span>
                                <p class="font-bold text-gray-800">{{ $payout->account_name }}</p>
                            </div>
                        </div>
                        <div class="flex items-center justify-between bg-white p-4 rounded-lg border-2 border-green-300">
                            <div>
                                <p class="text-xs text-gray-600 mb-1">Account Number</p>
                                <p class="font-bold text-2xl text-gray-800">{{ $payout->account_number }}</p>
                            </div>
                            <button type="button" 
                                onclick="copyAccountNumber('{{ $payout->account_number }}', this)"
                                class="bg-primary text-white px-6 py-3 rounded-lg hover:bg-primary-dark transition font-semibold">
                                <i class="fas fa-copy mr-2"></i> Copy
                            </button>
                        </div>
                    </div>

                    @if($payout->processed_by)
                        <div class="bg-blue-50 border-l-4 border-blue-500 rounded-lg p-4 mb-6">
                            <div class="flex items-start">
                                <i class="fas fa-user-check text-blue-500 text-xl mr-3 mt-1"></i>
                                <div class="flex-1">
                                    <p class="font-bold text-blue-800 mb-2">Processing Information</p>
                                    <p class="text-sm text-blue-700 mb-1">
                                        <strong>Processed by:</strong> {{ $payout->processedBy->name }} on {{ $payout->processed_at->format('M d, Y H:i') }}
                                    </p>
                                    @if($payout->transaction_reference)
                                        <p class="text-sm text-blue-700 mb-1">
                                            <strong>Transaction Reference:</strong> {{ $payout->transaction_reference }}
                                        </p>
                                    @endif
                                    @if($payout->admin_notes)
                                        <p class="text-sm text-blue-700">
                                            <strong>Notes:</strong> {{ $payout->admin_notes }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($payout->status === 'rejected' && $payout->rejection_reason)
                        <div class="bg-red-50 border-l-4 border-red-500 rounded-lg p-4 mb-6">
                            <div class="flex items-start">
                                <i class="fas fa-exclamation-circle text-red-500 text-xl mr-3 mt-1"></i>
                                <div>
                                    <p class="font-bold text-red-800 mb-1">Rejection Reason:</p>
                                    <p class="text-sm text-red-700">{{ $payout->rejection_reason }}</p>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if($payout->status === 'pending')
                        <div class="flex gap-4 pt-4 border-t-2 border-gray-200">
                            <button onclick="openApproveModal({{ $payout->id }})" 
                                class="flex-1 bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-lg">
                                <i class="fas fa-check-circle mr-2"></i> Mark as Paid
                            </button>
                            
                            <button onclick="openRejectModal({{ $payout->id }})" 
                                class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-4 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold text-lg">
                                <i class="fas fa-times-circle mr-2"></i> Reject
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        @empty
            <div class="bg-gradient-to-br from-gray-50 to-gray-100 rounded-xl shadow-lg p-16 text-center border-2 border-dashed border-gray-300">
                <div class="bg-gray-200 rounded-full w-24 h-24 flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-inbox text-5xl text-gray-400"></i>
                </div>
                <h3 class="text-2xl font-bold text-gray-700 mb-2">No Payout Requests Found</h3>
                <p class="text-gray-600">No <span class="font-semibold">{{ $status }}</span> payout requests at the moment.</p>
            </div>
        @endforelse
    </div>

    <div class="mt-6">
        {{ $payouts->links() }}
    </div>
</div>

<!-- Approve Modal -->
<div id="approve-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 backdrop-blur-sm flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl shadow-2xl max-w-lg w-full mx-4 transform transition-all">
        <!-- Modal Header -->
        <div class="bg-gradient-to-r from-green-500 to-green-600 text-white rounded-t-2xl p-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-white/20 p-3 rounded-lg mr-3">
                        <i class="fas fa-check-circle text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold">Mark Payout as Paid</h2>
                        <p class="text-sm text-green-100">Confirm payment completion</p>
                    </div>
                </div>
                <button type="button" 
                    onclick="document.getElementById('approve-modal').classList.add('hidden')"
                    class="text-white hover:bg-white/20 rounded-full p-2 transition">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>

        <!-- Modal Body -->
        <form id="approve-form" method="POST" class="p-6">
            @csrf
            
            <div class="mb-4">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-hashtag text-green-600 mr-2"></i>Transaction Reference (Optional)
                </label>
                <input type="text" name="transaction_reference" 
                    placeholder="e.g., Bank transfer reference number"
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-green-500 focus:outline-none transition">
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-sticky-note text-green-600 mr-2"></i>Notes (Optional)
                </label>
                <textarea name="notes" rows="4" 
                    placeholder="Any additional notes about this payment..."
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-green-500 focus:outline-none transition"></textarea>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('approve-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300 font-semibold transition">
                    <i class="fas fa-arrow-left mr-2"></i>Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold">
                    <i class="fas fa-check-double mr-2"></i>Confirm Payment
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Reject Modal -->
<div id="reject-modal" class="hidden fixed inset-0 bg-black bg-opacity-60 backdrop-blur-sm flex items-center justify-center z-50 p-4">
    <div class="bg-white rounded-2xl shadow-2xl max-w-lg w-full mx-4 transform transition-all">
        <!-- Modal Header -->
        <div class="bg-gradient-to-r from-red-500 to-red-600 text-white rounded-t-2xl p-6">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <div class="bg-white/20 p-3 rounded-lg mr-3">
                        <i class="fas fa-times-circle text-2xl"></i>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold">Reject Payout</h2>
                        <p class="text-sm text-red-100">Provide a reason for rejection</p>
                    </div>
                </div>
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="text-white hover:bg-white/20 rounded-full p-2 transition">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>

        <!-- Modal Body -->
        <form id="reject-form" method="POST" class="p-6">
            @csrf
            
            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">
                    <i class="fas fa-comment-alt text-red-600 mr-2"></i>Reason for Rejection *
                </label>
                <textarea name="rejection_reason" rows="5" required
                    placeholder="Please provide a detailed reason for rejecting this payout request..."
                    class="w-full border-2 rounded-lg px-4 py-3 focus:border-red-500 focus:outline-none transition"></textarea>
                <p class="text-xs text-gray-600 mt-2">
                    <i class="fas fa-info-circle mr-1"></i>This reason will be shown to the vendor
                </p>
            </div>

            <div class="flex gap-3">
                <button type="button" 
                    onclick="document.getElementById('reject-modal').classList.add('hidden')"
                    class="flex-1 bg-gray-200 text-gray-700 px-6 py-3 rounded-lg hover:bg-gray-300 font-semibold transition">
                    <i class="fas fa-arrow-left mr-2"></i>Cancel
                </button>
                <button type="submit" 
                    class="flex-1 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-3 rounded-lg hover:shadow-xl transition transform hover:scale-105 font-bold">
                    <i class="fas fa-ban mr-2"></i>Reject Payout
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openApproveModal(payoutId) {
    document.getElementById('approve-form').action = `/admin/payouts/${payoutId}/approve`;
    document.getElementById('approve-modal').classList.remove('hidden');
}

function openRejectModal(payoutId) {
    document.getElementById('reject-form').action = `/admin/payouts/${payoutId}/reject`;
    document.getElementById('reject-modal').classList.remove('hidden');
}

function copyAccountNumber(accountNumber, button) {
    // Create temporary input element
    const tempInput = document.createElement('input');
    tempInput.value = accountNumber;
    document.body.appendChild(tempInput);
    tempInput.select();
    
    try {
        // Copy to clipboard
        document.execCommand('copy');
        
        // Show success feedback
        const originalHTML = button.innerHTML;
        button.innerHTML = '<i class="fas fa-check mr-1"></i> Copied!';
        button.classList.remove('bg-primary', 'hover:bg-primary-dark');
        button.classList.add('bg-green-600');
        
        // Reset button after 2 seconds
        setTimeout(() => {
            button.innerHTML = originalHTML;
            button.classList.remove('bg-green-600');
            button.classList.add('bg-primary', 'hover:bg-primary-dark');
        }, 2000);
    } catch (err) {
        alert('Failed to copy. Please copy manually: ' + accountNumber);
    }
    
    // Remove temporary input
    document.body.removeChild(tempInput);
}
</script>
@endsection
